/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public class ConvertTest
extends TestCase {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(Convert.class.getName());
    private static final String yes = rbh.getText("Yes");
    private static final String no = rbh.getText("No");
    private static final String y = rbh.getText("Y");
    private static final String n = rbh.getText("N");

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBooleanToYesNo() {
        ConvertTest.assertEquals((String)yes, (String)Convert.booleanToYesNo(true));
        ConvertTest.assertEquals((String)no, (String)Convert.booleanToYesNo(false));
    }

    public void testYesNoToBoolean() {
        ConvertTest.assertTrue((boolean)Convert.yesNoToBoolean(yes));
        ConvertTest.assertFalse((boolean)Convert.yesNoToBoolean(no));
    }

    public void testYesNoToBooleanRejectsNull() {
        try {
            Convert.yesNoToBoolean(null);
            ConvertTest.fail((String)"yesNoToBoolean() accepted null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBooleanToYN() {
        ConvertTest.assertEquals((String)y, (String)Convert.booleanToYN(true));
        ConvertTest.assertEquals((String)n, (String)Convert.booleanToYN(false));
    }

    public void testYnToBoolean() {
        ConvertTest.assertFalse((boolean)Convert.ynToBoolean("N"));
        ConvertTest.assertFalse((boolean)Convert.ynToBoolean("X"));
        ConvertTest.assertTrue((boolean)Convert.ynToBoolean("Y"));
    }

    public void testYnToBooleanRejectsNull() {
        try {
            Convert.ynToBoolean(null);
            ConvertTest.fail((String)"ynToBoolean() accepted null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBooleanToZeroOne() {
        ConvertTest.assertEquals((String)"1", (String)Convert.booleanToZeroOne(true));
        ConvertTest.assertEquals((String)"0", (String)Convert.booleanToZeroOne(false));
    }

    public void testZeroOneToBoolean() {
        ConvertTest.assertFalse((boolean)Convert.zeroOneToBoolean("0"));
        ConvertTest.assertFalse((boolean)Convert.zeroOneToBoolean("X"));
        ConvertTest.assertTrue((boolean)Convert.zeroOneToBoolean("1"));
    }

    public void testZeroOneToBooleanRejectsNull() {
        try {
            Convert.zeroOneToBoolean(null);
            ConvertTest.fail((String)"zeroOneToBoolean() accepted null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBooleanToXOrBlank() {
        ConvertTest.assertEquals((String)"X", (String)Convert.booleanToXOrBlank(true));
        ConvertTest.assertEquals((String)" ", (String)Convert.booleanToXOrBlank(false));
    }

    public void testXOrBlankToBoolean() {
        ConvertTest.assertFalse((boolean)Convert.xOrBlankToBoolean(" "));
        ConvertTest.assertFalse((boolean)Convert.xOrBlankToBoolean("Z"));
        ConvertTest.assertTrue((boolean)Convert.xOrBlankToBoolean("X"));
    }

    public void testXOrBlankToBooleanRejectsNull() {
        try {
            Convert.xOrBlankToBoolean(null);
            ConvertTest.fail((String)"xOrBlankToBoolean() accepted null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testTrimL() {
        ConvertTest.assertEquals((String)"xyz   ", (String)Convert.trimL("  xyz   "));
    }

    public void testTrimLNullReturnsNull() {
        ConvertTest.assertNull((Object)Convert.trimL(null));
    }

    public void testTrimLBlanksReturnsEmptyString() {
        ConvertTest.assertEquals((String)"", (String)Convert.trimL("     "));
    }

    public void testTrimR() {
        ConvertTest.assertEquals((String)"  xyz", (String)Convert.trimR("  xyz   "));
    }

    public void testTrimRNullReturnsNull() {
        ConvertTest.assertNull((Object)Convert.trimR(null));
    }

    public void testGetCalendarDate() {
        Calendar calendar = Convert.getCalendar(1090415);
        ConvertTest.assertEquals((int)3, (int)calendar.get(2));
        ConvertTest.assertEquals((int)15, (int)calendar.get(5));
        ConvertTest.assertEquals((int)2009, (int)calendar.get(1));
        ConvertTest.assertEquals((Object)TimeZone.getDefault(), (Object)calendar.getTimeZone());
    }

    public void testGetCalendarDateTime() {
        Calendar calendar = Convert.getCalendar(1090415, 123456);
        ConvertTest.assertEquals((int)12, (int)calendar.get(11));
        ConvertTest.assertEquals((int)34, (int)calendar.get(12));
        ConvertTest.assertEquals((int)56, (int)calendar.get(13));
        ConvertTest.assertEquals((int)3, (int)calendar.get(2));
        ConvertTest.assertEquals((int)15, (int)calendar.get(5));
        ConvertTest.assertEquals((int)2009, (int)calendar.get(1));
        ConvertTest.assertEquals((Object)TimeZone.getDefault(), (Object)calendar.getTimeZone());
    }

    public void testGetCalendarDateTimeTimeZone() {
        Calendar calendar = Convert.getCalendar(1090415, 123456, TimeZone.getTimeZone("GMT"));
        ConvertTest.assertEquals((int)12, (int)calendar.get(11));
        ConvertTest.assertEquals((int)34, (int)calendar.get(12));
        ConvertTest.assertEquals((int)56, (int)calendar.get(13));
        ConvertTest.assertEquals((int)2009, (int)calendar.get(1));
        ConvertTest.assertEquals((int)3, (int)calendar.get(2));
        ConvertTest.assertEquals((int)15, (int)calendar.get(5));
        ConvertTest.assertEquals((Object)TimeZone.getTimeZone("GMT"), (Object)calendar.getTimeZone());
    }

    public void testGetCalendarDateTimeTimeZoneRejectsZero() {
        try {
            Convert.getCalendar(0, 123456, TimeZone.getTimeZone("GMT"));
            ConvertTest.fail((String)"getCalendar(cyymmdd, hhmmss, timeZone) accepted 0 date");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDateInt() {
        Date date = Convert.getDate(1090415);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        ConvertTest.assertEquals((int)2009, (int)gregorianCalendar.get(1));
        ConvertTest.assertEquals((int)3, (int)gregorianCalendar.get(2));
        ConvertTest.assertEquals((int)15, (int)gregorianCalendar.get(5));
    }

    public void testGetDateIntInt() {
        Date date = Convert.getDate(1090415, 123456);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        ConvertTest.assertEquals((int)12, (int)gregorianCalendar.get(11));
        ConvertTest.assertEquals((int)34, (int)gregorianCalendar.get(12));
        ConvertTest.assertEquals((int)56, (int)gregorianCalendar.get(13));
        ConvertTest.assertEquals((int)2009, (int)gregorianCalendar.get(1));
        ConvertTest.assertEquals((int)3, (int)gregorianCalendar.get(2));
        ConvertTest.assertEquals((int)15, (int)gregorianCalendar.get(5));
    }

    public void testGetDateGMT() {
        Date date = Convert.getDateGMT(1090415);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        ConvertTest.assertEquals((int)2009, (int)gregorianCalendar.get(1));
        ConvertTest.assertEquals((int)3, (int)gregorianCalendar.get(2));
    }

    public void testGetDateFromTimestamp() {
        Date date = Convert.getDateFromTimestamp(1090415123456L);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        ConvertTest.assertEquals((int)12, (int)gregorianCalendar.get(11));
        ConvertTest.assertEquals((int)34, (int)gregorianCalendar.get(12));
        ConvertTest.assertEquals((int)56, (int)gregorianCalendar.get(13));
        ConvertTest.assertEquals((int)2009, (int)gregorianCalendar.get(1));
        ConvertTest.assertEquals((int)3, (int)gregorianCalendar.get(2));
        ConvertTest.assertEquals((int)15, (int)gregorianCalendar.get(5));
    }

    public void testGetCyymmdd() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2009);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        ConvertTest.assertEquals((int)1090415, (int)Convert.getCyymmdd(gregorianCalendar));
    }

    public void testGetIsoDateString() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2009);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        Date date = gregorianCalendar.getTime();
        ConvertTest.assertEquals((String)"2009-04-15", (String)Convert.getIsoDateString(date));
    }

    public void testGetIsoTimeString() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2009);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 34);
        gregorianCalendar.set(13, 56);
        Date date = gregorianCalendar.getTime();
        ConvertTest.assertEquals((String)"12.34.56", (String)Convert.getIsoTimeString(date));
    }

    public void testGetDateString() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2009);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 34);
        gregorianCalendar.set(13, 56);
        ConvertTest.assertEquals((String)"1090415123456", (String)Convert.getDateString(gregorianCalendar));
    }

    public void testGetDateStringRejectsNull() {
        Calendar calendar = null;
        try {
            Convert.getDateString(calendar);
            ConvertTest.fail((String)"getDateString() accepted a null parameter");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetDate() {
        Calendar calendar = Convert.getDate("1090415123456");
        ConvertTest.assertEquals((int)2009, (int)calendar.get(1));
        ConvertTest.assertEquals((int)3, (int)calendar.get(2));
        ConvertTest.assertEquals((int)15, (int)calendar.get(5));
        ConvertTest.assertEquals((int)12, (int)calendar.get(11));
        ConvertTest.assertEquals((int)34, (int)calendar.get(12));
        ConvertTest.assertEquals((int)56, (int)calendar.get(13));
    }

    public void testGetDateRejectsNull() {
        String string = null;
        try {
            Convert.getDate(string);
            ConvertTest.fail((String)"getDate() accepted a null parameter");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSingleQuotedString() {
        String string = "Here's a quote.";
        String string2 = "'Here''s a quote.'";
        String string3 = Convert.singleQuotedString(string);
        ConvertTest.assertEquals((String)string2, (String)string3);
    }

    public void testRemoveNonDisplayableCharacters() {
        char[] cArray = new char[]{'\u0010', 'A', '\u0019', 'B', '\u0014', 'C', '\u0013'};
        String string = new String(cArray);
        ConvertTest.assertEquals((String)"ABC", (String)Convert.removeNonDisplableCharacters(string));
    }

    public void testRemoveNonDisplayableCharactersNullReturnsNull() {
        String string = null;
        ConvertTest.assertNull((Object)Convert.removeNonDisplableCharacters(string));
    }

    public void testGetDouble() {
        Double d = Convert.getDouble(1.23f);
        ConvertTest.assertEquals((Object)1.23, (Object)d);
    }

    public void testUnbinaryBytes() {
        BigInteger bigInteger = new BigInteger("67305985");
        BigInteger bigInteger2 = Convert.unbinaryBytes(new byte[]{4, 3, 2, 1});
        ConvertTest.assertEquals((Object)bigInteger, (Object)bigInteger2);
    }

    public void testUnbinaryBytesLargeByte() {
        BigInteger bigInteger = new BigInteger("135");
        BigInteger bigInteger2 = Convert.unbinaryBytes(new byte[]{-121});
        ConvertTest.assertEquals((Object)bigInteger, (Object)bigInteger2);
    }

    public void testUnpackBytesLargeByte() {
        BigDecimal bigDecimal = new BigDecimal("-8703.020");
        BigDecimal bigDecimal2 = Convert.unpackBytes(new byte[]{-121, 3, 2, 13}, 3);
        ConvertTest.assertEquals((Object)bigDecimal, (Object)bigDecimal2);
    }

    public void testUnpackBytesByteArrayInt() {
        BigDecimal bigDecimal = new BigDecimal("403.020");
        BigDecimal bigDecimal2 = Convert.unpackBytes(new byte[]{4, 3, 2, 1}, 3);
        ConvertTest.assertEquals((Object)bigDecimal, (Object)bigDecimal2);
    }

    public void testUnpackBytesByteArrayIntInt() {
        BigDecimal bigDecimal = new BigDecimal("403.020");
        BigDecimal bigDecimal2 = Convert.unpackBytes(new byte[]{4, 3, 2, 1}, 6, 3);
        ConvertTest.assertEquals((Object)bigDecimal, (Object)bigDecimal2);
    }

    public void testFormatSizeLong() {
        String string = "12 KB";
        String string2 = Convert.formatSize(12345L);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "11 MB";
        string2 = Convert.formatSize(12345678L);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "11 GB";
        string2 = Convert.formatSize(12345678901L);
        ConvertTest.assertEquals((String)string, (String)string2);
    }

    public void testFormatSizeLongInt() {
        String string = "12.06 KB";
        String string2 = Convert.formatSize(12345L, 2);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "11.77 MB";
        string2 = Convert.formatSize(12345678L, 2);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "11.5 GB";
        string2 = Convert.formatSize(12345678901L, 2);
        ConvertTest.assertEquals((String)string, (String)string2);
    }

    public void testFormatSizeInBytes() {
        String string = "1 byte";
        String string2 = Convert.formatSizeInBytes(1L);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "1023 bytes";
        string2 = Convert.formatSizeInBytes(1023L);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "12.1 KB";
        string2 = Convert.formatSizeInBytes(12345L);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "11.8 MB";
        string2 = Convert.formatSizeInBytes(12345678L);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "11.5 GB";
        string2 = Convert.formatSizeInBytes(12345678901L);
        ConvertTest.assertEquals((String)string, (String)string2);
    }

    public void testToHexString() {
        String string = "04030201";
        String string2 = Convert.toHexString(new byte[]{4, 3, 2, 1});
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "87";
        string2 = Convert.toHexString(new byte[]{-121});
        ConvertTest.assertEquals((String)string, (String)string2);
    }

    public void testToHexStringPortionWithOffset() {
        String string = "0302";
        String string2 = Convert.toHexString(new byte[]{4, 3, 2, 1}, 1, 2);
        ConvertTest.assertEquals((String)string, (String)string2);
    }

    public void testHexToBytes() {
        byte[] byArray = new byte[]{18, 52, 86};
        byte[] byArray2 = Convert.hexToBytes("123456");
        ConvertTest.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    public void testHexToBytesRejectsOddLength() {
        try {
            Convert.hexToBytes("12345");
            ConvertTest.fail((String)"");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMakeSafeJavaScript() {
        ConvertTest.assertEquals((String)"", (String)Convert.makeSafeJavaScript(null));
        ConvertTest.assertEquals((String)"", (String)Convert.makeSafeJavaScript(""));
        String string = "don\\'t";
        String string2 = Convert.makeSafeJavaScript("don't");
        ConvertTest.assertEquals((String)string, (String)string2);
    }

    public void testMakeSafeHtml() {
        ConvertTest.assertEquals((String)"", (String)Convert.makeSafeHtml(null));
        ConvertTest.assertEquals((String)"", (String)Convert.makeSafeHtml(""));
        String string = "&lt;&amp;&gt;";
        String string2 = Convert.makeSafeHtml("<&>   ");
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        string2 = Convert.makeSafeHtml("\t");
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "<br>";
        string2 = Convert.makeSafeHtml("\n");
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "AB";
        string2 = Convert.makeSafeHtml("A\r\r\r\r\rB");
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "A B";
        string2 = Convert.makeSafeHtml("A B", true, true);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "A&nbsp;B";
        string2 = Convert.makeSafeHtml("A B", true, false);
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "A&nbsp;B";
        string2 = Convert.makeSafeHtml("A B   ", true);
        ConvertTest.assertEquals((String)string, (String)string2);
    }

    public void testHtmlToText() {
        ConvertTest.assertEquals((String)"", (String)Convert.htmlToText(null));
        ConvertTest.assertEquals((String)"", (String)Convert.htmlToText(""));
        ConvertTest.assertEquals((String)"ABC", (String)Convert.htmlToText("ABC"));
        String string = "&gt;";
        String string2 = Convert.htmlToText("&amp;gt;");
        ConvertTest.assertEquals((String)string, (String)string2);
        string = "< > &\n";
        string2 = Convert.htmlToText("&lt;&nbsp;&gt;&nbsp;&amp;<br>");
        ConvertTest.assertEquals((String)string, (String)string2);
    }

    public void testGetDateFromString() {
        ConvertTest.assertNull((Object)Convert.getDateFromString("asdfasdfsadf"));
        ConvertTest.assertNotNull((Object)Convert.getDateFromString("2010-03-26  01:02:03"));
    }

    public void testDumpStackToString() {
        ConvertTest.assertNull((Object)Convert.dumpStackToString(null));
        Throwable throwable = new Throwable("Cause");
        Throwable throwable2 = new Throwable("Description", throwable);
        String string = Convert.dumpStackToString(throwable2);
        ConvertTest.assertTrue((boolean)string.startsWith("java.lang.Throwable: Description"));
        ConvertTest.assertTrue((boolean)string.contains("Caused by: java.lang.Throwable: Cause"));
    }
}

