/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.busobj.LocalizedDate;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Convert {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(Convert.class.getName());
    private static final String yes = rbh.getText("Yes");
    private static final String no = rbh.getText("No");
    private static final String y = rbh.getText("Y");
    private static final String n = rbh.getText("N");
    private static final SimpleDateFormat FORMATTED_ISO_DATE_STRING = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat FORMATTED_ISO_TIME_STRING = new SimpleDateFormat("HH.mm.ss");

    private Convert() {
    }

    public static String booleanToYesNo(boolean bl) {
        if (bl) {
            return yes;
        }
        return no;
    }

    public static boolean yesNoToBoolean(String string) {
        if (string == null) {
            throw new NullPointerException("String value must not be null.");
        }
        return string.equalsIgnoreCase("YES") || string.equalsIgnoreCase(yes);
    }

    public static String booleanToYN(boolean bl) {
        if (bl) {
            return y;
        }
        return n;
    }

    public static boolean ynToBoolean(String string) {
        if (string == null) {
            throw new NullPointerException("String value must not be null.");
        }
        return string.equalsIgnoreCase("Y") || string.equalsIgnoreCase(y);
    }

    public static String booleanToZeroOne(boolean bl) {
        if (bl) {
            return "1";
        }
        return "0";
    }

    public static boolean zeroOneToBoolean(String string) {
        if (string == null) {
            throw new NullPointerException("String value must not be null.");
        }
        return string.equals("1");
    }

    public static String booleanToXOrBlank(boolean bl) {
        if (bl) {
            return "X";
        }
        return " ";
    }

    public static boolean xOrBlankToBoolean(String string) {
        if (string == null) {
            throw new NullPointerException("String value must not be null.");
        }
        return string.equals("X");
    }

    public static String dumpStackToString(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter(1000);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        Convert.dumpStack(throwable, printWriter);
        printWriter.close();
        charArrayWriter.close();
        return charArrayWriter.toString();
    }

    private static void dumpStack(Throwable throwable, PrintWriter printWriter) {
        if (throwable == null) {
            return;
        }
        printWriter.print(throwable.getClass().getName());
        printWriter.print(": ");
        printWriter.println(throwable.getMessage());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray != null) {
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                printWriter.print("\tat ");
                printWriter.println(stackTraceElementArray[i].toString());
            }
        }
        printWriter.flush();
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            printWriter.print("Caused by: ");
            Convert.dumpStack(throwable2, printWriter);
        }
    }

    public static Calendar getCalendar(int n) {
        return Convert.getCalendar(n, 0);
    }

    public static Calendar getCalendar(int n, int n2) {
        TimeZone timeZone = TimeZone.getDefault();
        return Convert.getCalendar(n, n2, timeZone);
    }

    public static Calendar getCalendar(int n, int n2, TimeZone timeZone) {
        ValidationHelper.checkForNull("Time Zone", timeZone);
        if (n == 0) {
            throw new IllegalArgumentException("cyymmdd cannot be 0.");
        }
        int n3 = 1900 + n / 10000;
        int n4 = n / 100 % 100;
        int n5 = n % 100;
        int n6 = n2 / 10000;
        int n7 = n2 / 100 % 100;
        int n8 = n2 % 100;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.set(n3, n4 - 1, n5, n6, n7, n8);
        return gregorianCalendar;
    }

    public static Date getDate(int n) {
        LocalizedDate localizedDate = new LocalizedDate(Convert.getCalendar(n).getTime());
        LocalizedDate.correctTime(localizedDate);
        return localizedDate;
    }

    public static Date getDate(int n, int n2) {
        LocalizedDate localizedDate = new LocalizedDate(Convert.getCalendar(n, n2).getTime());
        LocalizedDate.correctTime(localizedDate);
        return localizedDate;
    }

    public static Date getDateGMT(int n) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        return new LocalizedDate(Convert.getCalendar(n, 0, timeZone).getTime(), timeZone);
    }

    public static Date getDateFromTimestamp(long l) {
        int n = (int)(l / 1000000L);
        int n2 = (int)(l % 1000000L);
        LocalizedDate localizedDate = new LocalizedDate(Convert.getCalendar(n, n2).getTime());
        LocalizedDate.correctTime(localizedDate);
        return localizedDate;
    }

    public static Date getDateFromString(String string) {
        Calendar calendar = Calendar.getInstance();
        try {
            int n = Integer.valueOf(string.substring(0, 4));
            int n2 = Integer.valueOf(string.substring(5, 7));
            int n3 = Integer.valueOf(string.substring(8, 10));
            int n4 = Integer.valueOf(string.substring(12, 14));
            int n5 = Integer.valueOf(string.substring(15, 17));
            int n6 = Integer.valueOf(string.substring(18, 20));
            calendar.set(n, n2, n3, n4, n5, n6);
        }
        catch (Exception exception) {
            return null;
        }
        LocalizedDate localizedDate = new LocalizedDate(calendar.getTime());
        LocalizedDate.correctTime(localizedDate);
        return localizedDate;
    }

    public static int getCyymmdd(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = n % 100;
        int n3 = (n - 1900) / 100;
        int n4 = calendar.get(2) + 1;
        int n5 = calendar.get(5);
        int n6 = n3 * 1000000 + n2 * 10000 + n4 * 100 + n5;
        return n6;
    }

    public static String getIsoDateString(Date date) {
        ValidationHelper.checkForNull("Date", date);
        return FORMATTED_ISO_DATE_STRING.format(date);
    }

    public static String getIsoTimeString(Date date) {
        ValidationHelper.checkForNull("Date", date);
        return FORMATTED_ISO_TIME_STRING.format(date);
    }

    public static String getDateString(Calendar calendar) {
        String string = "CYYMMDDHHMMSS";
        if (calendar == null) {
            throw new NullPointerException("Calendar value must not be null.");
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumIntegerDigits(2);
        String string2 = numberFormat.format(calendar.get(1) % 100);
        String string3 = numberFormat.format(calendar.get(2) + 1);
        String string4 = numberFormat.format(calendar.get(5));
        int n = (calendar.get(1) - 1900) / 100;
        String string5 = numberFormat.format(calendar.get(11));
        String string6 = numberFormat.format(calendar.get(12));
        String string7 = numberFormat.format(calendar.get(13));
        string = n + string2 + string3 + string4 + string5 + string6 + string7;
        return string;
    }

    public static Calendar getDate(String string) {
        if (string == null) {
            throw new NullPointerException("String value must not be null.");
        }
        ValidationHelper.validateBounds("CYYMMDDHHMMSS", 13L, 13L, string.length());
        StringBuffer stringBuffer = new StringBuffer(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, Integer.parseInt(stringBuffer.substring(0, 1)) * 100 + (1900 + Integer.parseInt(stringBuffer.substring(1, 3))));
        gregorianCalendar.set(2, Integer.parseInt(stringBuffer.substring(3, 5)) - 1);
        gregorianCalendar.set(5, Integer.parseInt(stringBuffer.substring(5, 7)));
        gregorianCalendar.set(11, Integer.parseInt(stringBuffer.substring(7, 9)));
        gregorianCalendar.set(12, Integer.parseInt(stringBuffer.substring(9, 11)));
        gregorianCalendar.set(13, Integer.parseInt(stringBuffer.substring(11, 13)));
        return gregorianCalendar;
    }

    public static String trimL(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return string.substring(i);
        }
        return "";
    }

    public static String trimR(String string) {
        if (string == null) {
            return null;
        }
        for (int i = string.length(); i > 0; --i) {
            if (string.charAt(i - 1) == ' ') continue;
            return string.substring(0, i);
        }
        return "";
    }

    public static String singleQuotedString(String string) {
        ValidationHelper.checkForNull("String", string);
        return "'" + string.replaceAll("'", "''") + "'";
    }

    public static String removeNonDisplableCharacters(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static double getDouble(float f) {
        return Math.rint(f * 100.0f) / 100.0;
    }

    public static BigInteger unbinaryBytes(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            l *= 256L;
            l += (long)n;
        }
        return new BigInteger(Long.toString(l));
    }

    public static BigDecimal unpackBytes(byte[] byArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n3 = byArray[n2];
            if (n3 < 0) {
                n3 += 256;
            }
            if (n3 <= 15) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n3));
        }
        n2 = stringBuffer.charAt(stringBuffer.length() - 1);
        if (n2 == 68 || n2 == 100) {
            stringBuffer.insert(0, '-');
        }
        stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        stringBuffer.insert(stringBuffer.length() - n, '.');
        return new BigDecimal(stringBuffer.toString());
    }

    public static BigDecimal unpackBytes(byte[] byArray, int n, int n2) {
        return Convert.unpackBytes(byArray, n2);
    }

    public static String formatSize(long l) {
        return Convert.formatSize(l, 0);
    }

    public static String formatSize(long l, int n) {
        double d = l;
        String[] stringArray = new String[]{"", "KB", "MB", "GB", "TB"};
        int n2 = 0;
        while (true) {
            if (d < 1024.0 || n2 + 1 == stringArray.length) {
                if (n < 1 || n2 == 0) {
                    long l2 = (long)d;
                    return l2 + " " + stringArray[n2];
                }
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setMaximumFractionDigits(n);
                return numberFormat.format(d) + " " + stringArray[n2];
            }
            ++n2;
            d /= 1024.0;
        }
    }

    public static String formatSizeInBytes(long l) {
        String string = null;
        if (l == 1L) {
            string = l + " byte";
            return string;
        }
        if (l < 1024L) {
            string = l + " bytes";
            return string;
        }
        return Convert.formatSize(l, 1);
    }

    public static String toHexString(byte[] byArray) {
        return Convert.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2; ++i) {
            String string;
            int n3 = byArray[i];
            if (n3 < 0) {
                n3 += 256;
            }
            if ((string = Integer.toHexString(n3)).length() < 2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static byte[] hexToBytes(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Odd number of chars: " + string.length());
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = string.substring(i * 2, i * 2 + 2);
            byArray[i] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    public static String makeSafeHtml(String string, boolean bl) {
        return Convert.makeSafeHtml(string, bl, false);
    }

    public static String makeSafeJavaScript(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return string.replaceAll("'", "\\\\'");
    }

    public static String makeSafeHtml(String string) {
        return Convert.makeSafeHtml(string, true, false);
    }

    public static String makeSafeHtml(String string, boolean bl, boolean bl2) {
        String string2 = string;
        if (string2 == null || string2.length() == 0) {
            return "";
        }
        if (bl) {
            int n;
            for (n = string2.length() - 1; n > -1 && string2.charAt(n) == ' '; --n) {
            }
            string2 = string2.substring(0, n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        block10: for (int i = 0; i < string2.length(); ++i) {
            switch (string2.charAt(i)) {
                case ' ': {
                    if (!bl2) {
                        stringBuffer.append("&nbsp;");
                        continue block10;
                    }
                    stringBuffer.append(string2.charAt(i));
                    continue block10;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block10;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block10;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    continue block10;
                }
                case '\r': {
                    continue block10;
                }
                default: {
                    stringBuffer.append(string2.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String htmlToText(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String[][] stringArrayArray = new String[][]{{"&nbsp;", " "}, {"&lt;", "<"}, {"&gt;", ">"}, {"&amp;", "&"}, {"<br>", "\n"}};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n = 0;
        while (n < string.length()) {
            boolean bl = false;
            for (int i = 0; i < stringArrayArray.length; ++i) {
                string2 = stringArrayArray[i][0];
                if (!string.regionMatches(true, n, string2, 0, string2.length())) continue;
                stringBuffer.append(stringArrayArray[i][1]);
                n += string2.length();
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }
}

