/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.filter.FilterCriteria;
import java.io.Serializable;

public class FilterFieldList
extends AbstractFilterField {
    private static final long serialVersionUID = 2962092204725244085L;
    private String[] operators = new String[]{"0", "1"};
    private String[] displayable = null;
    private Serializable[] values = null;

    public FilterFieldList() {
    }

    public FilterFieldList(String string, String string2, String[] stringArray, Serializable[] serializableArray) {
        super(string, string2, 5);
        this.setOperatorArray(this.operators);
        this.validateParameters(stringArray, serializableArray);
        this.values = serializableArray;
        this.displayable = stringArray;
    }

    public FilterFieldList(String string, String string2, String[] stringArray, Serializable[] serializableArray, String string3) {
        super(string, string2, 5);
        this.setOperatorArray(new String[]{string3});
        this.validateParameters(stringArray, serializableArray);
        this.values = serializableArray;
        this.displayable = stringArray;
    }

    private void validateParameters(String[] stringArray, Serializable[] serializableArray) {
        if (serializableArray == null) {
            throw new NullPointerException("Values array may not be null.");
        }
        if (stringArray == null) {
            throw new NullPointerException("Displayble array may not be null.");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Displayble array may not be length 0.");
        }
        if (serializableArray.length == 0) {
            throw new IllegalArgumentException("Value array may not be length 0.");
        }
        if (serializableArray.length != stringArray.length) {
            throw new IllegalArgumentException("Value and Displayable arrays must have the same length.");
        }
    }

    @Override
    public boolean valid(int n, Object object) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Operator " + n + " is invalid.");
        }
        return super.valid(n, object);
    }

    public String[] getDisplayableItems() {
        return this.displayable;
    }

    private Serializable getValueForDisplayable(String string) {
        int n = -1;
        for (int i = 0; i < this.displayable.length; ++i) {
            if (!this.displayable[i].equals(string)) continue;
            n = i;
            break;
        }
        return this.values[n];
    }

    private Serializable getDisplayableForValue(Object object) {
        int n = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(object)) continue;
            n = i;
            break;
        }
        return this.displayable[n];
    }

    @Override
    public FilterCriteria getFilterCriteria(int n, Serializable serializable) {
        this.valid(n, serializable);
        return new FilterCriteria(this.fieldName, this.getValueForDisplayable((String)((Object)serializable)), n);
    }

    @Override
    public Serializable getValueFromCriteria(FilterCriteria filterCriteria) {
        return this.getDisplayableForValue(filterCriteria.getValue());
    }
}

