/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.console;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.ValidationHelper;

public class MessageCenterMessage
extends CommonVersionedObject {
    public static final int MAXLEN_CENTER_NAME = 10;
    public static final int MAXLEN_MESSAGE_TEXT = 256;
    public static final String RESP_REQ_NO = "*NO";
    public static final String RESP_REQ_YES = "*YES";
    private String messageCenter = null;
    private String messageText = null;
    private boolean responseRequired = false;

    public MessageCenterMessage() {
    }

    public MessageCenterMessage(String string, String string2) {
        this(string, string2, false);
    }

    public MessageCenterMessage(String string, String string2, boolean bl) {
        this.setMessageCenter(string);
        this.setMessageText(string2);
        this.setResponseRequired(bl);
    }

    public String buildSndMsgCommand() {
        if (this.messageCenter == null) {
            throw new IllegalStateException("Message Center name is null.");
        }
        if (this.messageText == null) {
            throw new IllegalStateException("Message text is null.");
        }
        String string = "SENDMC MSG('" + this.messageText.replaceAll("'", "''") + "') MSGCTR(" + this.messageCenter.replaceAll("'", "''") + ")";
        return string;
    }

    public String getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(String string) {
        String string2 = "Message Center Name";
        ValidationHelper.checkForNull(string2, string);
        String string3 = Convert.trimR(string);
        ValidationHelper.checkForBlankIgnoreNull(string2, string3);
        ValidationHelper.validateLength(string2, 10, string3);
        this.messageCenter = string3;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String string) {
        String string2 = "Message Text";
        ValidationHelper.checkForNull(string2, string);
        String string3 = Convert.trimR(string);
        ValidationHelper.checkForBlankIgnoreNull(string2, string3);
        ValidationHelper.validateLength(string2, 256, string3);
        this.messageText = string3;
    }

    public boolean getResponseRequired() {
        return this.responseRequired;
    }

    public void setResponseRequired(boolean bl) {
        this.responseRequired = bl;
    }
}

