/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.util.NativeSz;
import com.helpsystems.common.core.util.TargetVersionInfo;
import com.helpsystems.common.core.util.VersionedObjectOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class VersionedObject
implements Externalizable {
    private static final Logger logger = Logger.getLogger(VersionedObject.class);
    private static final long serialVersionUID = 221133114411551166L;

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        VersionedObject versionedObject = (VersionedObject)object;
        TargetVersionInfo targetVersionInfo = new TargetVersionInfo();
        versionedObject.fillInVersion(targetVersionInfo);
        TargetVersionInfo targetVersionInfo2 = new TargetVersionInfo();
        this.fillInVersion(targetVersionInfo2);
        return targetVersionInfo2.equals(targetVersionInfo);
    }

    @Override
    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        TargetVersionInfo targetVersionInfo = (TargetVersionInfo)objectInput.readObject();
        TargetVersionInfo targetVersionInfo2 = new TargetVersionInfo();
        this.fillInVersion(targetVersionInfo2);
        int n = targetVersionInfo2.testCompatibility(targetVersionInfo);
        if (n == 3) {
            logger.debug((Object)("Warning: Attempting to read a newer version of " + this.getClass().getName()));
        }
        if (n == 1) {
            NativeSz.readObject(objectInput, this);
        } else {
            ObjectFieldMap objectFieldMap = new ObjectFieldMap();
            NativeSz.copyStreamToMap(objectInput, objectFieldMap);
            try {
                this.adjustForReading(targetVersionInfo, objectFieldMap);
                NativeSz.copyMapToObject(objectFieldMap, this);
            }
            catch (RuntimeException runtimeException) {
                String string = "Error deserializing object " + this.getClass().getName();
                logger.debug((Object)(string + "\n" + targetVersionInfo), (Throwable)runtimeException);
                IOException iOException = new IOException(string);
                iOException.initCause(runtimeException);
                throw iOException;
            }
        }
        this.afterReading();
    }

    protected void afterReading() throws IOException {
    }

    protected abstract void adjustForReading(TargetVersionInfo var1, ObjectFieldMap var2) throws IOException;

    @Override
    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.beforeWriting();
        TargetVersionInfo targetVersionInfo = new TargetVersionInfo();
        this.fillInVersion(targetVersionInfo);
        TargetVersionInfo targetVersionInfo2 = null;
        if (objectOutput instanceof VersionedObjectOutputStream) {
            VersionedObjectOutputStream versionedObjectOutputStream = (VersionedObjectOutputStream)objectOutput;
            targetVersionInfo2 = versionedObjectOutputStream.getTargetVersionInfo();
        }
        int n = 1;
        if (targetVersionInfo2 != null) {
            n = targetVersionInfo.testCompatibility(targetVersionInfo2);
        }
        if (n == 1 || n == 3) {
            objectOutput.writeObject(targetVersionInfo);
            NativeSz.writeObject(objectOutput, this);
        } else {
            ObjectFieldMap objectFieldMap = new ObjectFieldMap();
            NativeSz.copyFieldsToMap(this, objectFieldMap);
            this.adjustForWriting(targetVersionInfo2, objectFieldMap);
            objectOutput.writeObject(targetVersionInfo2);
            NativeSz.writeMapToStream(objectOutput, objectFieldMap);
        }
    }

    protected void beforeWriting() throws IOException {
    }

    protected abstract void adjustForWriting(TargetVersionInfo var1, ObjectFieldMap var2) throws IOException;

    protected abstract void fillInVersion(TargetVersionInfo var1);

    public class ObjectFieldMap
    extends HashMap {
        @Override
        public Object put(Object object, Object object2) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("The key passed in must be a String: " + object.getClass().getName());
            }
            if (this.get(object) != null) {
                throw new IllegalStateException("The field " + object + " has already been set.");
            }
            return super.put(object, object2);
        }

        @Override
        public Object replace(Object object, Object object2) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("The key passed in must be a String: " + object.getClass().getName());
            }
            return super.put(object, object2);
        }
    }
}

