/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.UserIdentityProxy;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserIdentity
extends UserIdentityProxy
implements XMLSerializable {
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(UserIdentity.class);
    private static final long serialVersionUID = -989515108675309023L;
    public static final int MAX_USERNAME_LENGTH = 100;
    public static final int MAX_SYSTEM_LENGTH = 256;
    public static final int MAX_PASSWORD_LENGTH = 100;
    public static final UserIdentity NO_USER_SPECIFIED = new UserIdentity("NoUserSpecified", "Localhost");
    private boolean immutable;
    public static final int UNKNOWN = 0;
    public static final int PASSWORD_VALID = 1;
    public static final int PASSWORD_INVALID = -1;
    private static final Serializable LAST_LOGIN_DATE;
    private static final Serializable CURRENT_LOGIN_DATE;
    private static final Serializable PARENT_USER_IDENTITY;
    private static final Serializable FLAGS;
    private static final Serializable PASSWORD_STATE;
    private static final Serializable WHEN_SAVED_DATE;
    private int GROUP_TYPE = 1;
    private int IDENTITY_TYPE = 2;
    private String encryptedPassword;
    private HashMap<Object, Serializable> attributes = new HashMap();

    public UserIdentity() {
        this.addDoNotInvoke("getAttributeNames");
    }

    public UserIdentity(String string, String string2) {
        super(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(String string) {
        ValidationHelper.checkForNull("Group", string);
        Key key = new Key(this.GROUP_TYPE, string);
        HashMap<Object, Serializable> hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(key, (Serializable)((Object)string));
        }
    }

    public void addIdentity(UserIdentity userIdentity) {
        ValidationHelper.checkForNull("UserIdentity", userIdentity);
        ValidationHelper.checkForNull("Username", userIdentity.getName());
        String string = userIdentity.getSystem();
        ValidationHelper.checkForNull("System", string);
        if (this.getSystem() != null && this.getSystem().equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(rbh.getMsg("same_system_as_parent", string));
        }
        UserIdentity userIdentity2 = this.getIdentity(string);
        if (userIdentity2 != null) {
            int n = userIdentity2.getOID();
            userIdentity.setOID(n);
        }
        Key key = new Key(this.IDENTITY_TYPE, string);
        this.internalSetAttribute(key, userIdentity);
        userIdentity.setParentIdentity(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getAttributes(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<Object, Serializable> hashMap = this.attributes;
        synchronized (hashMap) {
            for (Map.Entry<Object, Serializable> entry : this.attributes.entrySet()) {
                Key key;
                if (!(entry.getKey() instanceof Key) || (key = (Key)entry.getKey()).objectType != n) continue;
                arrayList.add(entry.getValue());
            }
        }
        return arrayList;
    }

    public String[] getGroups() {
        List<Object> list = this.getAttributes(this.GROUP_TYPE);
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    public UserIdentity[] getIdentities() {
        List<Object> list = this.getAttributes(this.IDENTITY_TYPE);
        UserIdentity[] userIdentityArray = new UserIdentity[list.size()];
        list.toArray(userIdentityArray);
        return userIdentityArray;
    }

    public UserIdentity getIdentity(String string) {
        if (string == null) {
            throw new NullPointerException("The server name passed in was null.");
        }
        if (string != null && string.equalsIgnoreCase(this.getSystem())) {
            return this;
        }
        UserIdentity[] userIdentityArray = this.getIdentities();
        for (int i = 0; i < userIdentityArray.length; ++i) {
            UserIdentity userIdentity = userIdentityArray[i].getIdentity(string);
            if (userIdentity == null) continue;
            return userIdentity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getAttribute(Serializable serializable) {
        HashMap<Object, Serializable> hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable[] getAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.attributes;
        synchronized (this.attributes) {
            for (Object object : this.attributes.keySet()) {
                if (!(object instanceof String)) continue;
                arrayList.add((String)object);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
    }

    public long getCurrentLogin() {
        return this.getLongAttribute(CURRENT_LOGIN_DATE);
    }

    public int getFlags() {
        return (int)this.getLongAttribute(FLAGS);
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public long getLastLogin() {
        return this.getLongAttribute(LAST_LOGIN_DATE);
    }

    public long getWhenSaved() {
        return this.getLongAttribute(WHEN_SAVED_DATE);
    }

    private long getLongAttribute(Object object) {
        Long l = (Long)this.internalGetAttribute(object);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public UserIdentity getParentIdentity() {
        return (UserIdentity)this.internalGetAttribute(PARENT_USER_IDENTITY);
    }

    public int getParentOID() {
        UserIdentity userIdentity = this.getParentIdentity();
        if (userIdentity == null) {
            return -1;
        }
        return userIdentity.getOID();
    }

    public int getPasswordState() {
        return (int)this.getLongAttribute(PASSWORD_STATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable internalGetAttribute(Object object) {
        HashMap<Object, Serializable> hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSetAttribute(Serializable serializable, Serializable serializable2) {
        HashMap<Object, Serializable> hashMap = this.attributes;
        synchronized (hashMap) {
            if (serializable2 == null) {
                this.attributes.remove(serializable);
            } else {
                this.attributes.put(serializable, serializable2);
            }
        }
    }

    public void removeGroup(String string) {
        this.checkIfImmutable();
        ValidationHelper.checkForNull("Group", string);
        this.internalSetAttribute(new Key(this.GROUP_TYPE, string), null);
    }

    public void removeIdentity(String string) {
        this.checkIfImmutable();
        ValidationHelper.checkForNull("Server name", string);
        this.internalSetAttribute(new Key(this.IDENTITY_TYPE, string), null);
    }

    public void removeAttribute(Serializable serializable) {
        this.checkIfImmutable();
        ValidationHelper.checkForNull("Key name", serializable);
        this.internalSetAttribute(serializable, null);
    }

    public void setAttribute(Serializable serializable, Serializable serializable2) {
        this.checkIfImmutable();
        ValidationHelper.checkForNull("Key name", serializable);
        if (serializable2 == null) {
            this.removeAttribute(serializable);
            return;
        }
        this.internalSetAttribute(serializable, serializable2);
    }

    public void setLastLogin(long l) {
        this.checkIfImmutable();
        this.internalSetAttribute(LAST_LOGIN_DATE, new Long(l));
    }

    public void setWhenSaved(long l) {
        this.checkIfImmutable();
        this.internalSetAttribute(WHEN_SAVED_DATE, new Long(l));
    }

    public void setCurrentLogin(long l) {
        this.checkIfImmutable();
        this.internalSetAttribute(CURRENT_LOGIN_DATE, new Long(l));
    }

    public void setFlags(int n) {
        this.checkIfImmutable();
        this.internalSetAttribute(FLAGS, new Long(n));
    }

    public void setEncryptedPassword(String string) {
        this.checkIfImmutable();
        String string2 = string == null ? "" : string;
        ValidationHelper.validateLength("Encrypted password", 100, string2);
        this.encryptedPassword = string2;
        this.setPasswordState(0);
    }

    @Override
    public void setName(String string) {
        this.checkIfImmutable();
        ValidationHelper.validateLength("Name", 100, string);
        super.setName(string);
    }

    public void setParentIdentity(UserIdentity userIdentity) {
        this.checkIfImmutable();
        this.internalSetAttribute(PARENT_USER_IDENTITY, userIdentity);
    }

    public void setParentOID(int n) {
        this.checkIfImmutable();
    }

    public void setPasswordState(int n) {
        this.checkIfImmutable();
        switch (n) {
            case -1: 
            case 0: 
            case 1: {
                this.internalSetAttribute(PASSWORD_STATE, new Long(n));
                return;
            }
        }
        throw new IllegalArgumentException("The value passed in is not valid");
    }

    @Override
    public void setSystem(String string) {
        this.checkIfImmutable();
        ValidationHelper.validateLength("System", 256, string);
        super.setSystem(string);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UserIdentity userIdentity = (UserIdentity)object;
        return super.equals(object) && Equal.isEqual(this.encryptedPassword, userIdentity.encryptedPassword);
    }

    private void checkIfImmutable() {
        if (this.immutable) {
            throw new IllegalStateException("This User Identity instance is immutable.");
        }
    }

    static {
        UserIdentity.NO_USER_SPECIFIED.immutable = true;
        LAST_LOGIN_DATE = new Integer(1001);
        CURRENT_LOGIN_DATE = new Integer(1002);
        PARENT_USER_IDENTITY = new Double(1003.0);
        FLAGS = new Integer(1004);
        PASSWORD_STATE = new Integer(1005);
        WHEN_SAVED_DATE = new Integer(1006);
    }

    class Key
    implements Serializable {
        private static final long serialVersionUID = -8353132249041853046L;
        private String string;
        private int objectType;

        Key(int n, String string) {
            this.objectType = n;
            this.string = string;
        }

        public int hashCode() {
            return this.string.hashCode() + this.objectType;
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            Key key = (Key)object;
            return Equal.isEqual(this.string, key.string) && this.objectType == key.objectType;
        }
    }
}

