/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.InstalledProduct;
import java.util.Hashtable;

public class InstalledProducts {
    private Hashtable<BasicIdentifier, Hashtable<String, InstalledProduct>> systems = new Hashtable();
    private static InstalledProducts instance;

    private InstalledProducts() {
    }

    public static InstalledProducts getInstance() {
        if (instance == null) {
            instance = new InstalledProducts();
        }
        return instance;
    }

    public void clearProducts() {
        this.systems.clear();
    }

    public boolean isProductInstalled(String string, BasicIdentifier basicIdentifier) {
        InstalledProduct installedProduct = null;
        Hashtable<String, InstalledProduct> hashtable = this.systems.get(basicIdentifier);
        if (hashtable == null) {
            return false;
        }
        installedProduct = hashtable.get(string);
        if (installedProduct == null) {
            return false;
        }
        return installedProduct.isInstalled();
    }

    public boolean isProductInstalled(int n, BasicIdentifier basicIdentifier) {
        String string = InstalledProduct.getApplCode(n);
        return this.isProductInstalled(string, basicIdentifier);
    }

    public void add(InstalledProduct installedProduct, BasicIdentifier basicIdentifier) {
        Hashtable<String, InstalledProduct> hashtable = this.systems.get(basicIdentifier);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.systems.put(basicIdentifier, hashtable);
        }
        hashtable.put(installedProduct.getApplCode(), installedProduct);
    }

    public InstalledProduct getInstalledProduct(String string, BasicIdentifier basicIdentifier) {
        Hashtable<String, InstalledProduct> hashtable = this.systems.get(basicIdentifier);
        if (hashtable == null) {
            return null;
        }
        return hashtable.get(string);
    }

    public InstalledProduct[] getInstalledProducts() {
        return null;
    }

    public void logList() {
    }
}

