/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.Feedback;
import junit.framework.TestCase;

public class FeedbackTest
extends TestCase {
    Feedback fb1;
    Feedback fb2;

    protected void setUp() throws Exception {
        super.setUp();
        this.fb1 = new Feedback();
        this.fb2 = new Feedback();
    }

    protected void tearDown() throws Exception {
        this.fb1 = null;
        this.fb2 = null;
        super.tearDown();
    }

    public void testHandleErrors() {
        FeedbackTest.assertFalse((boolean)this.fb1.hasErrors());
        Throwable[] throwableArray = this.fb1.getErrors();
        FeedbackTest.assertNotNull((Object)throwableArray);
        FeedbackTest.assertEquals((int)0, (int)throwableArray.length);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("An illegal argument exception");
        this.fb1.addError(illegalArgumentException);
        FeedbackTest.assertTrue((boolean)this.fb1.hasErrors());
        throwableArray = this.fb1.getErrors();
        FeedbackTest.assertEquals((int)1, (int)throwableArray.length);
        NullPointerException nullPointerException = new NullPointerException("A null pointer exception");
        IllegalStateException illegalStateException = new IllegalStateException("An illegal state exception");
        this.fb1.addErrors(new Throwable[]{nullPointerException, illegalStateException});
        throwableArray = this.fb1.getErrors();
        FeedbackTest.assertEquals((int)3, (int)throwableArray.length);
        FeedbackTest.assertFalse((boolean)this.fb2.hasErrors());
        this.fb2.addErrors(new Throwable[]{nullPointerException, illegalStateException});
        FeedbackTest.assertTrue((boolean)this.fb2.hasErrors());
        throwableArray = this.fb2.getErrors();
        FeedbackTest.assertEquals((int)2, (int)throwableArray.length);
    }

    public void testHandleWarnings() {
        FeedbackTest.assertFalse((boolean)this.fb1.hasWarnings());
        String[] stringArray = this.fb1.getWarnings();
        FeedbackTest.assertNotNull((Object)stringArray);
        FeedbackTest.assertEquals((int)0, (int)stringArray.length);
        this.fb1.addWarning("Warning one");
        FeedbackTest.assertTrue((boolean)this.fb1.hasWarnings());
        stringArray = this.fb1.getWarnings();
        FeedbackTest.assertEquals((int)1, (int)stringArray.length);
        this.fb1.addWarnings(new String[]{"Warning two", "Warning three"});
        stringArray = this.fb1.getWarnings();
        FeedbackTest.assertEquals((int)3, (int)stringArray.length);
        FeedbackTest.assertFalse((boolean)this.fb2.hasWarnings());
        this.fb2.addWarnings(new String[]{"Warning two", "Warning three"});
        FeedbackTest.assertTrue((boolean)this.fb2.hasWarnings());
        stringArray = this.fb2.getWarnings();
        FeedbackTest.assertEquals((int)2, (int)stringArray.length);
    }

    public void testHandleSuccesses() {
        FeedbackTest.assertFalse((boolean)this.fb1.hasSuccesses());
        String[] stringArray = this.fb1.getSuccesses();
        FeedbackTest.assertNotNull((Object)stringArray);
        FeedbackTest.assertEquals((int)0, (int)stringArray.length);
        this.fb1.addSuccess("Success one");
        FeedbackTest.assertTrue((boolean)this.fb1.hasSuccesses());
        stringArray = this.fb1.getSuccesses();
        FeedbackTest.assertEquals((int)1, (int)stringArray.length);
        this.fb1.addSuccesses(new String[]{"Success two", "Success three"});
        stringArray = this.fb1.getSuccesses();
        FeedbackTest.assertEquals((int)3, (int)stringArray.length);
        FeedbackTest.assertFalse((boolean)this.fb2.hasSuccesses());
        this.fb2.addSuccesses(new String[]{"Success two", "Success three"});
        FeedbackTest.assertTrue((boolean)this.fb2.hasSuccesses());
        stringArray = this.fb2.getSuccesses();
        FeedbackTest.assertEquals((int)2, (int)stringArray.length);
    }
}

