/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.AbstractManagerLoader;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class GenericManagerLoader
extends AbstractManagerLoader {
    private static final Logger logger = Logger.getLogger(GenericManagerLoader.class);
    private String libraryName;
    private RelMod interfaceVersion;
    private String suffix = "";
    private List<AbstractManager> list;

    protected GenericManagerLoader(String string, String string2) {
        ValidationHelper.checkForNullAndBlank("Library", string);
        this.libraryName = string;
        if (string2 != null && string2.trim().length() > 0) {
            this.suffix = string2;
        }
        this.list = new ArrayList<AbstractManager>();
    }

    public RelMod getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public String getLibrary() {
        return this.libraryName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    protected boolean isProductMasterMode() {
        return this.suffix.equals("_PM");
    }

    protected boolean isDataReplicationMode() {
        return this.suffix.equals("_DR");
    }

    protected abstract RelMod retrieveInterfaceVersion() throws ResourceUnavailableException;

    protected final void registerManager(AbstractManager abstractManager) {
        if (this.interfaceVersion == null) {
            try {
                this.interfaceVersion = this.retrieveInterfaceVersion();
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to retrieve the interface version.", (Throwable)exception);
                this.interfaceVersion = RelMod.UNKNOWN;
            }
        }
        abstractManager.setInterfaceVersion(this.interfaceVersion);
        this.setAdditionalManagerAttributes(abstractManager);
        ManagerRegistry.registerManager(abstractManager);
        this.list.add(abstractManager);
    }

    protected final void registerManagerWithSuffix(AbstractManager abstractManager) {
        String string = abstractManager.getName();
        if (!string.endsWith(this.suffix)) {
            abstractManager.setName(string, this.suffix);
        }
        this.registerManager(abstractManager);
    }

    protected void setAdditionalManagerAttributes(AbstractManager abstractManager) {
    }

    @Override
    public void unloadAll() {
        for (IAbstractManager iAbstractManager : this.list) {
            ManagerRegistry.removeManager(iAbstractManager.getName());
        }
        this.list.clear();
    }
}

