/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

public class WindowsSocketProcess
extends Process {
    private static final Logger logger = Logger.getLogger(WindowsSocketProcess.class);
    private final String END_OF_PROCESS = "Process exited with value: ";
    private Socket socket;
    private InputStream socketin;
    private InputStream in;
    private OutputStream out;
    private int exitValue;

    public WindowsSocketProcess(Socket socket) throws IOException {
        this.socket = socket;
        this.socketin = socket.getInputStream();
        InputStreamWrapper inputStreamWrapper = new InputStreamWrapper();
        Thread thread = new Thread(inputStreamWrapper);
        thread.setName("Reading socket/job data");
        thread.start();
        this.in = new BufferedInputStream(inputStreamWrapper, 8000);
        this.out = this.socket.getOutputStream();
        this.exitValue = Integer.MIN_VALUE;
    }

    @Override
    public void destroy() {
        if (this.in != null) {
            try {
                this.in.close();
                this.in = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            logger.debug((Object)"Unable to close socket, process may be left running.", (Throwable)iOException);
        }
    }

    @Override
    public boolean isAlive() {
        return this.exitValue == Integer.MIN_VALUE;
    }

    @Override
    public int exitValue() {
        if (this.exitValue == Integer.MIN_VALUE) {
            throw new IllegalThreadStateException();
        }
        return this.exitValue;
    }

    @Override
    public InputStream getErrorStream() {
        return this.getInputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public int waitFor() throws InterruptedException {
        while (this.isAlive()) {
            Thread.sleep(250L);
        }
        return this.exitValue;
    }

    private class InputStreamWrapper
    extends InputStream
    implements Runnable {
        private byte[] mybuf = new byte[1024];
        private int bufoffset;
        private int buflength;
        private boolean isClosed = false;
        private int possibleExitValue = Integer.MIN_VALUE;

        private InputStreamWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (!this.isClosed) {
                try {
                    Object object;
                    int n;
                    int n2;
                    byte[] byArray = this.mybuf;
                    // MONITORENTER : this.mybuf
                    if (this.buflength == 0) {
                        this.bufoffset = 0;
                    }
                    if ((n2 = this.mybuf.length - (this.bufoffset + this.buflength)) == 0) {
                        this.mybuf.wait();
                        // MONITOREXIT : byArray
                        continue;
                    }
                    // MONITOREXIT : byArray
                    byte[] byArray2 = new byte[n2];
                    int n3 = WindowsSocketProcess.this.socketin.read(byArray2, 0, byArray2.length);
                    if (n3 > 0 && (n = ((String)(object = (Object)new String(byArray2, 0, n3))).indexOf("Process exited with value: ")) > -1 && ((String)object).length() > "Process exited with value: ".length()) {
                        StringBuilder stringBuilder = new StringBuilder(((String)object).substring("Process exited with value: ".length()));
                        boolean bl = true;
                        while (bl) {
                            bl = false;
                            for (int i = stringBuilder.length() - 1; i >= 0; --i) {
                                if (Character.isDigit(stringBuilder.charAt(i))) continue;
                                stringBuilder.deleteCharAt(i);
                                bl = true;
                            }
                        }
                        String string = stringBuilder.toString();
                        try {
                            this.possibleExitValue = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.debug((Object)("Unable to parse exit code: " + (String)object));
                            logger.debug((Object)("Unable to parse exs[" + string + "]"));
                            logger.debug((Object)("Unable to parse sb[" + stringBuilder + "]"));
                            logger.debug((Object)("Unable to parse lengths s[" + ((String)object).length() + "]"));
                            logger.debug((Object)("Unable to parse lengths sb[" + stringBuilder.length() + "]"));
                            logger.debug((Object)("Unable to parse lengths exs[" + string.length() + "]"));
                        }
                    }
                    object = this.mybuf;
                    // MONITORENTER : this.mybuf
                    if (n3 < 0) {
                        this.isClosed = true;
                        WindowsSocketProcess.this.exitValue = 1;
                    }
                    if (n3 > 0) {
                        System.arraycopy(byArray2, 0, this.mybuf, this.bufoffset + this.buflength, n3);
                        this.buflength += n3;
                        if (this.buflength > 0) {
                            this.mybuf.notifyAll();
                        }
                    }
                    // MONITOREXIT : object
                }
                catch (IOException iOException) {
                    if (this.possibleExitValue == Integer.MIN_VALUE) break;
                    WindowsSocketProcess.this.exitValue = this.possibleExitValue;
                    break;
                }
                catch (Throwable throwable) {
                    logger.debug((Object)"Error reading from socket", throwable);
                    break;
                }
            }
            if (WindowsSocketProcess.this.exitValue == Integer.MIN_VALUE) {
                WindowsSocketProcess.this.exitValue = 1;
            }
            this.isClosed = true;
            try {
                WindowsSocketProcess.this.socket.close();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int transferBuffer(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = this.mybuf;
            synchronized (this.mybuf) {
                while (this.buflength == 0) {
                    if (this.areWeClosed()) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return 0;
                    }
                    this.mybuf.notifyAll();
                    try {
                        this.mybuf.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return 0;
                    }
                }
                int n3 = Math.min(this.buflength, n2);
                System.arraycopy(this.mybuf, this.bufoffset, byArray, n, n3);
                this.bufoffset += n3;
                this.buflength -= n3;
                if (this.buflength == 0) {
                    this.mybuf.notifyAll();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return n3;
            }
        }

        private boolean areWeClosed() throws IOException {
            if (this.buflength > 0) {
                return false;
            }
            return this.isClosed;
        }

        @Override
        public void close() {
            this.isClosed = true;
            try {
                WindowsSocketProcess.this.socketin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                WindowsSocketProcess.this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void mark(int n) {
        }

        @Override
        public synchronized void reset() throws IOException {
            WindowsSocketProcess.this.socketin.reset();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.transferBuffer(byArray, n, n2);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.transferBuffer(byArray, 0, byArray.length);
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            this.transferBuffer(byArray, 0, 1);
            return byArray[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            byte[] byArray = this.mybuf;
            synchronized (this.mybuf) {
                if (this.areWeClosed()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return 0;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.buflength;
            }
        }

        @Override
        public long skip(long l) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

