/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.webservice;

import com.helpsystems.common.core.access.ActionFailedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;

public class WebServiceDetails {
    private final String http = "http://";
    private final String https = "https://";
    private final String sslValue = "any";
    private boolean ssl = false;
    private String serverurl = null;
    private String password = null;
    private String username = null;
    private String name = null;
    private String suite = null;
    private String type = null;
    private String action = null;
    private String configFile = null;
    private String filename = null;
    private String filepath = null;
    private boolean devMode = false;
    private boolean useHttps = false;
    private String jobparameter = null;
    private String queuename = null;
    private String queueparameter = null;
    private String jobnameoverride = null;
    private String runpriority = null;

    public String getServerurl() {
        return this.serverurl;
    }

    public void setServerurl(String string) {
        this.serverurl = string;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public String getRunPriority() {
        return this.runpriority;
    }

    public void setRunPriority(String string) {
        this.runpriority = string;
    }

    public void parseParameters(String[] stringArray) throws ActionFailedException {
        int n;
        Object object;
        int n2;
        String string = null;
        String string2 = null;
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = stringArray[n2].split("=");
            n = ((String[])object).length;
            if (n > 0) {
                string = object[0].trim().toLowerCase();
            }
            string2 = null;
            if (n == 2) {
                string2 = object[1];
            } else if (n > 2) {
                String string3;
                string2 = string3 = stringArray[n2].substring(object[0].length() + 1);
            }
            try {
                if (string.equals("-name")) {
                    this.name = string2;
                    continue;
                }
                if (string.equals("-type")) {
                    this.type = string2;
                    continue;
                }
                if (string.equals("-serverurl")) {
                    this.serverurl = string2;
                    continue;
                }
                if (string.equals("-username")) {
                    this.username = string2;
                    continue;
                }
                if (string.equals("-password")) {
                    this.password = string2;
                    continue;
                }
                if (string.equals("-action")) {
                    this.action = string2;
                    continue;
                }
                if (string.equals("-configfile")) {
                    this.configFile = string2;
                    continue;
                }
                if (string.equals("-filename")) {
                    this.filename = string2;
                    continue;
                }
                if (string.equals("-filepath")) {
                    this.filepath = string2;
                    continue;
                }
                if (string.equals("-jobparameter")) {
                    this.jobparameter = string2;
                    continue;
                }
                if (string.equals("-jobnameoverride")) {
                    this.jobnameoverride = string2;
                    continue;
                }
                if (string.equals("-devmode")) {
                    this.devMode = Boolean.parseBoolean(string2);
                    continue;
                }
                if (string.equals("-suite")) {
                    this.suite = string2;
                    continue;
                }
                if (string.equals("-ssl")) {
                    if (string2.equals("any")) {
                        this.ssl = true;
                    }
                    continue;
                }
                if (string.equals("-queuename")) {
                    this.queuename = string2;
                    continue;
                }
                if (string.equals("-queueparameter")) {
                    this.queueparameter = string2;
                    continue;
                }
                if (string.equals("-runpriority")) {
                    this.runpriority = string2;
                    continue;
                }
                throw new ActionFailedException("Invalid option parameter: " + string + " full parm: " + stringArray[n2]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ActionFailedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
        if (this.type == null || this.type.length() == 0) {
            throw new ActionFailedException("Command is not valid - No type parameter was passed.");
        }
        if (this.action == null || this.action.length() == 0) {
            throw new ActionFailedException("Command is not valid - No action parameter was passed.");
        }
        if (this.configFile != null) {
            this.readPropFile();
        }
        if (!(this.action.equalsIgnoreCase("create") || this.action.equalsIgnoreCase("index") || this.action.equalsIgnoreCase("all_jobs") || this.name != null && this.name.length() != 0)) {
            throw new ActionFailedException("Command is not valid - No name parameter was passed.");
        }
        if (this.action.equalsIgnoreCase("create") && (this.filename == null || this.filename.length() == 0)) {
            throw new ActionFailedException("Command is not valid - No filename parameter was passed.");
        }
        if (this.action.equalsIgnoreCase("index") || this.action.equalsIgnoreCase("all_jobs") || this.action.equalsIgnoreCase("get")) {
            if (this.filepath == null || this.filepath.length() == 0) {
                throw new ActionFailedException("Command is not valid - No filepath parameter was passed.");
            }
            File file = new File(this.filepath);
            if (!file.isDirectory()) {
                throw new ActionFailedException("Command is not valid - Could not find " + this.filepath + " directory.");
            }
        }
        if (this.username == null || this.username.length() == 0) {
            throw new ActionFailedException("Command is not valid - No username parameter was passed.");
        }
        if (this.password == null || this.password.length() == 0) {
            throw new ActionFailedException("Command is not valid - No password parameter was passed.");
        }
        if (this.serverurl.substring(0, "https://".length()).equalsIgnoreCase("https://")) {
            this.useHttps = true;
        }
        if (this.type.equals("member_jobs")) {
            if (this.action.equals("hold")) {
                this.action = "skip";
            } else if (this.action.equals("release")) {
                this.action = "include";
            }
        } else if (this.type.equals("jobs") || this.type.equals("job_suites")) {
            if (this.action.equals("skip")) {
                this.action = "hold";
            } else if (this.action.equals("include")) {
                this.action = "release";
            }
        }
        if ((this.suite == null || this.suite.length() == 0) && this.type.equals("member_jobs") && (this.action.equals("skip") || this.action.equals("include"))) {
            throw new ActionFailedException("Command is not valid - No suite parameter was passed.");
        }
        if (this.runpriority != null) {
            n2 = 1;
            n3 = 99;
            object = "Command is not valid - The runpriority parameter must be a numeric value (" + n2 + "-" + n3 + ").";
            try {
                n = Integer.parseInt(this.runpriority);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ActionFailedException((String)object);
            }
            if (n < n2 || n > n3) {
                throw new ActionFailedException((String)object);
            }
        }
    }

    public String getUrl() throws ActionFailedException, UnsupportedEncodingException {
        String string = this.getServerUrl(false) + "/" + URLEncoder.encode(this.action, "UTF-8");
        if (this.action.equals("run")) {
            String string2 = "";
            if (this.jobparameter != null && this.jobparameter.length() != 0) {
                string2 = string2 + this.jobparameter;
            }
            if (this.runpriority != null && this.runpriority.trim().length() > 0) {
                if (string2.length() > 0) {
                    string2 = string2 + "&";
                }
                string2 = string2 + "run_priority=" + this.runpriority;
            }
            if (this.jobnameoverride != null && this.jobnameoverride.length() != 0) {
                if (string2.length() > 0) {
                    string2 = string2 + "&";
                }
                string2 = string2 + "job_name_override=" + this.jobnameoverride;
            }
            string = string + "?" + string2;
        }
        if ((this.action.equals("hold_job_queue") || this.action.equals("release_job_queue")) && this.queuename != null && this.queuename.length() != 0) {
            string = string + "?queue_name=" + this.queuename;
        }
        if (this.action.equals("update_job_queue") || this.action.equals("find_id_by_name") || this.action.equals("get")) {
            if (this.queuename != null && this.queuename.length() != 0) {
                string = string + "?queue_name=" + this.queuename;
                if (this.queueparameter != null && this.queueparameter.length() != 0) {
                    string = string + "&" + this.queueparameter;
                }
            } else if (this.queueparameter != null && this.queueparameter.length() != 0) {
                string = string + "?" + this.queueparameter;
            }
        }
        return string;
    }

    public String getUrlForGetAction() throws ActionFailedException, UnsupportedEncodingException {
        if (this.name == null) {
            this.name = "";
        }
        String string = this.getUrlString() + URLEncoder.encode(this.type, "UTF-8") + "/" + URLEncoder.encode(this.action, "UTF-8") + "?" + this.name.replaceAll(" ", "%20");
        return string;
    }

    public String getServerUrl(boolean bl) throws ActionFailedException, UnsupportedEncodingException {
        String string = this.getUrlString();
        if (bl) {
            return string + URLEncoder.encode(this.type, "UTF-8");
        }
        if (this.suite != null && this.suite.length() != 0 && (this.action.equals("skip") || this.action.equals("include"))) {
            return string + "job_suites/" + URLEncoder.encode(this.suite, "UTF-8") + "/" + URLEncoder.encode(this.type, "UTF-8") + "/" + URLEncoder.encode(this.name, "UTF-8");
        }
        if (this.queueparameter != null && this.queueparameter.length() != 0 && this.action.equals("delete")) {
            return string + URLEncoder.encode(this.type, "UTF-8") + "/" + URLEncoder.encode(this.name, "UTF-8") + "?" + this.queueparameter;
        }
        return string + URLEncoder.encode(this.type, "UTF-8") + "/" + URLEncoder.encode(this.name, "UTF-8");
    }

    public String getUrlString() throws ActionFailedException, UnsupportedEncodingException {
        String string = "";
        if (this.serverurl == null || this.serverurl.length() < "http://".length()) {
            throw new ActionFailedException("Command is not valid - No serverurl parameter was passed.");
        }
        if (this.useHttps) {
            if (this.serverurl.substring(0, "https://".length()).equalsIgnoreCase("https://")) {
                string = "https://" + this.serverurl.substring("https://".length(), this.serverurl.length());
            }
        } else if (this.serverurl.substring(0, "http://".length()).equalsIgnoreCase("http://")) {
            string = "http://" + this.serverurl.substring("http://".length(), this.serverurl.length());
        }
        if (!this.devMode) {
            string = string + "/automate-schedule";
        }
        return string + "/ws/";
    }

    private void readPropFile() throws ActionFailedException {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.configFile);
            properties.load(fileInputStream);
            if (this.username == null) {
                this.username = properties.getProperty("username");
            }
            if (this.password == null) {
                this.password = properties.getProperty("password");
            }
            if (this.serverurl == null) {
                this.serverurl = properties.getProperty("serverurl");
            }
        }
        catch (IOException iOException) {
            throw new ActionFailedException("Unable to parse configuration file: " + this.configFile);
        }
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public void setUseHttps(boolean bl) {
        this.useHttps = bl;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean bl) {
        this.ssl = bl;
    }

    public String getSuite() {
        return this.suite;
    }

    public void setSuite(String string) {
        this.suite = string;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getJobparameter() {
        return this.jobparameter;
    }

    public void setJobparameter(String string) {
        this.jobparameter = string;
    }

    public String getJobnameoverride() {
        return this.jobnameoverride;
    }

    public void setJobnameoverride(String string) {
        this.jobnameoverride = string;
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    public String getQueuename() {
        return this.queuename;
    }

    public void setQueuename(String string) {
        this.queuename = string;
    }

    public String getQueueparameter() {
        return this.queueparameter;
    }

    public void setQueueparameter(String string) {
        this.queueparameter = string;
    }
}

