/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.sap;

import com.helpsystems.enterprise.core.busobj.sap.SAPSystem;
import com.helpsystems.enterprise.core.busobj.sap.SAPXBPVersion;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRepository;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class SAPConnection {
    private static final Logger logger = Logger.getLogger(SAPConnection.class);
    public static String SAP_SERVER = "TEST_SAP_SERVER";
    private JCoRepository repository;
    private JCoDestination destination;
    private String sapSystemDefinitionName;
    private SAPXMIAuditLevel xmiAuditLevel;
    private SAPXBPVersion xbpVersion;
    private long sapSystemDefinitionID;
    private long sapSystemEnvironmentID;
    private String externalUserName;
    private TimeZone timeZone;
    private String usableSystemName;

    public SAPConnection(JCoDestination jCoDestination, SAPSystem sAPSystem) throws JCoException {
        this.destination = jCoDestination;
        this.sapSystemDefinitionName = sAPSystem.getSapSystemName();
        this.sapSystemDefinitionID = sAPSystem.getSystemDefinitionID();
        this.sapSystemEnvironmentID = sAPSystem.getSystemEnvironmentID();
        this.xmiAuditLevel = sAPSystem.getXMIAuditLevel();
        this.xbpVersion = sAPSystem.getXBPVersion();
        this.externalUserName = sAPSystem.getUser();
        this.setTimeZone(sAPSystem.getTimeZoneString());
        this.repository = jCoDestination.getRepository();
        this.init();
    }

    private void setTimeZone(String string) {
        this.timeZone = TimeZone.getDefault();
        try {
            this.timeZone = TimeZone.getTimeZone(string);
            logger.debug((Object)("Timezone set to " + this.timeZone.getDisplayName() + " using String " + string));
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to set timezone using String " + string + ". Using system default: " + this.timeZone.getDisplayName()));
        }
    }

    private void init() throws JCoException {
        this.testConnection();
    }

    private void testConnection() throws JCoException {
        this.getJCoDestination().getAttributes();
    }

    public JCoDestination getJCoDestination() {
        return this.destination;
    }

    public long getSapSystemDefinitionID() {
        return this.sapSystemDefinitionID;
    }

    public SAPXMIAuditLevel getXMIAuditLevel() {
        return this.xmiAuditLevel;
    }

    public void setXMIAuditLevel(SAPXMIAuditLevel sAPXMIAuditLevel) {
        this.xmiAuditLevel = sAPXMIAuditLevel;
    }

    public SAPXBPVersion getXBPVersion() {
        return this.xbpVersion;
    }

    public JCoFunction getFunction(String string) throws JCoException {
        JCoFunction jCoFunction = null;
        jCoFunction = this.repository.getFunction(string);
        return jCoFunction;
    }

    public void execute(JCoFunction jCoFunction) throws JCoException {
        this.execute(jCoFunction, true, true, true);
    }

    public void executeFirstFunction(JCoFunction jCoFunction) throws JCoException {
        this.execute(jCoFunction, true, false, true);
    }

    public void executeMiddleFunction(JCoFunction jCoFunction) throws JCoException {
        this.execute(jCoFunction, false, false, true);
    }

    public void executeMiddleFunction(JCoFunction jCoFunction, boolean bl) throws JCoException {
        this.execute(jCoFunction, false, false, bl);
    }

    public void executeFinalFunction(JCoFunction jCoFunction) throws JCoException {
        this.execute(jCoFunction, false, true, true);
    }

    private void execute(JCoFunction jCoFunction, boolean bl, boolean bl2, boolean bl3) throws JCoException {
        try {
            if (bl) {
                JCoContext.begin((JCoDestination)this.destination);
            }
            if (bl3) {
                logger.debug((Object)(jCoFunction.getName() + " starting..."));
            }
            jCoFunction.execute(this.destination);
            if (bl3) {
                logger.debug((Object)(jCoFunction.getName() + " completed."));
            }
        }
        catch (JCoException jCoException) {
            throw jCoException;
        }
        finally {
            if (bl2) {
                JCoContext.end((JCoDestination)this.destination);
            }
        }
    }

    public String getExternalUserName() {
        return this.externalUserName;
    }

    public long getSapSystemEnvironmentID() {
        return this.sapSystemEnvironmentID;
    }

    public String getSapSystemDefinitionName() {
        return this.sapSystemDefinitionName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getUsableSystemName() {
        return this.usableSystemName;
    }

    public void setUsableSystemName(String string) {
        this.usableSystemName = string;
    }
}

