/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.enterprise.core.busobj.LanguageCode;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStep;
import com.helpsystems.enterprise.core.busobj.sap.SAPAllPrintParameters;
import com.helpsystems.enterprise.core.busobj.sap.SAPField;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import java.util.ArrayList;
import java.util.Map;

public class SAPReportHelper {
    public static final String NAMEFIELD = "NAMEFIELD";
    public static final String VALUEFIELD = "VALUEFIELD";
    public static final String ONELINEFIELD = "ONELINEFIELD";

    private SAPReportHelper() {
    }

    public static void buildPrintParamReportSection(AbstractJasperReport.ReportDataBuilder reportDataBuilder, ReportDM reportDM, SAPABAPStep sAPABAPStep) {
        ArrayList<SAPAllPrintParameters> arrayList = reportDM.getPrintParamsBySapAbapStepId(sAPABAPStep.getOID());
        if (arrayList.size() == 0) {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue(NAMEFIELD, "Print Parameters:");
            reportDataBuilder.setFieldValue(VALUEFIELD, "");
        } else {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue(ONELINEFIELD, "Print Parameters");
            for (SAPAllPrintParameters sAPAllPrintParameters : arrayList) {
                for (SAPAllPrintParameters.PrintParameterField printParameterField : SAPAllPrintParameters.PrintParameterField.values()) {
                    if (!printParameterField.getShowInReport()) continue;
                    reportDataBuilder.nextRow();
                    reportDataBuilder.setFieldValue(NAMEFIELD, printParameterField.getDescription());
                    if (printParameterField.getParameterType() == SAPField.ParameterType.BOOLEAN) {
                        reportDataBuilder.setFieldValue(VALUEFIELD, sAPAllPrintParameters.getBooleanField(printParameterField) ? "Yes" : "No");
                        continue;
                    }
                    Object object = sAPAllPrintParameters.getField(printParameterField);
                    if (printParameterField == SAPAllPrintParameters.PrintParameterField.PRSAP) {
                        object = SAPAllPrintParameters.SAP_PRSAP_Setting.getName((String)object);
                    } else if (printParameterField == SAPAllPrintParameters.PrintParameterField.PRIOT) {
                        object = sAPAllPrintParameters.getSpoolRequestPriorityAsString((Integer)sAPAllPrintParameters.getField(printParameterField));
                    } else if (printParameterField == SAPAllPrintParameters.PrintParameterField.ARMOD) {
                        object = sAPAllPrintParameters.getArchivingModeAsString((Integer)sAPAllPrintParameters.getField(printParameterField));
                    }
                    if (object.equals("$")) {
                        object = "";
                    }
                    reportDataBuilder.setFieldValue(VALUEFIELD, object);
                }
            }
        }
    }

    public static void addRowWithTwoColumns(Map<String, String> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue(NAMEFIELD, entry.getKey());
            reportDataBuilder.setFieldValue(VALUEFIELD, entry.getValue());
        }
    }

    public static void addOnelineField(String string, AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(ONELINEFIELD, string);
    }

    public static void addRowWithTwoColumns(String string, String string2, AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(NAMEFIELD, string);
        reportDataBuilder.setFieldValue(VALUEFIELD, string2);
    }

    public static void buildAbapStepSection(AbstractJasperReport.ReportDataBuilder reportDataBuilder, SAPABAPStep sAPABAPStep, LanguageCode languageCode) {
        SAPReportHelper.addRowWithTwoColumns("ABAP Program Name:", sAPABAPStep.getAbapProgramName(), reportDataBuilder);
        SAPReportHelper.addRowWithTwoColumns("Program Variant Name:", sAPABAPStep.getAbapProgramVariantName(), reportDataBuilder);
        SAPReportHelper.addRowWithTwoColumns("Language:", languageCode.getLocalName(), reportDataBuilder);
        SAPReportHelper.addRowWithTwoColumns("Username:", sAPABAPStep.getSapUserName(), reportDataBuilder);
    }
}

