/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.AgentEnvironmentVariable;
import com.helpsystems.enterprise.core.busobj.CommandSet;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.IBMiAgentEnvironment;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobConditionR02M03;
import com.helpsystems.enterprise.core.busobj.JobMonitor;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.NotificationList;
import com.helpsystems.enterprise.core.busobj.OutputDistribution;
import com.helpsystems.enterprise.core.busobj.ReactivityDateObject;
import com.helpsystems.enterprise.core.busobj.ReactivityDayOfPeriod;
import com.helpsystems.enterprise.core.busobj.ReactivityDays;
import com.helpsystems.enterprise.core.busobj.ScheduleDayOfPeriod;
import com.helpsystems.enterprise.core.busobj.ScheduleDayOfWeek;
import com.helpsystems.enterprise.core.busobj.SimpleProxy;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceDays;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceType;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptCriterion;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEnvironmentDM;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.dm.IBMiAgentEnvironmentDM;
import com.helpsystems.enterprise.core.dm.JobConditionDM;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.OutputDistributionDM;
import com.helpsystems.enterprise.core.dm.ReactivityDateObjectDM;
import com.helpsystems.enterprise.core.dm.ReactivityDayOfPeriodDM;
import com.helpsystems.enterprise.core.dm.ReactivityDaysDM;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.SpecialInstanceDM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.enums.AndOrSelection;
import com.helpsystems.enterprise.core.enums.CommandSetType;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.JobSetupReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.JobSetupReportFilterParser;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.DateObjectDM;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsDM;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsType;
import com.helpsystems.enterprise.core.scheduler.JobHoldFlag;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMember;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMemberJobDependencies;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMemberJobSkipSpecialInstance;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.MissedJobAction;
import com.helpsystems.enterprise.core.scheduler.Prereq;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayCount;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_TimedInterval;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobBigProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.util.JobConditionMessageGenerator;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.module.reports.jasper.JobSetupReportHelper;
import com.helpsystems.enterprise.module.reports.jasper.OutputDistributionComparator;
import com.helpsystems.enterprise.module.reports.jasper.ScheduleJobComparator;
import com.helpsystems.enterprise.peer.preconditions.JobConditionsComparator;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobSetupReport
extends AbstractJasperReport
implements Serializable {
    private static final long serialVersionUID = -434559359345989113L;
    private static final Logger logger = Logger.getLogger(JobSetupReport.class);
    private ScheduleJobDM job;
    private AgentDM agent;
    private JobSuiteDM jobSuiteDM;
    private JobQueuesDM jobQueuesDM;
    private SpecialInstanceDM specialInstance;
    private NotificationListDM noteListDM;
    private AgentEnvironmentDM agentEnv;
    private PrereqDM prereqDM;
    private JobDateObjectsDM jobDateObjectsDM;
    private ReactivityDateObjectDM reactivityDateObjectDM;
    private ReactivityDayOfPeriodDM reactivityDayOfPeriodDM;
    private ReactivityDaysDM reactivityDaysDM;
    private ScheduleInfoDM scheduleInfoDM;
    private CalendarObjectDM calendarObjectDM;
    private SystemSetupDM systemSetupDM;
    private JobConditionDM conditionDM;
    private DateObjectDM dateObjectDM;
    private IBMiAgentEnvironmentDM ibmiAgentEnvironmentDM;
    private long[] jobIdParams;
    private String[] jobNameParams;
    private String[] jobTagParams;
    private String[] jobAgentParams;
    private String[] agentGroupParams;
    private boolean addAllUntaggedJobs = false;
    private AndOrSelection objectsAndOrSelection;
    private Long[] jobIdToShow;
    private ArrayList<ScheduleJob> jobs = new ArrayList();
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    public static final String TITLE_JOB_SETUP_REPORT = "TITLE_JOB_SETUP_REPORT";
    public static final String HEADER_DATE = "HEADER_DATE";
    public static final String REPORT_NAME = "JobSetupReport";
    public static final String FIELD_GROUPING = "GROUPING";
    public static final String FIELD_GROUP_SUBREPORT_PARAMS = "GROUP_SUBREPORT_PARAMS";
    public static final String FIELD_GROUP_SUBREPORT_DATA = "GROUP_SUBREPORT_DATA";
    public static final String NAMEFIELD = "NAMEFIELD";
    public static final String NAMEFIELD_TITLE = "NAMEFIELD_TITLE";
    public static final String VALUEFIELD = "VALUEFIELD";
    public static final String ONELINEFIELD = "ONELINEFIELD";
    public static final String ONELINEFIELD_CENTER = "ONELINEFIELD_CENTER";
    public static final String TWOVALUEDFIELD = "TWOVALUEDFIELD";
    public static final String FIELD_SHOW_BACK_COLOR = "SHOW_BACK_COLOR";
    public static final String FIELD_SHOW_COLUMN_BACK_COLOR = "SHOW_COLUMN_BACK_COLOR";
    public static final String END_LISTING_FOR_JOB = "END_LISTING_FOR_JOB";
    public static final String END_OF_REPORT = "END_OF_REPORT";
    public static final String NO_DATA_EXISTS = "NO_DATA_EXISTS";
    public static final String VALUEFIELD0 = "VALUEFIELD0";
    public static final String VALUEFIELD1 = "VALUEFIELD1";
    public static final String VALUEFIELD2 = "VALUEFIELD2";
    public static final String VALUEFIELD3 = "VALUEFIELD3";
    public static final String VALUEFIELD4 = "VALUEFIELD4";
    public static final String VALUEFIELD5 = "VALUEFIELD5";
    public static final String VALUEFIELD6 = "VALUEFIELD6";
    public static final String COLUMN_VALUEFIELD0 = "COLUMN_VALUEFIELD0";
    public static final String COLUMN_VALUEFIELD1 = "COLUMN_VALUEFIELD1";
    public static final String COLUMN_VALUEFIELD2 = "COLUMN_VALUEFIELD2";
    public static final String COLUMN_VALUEFIELD3 = "COLUMN_VALUEFIELD3";
    public static final String COLUMN_VALUEFIELD4 = "COLUMN_VALUEFIELD4";
    public static final String COLUMN_VALUEFIELD5 = "COLUMN_VALUEFIELD5";
    public static final String COLUMN_VALUEFIELD6 = "COLUMN_VALUEFIELD6";
    public static final String NOT_MONITORED = " >> not monitored";
    public static final String MUST_COMPLETE = "Must Complete by:";
    public static final String MUST_START = "Must start by:";
    public static final String MINIMUM_DURATION = "Minimum Duration:";
    public static final String MAXIMUM_DURATION = "Maximum Duration:";
    public static final String SEND_SNMP_TRAP = "Send SNMP Trap:";
    public static final String NOTIFICATION_LIST = "Notification List to use:";
    public static final String SPECIAL_INSTANCES = "Special Instances";
    public static final String SKIP_SPECIAL_INSTANCES = "Member Options";
    public static final String SCHEDULE_TYPE = "Schedule type:";
    public static final String EMAIL_TO_USERS = "Email to Users:";
    public static final String LATER_TAHN_SCHEDULED_BY = "Later than scheduled by:";
    public static final String STATUS_NOTE = "Status Notification";
    public static final String SCHEDULE_EXCEPTIONS = "Schedule Exceptions";
    public static final String NOT_OCCURE = " will not occur";
    public static final String DO_NOT_OVERWRITE = "Don't overwrite";
    public static final String DO_NOT_CLEAR = "Don't clear";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String SHARED = "*SHARED";
    public static final String SHARED_DISPLAY = "<shared>";
    public static final String EMAIL_SUBJECT = "Custom Subject:";
    public static final String EMAIL_BODY = "Custom Text:";
    public static final String PARAM_DELIMITER = " ";
    public static final String JOB_ID_PARAM = "-jobIds";
    public static final String JOB_NAME_PARAM = "-jobNames";
    public static final String TAG_PARAM = "-tags";
    public static final String AGENT_PARAM = "-agents";
    public static final String AGENT_GROUP_PARAM = "-agentGroups";
    public static final String UNTAGGED_PARAM = "-untagged";
    public static final int JOB_ID_PARAM_ID = 1;
    public static final int TAG_PARAM_ID = 2;
    public static final int AGENT_PARAM_ID = 3;
    public static final int JOB_NAME_PARAM_ID = 4;
    public static final int UNTAGS_PARAM_ID = 5;
    public static final int AGENT_GROUP_PARAM_ID = 14;
    public static final int BLANK_VALUE = 0;
    private static final String JOB_NAMES = "-jobNames";
    private static final String JOB_IDS = "-jobIds";
    private static final String AGENTS = "-agents";
    private static final String AGENT_GROUPS = "-agentGroups";
    private static final String TAGS = "-tags";
    private static final String UNTAGGED = "-untagged";
    private static final String USER_NAME = "-userName";
    private static final String TAGING_TABLE_TAGGER_TYPE_JOB = "Job";
    private static final String TAGING_TABLE_TAGGER_TYPE_JOB_SUITE = "JobSuite";
    private static final String TAGING_TABLE_TAGGER_TYPE_JOB_SUITE_MEMBER = "MemberJob";
    private static final String AGENT_ENVIRONMENT_TYPE = "AgentEnvironment";
    private static final String IBMI_AGENT_ENVIRONMENT = "IbmiAgentEnvironment";
    private JobSetupReportFilter filter = new JobSetupReportFilter();

    public JobSetupReport(Locale locale, ReportOutput.OutputType outputType, String string, Object[] objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
        this.job = (ScheduleJobDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleJobDM");
        this.agent = (AgentDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentDM");
        this.jobQueuesDM = (JobQueuesDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobQueuesDM");
        this.specialInstance = (SpecialInstanceDM)ManagerRegistry.getManager((String)"ENTERPRISE.SpecialInstanceDM");
        this.noteListDM = (NotificationListDM)ManagerRegistry.getManager((String)"ENTERPRISE.NotificationListDM");
        this.agentEnv = (AgentEnvironmentDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEnvironmentDM");
        this.prereqDM = (PrereqDM)ManagerRegistry.getManager((String)"ENTERPRISE.PrereqDM");
        this.jobDateObjectsDM = (JobDateObjectsDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobDateObjectsDM");
        this.reactivityDateObjectDM = (ReactivityDateObjectDM)ManagerRegistry.getManager((String)"ENTERPRISE.ReactivityDateObjectDM");
        this.reactivityDayOfPeriodDM = (ReactivityDayOfPeriodDM)ManagerRegistry.getManager((String)"ENTERPRISE.ReactivityDayOfPeriodDM");
        this.reactivityDaysDM = (ReactivityDaysDM)ManagerRegistry.getManager((String)"ENTERPRISE.ReactivityDaysDM");
        this.scheduleInfoDM = (ScheduleInfoDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleInfoDM");
        this.calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManager((String)"ENTERPRISE.CalendarObjectDM");
        this.systemSetupDM = (SystemSetupDM)ManagerRegistry.getManager((String)"ENTERPRISE.SystemSetupDM");
        this.conditionDM = (JobConditionDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobConditionDM");
        this.dateObjectDM = (DateObjectDM)ManagerRegistry.getManager((String)"ENTERPRISE.DateObjectDM");
        this.jobSuiteDM = (JobSuiteDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobSuiteDM");
        this.ibmiAgentEnvironmentDM = (IBMiAgentEnvironmentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.IBMiAgentEnvironmentDM");
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        JobSetupReportFilterParser jobSetupReportFilterParser = new JobSetupReportFilterParser();
        this.replaceIfNotAKey(objectArray);
        jobSetupReportFilterParser.parseParameters(this.filter, objectArray);
        this.jobIdParams = this.filter.getJobIds();
        this.jobNameParams = this.filter.getJobNames();
        this.jobTagParams = this.filter.getTags();
        this.jobAgentParams = this.filter.getAgentNames();
        this.agentGroupParams = this.filter.getAgentGroupNames();
        this.addAllUntaggedJobs = this.filter.isSelectedAllUntaggedJobs();
        this.objectsAndOrSelection = this.filter.getObjectsAndOrSelection();
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return (string = string.trim()).equals("-jobNames") || string.equals("-agents") || string.equals("-jobIds") || string.equals("-agentGroups") || string.equals("-tags") || string.equals("-untagged") || string.equals(USER_NAME) || string.equals("-f");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.JOB_SETUP_REPORT.getReportID();
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    JasperReportData buildReportData() {
        this.jobIdToShow = this.reportDM.getJobIdList(this.jobIdParams, this.jobNameParams, this.jobTagParams, this.jobAgentParams, this.agentGroupParams, this.addAllUntaggedJobs, this.objectsAndOrSelection);
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = JobSetupReport.createReportDataBuilder();
        this.parentParams.put(HEADER_DATE, ReportHelper.getFormatedDate(new Date()));
        this.parentParams.put(TITLE_JOB_SETUP_REPORT, "Job Setup Report");
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.parentParams.put("REPORT_NAME", REPORT_NAME);
        if (this.jobIdToShow.length > 0) {
            this.fillJobList();
        }
        try {
            this.buildTableOfContentJLRData(reportDataBuilder);
            this.buildParametersJLRData(this.parentParams);
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
        if (this.jobIdToShow.length == 0) {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue(NO_DATA_EXISTS, "No jobs have been found to list.");
        } else {
            for (ScheduleJob scheduleJob : this.jobs) {
                this.buildJLRData(reportDataBuilder, scheduleJob);
            }
            reportDataBuilder.setFieldValue(END_OF_REPORT, "*** End of Report ***");
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"Job Setup Report has been built.");
        return jasperReportData;
    }

    private void buildJLRData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, ScheduleJob scheduleJob) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = reportDataBuilder;
        try {
            switch (scheduleJob.getJobType()) {
                case JOB: {
                    this.buildJRLJobData(scheduleJob, reportDataBuilder2);
                    break;
                }
                case SUITE: {
                    this.buildJRLSuiteData(scheduleJob, reportDataBuilder2);
                    break;
                }
                case SUITE_MEMBER: {
                    this.buildJRLMemberData(scheduleJob, reportDataBuilder2);
                }
            }
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
    }

    private void fillJobList() {
        for (int i = 0; i < this.jobIdToShow.length; ++i) {
            try {
                ScheduleJob scheduleJob = ReportTitleHelper.getInstance().getJobOrSuite(this.jobIdToShow[i]);
                long l = scheduleJob.getSkybotJobNumber();
                switch (scheduleJob.getJobType()) {
                    case JOB: {
                        this.jobs.add(scheduleJob);
                        break;
                    }
                    case SUITE: {
                        this.jobs.add(scheduleJob);
                        this.addSuiteMemberJobs(l);
                        break;
                    }
                    case SUITE_MEMBER: {
                        this.addMemberJob(scheduleJob);
                    }
                }
                continue;
            }
            catch (DataException dataException) {
                logger.error((Object)dataException.getMessage(), (Throwable)dataException);
                continue;
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
            }
        }
        Collections.sort(this.jobs, new ScheduleJobComparator());
    }

    private void addSuiteMemberJobs(long l) {
        ArrayList<ScheduleJob> arrayList = this.reportDM.getSuiteMembersBySuiteID(l);
        for (ScheduleJob scheduleJob : arrayList) {
            this.addMemberJob(scheduleJob);
        }
    }

    private void addMemberJob(ScheduleJob scheduleJob) {
        if (!this.exsistMemberJob(scheduleJob)) {
            this.jobs.add(scheduleJob);
        }
    }

    private boolean exsistMemberJob(ScheduleJob scheduleJob) {
        if (this.jobs != null && this.jobs.size() > 0) {
            long l = scheduleJob.getSkybotJobNumber();
            for (ScheduleJob scheduleJob2 : this.jobs) {
                if (scheduleJob2.getSkybotJobNumber() != l) continue;
                return true;
            }
        }
        return false;
    }

    private void buildJRLJobData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        this.buildGeneralJLRData(scheduleJob, reportDataBuilder);
        this.buildScheduleJLRData(scheduleJob, reportDataBuilder);
        this.buildSchedlueExceptionsData(scheduleJob, reportDataBuilder);
        this.buildAgentEnvJLRData(scheduleJob, reportDataBuilder);
        this.buildCommandsData(scheduleJob, reportDataBuilder);
        this.buildMissedRunTimeOptionData(scheduleJob, reportDataBuilder);
        this.buildLoggingData(scheduleJob, reportDataBuilder);
        this.buildJobHistoryPurgeData(scheduleJob, reportDataBuilder);
        this.buildJobMonitorData(scheduleJob, reportDataBuilder);
        this.buildPrereqJLRData(scheduleJob, reportDataBuilder);
        this.buildConditionsJLRData(scheduleJob, reportDataBuilder);
        this.buildStatusNotificationData(scheduleJob, reportDataBuilder);
        this.buildOutputDistributionData(scheduleJob, reportDataBuilder);
        this.buildNoteData(scheduleJob, reportDataBuilder);
        this.buildJobParametersData(scheduleJob, reportDataBuilder);
        this.buildSpecialInstanceJLRData(scheduleJob, reportDataBuilder);
        this.buildForecastScheduleJLRData(scheduleJob, reportDataBuilder);
        logger.trace((Object)("Job Setup Report for job " + scheduleJob.getName() + " has been built."));
    }

    private void buildJRLSuiteData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        this.buildGeneralJLRData(scheduleJob, reportDataBuilder);
        this.buildScheduleJLRData(scheduleJob, reportDataBuilder);
        this.buildSchedlueExceptionsData(scheduleJob, reportDataBuilder);
        this.buildMissedRunTimeOptionData(scheduleJob, reportDataBuilder);
        this.buildJobHistoryPurgeData(scheduleJob, reportDataBuilder);
        this.buildSkipSpecialInstanceJLRData(scheduleJob, reportDataBuilder);
        this.buildJobMonitorData(scheduleJob, reportDataBuilder);
        this.buildPrereqJLRData(scheduleJob, reportDataBuilder);
        this.buildStatusNotificationData(scheduleJob, reportDataBuilder);
        this.buildJobParametersData(scheduleJob, reportDataBuilder);
        this.buildSpecialInstanceJLRData(scheduleJob, reportDataBuilder);
        this.buildForecastScheduleJLRData(scheduleJob, reportDataBuilder);
        this.buildJobSuiteDependenciesData(scheduleJob, reportDataBuilder);
        long l = scheduleJob.getSkybotJobNumber();
        ArrayList<ScheduleJob> arrayList = this.reportDM.getSuiteMembersBySuiteID(l);
        this.buildSuiteMembersData(reportDataBuilder, arrayList);
        logger.trace((Object)("Job Setup Report for suite " + scheduleJob.getName() + " has been built."));
    }

    private void buildJRLMemberData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        this.buildGeneralJLRData(scheduleJob, reportDataBuilder);
        this.buildAgentEnvJLRData(scheduleJob, reportDataBuilder);
        this.buildCommandsData(scheduleJob, reportDataBuilder);
        this.buildLoggingData(scheduleJob, reportDataBuilder);
        this.buildJobMonitorData(scheduleJob, reportDataBuilder);
        this.buildConditionsJLRData(scheduleJob, reportDataBuilder);
        this.buildStatusNotificationData(scheduleJob, reportDataBuilder);
        this.buildOutputDistributionData(scheduleJob, reportDataBuilder);
        this.buildNoteData(scheduleJob, reportDataBuilder);
        this.buildJobParametersData(scheduleJob, reportDataBuilder);
        logger.trace((Object)("Job Setup Report for suite member job " + scheduleJob.getName() + " has been built."));
    }

    private void buildSkipSpecialInstanceJLRData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        long l = scheduleJob.getSkybotJobNumber();
        List<JobSuiteMember> list = null;
        try {
            list = this.jobSuiteDM.getMemberJob(l);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Special Instances to Skip for Job Suite ID " + l));
        }
        JobSuiteMemberJobSkipSpecialInstance[] jobSuiteMemberJobSkipSpecialInstanceArray = null;
        hashMap.put("JLR_SUB_TITLE", SKIP_SPECIAL_INSTANCES);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                JobSuiteMember jobSuiteMember = list.get(i);
                try {
                    jobSuiteMemberJobSkipSpecialInstanceArray = this.jobSuiteDM.getSuiteMemberSpecialInstancesToSkip(jobSuiteMember.getJobID());
                }
                catch (Exception exception) {
                    logger.error((Object)("Error retrieving Special Instances to Skip for Suite Member ID " + jobSuiteMember.getMemberID()));
                }
                ScheduleJob scheduleJob2 = this.job.get(jobSuiteMember.getMemberID());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Member Job Name:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob2.getName());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Failed Member Action:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, jobSuiteMember.getFailedMemberActionStr());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Required Prerequisites:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, jobSuiteMember.getRequiredPrereqsStr());
                if (jobSuiteMemberJobSkipSpecialInstanceArray != null && jobSuiteMemberJobSkipSpecialInstanceArray.length > 0) {
                    SpecialInstanceDM specialInstanceDM = (SpecialInstanceDM)ManagerRegistry.getManager((String)"ENTERPRISE.SpecialInstanceDM");
                    String string = "";
                    for (int j = 0; j < jobSuiteMemberJobSkipSpecialInstanceArray.length; ++j) {
                        long l2 = jobSuiteMemberJobSkipSpecialInstanceArray[j].getSpecialInstanceID();
                        SpecialInstance specialInstance = specialInstanceDM.get(l2);
                        string = string + specialInstance.getName();
                        if (j == jobSuiteMemberJobSkipSpecialInstanceArray.length - 1) continue;
                        string = string + ", ";
                    }
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Skip Special Instance Names:");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, string);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Skip Options:");
                    if (jobSuiteMember.isSkipMatched()) {
                        reportDataBuilder2.setFieldValue(VALUEFIELD, "Skip all runtimes matched by Special Instances");
                    } else {
                        reportDataBuilder2.setFieldValue(VALUEFIELD, "Skip all runtimes that are not matched by Special Instances");
                    }
                } else {
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, "No Skip Special Instances for this member job.");
                    logger.trace((Object)"Suite member job doesn't have skip Special Instances");
                }
                if (i == list.size() - 1) continue;
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(FIELD_SHOW_COLUMN_BACK_COLOR, new Boolean(true));
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "");
            }
        } else {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "No Member Options for this job suite.");
            logger.trace((Object)"Job suite doesn't have Member Options");
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.SPECIAL_INSTANCE.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of suite member job member options has been built.");
    }

    private void buildTableOfContentJLRData(AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap hashMap = new HashMap();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        for (ScheduleJob scheduleJob : this.jobs) {
            String string = scheduleJob.getName();
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, string);
            reportDataBuilder2.setFieldValue(NAMEFIELD_TITLE, string);
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.TABLE_OF_CONTENT.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The Table of Content data has been built.");
    }

    private void buildParametersJLRData(Map<String, Object> map) throws DataException, ResourceUnavailableException {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = JobSetupReport.createReportDataBuilder();
        ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    private void buildGeneralJLRData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        String string;
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("JOB_NAME", scheduleJob.getName());
        String string2 = "";
        switch (scheduleJob.getJobType()) {
            case JOB: {
                string2 = "Job: ";
                break;
            }
            case SUITE: {
                string2 = "Suite: ";
                break;
            }
            case SUITE_MEMBER: {
                string2 = "Member Job: ";
                break;
            }
            default: {
                logger.error((Object)("Job type is not valid: " + scheduleJob.getJobType()));
            }
        }
        hashMap.put("HEADER_NAME_TYPE", string2);
        hashMap.put("HEADER_NAME", scheduleJob.getName());
        hashMap.put("JLR_SUB_TITLE", "General");
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Name:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.getName());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Description:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.getDescription());
        reportDataBuilder2.nextRow();
        long l = scheduleJob.getSkybotJobNumber();
        if (scheduleJob.getJobType() == JobType.JOB || scheduleJob.getJobType() == JobType.SUITE_MEMBER) {
            object = this.reportDM.getTargetNameByJobID(l);
            string = "Agent: ";
            int n = -1;
            if ("AgentGroup".equals(((HashMap)object).get("TARGET_TYPE"))) {
                string = "Agent Group: ";
                n = this.reportDM.getAgentGroupTypeByJobID(l);
            }
            reportDataBuilder2.setFieldValue(NAMEFIELD, string);
            reportDataBuilder2.setFieldValue(VALUEFIELD, ((HashMap)object).get("TARGET_NAME"));
            reportDataBuilder2.nextRow();
            if (n != -1) {
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Agent Group Type:");
                switch (n) {
                    case 0: {
                        reportDataBuilder2.setFieldValue(VALUEFIELD, "All Agents Group");
                        break;
                    }
                    case 1: {
                        reportDataBuilder2.setFieldValue(VALUEFIELD, "Utilization Balanced Group");
                        break;
                    }
                    case 2: {
                        reportDataBuilder2.setFieldValue(VALUEFIELD, "Preferred Agent Group");
                    }
                }
                reportDataBuilder2.nextRow();
            }
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Queue: ");
            reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.getJobQueueName());
            reportDataBuilder2.nextRow();
        }
        if (scheduleJob.getJobType() == JobType.JOB || scheduleJob.getJobType() == JobType.SUITE) {
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Calendar: ");
            object = this.calendarObjectDM.get(scheduleJob.getCalendarID());
            reportDataBuilder2.setFieldValue(VALUEFIELD, ((SimpleProxy)object).getName());
            reportDataBuilder2.nextRow();
        }
        if (scheduleJob.getJobType() == JobType.JOB || scheduleJob.getJobType() == JobType.SUITE) {
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Time Zone: ");
            object = "Server";
            if (scheduleJob.getTimezoneType() == ScheduleInfo.TimeZoneType.AGENT) {
                object = "Agent";
            } else if (scheduleJob.getTimezoneType() == ScheduleInfo.TimeZoneType.JOB) {
                object = scheduleJob.getJobTimezone();
            }
            reportDataBuilder2.setFieldValue(VALUEFIELD, object);
            reportDataBuilder2.nextRow();
        }
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Tags: ");
        if (scheduleJob.getJobType() == JobType.SUITE) {
            reportDataBuilder2.setFieldValue(VALUEFIELD, this.reportDM.getTagsByJobID(l, TAGING_TABLE_TAGGER_TYPE_JOB_SUITE));
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Automate Schedule Variable Base Date: ");
            if (scheduleJob.getVariableBaseDate() == 1) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Use Job Suite's Scheduled Time");
            } else {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Use Member Job's Scheduled Time");
            }
        } else if (scheduleJob.getJobType() == JobType.JOB) {
            reportDataBuilder2.setFieldValue(VALUEFIELD, this.reportDM.getTagsByJobID(l, TAGING_TABLE_TAGGER_TYPE_JOB));
        } else if (scheduleJob.getJobType() == JobType.SUITE_MEMBER) {
            reportDataBuilder2.setFieldValue(VALUEFIELD, this.reportDM.getTagsByJobID(l, TAGING_TABLE_TAGGER_TYPE_JOB_SUITE_MEMBER));
        }
        if (scheduleJob.getJobType() == JobType.JOB || scheduleJob.getJobType() == JobType.SUITE) {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Hold Status: ");
            object = scheduleJob.getJobHoldFlag().name();
            if (((String)object).equals(JobHoldFlag.HELD.name())) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Held");
            } else if (((String)object).equals(JobHoldFlag.HELD_FOR_X_TIMES.name())) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Held for " + scheduleJob.getHeldCount() + " of " + scheduleJob.getHoldTimes());
            } else if (((String)object).equals(JobHoldFlag.NOT_HELD.name())) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Released");
            } else if (((String)object).equals(JobHoldFlag.HELD_UNTIL.name())) {
                string = "Server";
                if (scheduleJob.getTimezoneType() == ScheduleInfo.TimeZoneType.AGENT) {
                    string = "Agent";
                } else if (scheduleJob.getTimezoneType() == ScheduleInfo.TimeZoneType.JOB) {
                    string = scheduleJob.getJobTimezone();
                }
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Held Until " + ReportHelper.getStartDate(scheduleJob.getHoldUntil()) + " (" + string + ")");
            } else {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Unknown hold status");
            }
        }
        if (scheduleJob.getJobType() == JobType.JOB) {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Priority: ");
            reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.getDefaultPriority());
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.GENERAL.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The general report data has been built.");
    }

    private void buildScheduleJLRData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        long l = scheduleJob.getSkybotJobNumber();
        ScheduleInfo scheduleInfo = this.scheduleInfoDM.get((int)l);
        ScheduleJobProxy.ScheduleType scheduleType = scheduleJob.getScheduleType();
        String string = ReportHelper.getScheduleTypeName(scheduleType);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, SCHEDULE_TYPE);
        reportDataBuilder2.setFieldValue(VALUEFIELD, string);
        switch (scheduleType) {
            case DATE_LIST: {
                DateObject[] dateObjectArray = this.jobDateObjectsDM.getList(JobDateObjectsType.RUN_DATE_OBJECTS, l);
                for (int i = 0; i < dateObjectArray.length; ++i) {
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, dateObjectArray[i].getName());
                }
                Integer[] integerArray = this.reportDM.getRuntimes(l, ReportDM.TypeOfRuntime.BASIC);
                reportDataBuilder2.nextRow();
                if (integerArray.length == 0) {
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, "No Run Time");
                    break;
                }
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "Run Time");
                for (int i = 0; i < integerArray.length; ++i) {
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, ReportHelper.getFormattedTime(integerArray[i]));
                }
                break;
            }
            case UNSCHEDULED: {
                break;
            }
            case REACTIVITY_DATE_LIST: {
                ReactivityDateObject[] reactivityDateObjectArray = this.reactivityDateObjectDM.get(l);
                for (int i = 0; i < reactivityDateObjectArray.length; ++i) {
                    String string2 = reactivityDateObjectArray[i].getDateObject().getName();
                    String string3 = ReportHelper.getFormattedTime(reactivityDateObjectArray[i].getStartTime());
                    String string4 = ReportHelper.getFormattedTime(reactivityDateObjectArray[i].getEndTime());
                    String string5 = "React on Date List " + string2 + " From " + string3 + " To " + string4;
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string5);
                }
                break;
            }
            case REACTIVITY_DAY_OF_WEEK: {
                ReactivityDays[] reactivityDaysArray = this.reactivityDaysDM.get(l);
                for (int i = 0; i < reactivityDaysArray.length; ++i) {
                    int n = reactivityDaysArray[i].getStartTime();
                    int n2 = reactivityDaysArray[i].getEndTime();
                    String string6 = NO;
                    if (n == 0 && n2 == 2400) {
                        string6 = YES;
                    }
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "React all day:");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, string6);
                    String string7 = JobSetupReportHelper.getReacivityDaysOfWeekLine(reactivityDaysArray[i]);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string7);
                }
                break;
            }
            case REACTIVITY_DAY_OF_PERIOD: {
                ReactivityDayOfPeriod[] reactivityDayOfPeriodArray = this.reactivityDayOfPeriodDM.get(l);
                String string8 = ReportHelper.getWorkDaysName(scheduleJob.getDayType());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Count: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string8);
                for (int i = 0; i < reactivityDayOfPeriodArray.length; ++i) {
                    int n = reactivityDayOfPeriodArray[i].getStartTime();
                    int n3 = reactivityDayOfPeriodArray[i].getEndTime();
                    String string9 = NO;
                    if (n == 0 && n3 == 2400) {
                        string9 = YES;
                    }
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "React all day:");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, string9);
                    String string10 = JobSetupReportHelper.getReacivityDayofPeriodLine(reactivityDayOfPeriodArray[i]);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string10);
                }
                break;
            }
            case DAY_OF_WEEK: {
                ScheduleDayOfWeek[] scheduleDayOfWeekArray = this.reportDM.getDayOfWeekByJobId(l);
                for (int i = 0; i < scheduleDayOfWeekArray.length; ++i) {
                    String string11 = JobSetupReportHelper.getDaysOfWeekStr(scheduleDayOfWeekArray[i]);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string11);
                }
                break;
            }
            case DAY_OF_PERIOD: {
                String string12 = ReportHelper.getWorkDaysName(scheduleJob.getDayType());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Count: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string12);
                ScheduleDayOfPeriod[] scheduleDayOfPeriodArray = this.reportDM.getDayOfPeriodByJobId(l);
                for (int i = 0; i < scheduleDayOfPeriodArray.length; ++i) {
                    String string13 = JobSetupReportHelper.getScheduleDayofPeriodLine(scheduleDayOfPeriodArray[i]);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string13);
                }
                break;
            }
            case TIMED_INTERVAL: {
                Object object;
                if (scheduleInfo instanceof ScheduleInfo_TimedInterval) {
                    object = (ScheduleInfo_TimedInterval)scheduleInfo;
                    String string14 = JobSetupReportHelper.getTimeFormatFromMinutes(((ScheduleInfo_TimedInterval)object).getMinutes());
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Run every: ");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, string14);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Run on Non-Working days:");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, ((ScheduleInfo_TimedInterval)object).getDayType() == CalendarObject.DayType.ALL_DAYS ? YES : NO);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Base Date and Time:");
                    Object object2 = ReportHelper.getFormatedDate(((ScheduleInfo_TimedInterval)object).getBaseDateTime().getTime());
                    reportDataBuilder2.setFieldValue(VALUEFIELD, object2);
                }
                object = this.reportDM.getDayOfWeekRangeByJobId(l);
                for (Object object2 : ((Hashtable)object).keySet()) {
                    String string15 = JobSetupReportHelper.getScheduleDayOfWeekRanges((ArrayList)((Hashtable)object).get(object2));
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string15);
                }
                break;
            }
            case DAY_COUNT: {
                if (!(scheduleInfo instanceof ScheduleInfo_DayCount)) break;
                ScheduleInfo_DayCount scheduleInfo_DayCount = (ScheduleInfo_DayCount)scheduleInfo;
                String string16 = ReportHelper.getWorkDaysName(scheduleInfo_DayCount.getDayType());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Count: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string16);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Run every: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleInfo_DayCount.getDayCountInterval());
                String string17 = JobSetupReportHelper.getDateStrFromYyyymmdd(scheduleInfo_DayCount.getBaseDate());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Start run date:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string17);
                if (!(scheduleInfo_DayCount.getRuntimes() instanceof Runtimes_Basic)) break;
                Runtimes_Basic runtimes_Basic = (Runtimes_Basic)scheduleInfo_DayCount.getRuntimes();
                LocalHHMM[] localHHMMArray = runtimes_Basic.getRuntimes();
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Run time:");
                if (localHHMMArray.length != 0) {
                    int n = localHHMMArray[0].getMinuteOfHour();
                    String string18 = n < 10 ? "0" + n : String.valueOf(n);
                    int n4 = localHHMMArray[0].getHourOfDay();
                    String string19 = n4 < 10 ? "0" + n4 : "" + n4;
                    String string20 = string19 + ":" + string18;
                    reportDataBuilder2.setFieldValue(VALUEFIELD, string20);
                    break;
                }
                reportDataBuilder2.setFieldValue(VALUEFIELD, "No Run time");
                break;
            }
            case CRON_EXPRESSION: {
                Map<String, String> map = this.reportDM.getCronExpressionByJobID(l);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Minute: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, map.get("minute"));
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Hour: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, map.get("hour"));
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Day of Month: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, map.get("day"));
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Month: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, map.get("month"));
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Weekday: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, map.get("weekday"));
                String string21 = map.get("year");
                if (string21.equals("")) break;
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Year: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string21);
                break;
            }
            case SAP_RUN_INTERCEPT: {
                SAPInterceptCriterion sAPInterceptCriterion = this.reportDM.getSAPInterceptCriterionByJobID(l);
                String string22 = ReportHelper.getFormattedTime(sAPInterceptCriterion.getAllowedFromHHMM());
                String string23 = ReportHelper.getFormattedTime(sAPInterceptCriterion.getAllowedToHHMM());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Run Time Range Allowed From: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string22);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Run Time Range Allowed To: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string23);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Restricted Days: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, JobSetupReportHelper.getSAPRestrictedDays(sAPInterceptCriterion));
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "SAP System Definition: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, sAPInterceptCriterion.getSapSystemDefinitionName());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "SAP Job Name: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, sAPInterceptCriterion.getJobName());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "SAP Job Owner: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, sAPInterceptCriterion.getJobCreator());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "SAP Client: ");
                reportDataBuilder2.setFieldValue(VALUEFIELD, sAPInterceptCriterion.getClient());
                break;
            }
            default: {
                logger.trace((Object)"Schedule data can't be built because of wrong Schedule Type");
                return;
            }
        }
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Skip if running:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.isSkipOnNotCompleted() ? YES : NO);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Generate history when skipping:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.isGenerateSkippedHistory() ? YES : NO);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Hold on failure:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.isHoldOnFailure() ? YES : NO);
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Schedule");
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.SCHEDULE.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job schedule has been built.");
    }

    private void buildSpecialInstanceJLRData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        hashMap.put("JLR_SUB_TITLE", SPECIAL_INSTANCES);
        long l = scheduleJob.getSkybotJobNumber();
        SpecialInstance[] specialInstanceArray = this.specialInstance.getByJobID(l);
        for (int i = 0; i < specialInstanceArray.length; ++i) {
            int n;
            Object object;
            if (i != 0) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(FIELD_SHOW_COLUMN_BACK_COLOR, new Boolean(true));
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "");
            }
            SpecialInstance specialInstance = specialInstanceArray[i];
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Name:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, specialInstance.getName());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Description:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, specialInstance.getDescription());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Tags:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, this.reportDM.getTagsBySpecialID(specialInstance.getId()));
            if (specialInstance.getType() == SpecialInstanceType.DAY_OF_WEEK) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Instance type:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Day of Week");
                object = specialInstance.getSpecialInstanceDays();
                for (n = 0; n < ((SpecialInstanceDays[])object).length; ++n) {
                    String string = JobSetupReportHelper.getDaysOfWeekStr(object[n]);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string);
                }
                continue;
            }
            if (specialInstance.getType() == SpecialInstanceType.DATE_OBJECT) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Instance type:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Date List");
                object = this.dateObjectDM.get(specialInstance.getDateObjectID()).getName();
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Date list:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, object);
                n = specialInstance.getStartTime();
                int n2 = specialInstance.getEndTime();
                String string = ReportHelper.getFormattedTime(n);
                String string2 = ReportHelper.getFormattedTime(n2);
                String string3 = NO;
                if (n == 0 && n2 == 2400) {
                    string3 = YES;
                }
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "React all day:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string3);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "Between:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "and:");
                reportDataBuilder2.setFieldValue(VALUEFIELD, string2);
                continue;
            }
            if (specialInstance.getType() != SpecialInstanceType.DAY_OF_PERIOD) continue;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Instance type:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, "Day of Period");
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Count:");
            if (specialInstance.getDayType() == CalendarObject.DayType.ALL_DAYS) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "All Days");
            } else if (specialInstance.getDayType() == CalendarObject.DayType.WORKDAYS) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Working Days");
            } else if (specialInstance.getDayType() == CalendarObject.DayType.NON_WORKDAYS) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "Non-Working Days");
            }
            object = specialInstance.getSpecialInstanceDays();
            for (n = 0; n < ((SpecialInstanceDays[])object).length; ++n) {
                String string = JobSetupReportHelper.getDaysOfPeriodStr(object[n]);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD, string);
            }
        }
        if (specialInstanceArray.length == 0) {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "No Special Instances for this job.");
            logger.trace((Object)"Job doesn't have Special Instances");
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.SPECIAL_INSTANCE.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Special Instances has been built.");
    }

    private void buildAgentEnvJLRData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        AgentEnvironmentVariable[] agentEnvironmentVariableArray;
        AgentEnvironmentVariable[] agentEnvironmentVariableArray2;
        AgentEnvironmentVariable[] agentEnvironmentVariableArray3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        long l = scheduleJob.getSkybotJobNumber();
        AgentEnvironment agentEnvironment = null;
        AgentEnvironment agentEnvironment2 = null;
        String string = "No Shared Environment is used";
        String string2 = "";
        if (scheduleJob.getAgentEnvironmentType().equals(IBMI_AGENT_ENVIRONMENT)) {
            IBMiAgentEnvironment iBMiAgentEnvironment = null;
            iBMiAgentEnvironment = this.ibmiAgentEnvironmentDM.get(scheduleJob.getAgentEnvironmentID());
            string = iBMiAgentEnvironment.getName();
        } else {
            agentEnvironment2 = this.agentEnv.getByJobId(l);
            long l2 = agentEnvironment2.getRefSharedOID();
            if (l2 != 0L) {
                agentEnvironment = this.agentEnv.get(l2);
            } else {
                if (agentEnvironment2.isShared()) {
                    string = agentEnvironment2.getName();
                }
                if (agentEnvironment2.isPrivate()) {
                    string2 = "Private ";
                }
            }
        }
        if (agentEnvironment != null) {
            string = agentEnvironment.getName();
        }
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Agent Environment");
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Use Shared Environment:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, string);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Environment Type:");
        if (scheduleJob.getAgentEnvironmentType().equals(AGENT_ENVIRONMENT_TYPE)) {
            int n = agentEnvironment2.getRunType();
            reportDataBuilder2.setFieldValue(VALUEFIELD, agentEnvironment2.getRunTypeName(n));
            agentEnvironmentVariableArray3 = agentEnvironment2.getWorkingPath();
            if (n == 3) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "Run via the Agent's user");
            } else {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, "" + string2 + "User Name: ");
                agentEnvironmentVariableArray2 = agentEnvironment2.getPassword();
                agentEnvironmentVariableArray = agentEnvironment2.getUserProfile();
                if (agentEnvironmentVariableArray.equals(SHARED)) {
                    agentEnvironmentVariableArray = SHARED_DISPLAY;
                    agentEnvironmentVariableArray2 = agentEnvironment.getPassword();
                }
                if (agentEnvironmentVariableArray3.equals(SHARED)) {
                    agentEnvironmentVariableArray3 = SHARED_DISPLAY;
                }
                reportDataBuilder2.setFieldValue(VALUEFIELD, agentEnvironmentVariableArray);
                if (agentEnvironmentVariableArray2 != null && !agentEnvironmentVariableArray2.equals("")) {
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string2 + "Password is being used");
                } else {
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(ONELINEFIELD, string2 + "Password is not being used");
                }
            }
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, string2 + "Working Path: ");
            reportDataBuilder2.setFieldValue(VALUEFIELD, agentEnvironmentVariableArray3);
        } else {
            reportDataBuilder2.setFieldValue(VALUEFIELD, "IBM i Agent Environment");
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "IBM\u00ae i Job Name: ");
            reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.getIBMiJobName());
        }
        if (scheduleJob.getAgentEnvironmentType().equals(AGENT_ENVIRONMENT_TYPE)) {
            int n;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "Environment Variables:");
            int n2 = n = agentEnvironment != null ? agentEnvironment.getVariables().length : 0;
            if ((n += agentEnvironment2.getVariables().length) == 0) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "No Environment Variable data have been found.");
            } else {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD1, "Name");
                reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD2, "Value");
                reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD3, "Automate Schedule Variable");
                reportDataBuilder2.setFieldValue(FIELD_SHOW_COLUMN_BACK_COLOR, new Boolean(true));
            }
            agentEnvironmentVariableArray2 = agentEnvironment2.getVariables();
            agentEnvironmentVariableArray3 = agentEnvironment != null ? agentEnvironment.getVariables() : null;
            agentEnvironmentVariableArray = JobSetupReportHelper.getMergedAgtVariables(agentEnvironmentVariableArray2, agentEnvironmentVariableArray3);
            for (int i = 0; i < agentEnvironmentVariableArray.length; ++i) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(VALUEFIELD1, agentEnvironmentVariableArray[i].getName());
                reportDataBuilder2.setFieldValue(VALUEFIELD2, agentEnvironmentVariableArray[i].getVariable());
                reportDataBuilder2.setFieldValue(VALUEFIELD3, agentEnvironmentVariableArray[i].getSkybotVariable().getName());
            }
            if (agentEnvironmentVariableArray.length > 0) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "* Means field was merged");
            }
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.AGENT_ENVIRONMENT.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Agent Environment has been built.");
    }

    private void buildJobSuiteDependenciesData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        JobSuiteMemberJobDependencies[] jobSuiteMemberJobDependenciesArray = null;
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Job Suite Member Job Dependencies");
        long l = scheduleJob.getSkybotJobNumber();
        try {
            jobSuiteMemberJobDependenciesArray = this.jobSuiteDM.getJobSuiteMemberJobDependencies(l);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving job suite dependencies for Suite ID " + l));
        }
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD1, "Prerequisite Member Job");
        reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD2, "Dependent Member Job");
        reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD3, "Dependency Type");
        reportDataBuilder2.setFieldValue(FIELD_SHOW_COLUMN_BACK_COLOR, new Boolean(true));
        if (jobSuiteMemberJobDependenciesArray != null && jobSuiteMemberJobDependenciesArray.length > 0) {
            for (int i = 0; i < jobSuiteMemberJobDependenciesArray.length; ++i) {
                JobSuiteMemberJobDependencies jobSuiteMemberJobDependencies = jobSuiteMemberJobDependenciesArray[i];
                JobSuiteMember jobSuiteMember = this.jobSuiteDM.getMember(jobSuiteMemberJobDependencies.getDependentMemberId());
                JobSuiteMember jobSuiteMember2 = this.jobSuiteDM.getMember(jobSuiteMemberJobDependencies.getPrereqMemberId());
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(VALUEFIELD1, jobSuiteMember2.getName());
                reportDataBuilder2.setFieldValue(VALUEFIELD2, jobSuiteMember.getName());
                reportDataBuilder2.setFieldValue(VALUEFIELD3, jobSuiteMemberJobDependencies.getDependencyTypeText());
            }
        } else {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "No Job Suite Member Job Dependencies for this job suite.");
            logger.trace((Object)"Member Job doesn't have Member Job Dependencies");
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.MEMBER_DEPENDENCIES.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job suite dependencies has been built.");
    }

    private void buildOutputDistributionData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        long l = scheduleJob.getSkybotJobNumber();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Output Distribution");
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Save Job Log: ");
        reportDataBuilder2.setFieldValue(TWOVALUEDFIELD, scheduleJob.isCopyJobLogToServer() ? YES : NO);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Email Job Log: ");
        reportDataBuilder2.setFieldValue(TWOVALUEDFIELD, scheduleJob.isEmailJobLog() ? YES : NO);
        long l2 = scheduleJob.getEmailNotificationListId();
        NotificationList notificationList = null;
        if (l2 != 0L) {
            try {
                notificationList = this.noteListDM.get(l2);
            }
            catch (NoDataException noDataException) {
                // empty catch block
            }
        }
        JobSetupReportHelper.fillNotificationListData(reportDataBuilder2, notificationList, TWOVALUEDFIELD);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(ONELINEFIELD, "Agent File Distribution");
        OutputDistribution[] outputDistributionArray = null;
        try {
            OutputDistributionDM outputDistributionDM = MRHelper.getOutputDistributionDM();
            outputDistributionArray = outputDistributionDM.getByJobId(l);
        }
        catch (DataException dataException) {
            String string = "Error while retrieving the output distribution for job id = " + l;
            logger.debug((Object)string);
        }
        if (outputDistributionArray.length != 0) {
            Arrays.sort(outputDistributionArray, new OutputDistributionComparator());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(FIELD_SHOW_COLUMN_BACK_COLOR, new Boolean(true));
            reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD0, "Filter Type");
            reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD1, "Copy Option");
            reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD2, "On Duplicate Option");
            reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD3, "Email");
            reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD4, "Notification List or Users");
            reportDataBuilder2.setFieldValue(COLUMN_VALUEFIELD5, "Missing Action");
        } else {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "No Agent File Distribution data have been found.");
        }
        for (int i = 0; i < outputDistributionArray.length; ++i) {
            String string;
            reportDataBuilder2.nextRow();
            int n = outputDistributionArray[i].getFilterType();
            if ((long)n == 0L) {
                string = outputDistributionArray[i].getFileFilter();
                reportDataBuilder2.setFieldValue(VALUEFIELD0, "File: " + string);
            } else if ((long)n == 1L) {
                int n2 = outputDistributionArray[i].getReportID();
                String string2 = Reports.ReportType.getReportType(n2).getReportName();
                reportDataBuilder2.setFieldValue(VALUEFIELD0, "Report: " + string2);
            }
            string = NO;
            if (outputDistributionArray[i].getCopyFile() == 1) {
                string = YES;
            }
            reportDataBuilder2.setFieldValue(VALUEFIELD1, string);
            int n3 = outputDistributionArray[i].getCopyDuplicate();
            reportDataBuilder2.setFieldValue(VALUEFIELD2, JobSetupReportHelper.getOutputDublicateOption(n3));
            reportDataBuilder2.setFieldValue(VALUEFIELD3, outputDistributionArray[i].isEmailAttachment() ? YES : NO);
            long l3 = outputDistributionArray[i].getNotificationListId();
            NotificationList notificationList2 = null;
            if (l3 != 0L) {
                try {
                    notificationList2 = this.noteListDM.get(l3);
                }
                catch (NoDataException noDataException) {
                    // empty catch block
                }
            }
            reportDataBuilder2.setFieldValue(VALUEFIELD4, JobSetupReportHelper.getNoteListForOutput(notificationList2));
            reportDataBuilder2.setFieldValue(VALUEFIELD5, outputDistributionArray[i].isFailOnMissingFiles() ? "Fail" : "None");
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.OUTPUT_DISTRIBUTION.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data Output Distribution has been built!");
    }

    private void buildSchedlueExceptionsData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        long l = scheduleJob.getSkybotJobNumber();
        String string = this.reportDM.getNonWorkDayOption(l);
        ScheduleInfo.NonWorkdayOption nonWorkdayOption = ScheduleInfo.NonWorkdayOption.persistanceCodeToEnum(string);
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", SCHEDULE_EXCEPTIONS);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Run Time Range Allowed From:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, ReportHelper.getFormattedTime(scheduleJob.getTimeRangeStart()));
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Run Time Range Allowed To:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, ReportHelper.getFormattedTime(scheduleJob.getTimeRangeEnd()));
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Non-Working Days:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, JobSetupReportHelper.getScheduleExceptionType(nonWorkdayOption));
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Omit Date Lists:");
        String string2 = this.reportDM.getDateListByJobID(l);
        if (string2 == null || string2.trim().equals("")) {
            string2 = "No Omit Date List";
        }
        reportDataBuilder2.setFieldValue(VALUEFIELD, string2);
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.SCHEDULE_EXCEPTIONS.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Schedule Exception has been built.");
    }

    private void buildCommandsData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Commands");
        String string = "";
        CommandSet commandSet = scheduleJob.getCommandSet();
        CommandSetType commandSetType = CommandSetType.persistanceCodeToEnum(commandSet.getType());
        switch (commandSetType) {
            case PRIVATE: {
                string = "Using Private Command Set";
                break;
            }
            case SHARED: {
                string = "Using Shared Command Set - " + commandSet.getName();
                break;
            }
            case PRIVATE_IBMI: {
                string = "Using Private IBM i Command Set";
                break;
            }
            case SHARED_IBMI: {
                string = "Using Shared IBM i Command Set - " + commandSet.getName();
            }
        }
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(ONELINEFIELD, string);
        CommandSetCommand[] commandSetCommandArray = commandSet.getCommands();
        for (int i = 0; i < commandSetCommandArray.length; ++i) {
            Object object;
            if (i != 0) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "");
                reportDataBuilder2.setFieldValue(FIELD_SHOW_COLUMN_BACK_COLOR, new Boolean(true));
            }
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Command Type:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, commandSetCommandArray[i].getCommandTypeString());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Command:");
            if (commandSetCommandArray[i].getCommandType() == 10) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, commandSetCommandArray[i].getWebServiceCommand().toString());
            } else {
                reportDataBuilder2.setFieldValue(VALUEFIELD, commandSetCommandArray[i].getCommandString());
            }
            if (commandSet.getType() == CommandSetType.PRIVATE.persistanceCode().intValue() || commandSet.getType() == CommandSetType.SHARED.persistanceCode().intValue()) {
                object = commandSetCommandArray[i].getReturnCode();
                if (object.getType() == 1) {
                    String string2 = object.getSuccessTypeList() ? "Pass" : "Fail";
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Return Code Type:");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, string2);
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Return Code Values:");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, object.getActionList());
                } else {
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Return Code:");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, object.getName());
                }
            }
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "When command fails:");
            object = "";
            switch (commandSetCommandArray[i].getCommandAction()) {
                case 1: {
                    object = "Fail Job";
                    break;
                }
                case 2: {
                    object = "Ignore";
                    break;
                }
                case 3: {
                    object = "Retry command before Failing Job";
                    break;
                }
                case 4: {
                    object = "Retry Command before Ignoring Failure";
                    break;
                }
                default: {
                    object = "Fail Job";
                }
            }
            reportDataBuilder2.setFieldValue(VALUEFIELD, object);
            switch (commandSetCommandArray[i].getCommandAction()) {
                case 3: 
                case 4: {
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Number of Retries:");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, commandSetCommandArray[i].getRetriesCount());
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Wait Between Retries (seconds):");
                    reportDataBuilder2.setFieldValue(VALUEFIELD, commandSetCommandArray[i].getWaitCount());
                }
            }
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.COMMANDS.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Commands has been built!");
    }

    private void buildMissedRunTimeOptionData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Missed Run Time Options");
        MissedJobAction missedJobAction = scheduleJob.getMissedJobAction();
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(ONELINEFIELD, ReportHelper.getMissedActionType(missedJobAction));
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.MISSED_RUN_TIME_OPTION.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Missed Run Time Option has been built.");
    }

    private void buildNoteData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        long l = scheduleJob.getSkybotJobNumber();
        String string = this.reportDM.getNoteByJobID(l);
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Job Note");
        reportDataBuilder2.nextRow();
        if (string == null) {
            string = "No Note for this job.";
        }
        reportDataBuilder2.setFieldValue(ONELINEFIELD, string);
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.NOTE.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of Note has been built.");
    }

    private void buildJobParametersData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        String string = scheduleJob.getJobParameters();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Job Parameters");
        reportDataBuilder2.nextRow();
        if (string == null || string.length() == 0) {
            string = "No Parameters for this job.";
        }
        reportDataBuilder2.setFieldValue(ONELINEFIELD, string);
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.JOB_PARAMETERS.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of Job Parameters has been built.");
    }

    private void buildSuiteMembersData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, ArrayList<ScheduleJob> arrayList) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Job Suite Members");
        if (arrayList.size() > 0) {
            for (ScheduleJob scheduleJob : arrayList) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD, scheduleJob.getName());
            }
        } else {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "There is no member jobs for this suite.");
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.SUITE_MEMBERS.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of Suite Members has been built.");
    }

    private void buildJobHistoryPurgeData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        String string = "Job History Purge ";
        if (scheduleJob.getJobType() == JobType.SUITE) {
            string = "Job Suite History Purge";
        }
        boolean bl = scheduleJob.isUseDefaultsForJobHistoryPurge();
        boolean bl2 = scheduleJob.isPurgeJobHistory();
        int n = scheduleJob.getJobHistoriesToKeep();
        int n2 = scheduleJob.getJobHistoryDaysToKeep();
        if (bl) {
            SystemSetup systemSetup = this.systemSetupDM.get();
            bl2 = systemSetup.getJobHistoryPurgeDefault();
            n = systemSetup.getJobHistoriesToKeepDefault();
            n2 = systemSetup.getJobHistoryDaysToKeepDefault();
        }
        hashMap.put("JLR_SUB_TITLE", string);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Use default values in System Settings:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, bl ? YES : NO);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Purge:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, bl ? "" : (bl2 ? YES : NO));
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Runs to Keep:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, bl ? "" : (n == 0 ? "" : Integer.valueOf(n)));
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Days to Keep:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, bl ? "" : (n2 == 0 ? "" : Integer.valueOf(n2)));
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.JOB_HISTORY_PURGE_OPTION.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of Job History Purge Option has been built.");
    }

    private void buildJobMonitorData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        String string = "Job Monitors";
        if (scheduleJob.getJobType() == JobType.SUITE) {
            string = "Job Suite Monitors";
        }
        hashMap.put("JLR_SUB_TITLE", string);
        String string2 = "Job Overrun";
        JobMonitor.MonitorOption monitorOption = scheduleJob.getOverrunMonitorOption();
        ScheduleJobBigProxy scheduleJobBigProxy = this.job.getScheduleJobBigProxy(scheduleJob.getSkybotJobNumber());
        String string3 = "";
        String string4 = "";
        if (monitorOption == JobMonitor.MonitorOption.NONE) {
            string2 = string2 + NOT_MONITORED;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, string2);
        } else {
            String string5;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, string2);
            long l = scheduleJob.getOverrunNotificationListID();
            object = null;
            try {
                object = this.noteListDM.get(l);
            }
            catch (NoDataException noDataException) {
                // empty catch block
            }
            int n = scheduleJob.getOverrunTargetCompletionTime();
            int n2 = scheduleJob.getOverrunMaximumMinutes();
            boolean bl = scheduleJob.isOverrunSendSNMPTrap();
            if (monitorOption == JobMonitor.MonitorOption.TARGET_TIME) {
                string5 = ReportHelper.getFormattedTime(n);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, MUST_COMPLETE);
                reportDataBuilder2.setFieldValue(VALUEFIELD, string5);
            } else if (monitorOption == JobMonitor.MonitorOption.RUN_DURATION) {
                string5 = JobSetupReportHelper.getTimeFormatFromMinutes(n2);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, MAXIMUM_DURATION);
                reportDataBuilder2.setFieldValue(VALUEFIELD, string5);
            }
            JobSetupReportHelper.fillSnmpTrapOption(reportDataBuilder2, bl);
            string3 = scheduleJobBigProxy.getEmailSubjectOverrun();
            string4 = scheduleJobBigProxy.getEmailBodyOverrun();
            JobSetupReportHelper.fillNotificationListDataForMonitors(reportDataBuilder2, object, VALUEFIELD, string3, string4);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "End the job: ");
            reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.isOverrunEndJob() ? YES : NO);
        }
        String string6 = "Job Underrun";
        if (!scheduleJob.isUnderrunMonitorSelected()) {
            string6 = string6 + NOT_MONITORED;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, string6);
        } else {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, string6);
            long l = scheduleJob.getUnderrunNotificationListID();
            NotificationList notificationList = null;
            try {
                notificationList = this.noteListDM.get(l);
            }
            catch (NoDataException noDataException) {
                // empty catch block
            }
            int n = scheduleJob.getUnderrunMinimumMinutes();
            String string7 = JobSetupReportHelper.getTimeFormatFromMinutes(n);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, MINIMUM_DURATION);
            reportDataBuilder2.setFieldValue(VALUEFIELD, string7);
            boolean bl = scheduleJob.isUnderrunSendSNMPTrap();
            JobSetupReportHelper.fillSnmpTrapOption(reportDataBuilder2, bl);
            string3 = scheduleJobBigProxy.getEmailSubjectUnderrun();
            string4 = scheduleJobBigProxy.getEmailBodyUnderrun();
            JobSetupReportHelper.fillNotificationListDataForMonitors(reportDataBuilder2, notificationList, VALUEFIELD, string3, string4);
        }
        String string8 = "Late Start";
        object = scheduleJob.getLateStartMonitorOption();
        if (object == JobMonitor.MonitorOption.NONE) {
            string8 = string8 + NOT_MONITORED;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, string8);
        } else {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, string8);
            long l = scheduleJob.getLateStartNotificationListID();
            NotificationList notificationList = null;
            try {
                notificationList = this.noteListDM.get(l);
            }
            catch (NoDataException noDataException) {
                // empty catch block
            }
            int n = scheduleJob.getLateStartTargetStartTime();
            int n3 = scheduleJob.getLateStartMaximumMinutes();
            boolean bl = scheduleJob.isLateStartSendSNMPTrap();
            if (object == JobMonitor.MonitorOption.TARGET_TIME) {
                String string9 = ReportHelper.getFormattedTime(n);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, MUST_START);
                reportDataBuilder2.setFieldValue(VALUEFIELD, string9);
            } else if (object == JobMonitor.MonitorOption.RUN_DURATION) {
                String string10 = JobSetupReportHelper.getTimeFormatFromMinutes(n3);
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, LATER_TAHN_SCHEDULED_BY);
                reportDataBuilder2.setFieldValue(VALUEFIELD, string10);
            }
            JobSetupReportHelper.fillSnmpTrapOption(reportDataBuilder2, bl);
            string3 = scheduleJobBigProxy.getEmailSubjectLatestart();
            string4 = scheduleJobBigProxy.getEmailBodyLatestart();
            JobSetupReportHelper.fillNotificationListDataForMonitors(reportDataBuilder2, notificationList, VALUEFIELD, string3, string4);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "End the job from Job Queue: ");
            reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.isLateStartEndJob() ? YES : NO);
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.JOB_MONITORS.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Job Monitor has been built.");
    }

    private void buildStatusNotificationData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        String string;
        String string2;
        String string3;
        boolean bl;
        long l;
        String string4;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", STATUS_NOTE);
        boolean bl2 = false;
        ScheduleJobBigProxy scheduleJobBigProxy = this.job.getScheduleJobBigProxy(scheduleJob.getSkybotJobNumber());
        String string5 = "";
        String string6 = "";
        if (scheduleJob.getJobType() == JobType.JOB || scheduleJob.getJobType() == JobType.SUITE_MEMBER) {
            string4 = "Submitted Status Notification";
            l = scheduleJob.getSubmitNotificationListID();
            bl = scheduleJob.isSendSubmitSNMPTrap();
            string5 = scheduleJobBigProxy.getEmailSubjectSubmitted();
            string6 = scheduleJobBigProxy.getEmailBodySubmitted();
            JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string4, bl, string5, string6, JobStatusCode.SUBMITTED, bl2);
        }
        string4 = "Running Status Notification";
        l = scheduleJob.getRunNotificationListID();
        bl = scheduleJob.isSendRunSNMPTrap();
        string5 = scheduleJobBigProxy.getEmailSubjectRunning();
        string6 = scheduleJobBigProxy.getEmailBodyRunning();
        JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string4, bl, string5, string6, JobStatusCode.RUNNING, bl2);
        String string7 = "Completed Status Notification";
        l = scheduleJob.getCompleteNotificationListID();
        bl = scheduleJob.isSendCompleteSNMPTrap();
        string5 = scheduleJobBigProxy.getEmailSubjectCompleted();
        string6 = scheduleJobBigProxy.getEmailBodyCompleted();
        bl2 = scheduleJob.isSendCompleteJobLog();
        JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string7, bl, string5, string6, JobStatusCode.COMPLETED, bl2);
        if (scheduleJob.getJobType() == JobType.JOB || scheduleJob.getJobType() == JobType.SUITE_MEMBER) {
            string3 = "Failed Status Notification";
            l = scheduleJob.getFailNotificationListID();
            bl = scheduleJob.isSendFailSNMPTrap();
            string5 = scheduleJobBigProxy.getEmailSubjectFailed();
            string6 = scheduleJobBigProxy.getEmailBodyFailed();
            bl2 = scheduleJob.isSendFailJobLog();
            JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string3, bl, string5, string6, JobStatusCode.FAILED, bl2);
            string2 = "Cancelled Status Notification";
            l = scheduleJob.getCancelNotificationListID();
            bl = scheduleJob.isSendCancelSNMPTrap();
            string5 = scheduleJobBigProxy.getEmailSubjectCanceled();
            string6 = scheduleJobBigProxy.getEmailBodyCanceled();
            bl2 = scheduleJob.isSendCancelJobLog();
            JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string2, bl, string5, string6, JobStatusCode.CANCELED, bl2);
            string = "Retry Wait Status Notification";
            l = scheduleJob.getRetryWaitNotificationListID();
            bl = scheduleJob.isSendRetryWaitSNMPTrap();
            string5 = scheduleJobBigProxy.getEmailSubjectRetryWait();
            string6 = scheduleJobBigProxy.getEmailBodyRetryWait();
            JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string, bl, string5, string6, JobStatusCode.ERROR, bl2);
        }
        string3 = "Skipped Status Notification";
        l = scheduleJob.getSkipNotificationListID();
        bl = scheduleJob.isSendSkipSNMPTrap();
        string5 = scheduleJobBigProxy.getEmailSubjectSkipped();
        string6 = scheduleJobBigProxy.getEmailBodySkipped();
        JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string3, bl, string5, string6, JobStatusCode.SKIPPED, bl2);
        if (scheduleJob.getJobType() == JobType.SUITE) {
            string2 = "Member Failed  Status Notification";
            l = scheduleJob.getMemberFailNotificationListID();
            bl = scheduleJob.isSendMemberFailSNMPTrap();
            string5 = scheduleJobBigProxy.getEmailSubjectMemberFailed();
            string6 = scheduleJobBigProxy.getEmailBodyMemberFailed();
            JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string2, bl, string5, string6, JobStatusCode.MEMBER_FAILED, bl2);
            string = "Member Cancelled Status Notification";
            l = scheduleJob.getMemberCancelNotificationListID();
            bl = scheduleJob.isSendMemberCancelSNMPTrap();
            string5 = scheduleJobBigProxy.getEmailSubjectMemberCanceled();
            string6 = scheduleJobBigProxy.getEmailBodyMemberCanceled();
            JobSetupReportHelper.fillStatusNotificationData(reportDataBuilder2, l, string, bl, string5, string6, JobStatusCode.MEMBER_CANCELED, bl2);
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.MISSED_RUN_TIME_OPTION.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Status Notification has been built.");
    }

    private void buildPrereqJLRData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        long l = scheduleJob.getSkybotJobNumber();
        Prereq[] prereqArray = null;
        try {
            prereqArray = this.prereqDM.getPrereqByJobIdSortedBySeqNum(l);
        }
        catch (NoDataException noDataException) {
            logger.debug((Object)noDataException.getMessage());
        }
        if (prereqArray == null || prereqArray.length == 0) {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "There are no prerequisites on this job");
            logger.trace((Object)("No Prerequisites for job: " + scheduleJob.getName()));
        } else {
            for (int i = 0; i < prereqArray.length; ++i) {
                Object object;
                long l2 = prereqArray[i].getSpecialInstanceID();
                String string = "";
                if (l2 > 0L) {
                    object = this.specialInstance.get(l2);
                    string = " during " + ((SpecialInstance)object).getName();
                }
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, JobSetupReportHelper.getPrerqData(scheduleJob, prereqArray[i], string));
                if (i >= prereqArray.length - 1) continue;
                object = prereqArray[i + 1].getConjunction();
                if (((String)object).equals(AND)) {
                    reportDataBuilder2.setFieldValue(VALUEFIELD, object);
                    continue;
                }
                if (!((String)object).equals(OR)) continue;
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD_CENTER, object);
            }
        }
        hashMap.put("JLR_SUB_TITLE", "Prerequisites");
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.PREREQUISITES.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The Prerequisites report data has been built.");
    }

    private void buildConditionsJLRData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Conditions");
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Status:");
        long l = scheduleJob.getSkybotJobNumber();
        if (!scheduleJob.isConditional()) {
            reportDataBuilder2.setFieldValue(VALUEFIELD, "Job conditions not checked before execution.");
        } else {
            Object object;
            reportDataBuilder2.setFieldValue(VALUEFIELD, "Job conditions checked before execution.");
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Retry if not met:");
            if (!scheduleJob.isCondRetry()) {
                reportDataBuilder2.setFieldValue(VALUEFIELD, NO);
            } else {
                object = JobSetupReportHelper.getTimeBySec(scheduleJob.getCondRetryDelay());
                object = "Every " + (String)object + ", repeat up to " + scheduleJob.getCondRetryCount() + PARAM_DELIMITER + (scheduleJob.getCondRetryCount() > 1 ? "times" : "time");
                reportDataBuilder2.setFieldValue(VALUEFIELD, object);
            }
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Condition Fail Action: ");
            reportDataBuilder2.setFieldValue(VALUEFIELD, ReportHelper.getCondFailAction(scheduleJob.getConditionFailStatus()));
            object = this.conditionDM.getList(l, new JobConditionR02M03());
            Arrays.sort(object, new JobConditionsComparator());
            for (int i = 0; i < ((JobCondition[])object).length; ++i) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, JobConditionMessageGenerator.getConditionMessage(object[i]));
                if (i >= ((JobCondition[])object).length - 1) continue;
                String string = object[i + 1].getConjunction();
                if (string.equals(AND)) {
                    reportDataBuilder2.setFieldValue(VALUEFIELD, AND);
                    continue;
                }
                if (!string.equals(OR)) continue;
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD_CENTER, OR);
            }
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.CONDITIONS.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The conditions report data has been built.");
    }

    private void buildForecastScheduleJLRData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        long l = scheduleJob.getSkybotJobNumber();
        reportDataBuilder.nextRow();
        Map<String, Object> map = this.reportDM.getForecastScheduleDataByJobID(l);
        hashMap.put("JLR_SUB_TITLE", "Forecast Schedule");
        if (map != null) {
            int n;
            Object object;
            ScheduleJobProxy.ScheduleType scheduleType = (ScheduleJobProxy.ScheduleType)map.get("SCHEDULE_TYPE");
            long l2 = (Long)map.get("CALENDAR_ID");
            long l3 = (Long)map.get("FORECAST_SCHEDULE_ID");
            CalendarObject calendarObject = this.calendarObjectDM.get(l2);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Calendar:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, calendarObject.getName());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, SCHEDULE_TYPE);
            switch (scheduleType) {
                case DATE_LIST: {
                    String[] stringArray;
                    int n2;
                    reportDataBuilder2.setFieldValue(VALUEFIELD, ReportHelper.getScheduleTypeName(scheduleType));
                    object = this.reportDM.getForecastDateObject(l3);
                    int n3 = object.size();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (n2 = 0; n2 < n3; ++n2) {
                        int n4 = (Integer)object.get(n2).get("DATE_OBJECT_TYPE");
                        if (n4 != 0) continue;
                        stringArray = this.dateObjectDM.get((Long)((Map)object.get(n2)).get("DATE_OBJECT_ID"));
                        arrayList.add(stringArray.getName());
                    }
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Run Date Lists:");
                    n2 = arrayList.size();
                    if (n2 > 0) {
                        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                        reportDataBuilder2.setFieldValue(VALUEFIELD, JobSetupReportHelper.getOneLineString(stringArray2));
                    } else {
                        reportDataBuilder2.setFieldValue(VALUEFIELD, "No Date List");
                    }
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Run Time:");
                    Integer[] integerArray = this.reportDM.getRuntimes(l3, ReportDM.TypeOfRuntime.FORECAST);
                    stringArray = new String[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        stringArray[i] = ReportHelper.getFormattedTime(integerArray[i]);
                    }
                    if (stringArray.length > 0) {
                        String string = JobSetupReportHelper.getOneLineString(stringArray);
                        reportDataBuilder2.setFieldValue(VALUEFIELD, string);
                        break;
                    }
                    reportDataBuilder2.setFieldValue(VALUEFIELD, "No Run Time");
                    break;
                }
                case UNSCHEDULED: {
                    reportDataBuilder2.setFieldValue(VALUEFIELD, "No Additional Schedule");
                    break;
                }
                case DAY_OF_WEEK: {
                    ScheduleDayOfPeriod[] scheduleDayOfPeriodArray;
                    reportDataBuilder2.setFieldValue(VALUEFIELD, ReportHelper.getScheduleTypeName(scheduleType));
                    ScheduleDayOfWeek[] scheduleDayOfWeekArray = this.reportDM.getForecastScheduleDayOfWeek(l3);
                    for (int i = 0; i < scheduleDayOfWeekArray.length; ++i) {
                        scheduleDayOfPeriodArray = JobSetupReportHelper.getDaysOfWeekStr(scheduleDayOfWeekArray[i]);
                        reportDataBuilder2.nextRow();
                        reportDataBuilder2.setFieldValue(ONELINEFIELD, scheduleDayOfPeriodArray);
                    }
                    break;
                }
                case DAY_OF_PERIOD: {
                    reportDataBuilder2.setFieldValue(VALUEFIELD, ReportHelper.getScheduleTypeName(scheduleType));
                    reportDataBuilder2.nextRow();
                    reportDataBuilder2.setFieldValue(NAMEFIELD, "Count:");
                    CalendarObject.DayType dayType = CalendarObject.DayType.persistanceCodeToEnum((String)map.get("DAY_TYPE"));
                    reportDataBuilder2.setFieldValue(VALUEFIELD, ReportHelper.getWorkDaysName(dayType));
                    ScheduleDayOfPeriod[] scheduleDayOfPeriodArray = this.reportDM.getForecastScheduleDayOfPeriod(l3);
                    for (int i = 0; i < scheduleDayOfPeriodArray.length; ++i) {
                        String string = JobSetupReportHelper.getScheduleDayofPeriodLine(scheduleDayOfPeriodArray[i]);
                        reportDataBuilder2.nextRow();
                        reportDataBuilder2.setFieldValue(ONELINEFIELD, string);
                    }
                    break;
                }
                default: {
                    logger.trace((Object)"Forecast Schedule data can't be built because of wrong Schedule Type");
                    return;
                }
            }
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, SCHEDULE_EXCEPTIONS);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Non-Working Days:");
            object = JobSetupReportHelper.getScheduleExceptionType((ScheduleInfo.NonWorkdayOption)map.get("NON_WORKDAY_OPTION"));
            reportDataBuilder2.setFieldValue(VALUEFIELD, object);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Omit Date Lists:");
            List<Map<String, Object>> list = this.reportDM.getForecastDateObject(l3);
            int n5 = list.size();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < n5; ++n) {
                int n6 = (Integer)list.get(n).get("DATE_OBJECT_TYPE");
                if (n6 != 1) continue;
                DateObject dateObject = this.dateObjectDM.get((Long)list.get(n).get("DATE_OBJECT_ID"));
                arrayList.add(dateObject.getName());
            }
            n = arrayList.size();
            if (n > 0) {
                String[] stringArray = arrayList.toArray(new String[n]);
                reportDataBuilder2.setFieldValue(VALUEFIELD, JobSetupReportHelper.getOneLineString(stringArray));
            } else {
                reportDataBuilder2.setFieldValue(VALUEFIELD, "No date lists selected.");
            }
        } else {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "No Forecast Schedule on this job.");
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.FORECAST_SCHEDULE.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The forecast schedule report data has been built.");
    }

    private void buildLoggingData(ScheduleJob scheduleJob, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = JobSetupReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Logging");
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Save Job Log: ");
        reportDataBuilder2.setFieldValue(VALUEFIELD, scheduleJob.isCopyJobLogToServer() ? YES : NO);
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.LOGGING.name());
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_PARAMS, hashMap);
        reportDataBuilder.setFieldValue(FIELD_GROUP_SUBREPORT_DATA, reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data Output Distribution has been built!");
    }

    private static enum Groupings {
        TABLE_OF_CONTENT,
        GENERAL,
        AGENT_ENVIRONMENT,
        SPECIAL_INSTANCE,
        SCHEDULE_EXCEPTIONS,
        OUTPUT_DISTRIBUTION,
        SCHEDULE,
        COMMANDS,
        MISSED_RUN_TIME_OPTION,
        JOB_HISTORY_PURGE_OPTION,
        JOB_MONITORS,
        PREREQUISITES,
        STATUS_NOTIFICATION,
        PARAMETERS,
        CONDITIONS,
        FORECAST_SCHEDULE,
        LOGGING,
        NOTE,
        JOB_PARAMETERS,
        SUITE_MEMBERS,
        MEMBER_DEPENDENCIES;

    }
}

