/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.reports.AbstractReport;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportRenderer;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;

public abstract class AbstractJasperReport
extends AbstractReport {
    public static final String REPORT_EXTENSION = ".jasper";
    protected ReportDM reportDM;
    private URL reportDefinitionFile = this.getReportDefinitionPath();
    private JasperReport jreport = null;
    private String[] emailToNotificationList;
    private String[] emailToAddress;
    private boolean emailToCurrentUser = false;
    private String savedReportFilePath;
    private String savedReportFileName;

    public AbstractJasperReport() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("virtualizer.directory", "temp");
        this.setParameters(hashMap);
        this.log("Requesting Generation of the " + this.getReportName() + ".");
    }

    public AbstractJasperReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        this();
        this.setReportLocale(locale);
        this.setOutputType(outputType);
        this.setRunAsUserName(string);
        this.setParams(objectArray);
    }

    @Override
    public void initializeReportRender() throws ReportException {
        try {
            this.createRenderer(this.buildReportData());
        }
        catch (Exception exception) {
            String string = "Unable to initialize report " + this.getReportName() + ".";
            this.log(string, exception);
            throw new ReportException(string, exception);
        }
    }

    abstract JasperReportData buildReportData() throws ReportException;

    protected void createRenderer(JasperReportData jasperReportData) throws JRException, IOException {
        if (this.reportDefinitionFile == null) {
            this.reportDefinitionFile = this.getReportDefinitionPath();
        }
        if (this.jreport == null) {
            this.jreport = (JasperReport)JRLoader.loadObject((URL)this.reportDefinitionFile);
        }
        this.setReportRenderer(new JasperReportRenderer(jasperReportData, this.jreport, this));
    }

    protected static ReportDataBuilder createReportDataBuilder() {
        return new ReportDataBuilder();
    }

    protected static <T> CrosstabDataBuilder<T> createCrosstabDataBuilder() {
        return new CrosstabDataBuilder();
    }

    public static void generateReportDateInTitlePage(ReportDataBuilder reportDataBuilder, Integer n, Integer n2, Integer n3, Integer n4, Long l, Long l2, boolean bl) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2;
        String string;
        String string2;
        if (n != null || n2 != null) {
            string2 = "Start Date and Time";
            string = "Days: " + (n != null ? String.valueOf(n) : "0");
            string = string + " , Hours: " + (n2 != null ? String.valueOf(n2) : "0");
            string = string + " (prior to End Date and Time)";
        } else {
            string2 = "Start Date and Time";
            simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy");
            string = "Date: " + simpleDateFormat2.format(new Date(l));
            simpleDateFormat = new SimpleDateFormat("HH:mm");
            string = string + " , Time: " + simpleDateFormat.format(new Date(l));
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", string2);
        reportDataBuilder.setFieldValue("VALUEFIELD", string);
        if (bl) {
            string2 = "End Date and Time";
            simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy");
            string = "Date: " + simpleDateFormat2.format(new Date(l2));
            simpleDateFormat = new SimpleDateFormat("HH:mm");
            string = string + " , Time: " + simpleDateFormat.format(new Date(l2));
        } else if (n3 != null && n4 != null) {
            string2 = "End Date and Time";
            string = "Days: " + (n3 != null ? String.valueOf(n3) : "0");
            string = string + " , Hours: " + (n4 != null ? String.valueOf(n4) : "0");
            string = string + " (after Begin Date and Time)";
        } else {
            string2 = "End Date and Time";
            simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy");
            string = "Date: " + simpleDateFormat2.format(new Date(l2));
            simpleDateFormat = new SimpleDateFormat("HH:mm");
            string = string + " , Time: " + simpleDateFormat.format(new Date(l2));
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", string2);
        reportDataBuilder.setFieldValue("VALUEFIELD", string);
    }

    @Override
    public String getReportDefinitionExtension() {
        return REPORT_EXTENSION;
    }

    protected abstract void replaceIfNotAKey(Object ... var1);

    protected abstract boolean isEqualToKey(String var1);

    @Override
    public String[] getEmailToNotificationList() {
        return this.emailToNotificationList;
    }

    @Override
    public void setEmailToNotificationList(String[] stringArray) {
        this.emailToNotificationList = stringArray;
    }

    @Override
    public String[] getEmailToAddress() {
        return this.emailToAddress;
    }

    @Override
    public void setEmailToAddress(String[] stringArray) {
        this.emailToAddress = stringArray;
    }

    @Override
    public boolean isEmailToCurrentUser() {
        return this.emailToCurrentUser;
    }

    @Override
    public void setEmailToCurrentUser(boolean bl) {
        this.emailToCurrentUser = bl;
    }

    @Override
    public String getSavedReportFilePath() {
        return this.savedReportFilePath;
    }

    @Override
    public void setSavedReportFilePath(String string) {
        this.savedReportFilePath = string;
    }

    @Override
    public String getSavedReportFileName() {
        return this.savedReportFileName;
    }

    @Override
    public void setSavedReportFileName(String string) {
        this.savedReportFileName = string;
    }

    protected static class CrosstabDataBuilder<T> {
        private Collection<T> elements = new ArrayList<T>();

        public void close() {
        }

        public void add(T t) {
            this.elements.add(t);
        }

        public JRDataSource toJRDataSource() {
            return new JRBeanCollectionDataSource(this.elements);
        }
    }

    public static class ReportDataBuilder {
        private Collection<Object> elements = new ArrayList<Object>();
        private Map<String, Object> current = null;

        public void close() {
        }

        public void nextRow() {
            this.current = new HashMap<String, Object>();
            this.elements.add(this.current);
        }

        public void setFieldValue(String string, Object object) {
            this.current.put(string, object);
        }

        public JRDataSource toJRDataSource() {
            return new JRMapCollectionDataSource(this.elements);
        }
    }
}

