/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.infocloud;

import com.google.gson.Gson;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.dm.SkybotCommandDM;
import com.helpsystems.enterprise.core.infocloud.ICConnectionsExhausted;
import com.helpsystems.enterprise.core.infocloud.ICJobRunnerException;
import com.helpsystems.enterprise.core.infocloud.ICLoginFailedException;
import com.helpsystems.enterprise.core.infocloud.ICServerInfo;
import com.helpsystems.enterprise.core.infocloud.busobj.ICConnectionInfo;
import com.helpsystems.enterprise.core.infocloud.busobj.ICError;
import com.helpsystems.enterprise.core.infocloud.busobj.ICServerTime;
import com.helpsystems.enterprise.core.infocloud.busobj.ICSharedConnectionInfo;
import com.helpsystems.enterprise.module.infocloud.ICHelper;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class SkybotCommandDMImpl
extends AbstractManager
implements SkybotCommandDM,
Runnable {
    private static final Logger logger = Logger.getLogger(SkybotCommandDMImpl.class);
    public static long MAX_CONNECTION_DURATION = 3600000L;
    private Object icSharedConnectionLock = new Object();
    private boolean verifyStarted = false;
    private boolean agentEnding = false;
    private HashMap<String, ICConnectionHolder> icsciMap = new HashMap();
    private AgentPeer myPeer;
    private PeerID myPeerID;

    public SkybotCommandDMImpl(AgentPeer agentPeer) {
        this.myPeer = agentPeer;
        this.myPeerID = agentPeer.getRemotePeerID();
        this.setName("ENTERPRISE.SkybotCommandDM");
    }

    @Override
    public void run() {
        this.verifyStarted = true;
        while (true) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                if (this.agentEnding || this.icsciMap == null) {
                    return;
                }
                this.verifySharedConnections();
                continue;
            }
            catch (Exception exception) {
                logger.warn((Object)"Error verifying shared Informatica Cloud connections.", (Throwable)exception);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySharedConnections() {
        Object object = this.icSharedConnectionLock;
        synchronized (object) {
            Thread.currentThread().setName("InfoCloudConnectionMonitor");
            if (this.agentEnding || this.icsciMap == null) {
                return;
            }
            Iterator<Map.Entry<String, ICConnectionHolder>> iterator = this.icsciMap.entrySet().iterator();
            DefaultHttpClient defaultHttpClient = null;
            if (iterator.hasNext()) {
                defaultHttpClient = new DefaultHttpClient();
                while (iterator.hasNext()) {
                    Map.Entry<String, ICConnectionHolder> entry = iterator.next();
                    ICConnectionHolder iCConnectionHolder = entry.getValue();
                    if (iCConnectionHolder.icSharedConnectionInfo.isConnectionExpired()) {
                        logger.debug((Object)("Expired Informatica Cloud connection detected: " + iCConnectionHolder.icServerInfo.getServerName()));
                        iterator.remove();
                        SkybotCommandDMImpl.icServerLogout((HttpClient)defaultHttpClient, iCConnectionHolder.icServerInfo, iCConnectionHolder.icSharedConnectionInfo.getIcConnectionInfo(), true);
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Validating Informatica Cloud connection: " + iCConnectionHolder.icServerInfo.getServerName()));
                    }
                    ICServerTime iCServerTime = null;
                    try {
                        iCServerTime = SkybotCommandDMImpl.getICServerTime((HttpClient)defaultHttpClient, iCConnectionHolder.icSharedConnectionInfo.getIcConnectionInfo(), iCConnectionHolder.icServerInfo.isVerbose());
                    }
                    catch (Exception exception) {
                        logger.warn((Object)"Error testing connection.", (Throwable)exception);
                    }
                    if (iCServerTime == null) {
                        logger.debug((Object)("Invalid Informatica Cloud connection detected: " + iCConnectionHolder.icServerInfo.getServerName()));
                        iterator.remove();
                        SkybotCommandDMImpl.icServerLogout((HttpClient)defaultHttpClient, iCConnectionHolder.icServerInfo, iCConnectionHolder.icSharedConnectionInfo.getIcConnectionInfo(), true);
                        continue;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Server time from Informatica Cloud connection '" + iCConnectionHolder.icServerInfo.getServerName() + "': " + iCServerTime.toString()));
                }
            }
        }
    }

    @Override
    public PeerID getPeerID() {
        return this.myPeerID;
    }

    @Override
    public ICSharedConnectionInfo getICSharedConnectionInfo(ICServerInfo iCServerInfo, String string) throws ICLoginFailedException, ICConnectionsExhausted, ICJobRunnerException {
        logger.debug((Object)("Shared Informatica Cloud Connection requested by " + string + ": " + iCServerInfo.getServerName()));
        return this.getSharedConnection(iCServerInfo, true, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICSharedConnectionInfo getSharedConnection(ICServerInfo iCServerInfo, boolean bl, String string) throws ICConnectionsExhausted, ICLoginFailedException {
        Object object = this.icSharedConnectionLock;
        synchronized (object) {
            Object object2;
            if (!this.verifyStarted) {
                new Thread(this).start();
            }
            if (this.agentEnding || this.icsciMap == null) {
                throw new IllegalStateException("The agent is ending. Shared connections are not currently available.");
            }
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            String string2 = String.valueOf(iCServerInfo.getOID());
            logger.debug((Object)("Requesting validated connection for server ID: " + string2 + " (" + iCServerInfo.getServerName() + ")"));
            String string3 = this.makeConnectionKey(iCServerInfo);
            ICConnectionHolder iCConnectionHolder = this.icsciMap.get(string3);
            if (iCConnectionHolder != null) {
                if (iCConnectionHolder.icSharedConnectionInfo.isConnectionExpired()) {
                    logger.debug((Object)"Detected expired shared Informatica Cloud connection...");
                    this.releaseSharedConnection((HttpClient)defaultHttpClient, iCServerInfo, iCConnectionHolder.icSharedConnectionInfo);
                    this.icsciMap.remove(string3);
                    iCConnectionHolder = null;
                } else {
                    object2 = null;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Testing cached shared connection...");
                    }
                    try {
                        object2 = SkybotCommandDMImpl.getICServerTime((HttpClient)defaultHttpClient, iCConnectionHolder.icSharedConnectionInfo.getIcConnectionInfo(), iCServerInfo.isVerbose());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object2 == null) {
                        logger.warn((Object)"Invalid Cached shared Informatica Cloud connection...");
                        this.releaseSharedConnection((HttpClient)defaultHttpClient, iCServerInfo, iCConnectionHolder.icSharedConnectionInfo);
                        this.icsciMap.remove(string3);
                        iCConnectionHolder = null;
                    }
                }
            }
            if (iCConnectionHolder == null) {
                object2 = this.getSharedConnectionInfo((HttpClient)defaultHttpClient, iCServerInfo);
                iCConnectionHolder = new ICConnectionHolder();
                iCConnectionHolder.icServerInfo = iCServerInfo;
                iCConnectionHolder.icSharedConnectionInfo = object2;
                this.icsciMap.put(string3, iCConnectionHolder);
            }
            iCConnectionHolder.borrowers.add(string);
            return iCConnectionHolder.icSharedConnectionInfo;
        }
    }

    private String makeConnectionKey(ICServerInfo iCServerInfo) {
        String string = String.valueOf(iCServerInfo.getOID()) + "+" + iCServerInfo.getUserID().trim().toLowerCase() + "+" + iCServerInfo.getPassword().trim() + "+" + iCServerInfo.getBaseURL().trim().toLowerCase();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnICSharedConnectionInfo(String string, ICServerInfo iCServerInfo, ICSharedConnectionInfo iCSharedConnectionInfo) {
        logger.debug((Object)("Returning connection from Job Identifier: " + string));
        if (iCSharedConnectionInfo == null) {
            logger.warn((Object)"Returning a null ICSharedConnectionInfo object...");
            return;
        }
        Object object = this.icSharedConnectionLock;
        synchronized (object) {
            String string2 = this.makeConnectionKey(iCServerInfo);
            ICConnectionHolder iCConnectionHolder = this.icsciMap.get(string2);
            if (iCConnectionHolder == null) {
                logger.debug((Object)("Connection Information was not found for returned connection key: " + string2));
                return;
            }
            String string3 = iCSharedConnectionInfo.getIcConnectionInfo().getIcSessionId();
            String string4 = iCConnectionHolder.icSharedConnectionInfo.getIcConnectionInfo().getIcSessionId();
            if (string3 == null) {
                logger.debug((Object)"Returning IC connection session is null.");
                return;
            }
            if (string4 == null) {
                logger.debug((Object)"Current IC connection session is null.");
                return;
            }
            if (string3.trim().equalsIgnoreCase(string4.trim())) {
                boolean bl = iCConnectionHolder.borrowers.remove(string);
                if (bl) {
                    logger.debug((Object)("Returned connection was borrowed by Job Identifier: " + string));
                    if (iCConnectionHolder.borrowers.isEmpty()) {
                        logger.debug((Object)"Connection is no longer used.  It will be closed...");
                        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                        this.releaseSharedConnection((HttpClient)defaultHttpClient, iCServerInfo, iCConnectionHolder.icSharedConnectionInfo);
                        this.icsciMap.remove(string2);
                    } else {
                        logger.debug((Object)("Connection is still used by borrowers: " + iCConnectionHolder.borrowers.size()));
                    }
                } else {
                    logger.debug((Object)("Connection was not found for Job Identifier: " + string));
                }
            }
        }
    }

    public void managerRemoved() {
        super.managerRemoved();
        this.releaseConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnections() {
        this.agentEnding = true;
        Object object = this.icSharedConnectionLock;
        synchronized (object) {
            if (this.icsciMap == null) {
                return;
            }
            logger.debug((Object)("Releasing Informatica Cloud shared connections in connection map: " + this.icsciMap.size()));
            Iterator<Map.Entry<String, ICConnectionHolder>> iterator = this.icsciMap.entrySet().iterator();
            DefaultHttpClient defaultHttpClient = null;
            if (iterator.hasNext()) {
                defaultHttpClient = new DefaultHttpClient();
                while (iterator.hasNext()) {
                    Map.Entry<String, ICConnectionHolder> entry = iterator.next();
                    ICConnectionHolder iCConnectionHolder = entry.getValue();
                    logger.debug((Object)("Releasing open connection: " + iCConnectionHolder.icServerInfo.getServerName()));
                    try {
                        iterator.remove();
                        SkybotCommandDMImpl.icServerLogout((HttpClient)defaultHttpClient, iCConnectionHolder.icServerInfo, iCConnectionHolder.icSharedConnectionInfo.getIcConnectionInfo(), false);
                    }
                    catch (Throwable throwable) {
                        logger.warn((Object)"Error logging out shared Informatica Cloud connection.", throwable);
                    }
                }
            }
            logger.debug((Object)("Remaining Informatica Cloud shared connections in connection map: " + this.icsciMap.size()));
            this.icsciMap = null;
        }
    }

    private void releaseSharedConnection(HttpClient httpClient, ICServerInfo iCServerInfo, ICSharedConnectionInfo iCSharedConnectionInfo) {
        logger.debug((Object)"Releasing shared connection...");
        if (iCSharedConnectionInfo == null) {
            logger.debug((Object)"Shared connection was not released.  It was null...");
            return;
        }
        SkybotCommandDMImpl.icServerLogout(httpClient, iCServerInfo, iCSharedConnectionInfo.getIcConnectionInfo(), true);
    }

    private ICSharedConnectionInfo getSharedConnectionInfo(HttpClient httpClient, ICServerInfo iCServerInfo) throws ICConnectionsExhausted, ICLoginFailedException {
        logger.debug((Object)"Getting new Shared Informatica Cloud connection...");
        ICSharedConnectionInfo iCSharedConnectionInfo = new ICSharedConnectionInfo();
        ICConnectionInfo iCConnectionInfo = this.icServerLogin(httpClient, iCServerInfo);
        iCSharedConnectionInfo.setIcConnectionInfo(iCConnectionInfo);
        iCSharedConnectionInfo.setAgentExpirationTime(System.currentTimeMillis() + MAX_CONNECTION_DURATION);
        iCSharedConnectionInfo.setSharedConnection(true);
        return iCSharedConnectionInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ICConnectionInfo icServerLogin(HttpClient httpClient, ICServerInfo iCServerInfo) throws ICConnectionsExhausted, ICLoginFailedException {
        InputStream inputStream = null;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        String string = iCServerInfo.getBaseURL() + "/ma/api/v2/user/login";
        if (iCServerInfo.isVerbose()) {
            String string2 = "Logging into Informtica Cloud web server: UserID(" + iCServerInfo.getUserID() + ") LoginURL(" + string + ")";
            logger.debug((Object)string2);
        } else {
            logger.debug((Object)"Logging into Informatica Cloud web server...");
        }
        boolean bl = false;
        do {
            block21: {
                ICError iCError;
                Object object;
                block20: {
                    String string3;
                    int n;
                    block19: {
                        if (this.agentEnding) {
                            throw new RuntimeException("Agent is ending. Informatica Cloud shared connections are not available.");
                        }
                        HttpPost httpPost = new HttpPost(string);
                        httpPost.setHeader("Content-Type", "application/json");
                        httpPost.setHeader("Accept", "application/json");
                        String string4 = "{\n" + ICHelper.getJSONLine("@type", "login") + "," + "\n" + ICHelper.getJSONLine("username", iCServerInfo.getUserID()) + "," + "\n" + ICHelper.getJSONLine("password", iCServerInfo.getPassword()) + "\n" + "}";
                        StringEntity stringEntity = new StringEntity(string4);
                        httpPost.setEntity((HttpEntity)stringEntity);
                        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                        n = httpResponse.getStatusLine().getStatusCode();
                        string3 = httpResponse.getStatusLine().getReasonPhrase();
                        if (iCServerInfo.isVerbose()) {
                            String string5 = "Informtica Cloud login response Code(" + n + ") Message(" + string3 + ")";
                            logger.debug((Object)string5);
                        }
                        HttpEntity httpEntity = httpResponse.getEntity();
                        inputStream = httpEntity.getContent();
                        if (n != 200) break block19;
                        ICConnectionInfo iCConnectionInfo = this.parseConnectionEntry(inputStream);
                        if (iCConnectionInfo.getIcSessionId() == null || iCConnectionInfo.getIcSessionId().trim().length() == 0) {
                            throw new ICJobRunnerException("An 'icSessionId' was not returned by the login request.");
                        }
                        if (iCConnectionInfo.getServerUrl() == null || iCConnectionInfo.getServerUrl().trim().length() == 0) {
                            throw new ICJobRunnerException("A 'serverUrl' was not returned by the login request.");
                        }
                        object = iCConnectionInfo;
                        ICHelper.closeSomething(inputStream);
                        return object;
                    }
                    if (n != 403) throw new ICJobRunnerException("Informatica Cloud web service response code: " + n + " (" + string3 + ")");
                    iCError = ICHelper.parseError(inputStream);
                    object = "login";
                    if (iCError.getCode() == null || !iCError.getCode().trim().equalsIgnoreCase("APP_13408")) break block20;
                    long l3 = ICHelper.getAgentRandomWait();
                    String string6 = "Maximum number of REST API sessions are already in use.  Connect retry random wait time (milliseconds): " + l3;
                    logger.debug((Object)string6);
                    if (l + l2 < System.currentTimeMillis()) {
                        throw new ICConnectionsExhausted("Unable to connect to server " + iCServerInfo.getServerName() + ".");
                    }
                    try {
                        Thread.sleep(l3);
                        break block21;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    break block21;
                }
                try {
                    try {
                        if (iCError.getCode() != null && iCError.getCode().trim().equalsIgnoreCase("UI_10000")) {
                            String string7 = iCError.getSkybotErrorMsg((String)object);
                            logger.error((Object)string7);
                            throw new ICLoginFailedException(string7);
                        }
                        String string8 = iCError.getSkybotErrorMsg((String)object);
                        logger.error((Object)string8);
                        throw new RuntimeException(string8);
                    }
                    catch (ICLoginFailedException iCLoginFailedException) {
                        throw iCLoginFailedException;
                    }
                    catch (ICConnectionsExhausted iCConnectionsExhausted) {
                        throw iCConnectionsExhausted;
                    }
                    catch (Exception exception) {
                        throw new ICJobRunnerException("Error logging into the Informatica Cloud server.", exception);
                    }
                }
                catch (Throwable throwable) {
                    ICHelper.closeSomething(inputStream);
                    throw throwable;
                }
            }
            ICHelper.closeSomething(inputStream);
        } while (!bl);
        throw new IllegalStateException("Unable to connect with Informatica Cloud server.");
    }

    private ICConnectionInfo parseConnectionEntry(InputStream inputStream) {
        Gson gson = new Gson();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return (ICConnectionInfo)((Object)gson.fromJson((Reader)inputStreamReader, ICConnectionInfo.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void icServerLogout(HttpClient httpClient, ICServerInfo iCServerInfo, ICConnectionInfo iCConnectionInfo, boolean bl) {
        block19: {
            InputStream inputStream;
            block18: {
                block17: {
                    block16: {
                        inputStream = null;
                        logger.debug((Object)"Logging out Informatica Cloud Session...");
                        if (httpClient != null) break block16;
                        logger.debug((Object)"Unable to logout. An HTTP Client is not available.");
                        ICHelper.closeSomething(inputStream);
                        return;
                    }
                    if (iCConnectionInfo != null) break block17;
                    logger.debug((Object)"Unable to logout. The connection info is not available.");
                    ICHelper.closeSomething(inputStream);
                    return;
                }
                try {
                    Object object;
                    Object object2;
                    if (bl) {
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    String string = iCConnectionInfo.getServerUrl() + "/api/v2/user/logout";
                    if (iCServerInfo.isVerbose()) {
                        object2 = "Logging out: Session ID(" + iCConnectionInfo.getIcSessionId() + ")" + " Logout URL(" + string + ")";
                        logger.debug(object2);
                    }
                    object2 = new HttpPost(string);
                    object2.setHeader("Content-Type", "application/json");
                    object2.setHeader("Accept", "application/json");
                    object2.setHeader("icSessionId", iCConnectionInfo.getIcSessionId());
                    String string2 = "{\n}";
                    StringEntity stringEntity = new StringEntity(string2);
                    object2.setEntity((HttpEntity)stringEntity);
                    HttpResponse httpResponse = httpClient.execute((HttpUriRequest)object2);
                    int n = httpResponse.getStatusLine().getStatusCode();
                    String string3 = httpResponse.getStatusLine().getReasonPhrase();
                    if (iCServerInfo.isVerbose()) {
                        object = "Logout Response Code(" + n + ")" + "Response Message(" + string3 + ")";
                        logger.debug(object);
                    }
                    object = httpResponse.getEntity();
                    inputStream = object.getContent();
                    if (n == 200) {
                        if (iCServerInfo.isVerbose()) {
                            logger.debug((Object)"Logout with shared connection was successful.");
                        }
                        break block18;
                    }
                    throw new ICJobRunnerException("Informatica Cloud logout web service response code: " + n + " (" + string3 + ")");
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            logger.error((Object)"Informatica Cloud shared connection logout error.", throwable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        ICHelper.closeSomething(inputStream);
                    }
                }
            }
            ICHelper.closeSomething(inputStream);
        }
    }

    private static ICServerTime getICServerTime(HttpClient httpClient, ICConnectionInfo iCConnectionInfo, boolean bl) {
        String string;
        int n;
        InputStream inputStream;
        block9: {
            inputStream = null;
            String string2 = iCConnectionInfo.getServerUrl() + "/api/v2/server/serverTime";
            if (bl) {
                // empty if block
            }
            HttpGet httpGet = new HttpGet(string2);
            httpGet.setHeader("Content-Type", "application/json");
            httpGet.setHeader("Accept", "application/json");
            httpGet.setHeader("icSessionId", iCConnectionInfo.getIcSessionId());
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            n = httpResponse.getStatusLine().getStatusCode();
            string = httpResponse.getStatusLine().getReasonPhrase();
            if (bl) {
                // empty if block
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            inputStream = httpEntity.getContent();
            if (n != 200) break block9;
            ICServerTime iCServerTime = SkybotCommandDMImpl.parseServerTimeEntry(inputStream);
            if (bl) {
                // empty if block
            }
            ICServerTime iCServerTime2 = iCServerTime;
            ICHelper.closeSomething(inputStream);
            return iCServerTime2;
        }
        try {
            try {
                if (n == 403) {
                    ICError iCError = ICHelper.parseError(inputStream);
                    String string3 = "serverTime";
                    String string4 = iCError.getSkybotErrorMsg(string3);
                    logger.error((Object)string4);
                    throw new RuntimeException(string4);
                }
                throw new ICJobRunnerException("Informatica Cloud web service response code: " + n + " (" + string + ")");
            }
            catch (Exception exception) {
                throw new ICJobRunnerException("Error getting the server time from the Informatica Cloud server.", exception);
            }
        }
        catch (Throwable throwable) {
            ICHelper.closeSomething(inputStream);
            throw throwable;
        }
    }

    private static ICServerTime parseServerTimeEntry(InputStream inputStream) {
        Gson gson = new Gson();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return (ICServerTime)gson.fromJson((Reader)inputStreamReader, ICServerTime.class);
    }

    static {
        String string = "SKYBOT_IC_CONN_DURATION";
        String string2 = System.getenv(string);
        if (string2 != null) {
            try {
                long l = Long.parseLong(string2);
                if (l > 0L) {
                    MAX_CONNECTION_DURATION = l * 1000L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)("Connection duration value in environment variable '" + string + "' is not valid: " + string2));
            }
        }
    }

    class ICConnectionHolder {
        ICSharedConnectionInfo icSharedConnectionInfo = null;
        ICServerInfo icServerInfo = null;
        HashSet<String> borrowers = new HashSet();

        protected ICConnectionHolder() {
        }
    }
}

