/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.filetransfer;

import com.helpsystems.enterprise.module.exec.FTPWorker;
import com.helpsystems.enterprise.module.exec.Utils;
import com.helpsystems.enterprise.module.filetransfer.IPeerFileTransferClientFactory;
import com.helpsystems.enterprise.module.filetransfer.PeerFtpClient;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;

public class PeerFtpsClientFactory
implements IPeerFileTransferClientFactory<PeerFtpClient> {
    protected FTPWorker ftpWorker = new FTPWorker();
    protected boolean useImplicitFtps;

    public PeerFtpsClientFactory(boolean bl) {
        this.useImplicitFtps = bl;
    }

    @Override
    public PeerFtpClient connect(String string, Integer n, String string2, String string3) throws Exception {
        String string4 = Utils.concatToStrings("Connecting to system ", string, "port:", n, "user:", string2);
        System.out.println(string4);
        PeerFtpClient peerFtpClient = null;
        try {
            FTPSClient fTPSClient = this.ftpWorker.connectSecure(string, n, string2, string3, this.useImplicitFtps);
            if (fTPSClient == null) {
                throw new Exception("Username or password is/are incorrect");
            }
            String string5 = Utils.concatToStrings("Connected to FTPS server.");
            System.out.println(string5);
            peerFtpClient = new PeerFtpClient((FTPClient)fTPSClient);
        }
        catch (KeyManagementException keyManagementException) {
            String string6 = Utils.concatToStrings("Unable to connect to FTPS server. Exception: ", keyManagementException.getMessage());
            System.out.println(string6);
            throw keyManagementException;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            String string7 = Utils.concatToStrings("Unable to connect to FTPS server. Exception: ", unrecoverableKeyException.getMessage());
            System.out.println(string7);
            throw unrecoverableKeyException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string8 = Utils.concatToStrings("Unable to connect to FTPS server. Exception: ", noSuchAlgorithmException.getMessage());
            System.out.println(string8);
            throw noSuchAlgorithmException;
        }
        catch (KeyStoreException keyStoreException) {
            String string9 = Utils.concatToStrings("Unable to connect to FTPS server. Exception: ", keyStoreException.getMessage());
            System.out.println(string9);
            throw keyStoreException;
        }
        catch (CertificateException certificateException) {
            String string10 = Utils.concatToStrings("Unable to connect to FTPS server. Exception: ", certificateException.getMessage());
            System.out.println(string10);
            throw certificateException;
        }
        catch (RuntimeException runtimeException) {
            String string11 = Utils.concatToStrings("Unable to connect to FTPS server. Exception: ", runtimeException.getMessage());
            System.out.println(string11);
            throw runtimeException;
        }
        return peerFtpClient;
    }

    @Override
    public void close(PeerFtpClient peerFtpClient, String string) {
        try {
            String string2 = Utils.concatToStrings("Closing FTPS connection...");
            System.out.println(string2);
            FTPClient fTPClient = peerFtpClient.getFTPClient();
            this.ftpWorker.closeFTPS((FTPSClient)fTPClient, string);
            String string3 = Utils.concatToStrings("FTPS connection closed");
            System.out.println(string3);
        }
        catch (RuntimeException runtimeException) {
            String string4 = Utils.concatToStrings("Unable to close connectionto FTPS server. Exception:", runtimeException.getMessage());
            System.out.println(string4);
            throw runtimeException;
        }
    }
}

