/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.util.DurableQueue;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import com.helpsystems.enterprise.core.util.OutputDistributionSetup;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class StandbyBackupFileQueueAMImpl
extends AbstractManager
implements StandbyBackupFileQueueAM {
    private static final Logger logger = Logger.getLogger(StandbyBackupFileQueueAMImpl.class);
    private static final Object dqLock = new Object();
    private String dqName;
    private DurableQueue dq = null;

    public StandbyBackupFileQueueAMImpl() {
        this.setName("ENTERPRISE.StandbyBackupFileQueueAM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putStandbyBackupFile(StandbyBackupFile standbyBackupFile) throws ActionFailedException {
        if (standbyBackupFile == null) {
            logger.debug((Object)"ReportRunner is attempting to push a null Report");
            return;
        }
        if (this.isConfiguredForHA()) {
            Object object = dqLock;
            synchronized (object) {
                try {
                    this.getDQ().push((Serializable)standbyBackupFile);
                }
                catch (IOException iOException) {
                    String string = "Unable to submit standby backup file " + standbyBackupFile.getServerFileName() + ".";
                    logger.error((Object)string, (Throwable)iOException);
                    throw new ActionFailedException(string, (Throwable)iOException);
                }
            }
        }
    }

    private boolean isConfiguredForHA() {
        if (this.isQueueFileExists()) {
            return true;
        }
        SystemSetupDM systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
        try {
            SystemSetup systemSetup = systemSetupDM.get();
            if (systemSetup.getStandbyServer() != null && systemSetup.getStandbyServer().trim().length() > 0) {
                this.createQueueFile();
                return true;
            }
        }
        catch (IOException iOException) {
            logger.error((Object)"Error creating durable queue file.", (Throwable)iOException);
            return false;
        }
        catch (Exception exception) {
            logger.error((Object)"Error obtaining the System Setup.", (Throwable)exception);
            return false;
        }
        return false;
    }

    private void putAllUserFiles() {
        logger.info((Object)"Loading all user files.");
        this.putAllJobLogsInQueue();
        this.putAllReportsInQueue();
        this.putAllAgentDistributionsInQueue();
        logger.info((Object)"Finished loading all user files.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dataQueueHasData() {
        if (this.isQueueFileExists()) {
            Object object = dqLock;
            synchronized (object) {
                try {
                    return !this.getDQ().isEmpty();
                }
                catch (IOException iOException) {
                    logger.error((Object)"Unable to check if StandbyBackupFileQueue has files.", (Throwable)iOException);
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StandbyBackupFile getStandbyBackupFile() throws IOException {
        if (this.isQueueFileExists()) {
            Object object = dqLock;
            synchronized (object) {
                StandbyBackupFile standbyBackupFile = (StandbyBackupFile)this.getDQ().pop();
                return standbyBackupFile;
            }
        }
        return null;
    }

    private boolean createQueueFile() throws IOException {
        boolean bl = false;
        logger.info((Object)("*** About to create new file: " + this.getDataQueueFileName() + " ..."));
        File file = new File(this.getDataQueueFileName());
        logger.info((Object)("*** File " + this.getDataQueueFileName() + " exists = " + file.exists()));
        bl = !file.exists();
        file.createNewFile();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread clearAndReloadQueue() {
        Thread thread = null;
        Object object = dqLock;
        synchronized (object) {
            try {
                if (!this.isQueueFileExists()) {
                    this.createQueueFile();
                } else {
                    this.getDQ().clear();
                }
                thread = this.getTheTheadToPutAllUserFiles("clearAndReloadQueue");
                thread.start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return thread;
    }

    private Thread getTheTheadToPutAllUserFiles(String string) {
        Thread thread = new Thread(string + " - Put all user files in queue"){

            @Override
            public void run() {
                StandbyBackupFileQueueAMImpl.this.putAllUserFiles();
            }
        };
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.isQueueFileExists()) {
            try {
                Object object = dqLock;
                synchronized (object) {
                    return this.getDQ().size();
                }
            }
            catch (IOException iOException) {
                logger.debug((Object)"Failed to read standby file data queue", (Throwable)iOException);
            }
        }
        return 0;
    }

    private DurableQueue getDQ() throws IOException {
        if (this.dq == null) {
            this.dq = new DurableQueue(this.getDataQueueFileName());
        }
        return this.dq;
    }

    private boolean isQueueFileExists() {
        String string = this.getDataQueueFileName();
        File file = new File(string);
        return file.exists();
    }

    private String getDataQueueFileName() {
        if (this.dqName == null) {
            File file = new File(OutputDistributionSetup.getStandbyBackupFileQueueName());
            try {
                this.dqName = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.debug((Object)"Unable to get the actual path to the user file copy data queue.", (Throwable)iOException);
            }
        }
        return this.dqName;
    }

    private void putAllJobLogsInQueue() {
        logger.info((Object)"Loading all Joblog files.");
        String string = DefaultConfigPath.getJobLogDirectory();
        this.putFileInQueue(string, null, 0);
    }

    private void putAllReportsInQueue() {
        logger.info((Object)"Loading all Report files.");
        String string = OutputDistributionSetup.OUTPUT_DIR_NAME + File.separator + "userfiles";
        this.putFileInQueue(string, null, 1);
    }

    private void putAllAgentDistributionsInQueue() {
        logger.info((Object)"Loading all Agent Distribution files.");
        String string = OutputDistributionSetup.OUTPUT_DIR_NAME + File.separator + "attachments";
        this.putFileInQueue(string, null, 2);
    }

    private void putFileInQueue(String string, String string2, int n) {
        block4: {
            File file;
            block3: {
                file = null;
                String string3 = null;
                string3 = string2 == null ? string : string + File.separator + string2;
                file = new File(string3);
                File[] fileArray = file.listFiles();
                if (fileArray == null) break block3;
                for (File file2 : fileArray) {
                    String string4 = file2.getName();
                    this.putFileInQueue(string3, string4, n);
                }
                break block4;
            }
            if (string2 == null) break block4;
            StandbyBackupFile standbyBackupFile = new StandbyBackupFile();
            standbyBackupFile.setActionType(0);
            standbyBackupFile.setFileType(n);
            standbyBackupFile.setFullFileName(file.getAbsolutePath());
            standbyBackupFile.setServerDirName(string);
            standbyBackupFile.setServerFileName(string + File.separator + string2);
            try {
                this.putStandbyBackupFile(standbyBackupFile);
            }
            catch (ActionFailedException actionFailedException) {
                logger.error((Object)("Error putting file in queue: " + standbyBackupFile.getFullFileName()), (Throwable)actionFailedException);
            }
        }
    }
}

