/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.oracle.OracleCommandException;
import com.helpsystems.enterprise.core.busobj.sap.SAPCommandResults;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutable;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.dm.JobMarkRunningAM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.core.dm.sap.SAPCommandHelperAM;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.logger.ScheduleLogDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.core.uc.UniversalConnectorCommand;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import com.helpsystems.enterprise.module.exec.ConditionCheckLocker;
import com.helpsystems.enterprise.module.exec.JobConditionController;
import com.helpsystems.enterprise.module.exec.JobProcess;
import com.helpsystems.enterprise.module.exec.LogFileWrapper;
import com.helpsystems.enterprise.module.exec.PipeCleaner;
import com.helpsystems.enterprise.module.exec.Platform;
import com.helpsystems.enterprise.module.exec.ProcessCommand;
import com.helpsystems.enterprise.module.exec.ProcessUtil;
import com.helpsystems.enterprise.module.exec.WindowsPlatform;
import com.helpsystems.enterprise.module.oracle.OracleProcessUtility;
import com.helpsystems.enterprise.module.uc.UCExecutor;
import com.helpsystems.enterprise.module.unix.UnixActiveProcessAM;
import com.helpsystems.enterprise.module.windows.Kernel32Ext;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

class ProcessMonitor
implements Runnable {
    private static final int INITIALIZING = 0;
    private static final int WAITING_FOR_COMMAND_COMPLETION = 2;
    private static final int WAITING_FOR_PROCESS_OUTPUT = 3;
    private static final int FILEPEER_STARTING = 21;
    private static final int FILEPEER_CONNECTED = 22;
    private static final int WAITING_FOR_FILEPEER_COMPLETION = 23;
    private static final int EXITING = 113;
    private static final int WAITING_FOR_PROCESS_END = 114;
    private static final int ALL_DONE = 115;
    private static final boolean SKIP_PROCESS_WAIT = "y".equalsIgnoreCase(System.getProperty("HS_SKIP_PROCESS_WAIT"));
    private static final Logger logger = Logger.getLogger(ProcessMonitor.class);
    private static final int NO_COMPLETION = Integer.MIN_VALUE;
    private static final int UNPARSABLE_COMPLETION = -2147483647;
    private static final int COMMAND_NOT_FOUND = 127;
    private static final int COMMAND_IS_NOT_EXECUTABLE = 126;
    private static final String COMMAND_DELAY_PROPERTY = "helpsystems.command.delay";
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int JOB_INIT_TIMEOUT = 240000;
    private static final int FILEPEER_TIMEOUT = 300000;
    private boolean cancelOnError = true;
    private boolean isEndCommandActualRetries = false;
    static final String COMMAND_COMPLETION_MARKER = "COMPLETED_CMDID_";
    private static DateFormat CMDID_FORMATTER = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");
    private Date cmdidDate = new Date();
    static final String PROCESS_ID_MARKER = "Process ID=";
    static final String FILEREAD_PREFIX = "_@_PREFIX_@_";
    static final boolean divideLongCommands;
    private static final int INVALID_PATH_CODE = 8;
    private HashMap<Long, String> deletedFileArray = new HashMap();
    static final int MAX_COMMAND_LENGTH = 250;
    private boolean checkingConditions;
    private int sleep_delay = 100;
    private JobProcess jp;
    private ProcessCommand[] commandArray;
    private Process process;
    private PrintWriter stdIn;
    private InputStreamReader isr;
    private long agentOutputPosition;
    private String exitCodeMarker;
    private int state;
    private ExecutableJob ej;
    private LogFileWrapper logWrapper;
    private BufferedReader reader;
    private String lastImportantLine;
    private String importantCriteria;
    private boolean finishedJobInitialization;
    private ProcessCommand currentCommand;
    private int commandArrayCounter;
    private CharBuffer cbuf;
    private boolean needToBreakAndExit;
    private AtomicBoolean isTerminateCommand = new AtomicBoolean();
    private Object waitLock = new Object();
    private int exitCount;
    private long logCharsRead;
    private int followupDelay;
    private long logCharsThreshold;
    private long whenFilePeerStarted;
    private int conditionJobSequenceNumber = 0;
    private boolean conditionListCheckIsSucceed = false;
    private boolean previousConditionChecked = true;
    private JobMarkRunningAM jobMarkRunningAM = null;
    private JobHistory jobHistory = null;
    private JobConditionController jobConditionController;
    private JobCondition currentNotMetCondition;
    private SAPCommandHelperAM sapCommandHelperAM;
    private boolean runningSAPCommand;
    private SAPCommandResults sapCommandResults;
    private int universalConnectorCommandExitCode;
    private boolean runningOracleCommand;
    private StringBuffer commandOutput = null;
    private int currentCommandActualRetries = 0;
    private OracleProcessUtility oracleProcessUtility;
    private boolean isJobInRetryWait = false;
    private Thread commandRetryThread = null;

    ProcessMonitor(JobProcess jobProcess, ProcessCommand[] processCommandArray) throws IOException, ResourceUnavailableException, ActionFailedException {
        this.jp = jobProcess;
        this.commandArray = processCommandArray;
        this.ej = jobProcess.getExecutableJob();
        this.logWrapper = jobProcess.getLogFileWrapper();
        this.process = jobProcess.getProcess();
        String string = System.getProperty("file.encoding");
        if (jobProcess.getPlatform() instanceof WindowsPlatform) {
            string = "UTF-16BE";
        }
        this.stdIn = new PrintWriter(new OutputStreamWriter(this.process.getOutputStream(), string));
        this.isr = new InputStreamReader(this.process.getInputStream());
        this.reader = new BufferedReader(this.isr);
        this.cbuf = CharBuffer.allocate(64000);
        this.jobConditionController = new JobConditionController(this.ej.getServerPeerID());
        String string2 = System.getProperty(COMMAND_DELAY_PROPERTY);
        if (string2 != null) {
            try {
                this.followupDelay = Integer.parseInt(string2.trim());
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to parse system property 'helpsystems.command.delay': " + string2));
            }
        }
        this.jobHistory = this.ej.getJobHistory();
    }

    void setFollowupDelay(int n) {
        this.followupDelay = n;
    }

    public long getAgentOutputPosition() {
        return this.agentOutputPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(String string) {
        Object object;
        if (this.logWrapper != null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("The process has been asked to terminate");
            if (string != null) {
                ((StringBuffer)object).append(" " + string);
            }
            ((StringBuffer)object).append(".");
            this.logWrapper.write(((StringBuffer)object).toString());
        }
        this.needToBreakAndExit = true;
        object = this.waitLock;
        synchronized (object) {
            this.isTerminateCommand.set(true);
            this.waitLock.notifyAll();
        }
        if (this.runningSAPCommand) {
            this.sapCommandHelperAM.terminateCommand(this.jobHistory.getId());
        }
        this.jobConditionController.wakeUpRetryWaitJobs();
        if (this.isJobInRetryWait && this.commandRetryThread != null) {
            this.commandRetryThread.interrupt();
        }
    }

    void finish() {
        this.state = 23;
    }

    private void updateThreadName() {
        ScheduleJob scheduleJob = this.ej.getScheduleJob();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Running job ");
        stringBuffer.append(scheduleJob.getSkybotJobNumber());
        stringBuffer.append(" eventID ");
        stringBuffer.append(this.ej.getEventID());
        stringBuffer.append("  State ");
        stringBuffer.append(this.state);
        if (this.state == 3) {
            stringBuffer.append(" (");
            stringBuffer.append(this.logCharsThreshold);
            stringBuffer.append(")");
        }
        Thread.currentThread().setName(stringBuffer.toString());
    }

    public boolean isAlive() {
        int n = -9999;
        if (this.process == null) {
            return false;
        }
        try {
            n = this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        logger.debug((Object)("returning false - theExitValue = " + n));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string;
        Object object;
        String string2;
        this.state = 0;
        this.updateThreadName();
        try {
            if (logger.isDebugEnabled()) {
                string2 = this.ej.getScheduleJob().getSkybotJobName();
                object = this.ej.getEventID();
                string = "ProcessMonitor is starting job named " + string2 + " with event id " + (String)object + ".";
                logger.debug((Object)string);
            }
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Error logging ProcessMonitor started.", throwable);
        }
        try {
            while (this.isAlive() && this.state != 115) {
                this.readOutput();
                if (this.jobInitTimeout()) {
                    this.jp.setCompletionCode('F');
                    this.jp.setTerminationReason("Job initialization stalled.");
                    this.jp.setFailedAtCommandSequence(1);
                    break;
                }
                this.doSomething();
                this.updateThreadName();
                try {
                    Thread.sleep(this.sleep_delay);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.readOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.jp.getCompletionCode() == ' ') {
                if (this.state == 115 || this.state == 113 || this.state == 114) {
                    this.jp.setCompletionCode('C');
                    this.state = 115;
                } else {
                    this.jp.setCompletionCode('F');
                    this.jp.setTerminationReason("The process ended unexpectedly.");
                    if (this.jobHistory.getStatusCode().equals(JobStatusCode.RUNNING)) {
                        this.jp.setJobEndedReasonCode(JobEndedReasonCode.COMMAND_FAILURE);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (this.state <= 113) {
                if (throwable.getCause() instanceof InvalidClassException) {
                    object = (InvalidClassException)throwable.getCause();
                    string = ((InvalidClassException)object).classname;
                    logger.debug((Object)("Problem class is " + string));
                    try {
                        Class<?> clazz = Class.forName(string);
                        String string3 = "Unable to return results from executing SAP command " + this.currentCommand.getCommand().getCommandString();
                        logger.debug((Object)string3, throwable);
                        this.jp.setCompletionCode('F');
                        this.jp.setJobEndedReasonCode(JobEndedReasonCode.AGENT_UPDATE_REQUIRED);
                        this.jp.setTerminationReason(string3);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    object = "Unable to monitor process for job " + this.ej.getScheduleJob().getName() + "\n" + Convert.dumpStackToString((Throwable)throwable);
                    logger.debug(object, throwable);
                    this.jp.setCompletionCode('F');
                    this.jp.setTerminationReason((String)object);
                }
            } else {
                this.state = 115;
            }
        }
        finally {
            try {
                this.readOutput();
            }
            catch (Exception exception) {}
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                logger.debug((Object)("Unable to get exit value from process " + this.ej.getScheduleJob().getName()), (Throwable)illegalThreadStateException);
                try {
                    this.process.destroy();
                    this.process.exitValue();
                }
                catch (Exception exception) {}
            }
            try {
                this.readOutput();
            }
            catch (Exception exception) {}
            this.logWrapper.write("Job ended at " + DateTranslator.formatDateTimeWithTZ((Date)new Date()));
            this.logWrapper.close();
            this.jp.processFinished();
            PipeCleaner.addPipes(this.process);
            this.closeAllIO();
        }
        try {
            if (logger.isDebugEnabled()) {
                string2 = this.ej.getScheduleJob().getSkybotJobName();
                object = this.ej.getEventID();
                string = "ProcessMonitor has finished job named " + string2 + " with event id " + (String)object + ".";
                logger.debug((Object)string);
            }
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Error logging ProcessMonitor ended.", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllIO() {
        try {
            this.cbuf.clear();
            this.cbuf = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.isr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stdIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BufferedReader bufferedReader = this.reader;
            synchronized (bufferedReader) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isWindows() {
        return this.jp.getPlatform() instanceof WindowsPlatform;
    }

    private boolean jobInitTimeout() {
        if (this.finishedJobInitialization) {
            return false;
        }
        long l = System.currentTimeMillis() - this.jp.getWhenStarted();
        return l >= 240000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readOutput() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = this.reader;
        synchronized (bufferedReader) {
            while (this.reader.ready()) {
                int n;
                AgentReturnCode agentReturnCode;
                String[] stringArray;
                int n2 = 0;
                int n3 = this.cbuf.position();
                try {
                    n2 = this.reader.read(this.cbuf);
                }
                catch (CharConversionException charConversionException) {
                    if (this.jp.getCompletionCode() == ' ') {
                        this.jp.setCompletionCode('F');
                        String string = Charset.defaultCharset().name();
                        stringArray = "The job terminated because the output from the process contained bytes that are incompatible with the character encoding " + string + ". " + UnixActiveProcessAM.getCharConversionExceptionMessage();
                        this.jp.setTerminationReason((String)stringArray);
                    }
                    this.terminate("by Automate Schedule Server");
                    return;
                }
                if (n2 == 0) break;
                this.logCharsRead += (long)n2;
                String string = this.cbuf.flip().toString();
                if (this.currentCommand != null && this.currentCommand.getCommand() != null && (agentReturnCode = this.currentCommand.getCommand().getReturnCode()) != null && !agentReturnCode.isTextMatchEmpty()) {
                    if (this.commandOutput == null) {
                        this.commandOutput = new StringBuffer();
                    }
                    this.commandOutput.append(string);
                }
                boolean bl = !string.endsWith(LINE_SEPARATOR);
                stringArray = string.split(LINE_SEPARATOR);
                int n4 = stringArray.length;
                this.cbuf.clear();
                if (bl) {
                    --n4;
                    String string2 = stringArray[stringArray.length - 1];
                    n = Math.max(0, string2.length() - 200);
                    this.cbuf.put(string2.substring(n, string2.length()));
                }
                boolean bl2 = false;
                for (n = 0; n < n4; ++n) {
                    String string3 = stringArray[n];
                    if (this.runningOracleCommand) {
                        try {
                            this.oracleProcessUtility.processStringForOracleOutputChecks(string3, this.ej);
                            String string4 = this.oracleProcessUtility.getRegexString();
                            if (string3.contains(string4)) {
                                String string5;
                                string3 = string5 = this.oracleProcessUtility.getStringWithOraclePasswordHidden(this.currentCommand.getCommand().getCommandString());
                                n3 = 0;
                                if (!this.isWindows()) {
                                    bl2 = true;
                                }
                            }
                        }
                        catch (OracleCommandException oracleCommandException) {
                            logger.error((Object)"Error in Oracle command.  Check job log for more information.", (Throwable)oracleCommandException);
                            if (this.currentCommand.getCommand().isCancelOnError()) {
                                this.jp.setCompletionCode('F');
                                this.jp.setFailedAtCommandSequence(this.currentCommand.getCommandNumber());
                                this.jp.setTerminationReason(string3);
                                this.jp.setJobEndedReasonCode(JobEndedReasonCode.COMMAND_FAILURE);
                            } else {
                                logger.warn((Object)"Oracle Concurrent Request Command Fail Action is set to continue.");
                            }
                        }
                        catch (ResourceUnavailableException resourceUnavailableException) {
                            logger.error((Object)"Error processing Oracle command.", (Throwable)resourceUnavailableException);
                        }
                    }
                    this.checkIfImportant(string3);
                    if (n3 > 0 && n == 0) {
                        string3 = string3.length() >= n3 ? string3.substring(n3) : "";
                    }
                    arrayList.add(string3);
                    if (!bl2) continue;
                    arrayList.add("\r\n");
                    bl2 = false;
                }
                this.logList(arrayList);
                if (!bl) continue;
                String string6 = stringArray[stringArray.length - 1];
                if (n4 == 0 && n3 > 0) {
                    if (string6.length() == n3) {
                        string6 = "";
                    } else if (string6.length() > n3) {
                        string6 = string6.substring(n3);
                    }
                }
                if (this.isWindows() && (string6.endsWith("\n") || string6.endsWith("\r"))) {
                    string6 = string6.length() == 1 ? "" : string6.substring(0, string6.length() - 1);
                }
                this.logWrapper.writeNoEOL(string6);
            }
        }
    }

    private void logList(ArrayList<String> arrayList) {
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.logWrapper.write(stringArray);
        arrayList.clear();
    }

    private void checkIfImportant(String string) {
        if (this.importantCriteria == null || this.importantCriteria.length() == 0) {
            return;
        }
        if (string.indexOf(this.importantCriteria) > -1) {
            if (string.length() > 0) {
                int n = string.length();
                int n2 = string.charAt(n - 1);
                while (n2 == 13 || n2 == 10) {
                    if (--n == 0) {
                        n2 = 32;
                        continue;
                    }
                    n2 = string.charAt(n - 1);
                }
                this.lastImportantLine = string.substring(0, n);
            } else {
                this.lastImportantLine = string;
            }
        }
    }

    private void doSomething() {
        if (this.needToBreakAndExit) {
            this.performExitOperations();
        }
        if (this.jp.getCompletionCode() != ' ' && this.state < 21 && this.whenFilePeerStarted == 0L) {
            this.state = 113;
        }
        if (this.state == 0) {
            this.sendNextCommand();
            return;
        }
        if (this.state == 113) {
            if (JobStatusCode.PRE_RUNNING_STATES.contains(this.jobHistory.getStatusCode()) && !this.jp.wasTerminatedByServer()) {
                this.updateToRunning();
            }
            this.conditionCheckCompleted();
            ++this.exitCount;
            if (this.exitCount > 5) {
                this.state = 114;
                return;
            }
            this.deleteAllWebServiceFiles();
            Platform platform = this.jp.getPlatform();
            this.logStandardIn(platform.getExitCommand());
            this.stdIn.println(platform.getExitCommand());
            this.stdIn.flush();
            return;
        }
        if (this.state == 114) {
            this.process.destroy();
            if (!SKIP_PROCESS_WAIT) {
                while (true) {
                    try {
                        this.readOutput();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.process.exitValue();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            this.state = 115;
            return;
        }
        if (this.currentCommand == ProcessCommand.MARKER_INSTANCE) {
            this.finishedJobInitialization = true;
            this.sendNextCommand();
            return;
        }
        int n = this.currentCommand.getCommandNumber();
        if (this.state == 21) {
            if (this.jp.getFilePeerID() != null) {
                this.state = 22;
            } else {
                long l = System.currentTimeMillis() - this.whenFilePeerStarted;
                if (l >= 300000L) {
                    this.needToBreakAndExit = true;
                }
            }
        }
        if (this.state == 2 || this.state == 23) {
            Object object;
            Object object2;
            int n2 = this.parseLastCompletion();
            if (this.currentCommand.getCommand().isSAPCommand()) {
                n2 = this.sapCommandResults.getExitCode().getReturnCode();
            }
            if (this.currentCommand.getCommand().getCommandType() == 15) {
                n2 = this.universalConnectorCommandExitCode;
            }
            if (n2 == Integer.MIN_VALUE) {
                return;
            }
            if (n2 == -2147483647) {
                if (this.currentCommand.getCommand().getCommandAction() != 1) {
                    this.cancelOnError = false;
                }
                if (this.cancelOnError) {
                    this.jp.setCompletionCode('F');
                    this.jp.setTerminationReason("Unable to parse command completion exit value.");
                    this.state = 113;
                } else {
                    if (this.currentCommandActualRetries < this.currentCommand.getCommand().getRetriesCount()) {
                        this.retryCommandSend(this.currentCommand.getCommand().getRetriesCount(), this.currentCommand.getCommand().getWaitCount());
                        if (this.currentCommand.getCommand().getCommandAction() == 3) {
                            this.isEndCommandActualRetries = true;
                        }
                    } else {
                        if (this.currentCommand.getCommand().getCommandType() == 10) {
                            this.deleteWebServiceFiles(this.currentCommand.getCommand().getOid());
                        }
                        this.sendNextCommand();
                    }
                    return;
                }
            }
            if (n2 == 8 && this.currentCommand.getCommandNumber() == -3) {
                JobCondition jobCondition = this.ej.getJobConditions()[this.conditionJobSequenceNumber - 1];
                String string = jobCondition.getConditionData();
                this.invalidPathHandler(string);
                this.state = 113;
                return;
            }
            if (n == -3 && (n2 == 127 || n2 == 126)) {
                this.setProcessErrorStatus(n2);
                this.state = 113;
                return;
            }
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            AgentReturnCode agentReturnCode = this.currentCommand.getCommand().getReturnCode();
            if (agentReturnCode != null) {
                object2 = null;
                if (this.commandOutput != null && !agentReturnCode.isTextMatchEmpty()) {
                    object2 = this.commandOutput.toString();
                    object2 = this.getCommandPureOutput((String)object2);
                    object = System.getenv("SKYBOT_LOG_TEXT_RTNCODE");
                    if (object != null && "true".equalsIgnoreCase(((String)object).trim()) && logger.isDebugEnabled()) {
                        String string = System.getProperty("line.separator");
                        logger.debug((Object)("================= Start Of Pure Command Output ==================" + string + object2 + string + "================= End Of Pure Command Output =================="));
                    }
                }
                boolean bl2 = bl = agentReturnCode.getRetunCodeAndTextMatch(n2, (String)object2, stringBuffer) == 1;
            }
            if (this.commandOutput != null && this.commandOutput.length() != 0) {
                this.commandOutput.delete(0, this.commandOutput.length());
            }
            if (this.currentCommand.getCommand().getCommandAction() != 1) {
                this.cancelOnError = false;
            }
            if (!bl && (this.cancelOnError || this.isEndCommandActualRetries) || !bl && n == -3) {
                int n3;
                object2 = this.currentCommand.getCommand().getCommandString();
                if (object2.length() == 0 && (n3 = this.commandArrayCounter - 1) > -1) {
                    object2 = this.commandArray[n3].getCommand().getCommandString();
                }
                object = null;
                if (n == -1) {
                    object = "Job terminated due to failure of job setup command: " + object2;
                } else if (n == -2) {
                    object = "Job terminated due to failure of Agent Output command: " + object2;
                } else {
                    if (this.currentCommand.getCommand().isOracleCommand()) {
                        try {
                            object2 = this.oracleProcessUtility.getStringWithOraclePasswordHidden((String)object2);
                        }
                        catch (ResourceUnavailableException resourceUnavailableException) {
                            logger.error((Object)"Error setting terminationReason for Oracle command.", (Throwable)resourceUnavailableException);
                        }
                    }
                    object = "Job terminated due to failure of command " + n + ": " + object2 + stringBuffer.toString();
                }
                if (this.currentCommand.getCommand().getCommandType() == 10) {
                    this.deleteWebServiceFiles(this.currentCommand.getCommand().getOid());
                }
                if (n == -3) {
                    this.currentNotMetCondition = this.ej.getJobConditions()[this.conditionJobSequenceNumber - 1];
                    this.conditionFailed();
                } else {
                    this.jp.setCompletionCode('F');
                    this.jp.setFailedAtCommandSequence(n);
                    this.jp.setTerminationReason((String)object);
                    this.jp.setJobEndedReasonCode(JobEndedReasonCode.COMMAND_FAILURE);
                    this.state = 113;
                }
            } else {
                if (n == -3) {
                    if (this.conditionJobSequenceNumber == this.ej.getJobConditions().length) {
                        this.conditionListCheckIsSucceed = true;
                    } else {
                        object2 = this.ej.getJobConditions()[this.conditionJobSequenceNumber];
                        if ("OR".equals(((JobCondition)((Object)object2)).getConjunction())) {
                            this.conditionListCheckIsSucceed = true;
                        }
                        if ("OR".equals(((JobCondition)((Object)(object = this.ej.getJobConditions()[this.conditionJobSequenceNumber - 1]))).getConjunction())) {
                            this.previousConditionChecked = true;
                        }
                    }
                }
                int n4 = this.currentCommand.getCommand().getRetriesCount();
                if (!bl && this.currentCommandActualRetries < n4 && this.currentCommand.getCommand().getCommandAction() != 2) {
                    this.retryCommandSend(n4, this.currentCommand.getCommand().getWaitCount());
                    if (this.currentCommand.getCommand().getCommandAction() == 3 && this.currentCommandActualRetries == n4) {
                        this.isEndCommandActualRetries = true;
                    }
                } else {
                    if (this.currentCommand != null && this.currentCommand.getCommand() != null && this.currentCommand.getCommand().getCommandAction() == 3) {
                        this.isEndCommandActualRetries = true;
                    }
                    if (this.currentCommand.getCommand().getCommandType() == 10) {
                        this.deleteWebServiceFiles(this.currentCommand.getCommand().getOid());
                    }
                    this.sendNextCommand();
                    this.currentCommandActualRetries = 0;
                }
            }
        } else if (this.state == 3 && this.logCharsRead > this.logCharsThreshold) {
            this.sendNextCommand();
        }
    }

    private boolean commandRunsOutsideOfTheProcess(CommandSetCommand commandSetCommand) {
        return commandSetCommand.isSAPCommand() || commandSetCommand.getCommandType() == 15;
    }

    private void conditionCheckStarting() {
        if (!this.checkingConditions) {
            this.checkingConditions = true;
            ConditionCheckLocker.startConditionCheckForJob(ProcessUtil.resolveUser(this.ej), Long.parseLong(this.ej.getEventID()));
            logger.debug((Object)("Run ID " + this.ej.getEventID() + " will now check conditions."));
        }
    }

    private void conditionCheckCompleted() {
        if (this.checkingConditions) {
            this.checkingConditions = false;
            logger.debug((Object)("Completed condition checks for run ID " + this.ej.getEventID()));
            ConditionCheckLocker.endConditionCheckForJob(ProcessUtil.resolveUser(this.ej), Long.parseLong(this.ej.getEventID()));
        }
    }

    private void setProcessErrorStatus(int n) {
        if (n == 127) {
            this.jp.setJobEndedReasonCode(JobEndedReasonCode.COMMAND_NOT_FOUND);
            this.jp.setTerminationReason("Command not found.");
        } else {
            this.jp.setJobEndedReasonCode(JobEndedReasonCode.COMMAND_NOT_EXECUTABLE);
            this.jp.setTerminationReason("Command is not an executable.");
        }
        this.jp.setCompletionCode('E');
        this.jp.setFailedAtCommandSequence(this.currentCommand.getCommandNumber());
    }

    private void conditionFailed() {
        this.conditionCheckCompleted();
        if (this.conditionJobSequenceNumber == this.ej.getJobConditions().length) {
            JobCondition jobCondition = this.currentNotMetCondition;
            boolean bl = true;
            try {
                bl = this.jobConditionController.controlNotMetJobCondition(jobCondition, this.ej, this.jobHistory, this.jp);
                if (this.needToBreakAndExit) {
                    this.state = 113;
                    return;
                }
                JobHistory jobHistory = null;
                try {
                    jobHistory = this.getJobMarkRunningAM().getJobHistory(this.jobHistory.getId());
                }
                catch (Exception exception) {
                    logger.warn((Object)("Error getting JobHistory " + this.ej.getEventID()), (Throwable)exception);
                }
                if (jobHistory != null && jobHistory.getJobEndedReasonCode() != null && (jobHistory.getJobEndedReasonCode().equals(JobEndedReasonCode.ENDED_MANUALLY) || jobHistory.getJobEndedReasonCode().equals(JobEndedReasonCode.JOB_MONITOR_ACTION))) {
                    this.state = 113;
                    return;
                }
            }
            catch (SubmitFailedException submitFailedException) {
                logger.error((Object)submitFailedException);
            }
            catch (ActionFailedException actionFailedException) {
                logger.error((Object)actionFailedException);
            }
            if (this.ej.isCondRetry() && bl) {
                int n = this.commandArray.length;
                for (int i = 0; i < n; ++i) {
                    ProcessCommand processCommand = this.commandArray[i];
                    if (processCommand.getCommandNumber() != -3) continue;
                    this.conditionJobSequenceNumber = 0;
                    this.currentNotMetCondition = null;
                    this.previousConditionChecked = true;
                    this.currentCommand = processCommand;
                    this.commandArrayCounter = i;
                    this.sendNextCommand();
                    break;
                }
            }
            if (!(this.ej.getConditionFailStatus() != JobConditionController.RUN_ANYWAY || this.ej.isCondRetry() && bl)) {
                this.conditionListCheckIsSucceed = true;
                this.sendNextCommand();
            } else if (!bl) {
                this.state = 113;
            }
        } else {
            this.previousConditionChecked = false;
            this.sendNextCommand();
        }
    }

    public void bypassConditions() {
        this.ej.setIgnoreConditions(true);
        this.ej.setConditionFailStatus(JobConditionController.RUN_ANYWAY);
        this.conditionListCheckIsSucceed = true;
        this.jobConditionController.wakeUpRetryWaitJobs();
    }

    private void performExitOperations() {
        this.notifyCancelables();
        JobStatusCode jobStatusCode = this.jobHistory.getStatusCode();
        if (!jobStatusCode.equals(JobStatusCode.CONDITION_RETRY_WAIT) && !this.isJobInRetryWait || !this.isWindows()) {
            this.stdIn.println('\u0003');
            this.stdIn.flush();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stdIn.println('\u0003');
            this.stdIn.flush();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.state = 113;
        this.needToBreakAndExit = false;
    }

    private void notifyCancelables() {
        ArrayList<WinNT.HANDLE> arrayList = new ArrayList<WinNT.HANDLE>();
        for (ProcessCommand processCommand : this.commandArray) {
            CommandSetCommand commandSetCommand = processCommand.getCommand();
            if (commandSetCommand == null || commandSetCommand.getCancelableCommand() == null) continue;
            String string = commandSetCommand.getCancelableCommand().getUniqueCommandIndentifier();
            arrayList.add(Kernel32Ext.INSTANCE.CreateMutexW(null, false, string));
        }
        int n = arrayList.size() * 500;
        if (n < 1000) {
            n = 1000;
        }
        if (n > 4000) {
            n = 4000;
        }
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.getMessage();
        }
        for (WinNT.HANDLE hANDLE : arrayList) {
            Kernel32.INSTANCE.CloseHandle(hANDLE);
        }
    }

    private void retryCommandSend(int n, int n2) {
        block7: {
            if (this.currentCommandActualRetries < n) {
                this.isJobInRetryWait = true;
                this.commandRetryThread = Thread.currentThread();
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Starting command retry (" + this.currentCommandActualRetries + " of " + n + ") for command:" + this.currentCommand.getCommand().getCommandString()));
                    }
                    Thread.sleep(n2 * 1000);
                    ++this.currentCommandActualRetries;
                    --this.commandArrayCounter;
                    this.sendNextCommand();
                    if (this.currentCommand.getCommand().getCommandAction() != 1 || this.currentCommand.getCommand().getCommandAction() != 2) {
                        String string = System.getProperty("line.separator");
                        this.logWrapper.write(string + "===================================================" + string + "== Starting retry " + this.currentCommandActualRetries + " of " + n + string + "===================================================" + string);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (this.needToBreakAndExit) break block7;
                    this.logWrapper.write("Command Interrupted Exception...");
                    logger.error((Object)"Error on command retry.", (Throwable)interruptedException);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendNextCommand() {
        int n;
        Proxy proxy;
        this.isJobInRetryWait = false;
        if (this.state == 23) {
            this.state = 113;
        }
        if (this.commandArrayCounter >= this.commandArray.length) {
            if (this.state >= 21) {
                return;
            }
            if (this.whenFilePeerStarted > 0L) {
                if (this.jp.getFilePeerID() == null) {
                    this.state = 21;
                    return;
                }
                this.state = 22;
                return;
            }
            this.jp.parseAgentOutputLog(this.agentOutputPosition);
            if (!this.filePeerRequired()) {
                this.state = 113;
                return;
            }
            this.currentCommand = this.jp.buildFilePeerCommand();
            this.whenFilePeerStarted = System.currentTimeMillis();
            this.state = 21;
        } else {
            this.currentCommand = this.commandArray[this.commandArrayCounter];
            ++this.commandArrayCounter;
        }
        if (this.currentCommand == ProcessCommand.MARKER_INSTANCE) {
            this.finishedJobInitialization = true;
            return;
        }
        if (this.currentCommand.getCommandNumber() == -3) {
            ++this.conditionJobSequenceNumber;
            proxy = this.ej.getJobConditions()[this.conditionJobSequenceNumber - 1];
            if (this.ej.isIgnoreConditions()) return;
            if (!this.ej.isConditional()) {
                return;
            }
            if (this.conditionListCheckIsSucceed) {
                return;
            }
            if ("AND".equals(proxy.getConjunction()) && !this.previousConditionChecked) {
                this.conditionFailed();
                return;
            }
            if (!this.jobHistory.getStatusCode().equals(JobStatusCode.CONDITION_CHECK)) {
                this.jobHistory.setStatusCode(JobStatusCode.CONDITION_CHECK);
                this.getJobMarkRunningAM().updateJobStatus(this.jobHistory.getId(), JobStatusCode.CONDITION_CHECK);
            }
            this.conditionCheckStarting();
        }
        proxy = this.currentCommand.getCommand();
        String string = proxy.getCommandString();
        String string2 = "{cshnewline}";
        if (this.jp.getPlatform().isCSHShell(this.jp.getSubShell())) {
            string = string.replaceAll("\\Q" + string2 + "\\E", "\\\\\n");
        } else if (divideLongCommands && string.length() >= 250) {
            string = this.divideLongCommand(string);
        }
        String string3 = null;
        int n2 = this.currentCommand.getFollowupAction();
        if (this.conditionListCheckIsSucceed && (this.jobHistory.getStatusCode().equals(JobStatusCode.CONDITION_CHECK) || this.jobHistory.getStatusCode().equals(JobStatusCode.CONDITION_RETRY_WAIT))) {
            this.conditionCheckCompleted();
            this.updateToRunning();
        }
        if (!(this.jobHistory.getStatusCode().equals(JobStatusCode.CONDITION_CHECK) || this.jobHistory.getStatusCode().equals(JobStatusCode.CONDITION_RETRY_WAIT) || this.currentCommand.getCommandNumber() == -1 || this.jobHistory.getStatusCode().equals(JobStatusCode.RUNNING))) {
            this.updateToRunning();
        }
        if (n2 == 20) {
            this.cmdidDate.setTime(System.currentTimeMillis());
            this.exitCodeMarker = COMMAND_COMPLETION_MARKER + CMDID_FORMATTER.format(this.cmdidDate) + ": ";
            Platform platform = this.jp.getPlatform();
            string3 = platform.getExitCodeCommand(this.jp.getSubShell()).replace("{0}", this.exitCodeMarker);
            this.importantCriteria = COMMAND_COMPLETION_MARKER;
            this.state = 2;
        } else if (n2 == 10) {
            this.state = 3;
        }
        try {
            this.readOutput();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logCharsThreshold = this.logCharsRead;
        if (n2 == 14) {
            this.state = 3;
            this.logCharsThreshold += 4L;
        }
        if (!this.currentCommand.isInputHidden()) {
            n = string.length() + LINE_SEPARATOR.length();
            this.logCharsThreshold += (long)n;
        } else {
            n = LINE_SEPARATOR.length();
            this.logCharsThreshold += (long)n;
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        ++this.logCharsThreshold;
        if (!this.commandRunsOutsideOfTheProcess((CommandSetCommand)proxy)) {
            this.logStandardIn(string);
            this.stdIn.println(string);
        } else {
            this.stdIn.println("");
        }
        if (proxy.isOracleCommand()) {
            this.runningOracleCommand = true;
            this.oracleProcessUtility = new OracleProcessUtility(this.currentCommand.getCommand());
        } else {
            this.runningOracleCommand = false;
        }
        if (this.currentCommand.getFlushBeforeFollowup()) {
            this.stdIn.flush();
            try {
                this.readOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string3 != null) {
            if (this.followupDelay > 0 && this.finishedJobInitialization) {
                try {
                    this.stdIn.flush();
                    Thread.sleep(this.followupDelay * 1000);
                    this.readOutput();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logStandardIn(string3);
            this.stdIn.println(string3);
        }
        this.stdIn.flush();
        if (proxy.isSAPCommand()) {
            this.runningSAPCommand = true;
            String string4 = System.getProperty("os.name");
            boolean bl = string4.startsWith("Windows");
            this.runSAPCommand((CommandSetCommand)proxy, bl);
            this.runningSAPCommand = false;
            this.state = 2;
        }
        if (proxy.getCommandType() == 15) {
            UniversalConnectorCommand universalConnectorCommand = proxy.getUniversalConnectorCommand();
            this.runUniversalConnectorCommand(universalConnectorCommand);
            this.state = 2;
        }
        this.cancelOnError = true;
        this.isEndCommandActualRetries = false;
    }

    private String divideLongCommand(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 250;
        int n2 = 5;
        while (n < stringBuilder.length()) {
            if (stringBuilder.substring(n - 1, n).equals("\\")) {
                int n3 = 0;
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    n3 = n - (i + 1);
                    if (stringBuilder.substring(n3, n3 + 1).equals("\\")) continue;
                    stringBuilder.insert(n3 + 1, "\\\n");
                    n = n3 + 2 + 250;
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringBuilder.insert(n, "\\\n");
                n += 252;
                continue;
            }
            stringBuilder.insert(n, "\\\n");
            n += 252;
        }
        return stringBuilder.toString();
    }

    private void logStandardIn(String string) {
    }

    private void runSAPCommand(CommandSetCommand commandSetCommand, boolean bl) {
        this.sapCommandHelperAM = (SAPCommandHelperAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)ProductIID.DIRECT_CONNECT, (String)"ENTERPRISE.SAPCommandHelperAM");
        SAPExecutable sAPExecutable = commandSetCommand.getSAPExecutable();
        sAPExecutable.setSkybotEventID(this.jobHistory.getId());
        sAPExecutable.setAgentNameAndPort(this.ej.getAgent().getName() + ":" + this.ej.getAgent().getPort());
        String string = "SAP Command: " + sAPExecutable.getCommandString();
        this.logWrapper.write(string);
        if (!bl) {
            this.logWrapper.write("\r\n");
        }
        this.getCommandOutput().append(string);
        this.getCommandOutput().append("\r\n");
        this.cmdidDate.setTime(System.currentTimeMillis());
        this.exitCodeMarker = COMMAND_COMPLETION_MARKER + CMDID_FORMATTER.format(this.cmdidDate) + ": ";
        Platform platform = this.jp.getPlatform();
        String string2 = platform.getExitCodeCommand(this.jp.getSubShell()).replace("{0}", this.exitCodeMarker);
        this.logWrapper.write(string2);
        if (!bl) {
            this.logWrapper.write("\r\n");
        }
        this.getCommandOutput().append(string2);
        this.getCommandOutput().append("\r\n");
        if (!this.jobHistory.getStatusCode().equals(JobStatusCode.RUNNING)) {
            this.updateToRunning();
        }
        this.sapCommandResults = this.sapCommandHelperAM.runSAPCommand(sAPExecutable, this.logWrapper.getPw());
        if (this.sapCommandResults.isSuccessful() && this.sapCommandResults.isReleasingInterceptedJobs()) {
            if (this.sapCommandResults.isMultipleInterceptedJobs()) {
                this.jp.addStartedSAPInterceptedJobIDs(this.sapCommandResults.getStartedInterceptedJobIDs());
            } else {
                logger.debug((Object)("Command: " + commandSetCommand.getOid() + " started SAP Job " + sAPExecutable.getSapCommand().getSAPCommandName() + " on the SAP system."));
                this.jp.addStartedSAPInterceptedJobID(this.sapCommandResults.getStartedInterceptedJobIDs().get(0));
            }
        }
        ArrayList<String> arrayList = this.sapCommandResults.getLineByLineAccount();
        for (String string3 : arrayList) {
            this.logWrapper.write(string3);
            if (!bl) {
                this.logWrapper.write("\r\n");
            }
            this.getCommandOutput().append(string3);
            this.getCommandOutput().append("\r\n");
        }
        string2 = platform.getExitCodeCommand(this.jp.getSubShell()).replace("{0}", this.exitCodeMarker);
        String string4 = String.valueOf(this.sapCommandResults.getExitCode().getReturnCode());
        if (this.isWindows()) {
            string2 = string2.replace("%Errorlevel%", string4);
            this.logWrapper.write(string2);
        } else {
            string2 = string2.replace("$?", string4);
            this.logWrapper.write(string2);
            this.logWrapper.write("\r\n");
        }
        this.getCommandOutput().append(string2);
        this.getCommandOutput().append("\r\n");
    }

    private void runUniversalConnectorCommand(UniversalConnectorCommand universalConnectorCommand) {
        try {
            ValidationHelper.checkForNull((String)"Universal Connector Command", (Object)universalConnectorCommand);
            Map<String, String> map = universalConnectorCommand.getAgentParms();
            Map<String, Object> map2 = universalConnectorCommand.getUcParms();
            String string = map.get("server-url");
            String string2 = map.get("interface-id");
            String string3 = map.get("interface-name");
            String string4 = map.get("template-uuid");
            String string5 = map.get("template-name");
            long l = Long.parseLong(string2);
            String string6 = map.get("username");
            String string7 = map.get("encrypted-password");
            String string8 = map.get("password-salt");
            boolean bl = Boolean.valueOf(map.get("retrieve_log"));
            String string9 = this.clear(string7, string8);
            Map<String, String> map3 = this.requestorInfo();
            this.universalConnectorCommandExitCode = UCExecutor.execute(string, l, string3, string4, string5, map2, map3, this.logWrapper, LINE_SEPARATOR, this.isTerminateCommand, this.waitLock, string6, string9, bl);
        }
        catch (Exception exception) {
            this.universalConnectorCommandExitCode = 1;
            this.logWrapper.write(MessageUtil.formatMsg((String)"Command failure: {0}", (Object[])new Object[]{exception.getMessage()}));
        }
    }

    private Map<String, String> requestorInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("agent-name", this.ej.getJobHistory().getAgentName());
        hashMap.put("job-name", this.ej.getJobHistory().getJobName());
        hashMap.put("job-run-id", Long.toString(this.ej.getJobHistory().getId()));
        return hashMap;
    }

    private String clear(String string, String string2) {
        try {
            String string3 = UnacodeMash.unMash(string);
            string3 = string3.replaceAll(string2, "");
            return string3;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private StringBuffer getCommandOutput() {
        if (this.commandOutput == null) {
            this.commandOutput = new StringBuffer();
        }
        return this.commandOutput;
    }

    private int parseLastCompletion() {
        String string = this.lastImportantLine;
        if (string == null || string.indexOf(COMMAND_COMPLETION_MARKER) == -1) {
            return Integer.MIN_VALUE;
        }
        if (string.toLowerCase().indexOf("echo") > -1) {
            return Integer.MIN_VALUE;
        }
        String[] stringArray = string.split(this.exitCodeMarker);
        if (stringArray.length != 2) {
            return Integer.MIN_VALUE;
        }
        int n = Integer.MIN_VALUE;
        try {
            n = Integer.parseInt(stringArray[1]);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -2147483647;
        }
    }

    private boolean filePeerRequired() {
        Map<Long, List<String>> map = this.jp.getAgentOutputFileMap();
        if (map.size() == 0) {
            return false;
        }
        if (!this.jp.isConnectedToServer()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (List<String> object : map.values()) {
            if (arrayList.size() > 100) {
                return true;
            }
            arrayList.addAll(object);
        }
        for (String string : arrayList) {
            File file = new File(string);
            if (file.canRead()) continue;
            return true;
        }
        return false;
    }

    private void updateToRunning() {
        this.jobHistory.setStatusCode(JobStatusCode.RUNNING);
        try {
            this.getJobMarkRunningAM().markJobAsRunning(this.ej);
        }
        catch (Exception exception) {
            String string = "Error While marking job as Running with ID " + this.ej.getEventID();
            logger.info((Object)string, (Throwable)exception);
        }
    }

    private JobMarkRunningAM getJobMarkRunningAM() {
        if (this.jobMarkRunningAM == null) {
            this.jobMarkRunningAM = (JobMarkRunningAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.ej.getServerPeerID(), (String)"ENTERPRISE.JobMarkRunningAM");
        }
        return this.jobMarkRunningAM;
    }

    private void invalidPathHandler(String string) {
        String string2 = "Invalid path '" + string + "' specified for the condition.";
        this.logWrapper.write(string2);
        this.jp.setCompletionCode('E');
        this.jp.setFailedAtCommandSequence(this.currentCommand.getCommandNumber());
        this.jp.setTerminationReason(string2);
        this.jp.setJobEndedReasonCode(JobEndedReasonCode.AGENT_INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION);
        this.writeScheduleLog(string);
    }

    private void writeScheduleLog(String string) {
        ScheduleLogDM scheduleLogDM = (ScheduleLogDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.ej.getServerPeerID(), (String)"ENTERPRISE.ScheduleLogDM");
        String[] stringArray = new String[]{this.jobHistory.getJobName(), string};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION_1.newLogEntry(stringArray);
        scheduleLogEntry.setAgentID(this.jobHistory.getAgentID());
        scheduleLogEntry.setJobID(this.jobHistory.getJobID());
        scheduleLogEntry.setJobHistoryID(this.jobHistory.getId());
        try {
            scheduleLogDM.save(scheduleLogEntry);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error writing schedule log entry: " + scheduleLogEntry.toString()), throwable);
        }
        String string2 = ScheduleLogger.formatTimeStamp(System.currentTimeMillis());
        String[] stringArray2 = new String[]{this.jobHistory.getJobName(), this.jobHistory.getId() + "", this.jobHistory.getAgentName(), string2};
        ScheduleLogEntry scheduleLogEntry2 = RosettaMsg.INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION_2.newLogEntry(stringArray2);
        scheduleLogEntry2.setAgentID(this.jobHistory.getAgentID());
        scheduleLogEntry2.setJobID(this.jobHistory.getJobID());
        scheduleLogEntry2.setJobHistoryID(this.jobHistory.getId());
        try {
            scheduleLogDM.save(scheduleLogEntry2);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error writing schedule log entry: " + scheduleLogEntry2.toString()), throwable);
        }
    }

    public void updateSAPXMIAuditLevel(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        if (this.runningSAPCommand) {
            this.sapCommandHelperAM.xmiAuditLevelChange(l, sAPXMIAuditLevel);
        }
    }

    private String getCommandPureOutput(String string) {
        String string2 = string.substring(string.indexOf("\n") + 1);
        if (this.exitCodeMarker == null || this.exitCodeMarker.equals("")) {
            return string2;
        }
        String[] stringArray = string2.split("\n");
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isWindows()) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].contains(this.exitCodeMarker)) {
                    if (bl) {
                        return stringBuffer.toString();
                    }
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("\n");
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].contains(this.exitCodeMarker)) {
                    if (stringArray[i].contains("$")) continue;
                    return stringBuffer.toString();
                }
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public HashMap<Long, String> getDeletedFileArray() {
        return this.deletedFileArray;
    }

    public void setDeletedFileArray(HashMap<Long, String> hashMap) {
        this.deletedFileArray = hashMap;
    }

    private void deleteAllWebServiceFiles() {
        if (this.deletedFileArray.size() == 0) {
            return;
        }
        for (String string : this.deletedFileArray.values()) {
            File file = new File(string);
            if (!file.delete()) continue;
            String string2 = "Serialized Web Service Request file was deleted: " + file.getAbsolutePath();
            this.logWrapper.write(string2);
            this.getCommandOutput().append(string2);
        }
    }

    private void deleteWebServiceFiles(Long l) {
        if (this.deletedFileArray.size() == 0) {
            return;
        }
        this.logWrapper.write("");
        String string = this.deletedFileArray.get(l);
        File file = new File(string);
        if (file.delete()) {
            String string2 = "Serialized Web Service Request file was deleted: " + file.getAbsolutePath();
            this.deletedFileArray.remove(l);
            this.logWrapper.write(string2);
            this.getCommandOutput().append(string2);
        } else {
            String string3 = "WARNING: Serialized Web Service Request file was NOT deleted: " + file.getAbsolutePath();
            this.logWrapper.write(string3);
            this.getCommandOutput().append(string3);
        }
        this.logWrapper.write("");
    }

    static {
        boolean bl = "SunOS".equals(System.getProperty("os.name"));
        divideLongCommands = bl;
    }
}

