/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PipeCleaner {
    private static final Logger logger = Logger.getLogger(PipeCleaner.class);
    private static final int PIPE_TIMEOUT = 120000;
    private byte[] buffer = new byte[10000];
    private HashMap<InputStream, Long> pipeMap = new HashMap();
    private static PipeCleaner instance = new PipeCleaner();

    private PipeCleaner() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                instance.run();
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    public static void addPipes(Process process) {
        instance._addPipes(process);
    }

    private void _addPipes(Process process) {
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        PipeCleaner.addPipe(inputStream);
        if (inputStream != inputStream2) {
            PipeCleaner.addPipe(inputStream2);
        }
    }

    public static void addPipe(InputStream inputStream) {
        instance._addPipe(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addPipe(InputStream inputStream) {
        HashMap<InputStream, Long> hashMap = this.pipeMap;
        synchronized (hashMap) {
            this.pipeMap.put(inputStream, System.currentTimeMillis());
        }
    }

    private void cleanPipe(InputStream inputStream) throws IOException {
        if (inputStream.available() > 0) {
            int n = inputStream.read(this.buffer);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("PipeCleaner discarding " + n + " byte(s)"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanPipes() {
        InputStream[] inputStreamArray = null;
        InputStream[] inputStreamArray2 = this.pipeMap;
        synchronized (this.pipeMap) {
            inputStreamArray = new InputStream[this.pipeMap.size()];
            this.pipeMap.keySet().toArray(inputStreamArray);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (InputStream inputStream : inputStreamArray) {
                try {
                    this.cleanPipe(inputStream);
                }
                catch (Exception exception) {
                    PipeCleaner.removePipe(inputStream);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictPipes() {
        long l = System.currentTimeMillis();
        HashMap<InputStream, Long> hashMap = this.pipeMap;
        synchronized (hashMap) {
            Iterator<Map.Entry<InputStream, Long>> iterator = this.pipeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<InputStream, Long> entry = iterator.next();
                long l2 = entry.getValue();
                if (l2 + 120000L >= l) continue;
                try {
                    entry.getKey().close();
                }
                catch (Exception exception) {
                    logger.debug((Object)("Unable to close pipe " + entry.getKey() + ", pipe may linger indefinitely."), (Throwable)exception);
                }
                iterator.remove();
            }
        }
    }

    public static void removePipe(InputStream inputStream) {
        instance._removePipe(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removePipe(InputStream inputStream) {
        HashMap<InputStream, Long> hashMap = this.pipeMap;
        synchronized (hashMap) {
            this.pipeMap.remove(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to close pipe " + inputStream + ", pipe may linger indefinitely."), (Throwable)exception);
            }
        }
    }

    private void run() {
        while (true) {
            try {
                while (true) {
                    this.updateName();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.cleanPipes();
                    this.evictPipes();
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)"PipeCleaner ignoring an error", throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateName() {
        int n = 0;
        HashMap<InputStream, Long> hashMap = this.pipeMap;
        synchronized (hashMap) {
            n = this.pipeMap.size();
        }
        Thread.currentThread().setName("Process Output Cleanup (" + n + ")");
    }
}

