/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.JobStatusSNMPTrap;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMarkRunningAM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.JobStartEndRollupDM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.module.EmailInformation;
import org.apache.log4j.Logger;

public class JobMarkRunningAMImpl
extends AbstractManager
implements JobMarkRunningAM {
    private static Logger logger = Logger.getLogger(JobMarkRunningAMImpl.class);
    private JobHistoryDM jobHistoryDM;
    private JobStartEndRollupDM jobStartEndRollupDM;
    private EnterpriseSNMPTrapAM snmpTrapAM;
    private NotificationListDM notificationListDM;
    private EnterpriseEmailAM emailAM;
    private JobMonitorManagerAM jobMonitorManagerAM;
    private ScheduleJobDM scheduleJobDM;

    public JobMarkRunningAMImpl() {
        this.setName("ENTERPRISE.JobMarkRunningAM");
        this.jobMonitorManagerAM = (JobMonitorManagerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorManagerAM");
    }

    @Override
    public JobHistory getJobHistory(long l) throws DataException, ResourceUnavailableException {
        return this.getJobHistoryDM().get(l);
    }

    @Override
    public void markJobAsRunning(ExecutableJob executableJob) {
        block16: {
            JobHistory jobHistory = executableJob.getJobHistory();
            if (jobHistory == null) {
                try {
                    jobHistory = this.getJobHistoryDM().get(Integer.parseInt(executableJob.getEventID()));
                }
                catch (Exception exception) {
                    logger.error((Object)("Error while getting jobHistory with ID " + executableJob.getEventID()), (Throwable)exception);
                }
            }
            Long l = executableJob.getServerRunningTime();
            jobHistory.setServerRunningTime(executableJob.getServerRunningTime());
            jobHistory.setAgentStartedTime(executableJob.getAgentStartedTime());
            try {
                this.getJobHistoryDM().updateToRunning(jobHistory);
                if (!jobHistory.isBypassJobMonitors() && executableJob.getScheduleJob().hasMonitorsSelected()) {
                    this.jobMonitorManagerAM.jobHasStarted(jobHistory);
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error updating job history info with Server Running and Agent Started Times.", (Throwable)exception);
            }
            try {
                this.getJobStartEndRollupDM().saveStartCount(l);
            }
            catch (Exception exception) {
                logger.error((Object)"Error saving jobStartEndRolup for job starting", (Throwable)exception);
            }
            if (jobHistory.getStatusCode().isTerminalState()) {
                logger.debug((Object)("Bypassing notifications since Job History ID " + jobHistory.getId() + " is already in the terminal state " + jobHistory.getStatusCode()));
                return;
            }
            String string = RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_JOB_STATUS_NOTICE, new String[]{jobHistory.getJobName(), String.valueOf(jobHistory.getId()), jobHistory.getAgentName(), JobStatusCode.RUNNING.name()});
            logger.debug((Object)string);
            try {
                String[] stringArray;
                if (executableJob.getScheduleJob().isSendRunSNMPTrap()) {
                    stringArray = new JobStatusSNMPTrap(JobStatusCode.RUNNING);
                    stringArray.setJobID(jobHistory.getJobID());
                    stringArray.setJobName(jobHistory.getJobName());
                    stringArray.setRunID(jobHistory.getId());
                    stringArray.setAgentID(jobHistory.getAgentID());
                    stringArray.setAgentName(jobHistory.getAgentName());
                    stringArray.setText(string);
                    stringArray.setJobSuiteID(jobHistory.getJobSuiteID());
                    stringArray.setJobSuiteName(jobHistory.getJobSuiteName());
                    stringArray.setJobSuiteRunID(jobHistory.getJobSuiteHistoryID());
                    this.getSNMPTrapAM().sendSNMPTrap((EnterpriseSNMPTrap)stringArray);
                }
                if (!executableJob.getScheduleJob().isSendRunEmail() || executableJob.getScheduleJob().getRunNotificationListID() <= 0L) break block16;
                stringArray = null;
                try {
                    stringArray = this.getNotificationListDM().get(executableJob.getScheduleJob().getRunNotificationListID()).getListOfUniqueEmails();
                }
                catch (Exception exception) {
                    logger.error((Object)"Error retrieving Job Notification Options.", (Throwable)exception);
                }
                if (stringArray == null || stringArray.length <= 0) break block16;
                String string2 = RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_JOB_STATUS_NOTICE, new String[]{jobHistory.getJobName(), String.valueOf(jobHistory.getId()), jobHistory.getAgentName(), JobStatusCode.RUNNING.name()});
                EmailInformation emailInformation = new EmailInformation(string2, string);
                try {
                    emailInformation.setOverrideSubject(executableJob.getScheduleJob().getEmailSubjectRunning());
                    emailInformation.setOverrideBody(executableJob.getScheduleJob().getEmailBodyRunning());
                    emailInformation.replaceJobVariables(jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getId(), jobHistory.getStatusCode().toString(), jobHistory.getScheduledTime());
                }
                catch (Exception exception) {
                    logger.error((Object)"Error preparing email subject/body.", (Throwable)exception);
                }
                this.getEmailAM().sendMessage(stringArray, emailInformation.getFinalSubject(), emailInformation.getFinalBody());
            }
            catch (Exception exception) {
                logger.error((Object)"An error occurred that did not hinder the job from running. ", (Throwable)exception);
            }
        }
    }

    @Override
    public void markJobAsRunning(long l, long l2) {
        ScheduleJob scheduleJob;
        JobHistory jobHistory;
        try {
            jobHistory = this.getJobHistoryDM().get(l);
            scheduleJob = this.getScheduleJobDM().get(jobHistory.getJobID());
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to mark the job history with run ID {0} as Running status.", (Object[])new Object[]{l}), (Throwable)exception);
            return;
        }
        this.markJobAsRunning(jobHistory, scheduleJob, l2);
    }

    @Override
    public void markJobAsRunning(JobHistory jobHistory, ScheduleJob scheduleJob, long l) {
        ValidationHelper.checkForNull((String)"Job History", (Object)((Object)jobHistory));
        ValidationHelper.checkForNull((String)"Schedule Job", (Object)((Object)scheduleJob));
        long l2 = System.currentTimeMillis();
        ExecutableJob executableJob = new ExecutableJob();
        executableJob.setJobHistory(jobHistory);
        executableJob.setScheduleJob(scheduleJob);
        if (!jobHistory.getStatusCode().isTerminalState()) {
            executableJob.setServerRunningTime(l2);
        }
        executableJob.setAgentStartedTime(l);
        executableJob.setEventID(String.valueOf(jobHistory.getId()));
        this.markJobAsRunning(executableJob);
    }

    @Override
    public void addIBMiJobToJobHistory(long l, String string, String string2, String string3) {
        logger.debug((Object)("Agent is reporting Automate Schedule job history ID " + l + " submitted IBM i job " + string3 + "/" + string2 + "/" + string));
        try {
            this.getJobHistoryDM().updateToIBMiSubmitted(l, string, string2, string3);
        }
        catch (Exception exception) {
            logger.error((Object)("Error updating Job History record with ID " + l + " with IBM i Job information."), (Throwable)exception);
        }
    }

    @Override
    public void updateJobStatus(long l, JobStatusCode jobStatusCode) {
        try {
            if (!this.getJobHistoryDM().hasJobEnded(l)) {
                JobHistory jobHistory = this.getJobHistoryDM().get(l);
                jobHistory.setStatusCode(jobStatusCode);
                this.getJobHistoryDM().save(jobHistory);
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to mark the job history with run ID {0} as {1} status.", (Object[])new Object[]{l, jobStatusCode}), (Throwable)exception);
            return;
        }
    }

    private JobHistoryDM getJobHistoryDM() {
        if (this.jobHistoryDM == null) {
            this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        }
        return this.jobHistoryDM;
    }

    private JobStartEndRollupDM getJobStartEndRollupDM() {
        if (this.jobStartEndRollupDM == null) {
            this.jobStartEndRollupDM = (JobStartEndRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobStartEndRollupDM");
        }
        return this.jobStartEndRollupDM;
    }

    private EnterpriseSNMPTrapAM getSNMPTrapAM() {
        if (this.snmpTrapAM == null) {
            this.snmpTrapAM = (EnterpriseSNMPTrapAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseSNMPTrapAM");
        }
        return this.snmpTrapAM;
    }

    private NotificationListDM getNotificationListDM() {
        if (this.notificationListDM == null) {
            this.notificationListDM = (NotificationListDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.NotificationListDM");
        }
        return this.notificationListDM;
    }

    private EnterpriseEmailAM getEmailAM() {
        if (this.emailAM == null) {
            this.emailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseEmailAM");
        }
        return this.emailAM;
    }

    private ScheduleJobDM getScheduleJobDM() {
        if (this.scheduleJobDM == null) {
            this.scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
        }
        return this.scheduleJobDM;
    }
}

