/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.DurableMap;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.event.PeerEventListener;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.dm.JobCompletionDM;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobCompletionInfo;
import com.helpsystems.enterprise.core.exec.JobTimer;
import com.helpsystems.enterprise.module.exec.JobProcess;
import com.helpsystems.enterprise.module.exec.Platform;
import com.helpsystems.enterprise.module.exec.PlatformFactory;
import com.helpsystems.enterprise.module.exec.WindowsPlatform;
import com.helpsystems.enterprise.module.windows.WindowsProcessLauncher;
import com.helpsystems.enterprise.peer.AgentControl;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class JobExecDMImpl
extends AbstractManager
implements JobExecDM {
    private static final Logger logger = Logger.getLogger(JobExecDMImpl.class);
    private static final String SERVER_PEER_ID_KEY = "SERVER_PEER_ID_KEY";
    private static long lastTimestamp;
    private Set<JobProcess> processSet;
    private PeerID myPeerID;
    private DurableMap durableMap;
    private Set<String> oldEventSet;
    private AgentPeer myPeer;
    private AgentBacklogProcessor backlogProcessor = null;
    private ScheduledThreadPoolExecutor backlogExecutor;
    private ScheduledFuture scheduleTask;
    private WindowsProcessLauncher wpl;

    public JobExecDMImpl(AgentPeer agentPeer) throws IOException {
        this.myPeer = agentPeer;
        this.myPeerID = agentPeer.getRemotePeerID();
        this.processSet = new HashSet<JobProcess>();
        this.setName("ENTERPRISE.JobExecDM");
        this.initLogDir();
        String string = "joblogtmp";
        if (AgentControl.isWindows()) {
            string = DefaultConfigPath.getDefaultPath() + File.separator + string;
        }
        this.durableMap = new DurableMap(string, this.myPeerID.getInstanceIdentifier().toString());
        this.oldEventSet = new HashSet<String>();
        for (String string2 : this.durableMap.keySet()) {
            if (string2.equals(SERVER_PEER_ID_KEY)) continue;
            this.oldEventSet.add(string2);
        }
        agentPeer.addListener((SimpleEventListener)new MyPeerListener());
        this.purgeLogDir();
        Platform platform = PlatformFactory.getPlatform();
        if (platform instanceof WindowsPlatform) {
            this.wpl = new WindowsProcessLauncher(agentPeer.getAgentConfig().getWindowsProcessPort());
        }
    }

    WindowsProcessLauncher getWindowsProcessLauncher() {
        return this.wpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJobLogFilename(long l) {
        JobProcess jobProcess = null;
        Object object = this.processSet;
        synchronized (object) {
            for (JobProcess jobProcess2 : this.processSet) {
                if (jobProcess2.getWhenStarted() != l) continue;
                jobProcess = jobProcess2;
                break;
            }
        }
        if (jobProcess == null) {
            return null;
        }
        object = jobProcess.getOutputLogFile();
        if (object == null) {
            return null;
        }
        if (!((File)object).exists()) {
            return null;
        }
        return ((File)object).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteFile getJobLog(String string) {
        JobProcess jobProcess = null;
        Object object = this.processSet;
        synchronized (object) {
            for (JobProcess jobProcess2 : this.processSet) {
                ExecutableJob executableJob = jobProcess2.getExecutableJob();
                if (!string.equals(executableJob.getEventID())) continue;
                jobProcess = jobProcess2;
                break;
            }
        }
        if (jobProcess == null) {
            return null;
        }
        object = jobProcess.getOutputLogFile();
        RemoteFile remoteFile = new RemoteFile((File)object);
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<JobTimer, ExecutableJob> listJobs() {
        HashMap<JobTimer, ExecutableJob> hashMap = new HashMap<JobTimer, ExecutableJob>();
        Set<JobProcess> set = this.processSet;
        synchronized (set) {
            for (JobProcess jobProcess : this.processSet) {
                long l = jobProcess.getWhenStarted();
                JobTimer jobTimer = new JobTimer();
                jobTimer.setWhenStarted(l);
                jobTimer.setTerminating(jobProcess.wasTerminatedByServer());
                hashMap.put(jobTimer, jobProcess.getExecutableJob());
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int activeJobCount() {
        int n = -1;
        Set<JobProcess> set = this.processSet;
        synchronized (set) {
            n = this.processSet.size();
        }
        return n;
    }

    @Override
    public void endJob(String string) {
        this.endJob(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endJob(String string, String string2) {
        ValidationHelper.checkForNull((String)"Event ID", (Object)string);
        Set<JobProcess> set = this.processSet;
        synchronized (set) {
            for (JobProcess jobProcess : this.processSet) {
                ExecutableJob executableJob = jobProcess.getExecutableJob();
                if (!string.equals(executableJob.getEventID())) continue;
                jobProcess.terminate(string2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bypassConditions(String string, String string2) {
        Set<JobProcess> set = this.processSet;
        synchronized (set) {
            for (JobProcess jobProcess : this.processSet) {
                ExecutableJob executableJob = jobProcess.getExecutableJob();
                if (!string.equals(executableJob.getEventID())) continue;
                jobProcess.bypassConditions();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJob(String string) {
        ValidationHelper.checkForNull((String)"Event ID", (Object)string);
        Set<JobProcess> set = this.processSet;
        synchronized (set) {
            for (JobProcess jobProcess : this.processSet) {
                ExecutableJob executableJob = jobProcess.getExecutableJob();
                if (!string.equals(executableJob.getEventID())) continue;
                jobProcess.finishJob();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasJob(String string) {
        ValidationHelper.checkForNull((String)"Event ID", (Object)string);
        DurableMap durableMap = this.processSet;
        synchronized (durableMap) {
            for (JobProcess jobProcess : this.processSet) {
                ExecutableJob executableJob = jobProcess.getExecutableJob();
                if (!string.equals(executableJob.getEventID())) continue;
                return true;
            }
        }
        durableMap = this.durableMap;
        synchronized (durableMap) {
            try {
                Serializable serializable = this.durableMap.get(string);
                return serializable != null;
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to verify if info for job-event " + string + " is present."), (Throwable)exception);
                return false;
            }
        }
    }

    static synchronized long getUniqueNumber() {
        long l = System.currentTimeMillis();
        if (l <= lastTimestamp) {
            l = lastTimestamp + 1L;
        }
        lastTimestamp = l;
        return l;
    }

    @Override
    public long run(ExecutableJob executableJob) throws SubmitFailedException {
        ValidationHelper.checkForNull((String)"Executable Job", (Object)((Object)executableJob));
        if (this.myPeer.isShutdownRequested()) {
            throw new SubmitFailedException("The agent is shutting down.", SubmitFailedException.Reason.SHUTDOWN_IN_PROGRESS);
        }
        Platform platform = PlatformFactory.getPlatform();
        if (platform == null) {
            throw new SubmitFailedException("The platform " + System.getProperty("os.name") + " is not supported for running jobs.");
        }
        long l = JobExecDMImpl.getUniqueNumber();
        executableJob.setAgentStartedTime(l);
        JobProcess jobProcess = new JobProcess(executableJob, platform, this);
        this.registerProcess(jobProcess);
        return l;
    }

    AgentPeer getPeer() {
        return this.myPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProcess(JobProcess jobProcess) {
        DurableMap durableMap = this.processSet;
        synchronized (durableMap) {
            this.processSet.add(jobProcess);
        }
        durableMap = this.durableMap;
        synchronized (durableMap) {
            try {
                this.durableMap.put(String.valueOf(jobProcess.getExecutableJob().getEventID()), (Serializable)((Object)jobProcess));
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to persist info about a job that was started.", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetProcess(JobProcess jobProcess) {
        DurableMap durableMap = this.processSet;
        synchronized (durableMap) {
            this.processSet.remove((Object)jobProcess);
        }
        durableMap = this.durableMap;
        synchronized (durableMap) {
            if (!jobProcess.isJobCompletionSent()) {
                logger.debug((Object)("Leaving job completion info for the backlog processor: " + jobProcess.getExecutableJob().getEventID()));
                return;
            }
            try {
                this.durableMap.remove(String.valueOf(jobProcess.getExecutableJob().getEventID()));
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to remove a job's saved info.", (Throwable)exception);
            }
        }
    }

    private JobCompletionInfo makeInfo(JobProcess jobProcess) {
        JobCompletionInfo jobCompletionInfo = new JobCompletionInfo(jobProcess.getExecutableJob());
        jobCompletionInfo.setCompletionCode(jobProcess.getCompletionCode());
        jobCompletionInfo.setJobEndedReasonCode(jobProcess.getJobEndedReasonCode());
        File file = jobProcess.getOutputLogFile();
        if (file != null && file.exists()) {
            jobCompletionInfo.setJobLogFilename(file.getAbsolutePath());
        }
        jobCompletionInfo.setAgentOutputFile(jobProcess.getAgentOutputFileMap());
        jobCompletionInfo.setTerminationReason(jobProcess.getTerminationReason());
        jobCompletionInfo.setWhenStarted(jobProcess.getWhenStarted());
        jobCompletionInfo.setWhenEnded(System.currentTimeMillis());
        jobCompletionInfo.setTerminationData(jobProcess.getTerminationData());
        jobCompletionInfo.setFailedAtCommandSequence(jobProcess.getFailedAtCommandSequence());
        jobCompletionInfo.setStartedSAPInterceptedJobIDs(jobProcess.getStartedSAPInterceptedJobIDs());
        jobCompletionInfo.setFilePeerID(jobProcess.getFilePeerID());
        jobCompletionInfo.setTerminatedByServer(jobProcess.wasTerminatedByServer());
        return jobCompletionInfo;
    }

    private void sendCompletion(JobProcess jobProcess) {
        JobCompletionInfo jobCompletionInfo = this.makeInfo(jobProcess);
        this.sendCompletion(jobCompletionInfo, jobProcess.getExecutableJob().getServerPeerID(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCompletion(JobCompletionInfo jobCompletionInfo, PeerID peerID, boolean bl) {
        JobCompletionDM jobCompletionDM;
        jobCompletionInfo.setPeerID(this.myPeerID);
        boolean bl2 = false;
        try {
            if (this.myPeer.getPeerFromRoutingTable(peerID) == null) {
                throw new RuntimeException("Unable to resolve the enterprise server: " + peerID);
            }
            jobCompletionDM = (JobCompletionDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.JobCompletionDM");
            jobCompletionDM.jobCompleted(jobCompletionInfo);
            bl2 = jobCompletionDM.hasJob(jobCompletionInfo.getExecutableJob().getEventID());
            jobCompletionDM = this.durableMap;
        }
        catch (Exception exception) {
            DurableMap durableMap;
            String string;
            try {
                string = "Unable to notify server of job completion.Job information will be saved for later transmission.";
                if (bl) {
                    throw new RuntimeException(string, exception);
                }
                logger.debug((Object)string, (Throwable)exception);
                durableMap = this.durableMap;
            }
            catch (Throwable throwable) {
                DurableMap durableMap2 = this.durableMap;
                synchronized (durableMap2) {
                    String string2 = null;
                    try {
                        if (bl2) {
                            logger.debug((Object)("Removing old entry from durable map eventID: " + String.valueOf(jobCompletionInfo.getExecutableJob().getEventID())));
                            string2 = "delete";
                            this.durableMap.remove(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()));
                            this.oldEventSet.remove(jobCompletionInfo.getExecutableJob().getEventID());
                        } else {
                            logger.debug((Object)("Saving old entry from durable map eventID: " + String.valueOf(jobCompletionInfo.getExecutableJob().getEventID())));
                            string2 = "save";
                            this.durableMap.put(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()), (Serializable)((Object)jobCompletionInfo));
                            this.oldEventSet.add(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()));
                        }
                    }
                    catch (IOException iOException) {
                        logger.warn((Object)("Unable to " + string2 + " off-line job completion info"), (Throwable)iOException);
                    }
                }
                throw throwable;
            }
            synchronized (durableMap) {
                string = null;
                try {
                    if (bl2) {
                        logger.debug((Object)("Removing old entry from durable map eventID: " + String.valueOf(jobCompletionInfo.getExecutableJob().getEventID())));
                        string = "delete";
                        this.durableMap.remove(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()));
                        this.oldEventSet.remove(jobCompletionInfo.getExecutableJob().getEventID());
                    } else {
                        logger.debug((Object)("Saving old entry from durable map eventID: " + String.valueOf(jobCompletionInfo.getExecutableJob().getEventID())));
                        string = "save";
                        this.durableMap.put(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()), (Serializable)((Object)jobCompletionInfo));
                        this.oldEventSet.add(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()));
                    }
                }
                catch (IOException iOException) {
                    logger.warn((Object)("Unable to " + string + " off-line job completion info"), (Throwable)iOException);
                }
            }
        }
        synchronized (jobCompletionDM) {
            String string = null;
            try {
                if (bl2) {
                    logger.debug((Object)("Removing old entry from durable map eventID: " + String.valueOf(jobCompletionInfo.getExecutableJob().getEventID())));
                    string = "delete";
                    this.durableMap.remove(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()));
                    this.oldEventSet.remove(jobCompletionInfo.getExecutableJob().getEventID());
                } else {
                    logger.debug((Object)("Saving old entry from durable map eventID: " + String.valueOf(jobCompletionInfo.getExecutableJob().getEventID())));
                    string = "save";
                    this.durableMap.put(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()), (Serializable)((Object)jobCompletionInfo));
                    this.oldEventSet.add(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID()));
                }
            }
            catch (IOException iOException) {
                logger.warn((Object)("Unable to " + string + " off-line job completion info"), (Throwable)iOException);
            }
        }
    }

    void processEnded(JobProcess jobProcess) {
        this.forgetProcess(jobProcess);
    }

    void sendCompletionForProcess(JobProcess jobProcess) {
        this.sendCompletion(jobProcess);
    }

    void initLogDir() {
        File file;
        String string = "joblogtmp";
        if (AgentControl.isWindows()) {
            string = DefaultConfigPath.getDefaultPath() + File.separator + string;
        }
        if (!(file = new File(string)).exists()) {
            file.mkdir();
        }
        if (!file.isDirectory()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeLogDir() {
        File[] fileArray;
        String string = this.myPeerID.getInstanceIdentifier().toString();
        String string2 = "joblogtmp";
        if (AgentControl.isWindows()) {
            string2 = DefaultConfigPath.getDefaultPath() + File.separator + string2;
        }
        File file = new File(string2);
        Object object = this.durableMap;
        synchronized (object) {
            try {
                if (this.durableMap.size() > 1) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
        object = string + "_";
        for (File file2 : fileArray = file.listFiles()) {
            String string3 = file2.getName();
            if (!string3.startsWith((String)object) || !string3.endsWith(".log")) continue;
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOfflineCompletion(PeerID peerID) {
        if (this.oldEventSet.size() == 0) {
            return;
        }
        boolean bl = true;
        DurableMap durableMap = this.durableMap;
        synchronized (durableMap) {
            String[] stringArray = new String[]{};
            stringArray = this.oldEventSet.toArray(stringArray);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending offline completion for " + stringArray.length + " events."));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending offline completion for event ID: " + string));
                }
                try {
                    Object object;
                    if (this.myPeer.getConnectedAgentServer() == null) {
                        bl = false;
                        break;
                    }
                    JobCompletionInfo jobCompletionInfo = null;
                    Serializable serializable = this.durableMap.get(string);
                    if (serializable == null) continue;
                    if (serializable instanceof JobCompletionInfo) {
                        jobCompletionInfo = (JobCompletionInfo)((Object)serializable);
                    } else if (serializable instanceof JobProcess) {
                        object = (JobProcess)((Object)serializable);
                        jobCompletionInfo = this.makeInfo((JobProcess)((Object)object));
                        jobCompletionInfo.setCompletionCode('F');
                        jobCompletionInfo.setFailedAtCommandSequence(((JobProcess)((Object)object)).getFailedAtCommandSequence());
                        jobCompletionInfo.setTerminationReason("The agent ended while running the job.");
                        jobCompletionInfo.setJobEndedReasonCode(JobEndedReasonCode.AGENT_ENDED);
                        jobCompletionInfo.setTerminatedByServer(((JobProcess)((Object)object)).wasTerminatedByServer());
                    } else {
                        object = "null";
                        if (serializable != null) {
                            object = serializable.getClass().getName();
                        }
                        logger.debug((Object)("Ignoring unexpected object in off-line job info map: " + (String)object));
                        continue;
                    }
                    logger.trace((Object)("Processing offline completion info for job event ID " + jobCompletionInfo.getExecutableJob().getEventID()));
                    this.sendCompletion(jobCompletionInfo, peerID, true);
                    continue;
                }
                catch (Exception exception) {
                    bl = false;
                    logger.warn((Object)("Unable to restore off-line job completion information for Job-Event " + string), (Throwable)exception);
                }
            }
            if (bl) {
                this.cleanupOfflineInfo();
            }
        }
    }

    private synchronized void cleanupOfflineInfo() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Performing cleanup of offline completion info...");
            }
            this.durableMap.clear();
            this.oldEventSet.clear();
            String string = "joblogtmp";
            if (AgentControl.isWindows()) {
                string = DefaultConfigPath.getDefaultPath() + File.separator + string;
            }
            File file = new File(string);
            File[] fileArray = file.listFiles();
            String string2 = this.myPeerID.getInstanceIdentifier() + "_";
            String string3 = ".sz";
            for (File file2 : fileArray) {
                String string4 = file2.getName();
                if (!string4.startsWith(string2) || !string4.endsWith(string3)) continue;
                logger.trace((Object)("Deleting offline info file: " + file2.getAbsolutePath()));
                if (file2.delete()) continue;
                logger.debug((Object)("Unable to delete log file: " + file2.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"Unable to clear the off-line job info ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sapXMIAuditLevelChange(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        Set<JobProcess> set = this.processSet;
        synchronized (set) {
            for (JobProcess jobProcess : this.processSet) {
                jobProcess.notifySAPXMIAuditLevelChange(l, sAPXMIAuditLevel);
            }
        }
    }

    @Override
    public PeerID getPeerID() {
        return this.myPeerID;
    }

    class AgentBacklogProcessor
    implements Runnable {
        PeerID enterpriseServer = null;
        Object lock = "";

        AgentBacklogProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnterpriseServer(PeerID peerID) {
            Object object = this.lock;
            synchronized (object) {
                this.enterpriseServer = peerID;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                Thread.currentThread().setName("Agent Backlog Processor");
                try {
                    if (this.enterpriseServer == null) break block5;
                    Object object = this.lock;
                    synchronized (object) {
                        JobExecDMImpl.this.sendOfflineCompletion(this.enterpriseServer);
                    }
                }
                catch (Exception exception) {
                    logger.warn((Object)"Agent backlog processor encountered an error.", (Throwable)exception);
                }
            }
        }
    }

    class MyPeerListener
    extends PeerEventListener {
        MyPeerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void peerConnected(PeerID peerID, PeerID peerID2) {
            if (peerID.getPeerDescriptor().getType() == 6) {
                try {
                    JobExecDMImpl.this.sendOfflineCompletion(peerID);
                }
                catch (Exception exception) {
                    logger.warn((Object)"Unable to send offline job completion events", (Throwable)exception);
                }
                int n = 180;
                if (JobExecDMImpl.this.backlogProcessor == null) {
                    JobExecDMImpl.this.backlogProcessor = new AgentBacklogProcessor();
                    JobExecDMImpl.this.backlogProcessor.setEnterpriseServer(peerID);
                    JobExecDMImpl.this.backlogExecutor = new ScheduledThreadPoolExecutor(1);
                    JobExecDMImpl.this.scheduleTask = JobExecDMImpl.this.backlogExecutor.scheduleWithFixedDelay(JobExecDMImpl.this.backlogProcessor, n, n, TimeUnit.SECONDS);
                } else {
                    if (JobExecDMImpl.this.scheduleTask != null) {
                        JobExecDMImpl.this.scheduleTask.cancel(false);
                    }
                    JobExecDMImpl.this.backlogProcessor.setEnterpriseServer(peerID);
                    JobExecDMImpl.this.scheduleTask = JobExecDMImpl.this.backlogExecutor.scheduleWithFixedDelay(JobExecDMImpl.this.backlogProcessor, n, n, TimeUnit.SECONDS);
                }
            } else if (peerID.getPeerDescriptor().getType() == 3) {
                String string = peerID.getInstanceIdentifier().toString();
                boolean bl = true;
                if (string.startsWith("ENTERPRISE.AgentConditionsAM")) {
                    string = string.replace("ENTERPRISE.AgentConditionsAM", "");
                    bl = false;
                }
                long l = 0L;
                try {
                    l = Long.parseLong(string);
                }
                catch (Exception exception) {
                    logger.debug((Object)("The connected peer " + peerID + " is not a file peer."));
                    return;
                }
                logger.debug((Object)("Found process ID: " + l));
                Set set = JobExecDMImpl.this.processSet;
                synchronized (set) {
                    for (JobProcess jobProcess : JobExecDMImpl.this.processSet) {
                        if (jobProcess.getWhenStarted() != l) continue;
                        if (jobProcess.getCompletionCode() == ' ') {
                            if (bl) {
                                jobProcess.filePeerConnected(peerID);
                                break;
                            }
                            jobProcess.jobConditionsPeerConnected(peerID);
                            break;
                        }
                        JobExecDMImpl.this.myPeer.disconnectFromPeer(peerID);
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void peerDisconnected(PeerID peerID, PeerID peerID2) {
            if (peerID.getPeerDescriptor().getType() == 3) {
                long l = 0L;
                try {
                    l = Long.parseLong(peerID.getInstanceIdentifier().toString());
                }
                catch (Exception exception) {
                    return;
                }
                Object object = JobExecDMImpl.this.processSet;
                synchronized (object) {
                    for (JobProcess jobProcess : JobExecDMImpl.this.processSet) {
                        if (jobProcess.getWhenStarted() != l) continue;
                        jobProcess.finishJob();
                        break;
                    }
                }
            }
            if (peerID.getPeerDescriptor().getType() == 6) {
                Set set = JobExecDMImpl.this.processSet;
                synchronized (set) {
                    for (Object object : JobExecDMImpl.this.processSet) {
                        PeerID peerID3 = ((JobProcess)((Object)object)).getFilePeerID();
                        if (peerID3 == null) continue;
                        JobExecDMImpl.this.myPeer.disconnectFromPeer(peerID3);
                    }
                }
                if (JobExecDMImpl.this.backlogProcessor != null) {
                    JobExecDMImpl.this.backlogProcessor.setEnterpriseServer(null);
                }
            }
        }
    }
}

