/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ExistsAlreadyException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.event.PeerEventListener;
import com.helpsystems.enterprise.access.ibmi.IBMiJobDMImpl;
import com.helpsystems.enterprise.access.ibmi.IBMiJobExecDMHelper;
import com.helpsystems.enterprise.access.ibmi.IBMiJobStateMonitor;
import com.helpsystems.enterprise.access.ibmi.IBMiJobStatusMonitor;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.IBMiCallException;
import com.helpsystems.enterprise.core.busobj.JobData;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobLogHeader;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.dm.AgentCommandAM;
import com.helpsystems.enterprise.core.dm.IBMiJobDM;
import com.helpsystems.enterprise.core.dm.IBMiJobExecDM;
import com.helpsystems.enterprise.core.dm.JobCompletionDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMarkRunningAM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobCompletionInfo;
import com.helpsystems.enterprise.core.exec.JobTimer;
import com.helpsystems.enterprise.core.ibmi.IBMiJobIdentifier;
import com.helpsystems.enterprise.core.ibmi.IBMiJobNotFoundException;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.module.exec.Log4jLogFile;
import com.helpsystems.enterprise.module.exec.LogFile;
import com.helpsystems.enterprise.peer.AgentCredentials;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class IBMiJobExecDMImpl
extends AbstractManager
implements IBMiJobExecDM {
    private static final Logger logger = Logger.getLogger(IBMiJobExecDMImpl.class);
    private Map<Long, CachedJobInfo> jobCache = new HashMap<Long, CachedJobInfo>();
    private Map<Long, LogFile> logFileCache = new HashMap<Long, LogFile>();
    private IBMiJobExecDMHelper helper = new IBMiJobExecDMHelper();
    private IBMiJobDM jobDM = new IBMiJobDMImpl();
    private IBMiJobStatusMonitor jobStatusMonitor = new IBMiJobStatusMonitor(this);
    private Thread jobStatusMonitorThread;
    private IBMiJobStateMonitor jobStateMonitor = new IBMiJobStateMonitor(this, this.jobDM);
    private Thread jobStateMonitorThread;
    private AgentPeer myPeer;
    private PeerID myPeerID;
    private Object pauseLock = new Object();

    public IBMiJobExecDMImpl(AgentPeer agentPeer) {
        this.myPeer = agentPeer;
        this.myPeerID = agentPeer.getRemotePeerID();
        this.setName("ENTERPRISE.JobExecDM");
        agentPeer.addListener((SimpleEventListener)new MyPeerListener());
        this.initLogDirectory();
    }

    @Override
    public int activeJobCount() {
        try {
            return this.helper.activeJobCount();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Unable to obtain the active job count.", (Throwable)resourceUnavailableException);
            return 0;
        }
    }

    @Override
    public void bypassConditions(String string, String string2) {
        throw new IllegalStateException("The bypassConditions method is not supported on an IBMi agent.");
    }

    @Override
    public void endJob(String string) {
        throw new IllegalStateException("Program error: Call the method that takes an eventID and user instead.");
    }

    @Override
    public void endJob(String string, String string2) {
        JobCompletionDM jobCompletionDM;
        Object object;
        ValidationHelper.checkForNull((String)"Event ID", (Object)string);
        ValidationHelper.checkForNull((String)"User", (Object)string2);
        logger.debug((Object)MessageUtil.formatMsg((String)"Received request from {0} to end the job with run ID {1}.", (Object[])new Object[]{string2, string}));
        long l = IBMiJobExecDMImpl.parseJobHistoryID(string);
        JobData jobData = null;
        try {
            jobData = this.helper.getJobData(l);
        }
        catch (NoDataException noDataException) {
            logger.info((Object)MessageUtil.formatMsg((String)"A request was made to end the job with run ID {0}. However, information on that job run can no longer be located on the agent.", (Object[])new Object[]{l}));
            return;
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while attempting to end the job with run ID {0}.", (Object[])new Object[]{l}), (Throwable)exception);
            return;
        }
        String string3 = !string2.contains("by user") && !string2.contains("Job Monitor") ? "by user " + string2 : (string2.contains("Job Monitor") ? "by the " + string2 : string2);
        String string4 = MessageUtil.formatMsg((String)"Job termination requested {0}.", (Object[])new Object[]{string3});
        LogFile logFile = this.logFile(l);
        logFile.write(this.timestampedMessage(string4));
        IBMiJobIdentifier iBMiJobIdentifier = jobData.getJobIdentifier();
        if (iBMiJobIdentifier.getJobNumber().isEmpty()) {
            logger.error((Object)MessageUtil.formatMsg((String)"A request was made to end run {0} of job {1}. However, the job identifier information is not yet available. The job will not be ended.", (Object[])new Object[]{l, jobData.getJobName()}));
            logFile.write(this.timestampedMessage("Unable to issue an ENDJOB request. The IBM i job identifier has not yet been assigned."));
            return;
        }
        String string5 = MessageUtil.formatMsg((String)"ENDJOB JOB({0}) OPTION(*IMMED)", (Object[])new Object[]{iBMiJobIdentifier});
        logFile.write(this.timestampedMessage(MessageUtil.formatMsg((String)"Issued command {0}.", (Object[])new Object[]{string5})));
        try {
            String string6 = this.helper.terminateJob(iBMiJobIdentifier);
            logger.debug((Object)string6);
            logFile.write(string6);
            if (!string6.contains("CPC1232")) {
                return;
            }
        }
        catch (Exception exception) {
            String string7 = "Unable to terminate the job, due to an error.";
            if (exception instanceof IBMiCallException) {
                logFile.write(string7);
                logFile.write(exception.getMessage());
                object = ((IBMiCallException)exception).getAS400Messages();
                logFile.write((String[])object);
            }
            logFile.write(string7, exception);
        }
        long l2 = System.currentTimeMillis();
        logFile.writeJobEndedAndClose(l2);
        this.processIBMiJobLog(iBMiJobIdentifier, logFile);
        this.removeCachedEntries(l);
        this.removeDBEntries(l);
        object = this.makeInfo(jobData);
        ((JobCompletionInfo)((Object)object)).setWhenEnded(l2);
        ((JobCompletionInfo)((Object)object)).setJobLogFilename(this.logFileVerifiedName(logFile));
        ((JobCompletionInfo)((Object)object)).setCompletionCode('A');
        boolean bl = false;
        if (this.isConnectedToServer() && (jobCompletionDM = this.getJobCompletionDM()) != null) {
            jobCompletionDM.jobCompleted(l, jobData.getServerInitiatedTime(), jobData.getQueueEndedTime(), (JobCompletionInfo)((Object)object));
            bl = true;
        }
        if (!bl) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to notify the server of the results of trying to terminate run {0} of job {1}. Consequently, the job log was not copied to the server. However, it should still exist on the agent, at {2}.", (Object[])new Object[]{l, jobData.getJobName(), this.logFileVerifiedName(logFile)}));
        }
    }

    @Override
    public void finishJob(String string) {
        logger.error((Object)"The finishJob method is not supported on an IBMi agent.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteFile getJobLog(String string) {
        Object object;
        long l = IBMiJobExecDMImpl.parseJobHistoryID(string);
        File file = null;
        Object object2 = this.logFileCache;
        synchronized (object2) {
            object = this.logFileCache.get(l);
            if (object != null) {
                file = ((LogFile)object).getFile();
            }
        }
        if (file == null) {
            object2 = null;
            try {
                object2 = this.getJobData(l);
            }
            catch (ActionFailedException actionFailedException) {
                // empty catch block
            }
            if (object2 != null) {
                object = ((JobData)object2).getLogFilePathAndName();
                file = new File((String)object);
            }
        }
        if (file != null && file.exists()) {
            return new RemoteFile(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJobLogFilename(long l) {
        LogFile logFile;
        long l2 = this.jobHistoryID(l);
        Object object = this.logFileCache;
        synchronized (object) {
            logFile = this.logFileCache.get(l2);
        }
        object = null;
        if (logFile != null) {
            object = this.logFileVerifiedName(logFile);
        }
        if (object == null) {
            JobData[] jobDataArray = null;
            try {
                jobDataArray = this.helper.getActiveJobs();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                // empty catch block
            }
            if (jobDataArray != null) {
                for (JobData jobData : jobDataArray) {
                    if (jobData.getAgentStartedTime() != l) continue;
                    object = jobData.getLogFilePathAndName();
                    File file = new File((String)object);
                    if (file.exists()) break;
                    logger.warn((Object)("Unable to find job log file: " + (String)object));
                    object = null;
                    break;
                }
            }
        }
        return object;
    }

    @Override
    public PeerID getPeerID() {
        return this.myPeerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasJob(String string) {
        ValidationHelper.checkForNull((String)"Event ID", (Object)string);
        long l = IBMiJobExecDMImpl.parseJobHistoryID(string);
        Object object = this.jobCache;
        synchronized (object) {
            if (this.jobCache.containsKey(l)) {
                return true;
            }
        }
        object = null;
        try {
            object = this.getJobData(l);
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        return object != null;
    }

    @Override
    public Map<JobTimer, ExecutableJob> listJobs() {
        HashMap<JobTimer, ExecutableJob> hashMap = new HashMap<JobTimer, ExecutableJob>();
        JobData[] jobDataArray = null;
        try {
            jobDataArray = this.helper.getActiveJobs();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Unable to get a list of active jobs.", (Throwable)resourceUnavailableException);
        }
        if (jobDataArray != null) {
            for (JobData jobData : jobDataArray) {
                ExecutableJob executableJob = new ExecutableJob();
                executableJob.setEventID(String.valueOf(jobData.getJobHistoryID()));
                executableJob.setJobUser("");
                ScheduleJob scheduleJob = new ScheduleJob();
                scheduleJob.setName(jobData.getJobName());
                executableJob.setScheduleJob(scheduleJob);
                JobTimer jobTimer = new JobTimer();
                jobTimer.setWhenStarted(jobData.getAgentStartedTime());
                jobTimer.setTerminating(jobData.wasTerminatedByServer());
                hashMap.put(jobTimer, executableJob);
            }
        }
        return hashMap;
    }

    public void managerRemoved() {
        this.endTheJobStatusMonitor();
        this.endTheJobStateMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfJobStatusChange(long l, char c, IBMiJobIdentifier iBMiJobIdentifier, long l2, int n) {
        LogFile logFile;
        if (c == 'S') {
            return;
        }
        LogFile logFile2 = logFile = this.logFile(l);
        synchronized (logFile2) {
        }
        boolean bl = false;
        do {
            if (this.isConnectedToServer()) {
                try {
                    boolean bl2 = false;
                    switch (c) {
                        case 'R': {
                            CachedJobInfo cachedJobInfo;
                            Object object;
                            this.logStatusChange(c, l2, iBMiJobIdentifier, logFile);
                            JobMarkRunningAM jobMarkRunningAM = this.getJobMarkRunningAM();
                            if (jobMarkRunningAM != null) {
                                object = this.jobCache;
                                synchronized (object) {
                                    cachedJobInfo = this.jobCache.get(l);
                                }
                                if (cachedJobInfo != null) {
                                    jobMarkRunningAM.markJobAsRunning(cachedJobInfo.getJobHistory(), cachedJobInfo.getScheduleJob(), l2);
                                } else {
                                    jobMarkRunningAM.markJobAsRunning(l, l2);
                                }
                                bl = true;
                                break;
                            }
                            logger.warn((Object)MessageUtil.formatMsg((String)"Unable to notify the server that the job with run ID {0} has started running. Will auto retry.", (Object[])new Object[]{l}));
                            break;
                        }
                        case 'F': {
                            bl2 = true;
                        }
                        case 'C': {
                            JobCompletionDM jobCompletionDM;
                            CachedJobInfo cachedJobInfo;
                            this.logStatusChange(c, l2, iBMiJobIdentifier, logFile);
                            logFile.writeJobEndedAndClose(l2);
                            Object object = null;
                            Object object2 = this.jobCache;
                            synchronized (object2) {
                                cachedJobInfo = this.jobCache.get(l);
                            }
                            if (cachedJobInfo != null) {
                                object2 = this.makeInfo(cachedJobInfo);
                            } else {
                                object = this.getJobData(l);
                                object2 = this.makeInfo((JobData)object);
                            }
                            ((JobCompletionInfo)((Object)object2)).setJobLogFilename(this.logFileVerifiedName(logFile));
                            ((JobCompletionInfo)((Object)object2)).setCompletionCode(c);
                            ((JobCompletionInfo)((Object)object2)).setWhenEnded(l2);
                            if (n > 0) {
                                ((JobCompletionInfo)((Object)object2)).setFailedAtCommandSequence(n);
                                ((JobCompletionInfo)((Object)object2)).setJobEndedReasonCode(JobEndedReasonCode.COMMAND_FAILURE);
                            }
                            boolean bl3 = false;
                            if (cachedJobInfo != null && cachedJobInfo.getScheduleJob() != null && cachedJobInfo.getScheduleJob().isSendCompleteEmail() && cachedJobInfo.getScheduleJob().isSendCompleteJobLog()) {
                                bl3 = true;
                            }
                            if (((JobCompletionInfo)((Object)object2)).getExecutableJob().isCopyJobLogToServer() || bl3 || bl2) {
                                this.processIBMiJobLog(iBMiJobIdentifier, logFile);
                            }
                            if ((jobCompletionDM = this.getJobCompletionDM()) != null) {
                                if (cachedJobInfo != null) {
                                    jobCompletionDM.jobCompleted((JobCompletionInfo)((Object)object2));
                                } else {
                                    jobCompletionDM.jobCompleted(l, ((JobData)object).getServerInitiatedTime(), ((JobData)object).getQueueEndedTime(), (JobCompletionInfo)((Object)object2));
                                }
                                this.removeCachedEntries(l);
                                this.removeDBEntries(l);
                                bl = true;
                                break;
                            }
                            logger.warn((Object)MessageUtil.formatMsg((String)"Unable to notify the server that the job with run ID {0} has completed. Will auto retry.", (Object[])new Object[]{l}));
                            break;
                        }
                        default: {
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Status {0} is not supported by this method.", (Object[])new Object[]{Character.valueOf(c)}));
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to notify the server that the job with run ID {0} has changed status to {1}. The status change message will be removed.", (Object[])new Object[]{l, Character.valueOf(c)}), (Throwable)exception);
                    if (c != 'R') {
                        this.removeCachedEntries(l);
                    }
                    bl = true;
                }
                continue;
            }
            logger.debug((Object)MessageUtil.formatMsg((String)"Unable to notify the server that the job with run ID {0} has changed status to {1}, because the server is offline. Will retry as soon as the connection to the server is re-established.", (Object[])new Object[]{l, Character.valueOf(c)}));
            this.pause();
        } while (!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfJobEndedOrNotFound(long l, IBMiJobIdentifier iBMiJobIdentifier) {
        if (this.isConnectedToServer()) {
            LogFile logFile = this.logFile(l);
            Object object = logFile;
            synchronized (object) {
            }
            logFile.write("The Job State Monitor detected that this job, which it thought was active, has ended. It was likely ended via the IBM i ENDJOB command.");
            logFile.writeJobEndedAndClose();
            this.processIBMiJobLog(iBMiJobIdentifier, logFile);
            JobData jobData = null;
            Object object2 = this.jobCache;
            synchronized (object2) {
                object = this.jobCache.get(l);
            }
            if (object != null) {
                object2 = this.makeInfo((CachedJobInfo)object);
            } else {
                try {
                    jobData = this.getJobData(l);
                }
                catch (ActionFailedException actionFailedException) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to notify the server that the job with run ID {0} has ended.", (Object[])new Object[]{l}), (Throwable)actionFailedException);
                    this.removeCachedEntries(l);
                }
                object2 = this.makeInfo(jobData);
            }
            ((JobCompletionInfo)((Object)object2)).setJobLogFilename(this.logFileVerifiedName(logFile));
            ((JobCompletionInfo)((Object)object2)).setCompletionCode('F');
            ((JobCompletionInfo)((Object)object2)).setJobEndedReasonCode(JobEndedReasonCode.ENDED_MANUALLY);
            JobCompletionDM jobCompletionDM = this.getJobCompletionDM();
            if (jobCompletionDM != null) {
                if (object != null) {
                    jobCompletionDM.jobCompleted((JobCompletionInfo)((Object)object2));
                } else {
                    jobCompletionDM.jobCompleted(l, jobData.getServerInitiatedTime(), jobData.getQueueEndedTime(), (JobCompletionInfo)((Object)object2));
                }
                this.removeCachedEntries(l);
                this.removeDBEntries(l);
            }
        }
    }

    @Override
    public void notifyOfRunningJobWaitingOrHeld(long l, String string) {
        logger.info((Object)MessageUtil.formatMsg((String)"The agent has been notified that the job with runID {0} is in the following active sub-status - {1}.", (Object[])new Object[]{l, string}));
    }

    @Override
    public void notifyServerOfError() {
        AgentCommandAM agentCommandAM;
        if (this.isConnectedToServer() && (agentCommandAM = this.getAgentCommandAM()) != null) {
            try {
                agentCommandAM.notifyServerOfAgentError(this.getAgentName());
            }
            catch (Exception exception) {
                logger.warn((Object)"Unable to notify the server of an agent error, because of a server error.", (Throwable)exception);
            }
            return;
        }
        logger.warn((Object)"Unable to notify the server of an agent error, because the server is offline.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long run(ExecutableJob executableJob) throws SubmitFailedException {
        LogFile logFile;
        ValidationHelper.checkForNull((String)"Executable Job", (Object)((Object)executableJob));
        if (this.myPeer.isShutdownRequested()) {
            throw new SubmitFailedException("The agent is shutting down.", SubmitFailedException.Reason.SHUTDOWN_IN_PROGRESS);
        }
        long l = System.currentTimeMillis();
        executableJob.setAgentStartedTime(l);
        long l2 = executableJob.getJobHistory().getId();
        if (executableJob.getJobHistory().isNeedToCheckIfJobRunHasStarted()) {
            logger.info((Object)MessageUtil.formatMsg((String)"The server is requesting that job {0}, with run ID {1} be run and it is also indicating that it had previously requested to run this same job/run but communication was lost before it could be informed of what the disposition was and it was therefore put back on the queue.", (Object[])new Object[]{executableJob.getScheduleJob().getSkybotJobName(), l2}));
            if (this.hasBeenSubmittedToIBMi(l2)) {
                throw new SubmitFailedException(MessageUtil.formatMsg((String)"A request was received to run job {0}, with run ID {1}, but it has already started, based on a previous request.", (Object[])new Object[]{executableJob.getScheduleJob().getSkybotJobName(), l2}), SubmitFailedException.Reason.JOB_ALREADY_STARTED);
            }
            this.removeCachedEntries(l2);
            try {
                this.helper.removeJobInfoAndCommands(l2);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = "Error while trying to clean up job and command entries in the database.";
                this.submissionError(new Log4jLogFile(logger), string, (Exception)((Object)resourceUnavailableException), executableJob);
                return l;
            }
            try {
                this.deleteLogFile(this.logFileName(executableJob));
            }
            catch (ActionFailedException actionFailedException) {
                logger.error((Object)"Unable to delete the job log file.", (Throwable)actionFailedException);
            }
        }
        try {
            logFile = this.createLogFile(this.logFileName(executableJob));
        }
        catch (ExistsAlreadyException existsAlreadyException) {
            logger.error((Object)MessageUtil.formatMsg((String)"Trying to create the job log file {0}, but it already exists. All log entries for this job run will be written to the Agent log.", (Object[])new Object[]{this.logFileName(executableJob)}));
            logFile = new Log4jLogFile(logger);
        }
        JobLogHeader jobLogHeader = this.createJobLogHeader(executableJob);
        logFile.write(jobLogHeader.toStringArray());
        this.logUnsupportedFeatures(logFile, executableJob);
        String string = logFile.getFile().getAbsolutePath();
        try {
            this.helper.writeJobInfo(executableJob, string);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = "Error while trying to write the job information to the database.";
            this.submissionError(logFile, string2, (Exception)((Object)resourceUnavailableException), executableJob);
            return l;
        }
        try {
            this.helper.writeCommands(executableJob);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string3 = "Error while trying to write the commands to the database.";
            this.submissionError(logFile, string3, (Exception)((Object)resourceUnavailableException), executableJob);
            return l;
        }
        Object object = this.logFileCache;
        synchronized (object) {
            this.logFileCache.put(l2, logFile);
        }
        object = this.jobCache;
        synchronized (object) {
            this.jobCache.put(l2, new CachedJobInfo(executableJob));
        }
        object = null;
        try {
            LogFile logFile2 = logFile;
            synchronized (logFile2) {
                object = this.helper.submitJob(executableJob);
                long l3 = System.currentTimeMillis();
                this.logStatusChange('S', l3, (IBMiJobIdentifier)object, logFile);
            }
        }
        catch (Exception exception) {
            String string4 = "Error while trying to submit the job.";
            this.submissionError(logFile, string4, exception, executableJob);
            return l;
        }
        this.notifyServerOfJobIdentifier(l2, (IBMiJobIdentifier)object, logFile);
        return l;
    }

    @Override
    public void sapXMIAuditLevelChange(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        throw new IllegalStateException("The sapXMIAuditLevelChange method is not supported on an IBMi agent.");
    }

    private JobLogHeader createJobLogHeader(ExecutableJob executableJob) {
        ValidationHelper.checkForNull((String)"Executable Job", (Object)((Object)executableJob));
        AgentEnvironment agentEnvironment = executableJob.getSharedAgentEnvironment();
        String string = "<private>";
        if (agentEnvironment != null) {
            string = agentEnvironment.getName();
        }
        JobLogHeader jobLogHeader = new JobLogHeader(executableJob.getAgentStartedTime(), executableJob.getJobHistory().getJobName(), executableJob.getScheduleJob().getSkybotJobNumber(), executableJob.getScheduleJob().getDescription(), executableJob.getJobHistory().getJobParameters(), executableJob.getEventID(), string, executableJob.getAgent().getName(), System.getProperty("user.name"), executableJob.getAgent().getOperatingSystem(), executableJob.getAgent().getVersion(), this.serverName(executableJob.getServerPeerID()));
        return jobLogHeader;
    }

    private LogFile createLogFile(String string) throws ExistsAlreadyException {
        String string2 = "joblogtmp";
        try {
            return new LogFile(string, string2, false);
        }
        catch (ExistsAlreadyException existsAlreadyException) {
            throw existsAlreadyException;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error while trying to create job log file.", exception);
        }
    }

    private void deleteLogFile(String string) throws ActionFailedException {
        String string2 = "joblogtmp";
        String string3 = string2 + "/" + string + ".log";
        File file = new File(string3);
        if (file.exists() && !file.delete()) {
            throw new ActionFailedException(MessageUtil.formatMsg((String)"Unable to delete file {0}.", (Object[])new Object[]{file.getAbsolutePath()}));
        }
    }

    private void endTheJobStatusMonitor() {
        if (this.isJobStatusMonitorActive()) {
            try {
                this.jobStatusMonitor.endMonitor();
            }
            catch (ActionFailedException actionFailedException) {
                this.jobStatusMonitorThread.interrupt();
            }
        }
        this.jobStatusMonitorThread = null;
    }

    private void endTheJobStateMonitor() {
        if (this.isJobStateMonitorActive()) {
            this.jobStateMonitor.endMonitor();
        }
        this.jobStateMonitorThread = null;
    }

    private AgentCommandAM getAgentCommandAM() {
        try {
            return (AgentCommandAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.serverPeerID(), (String)"ENTERPRISE.AgentCommandAM");
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to communicate with the server ", (Throwable)exception);
            return null;
        }
    }

    private String getAgentName() {
        try {
            String string;
            AgentCredentials agentCredentials = new AgentCredentials();
            agentCredentials.loadDefaultAgentSpecifiedName();
            AgentPeerConfig agentPeerConfig = (AgentPeerConfig)this.myPeer.getConfig();
            String string2 = agentPeerConfig.getSpecifiedAgentName();
            if (string2 != null && string2.trim().length() > 0) {
                agentCredentials.setAgentSpecifiedName(string2);
            }
            if ((string = agentCredentials.getAgentSpecifiedName()) == null || string.trim().isEmpty()) {
                string = this.myPeer.getPeerDescriptor().getComputerName();
            }
            if (string == null || string.trim().isEmpty()) {
                string = this.myPeer.getPeerDescriptor().findPrintableAddress();
            }
            if ((string = string.split("\\.")[0].toUpperCase()).length() > 50) {
                string = string.substring(0, 50);
            }
            return string;
        }
        catch (Exception exception) {
            logger.error((Object)"Error constructing the agent name.", (Throwable)exception);
            return "?";
        }
    }

    private JobCompletionDM getJobCompletionDM() {
        try {
            return (JobCompletionDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.serverPeerID(), (String)"ENTERPRISE.JobCompletionDM");
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to communicate with the server ", (Throwable)exception);
            return null;
        }
    }

    private JobData getJobData(long l) throws ActionFailedException {
        JobData jobData = null;
        String string = "";
        Throwable throwable = null;
        try {
            jobData = this.helper.getJobData(l);
        }
        catch (NoDataException noDataException) {
            string = MessageUtil.formatMsg((String)"Cannot find the job with run ID {0} in the SKYJOB table.", (Object[])new Object[]{l});
            throwable = noDataException;
        }
        catch (BadDataException badDataException) {
            string = MessageUtil.formatMsg((String)"Corrupt data in the SKYJOB table for the job with run ID {0}.", (Object[])new Object[]{l});
            throwable = badDataException;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            string = MessageUtil.formatMsg((String)"Unable to read the data in the SKYJOB table for the job with run ID {0}.", (Object[])new Object[]{l});
            throwable = resourceUnavailableException;
        }
        if (jobData == null) {
            if (throwable != null) {
                throw new ActionFailedException(string, throwable);
            }
            throw new ActionFailedException(MessageUtil.formatMsg((String)"Unable to read the data in the SKYJOB table for the job with run ID {0}.", (Object[])new Object[]{l}));
        }
        return jobData;
    }

    private JobHistoryDM getJobHistoryDM() {
        try {
            return (JobHistoryDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.serverPeerID(), (String)"ENTERPRISE.JobHistoryDM");
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to communicate with the server ", (Throwable)exception);
            return null;
        }
    }

    private JobMarkRunningAM getJobMarkRunningAM() {
        try {
            return (JobMarkRunningAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.serverPeerID(), (String)"ENTERPRISE.JobMarkRunningAM");
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to communicate with the server ", (Throwable)exception);
            return null;
        }
    }

    private boolean hasBeenSubmittedToIBMi(long l) {
        try {
            return !this.helper.getJobStatusCode(l).equals(" ");
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to determine if the job with run ID {0} has been submitted to IBM i. Will assume yes.", (Object[])new Object[]{l}));
            return true;
        }
        catch (NoDataException noDataException) {
            JobHistoryDM jobHistoryDM;
            if (this.isConnectedToServer() && (jobHistoryDM = this.getJobHistoryDM()) != null) {
                return jobHistoryDM.isJobRunningOrHasEnded(l);
            }
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to determine if the job with run ID {0} has been submitted to IBM i. Will assume yes.", (Object[])new Object[]{l}));
            return true;
        }
    }

    private void initLogDirectory() {
        String string = "joblogtmp";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private boolean isConnectedToServer() {
        return this.myPeer.getConnectedAgentServer() != null;
    }

    private boolean isJobStatusMonitorActive() {
        return this.jobStatusMonitorThread != null;
    }

    private boolean isJobStateMonitorActive() {
        return this.jobStateMonitorThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long jobHistoryID(long l) {
        Map<Long, CachedJobInfo> map = this.jobCache;
        synchronized (map) {
            for (CachedJobInfo cachedJobInfo : this.jobCache.values()) {
                if (cachedJobInfo.getAgentStartedTime() != l) continue;
                return cachedJobInfo.getJobHistory().getId();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogFile logFile(long l) {
        Map<Long, LogFile> map;
        LogFile logFile;
        Object object = this.logFileCache;
        synchronized (object) {
            logFile = this.logFileCache.get(l);
        }
        object = null;
        if (logFile == null) {
            try {
                object = this.getJobData(l);
            }
            catch (ActionFailedException actionFailedException) {
                // empty catch block
            }
            if (object != null && (logFile = this.reattachToLogFile(((JobData)object).getLogFilePathAndName())) != null) {
                map = this.logFileCache;
                synchronized (map) {
                    this.logFileCache.put(l, logFile);
                }
            }
        }
        if (logFile == null) {
            logFile = new Log4jLogFile(logger);
            map = this.logFileCache;
            synchronized (map) {
                this.logFileCache.put(l, logFile);
                String string = MessageUtil.formatMsg((String)"Error: Could not reattach to the job log for the job with run ID {0}. Messages will be sent here for this job. ", (Object[])new Object[]{l});
                if (object != null) {
                    string = string + ((JobData)object).getJobIdentifier();
                }
                logFile.write(string);
            }
        }
        return logFile;
    }

    private String logFileName(ExecutableJob executableJob) {
        String string = executableJob.getAgent().getName();
        String string2 = executableJob.getJobHistory().getJobName();
        if (string2 == null) {
            string2 = executableJob.getScheduleJob().getName();
        }
        String string3 = executableJob.getEventID();
        return MessageUtil.formatMsg((String)"{0}_{1}_{2}", (Object[])new Object[]{string, string2, string3});
    }

    private String logFileVerifiedName(LogFile logFile) {
        File file = logFile.getFile();
        if (file != null) {
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            logger.warn((Object)("Unable to find job log file: " + file.getAbsolutePath()));
        }
        return null;
    }

    private void logStatusChange(char c, long l, IBMiJobIdentifier iBMiJobIdentifier, LogFile logFile) {
        String string;
        switch (c) {
            case 'S': {
                string = "submitted";
                break;
            }
            case 'R': {
                string = "started running";
                break;
            }
            case 'C': {
                string = "completed";
                break;
            }
            case 'F': {
                string = "failed";
                break;
            }
            default: {
                string = "status '" + c + "' unknown";
            }
        }
        String string2 = MessageUtil.formatMsg((String)"{0} - Job {1} {2}.", (Object[])new Object[]{DateTranslator.formatDateTimeWithTZ((Date)new Date(l)), iBMiJobIdentifier, string});
        logFile.write(string2);
        logger.debug((Object)string2);
    }

    private void logUnsupportedFeatures(LogFile logFile, ExecutableJob executableJob) {
        if (executableJob.isConditional()) {
            logFile.write("Job conditions are not supported on IBM i agents and will be ignored.");
        }
        if (executableJob.isIncludingOutputDistributions()) {
            logFile.write("Output Distributions are not supported on IBM i agents and will be ignored.");
        }
    }

    private JobCompletionInfo makeInfo(CachedJobInfo cachedJobInfo) {
        ExecutableJob executableJob = new ExecutableJob();
        executableJob.setJobHistory(cachedJobInfo.getJobHistory());
        executableJob.setScheduleJob(cachedJobInfo.getScheduleJob());
        executableJob.setAgent(cachedJobInfo.getAgent());
        executableJob.setAgentStartedTime(cachedJobInfo.getAgentStartedTime());
        executableJob.setCopyJobLogToServer(cachedJobInfo.isCopyJobLogToServer());
        executableJob.setEventID(String.valueOf(cachedJobInfo.getJobHistory().getId()));
        JobCompletionInfo jobCompletionInfo = new JobCompletionInfo(executableJob);
        jobCompletionInfo.setSupportingOutputDistribution(false);
        jobCompletionInfo.setPeerID(this.getPeerID());
        return jobCompletionInfo;
    }

    private JobCompletionInfo makeInfo(JobData jobData) {
        ExecutableJob executableJob = new ExecutableJob();
        executableJob.setAgentStartedTime(jobData.getAgentStartedTime());
        executableJob.setCopyJobLogToServer(jobData.isCopyJobLogToServer());
        executableJob.setEventID(String.valueOf(jobData.getJobHistoryID()));
        ScheduleJob scheduleJob = new ScheduleJob();
        scheduleJob.setSkybotJobNumber(jobData.getJobID());
        scheduleJob.setSkybotJobName(jobData.getJobName());
        executableJob.setScheduleJob(scheduleJob);
        JobCompletionInfo jobCompletionInfo = new JobCompletionInfo(executableJob);
        jobCompletionInfo.setSupportingOutputDistribution(false);
        jobCompletionInfo.setPeerID(this.getPeerID());
        return jobCompletionInfo;
    }

    private void notifyServerOfJobIdentifier(long l, IBMiJobIdentifier iBMiJobIdentifier, LogFile logFile) {
        if (iBMiJobIdentifier != null) {
            String string;
            String string2 = iBMiJobIdentifier.getJobName();
            String string3 = iBMiJobIdentifier.getJobUser();
            String string4 = iBMiJobIdentifier.getJobNumber();
            Exception exception = null;
            JobMarkRunningAM jobMarkRunningAM = this.getJobMarkRunningAM();
            if (jobMarkRunningAM != null) {
                try {
                    jobMarkRunningAM.addIBMiJobToJobHistory(l, string2, string3, string4);
                    return;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    string = "due to an error.";
                }
            } else {
                string = "because the server appears to be offline.";
            }
            String string5 = MessageUtil.formatMsg((String)"Unable to notify the server that the job with run ID {0} has been submitted, with job identifier {1}, ", (Object[])new Object[]{l, iBMiJobIdentifier});
            logger.error((Object)(string5 + string), (Throwable)exception);
            logFile.write(string5 + string, exception);
        }
    }

    private static long parseJobHistoryID(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to convert event ID {0} to a number.", (Object[])new Object[]{string}), (Throwable)numberFormatException);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause() {
        Object object = this.pauseLock;
        synchronized (object) {
            try {
                this.pauseLock.wait(this.pauseTime());
            }
            catch (InterruptedException interruptedException) {
                logger.warn((Object)"An attempt was made to interrupt this Thread. The request was ignored.", (Throwable)interruptedException);
            }
        }
    }

    private long pauseTime() {
        return TimeUnit.MINUTES.toMillis(1L);
    }

    private void processIBMiJobLog(IBMiJobIdentifier iBMiJobIdentifier, LogFile logFile) {
        String string = MessageUtil.formatMsg((String)"IBM i job log for {0}.", (Object[])new Object[]{iBMiJobIdentifier});
        String string2 = "Unable to append " + string;
        try {
            if (logFile.getFile() == null || !logFile.getFile().exists()) {
                logger.error((Object)"Log file either not specified or does not exist.");
                return;
            }
            String string3 = logFile.getFile().getAbsolutePath();
            this.helper.appendIBMiJobLog(iBMiJobIdentifier, string3);
        }
        catch (ActionFailedException actionFailedException) {
            logger.error((Object)actionFailedException);
        }
        catch (IBMiCallException iBMiCallException) {
            logger.error((Object)string2, (Throwable)iBMiCallException);
            String[] stringArray = iBMiCallException.getAS400Messages();
            for (int i = 0; i < stringArray.length; ++i) {
                logger.error((Object)stringArray[i]);
            }
        }
        catch (IBMiJobNotFoundException iBMiJobNotFoundException) {
        }
        catch (Exception exception) {
            logger.error((Object)"Unexpected error.", (Throwable)exception);
        }
    }

    private LogFile reattachToLogFile(String string) {
        try {
            return new LogFile(string, true);
        }
        catch (Exception exception) {
            logger.warn((Object)MessageUtil.formatMsg((String)"Unable to reattach to job log file {0}.", (Object[])new Object[]{string}), (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedEntries(long l) {
        Map<Long, Object> map = this.jobCache;
        synchronized (map) {
            this.jobCache.remove(l);
        }
        map = this.logFileCache;
        synchronized (map) {
            this.logFileCache.remove(l);
        }
    }

    private void removeDBEntries(long l) {
        try {
            this.helper.removeJobInfoAndCommands(l);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to remove all of the command entries and/or job information from the database for the job with run ID {0}.", (Object[])new Object[]{l}), (Throwable)resourceUnavailableException);
        }
    }

    private String serverName(PeerID peerID) {
        PeerDescriptor peerDescriptor = peerID.getPeerDescriptor();
        if (peerDescriptor != null) {
            return peerDescriptor.getPeerName();
        }
        return peerID.toString();
    }

    private PeerID serverPeerID() {
        PeerID peerID = this.myPeer.getConnectedAgentServer();
        if (peerID == null) {
            throw new IllegalStateException("Unable to determine the server peer ID since there is no connected server.");
        }
        return peerID;
    }

    private Thread startTheJobStatusMonitor() {
        if (this.isJobStatusMonitorActive()) {
            throw new IllegalStateException("Program error: Attempting to start the Job Status Monitor, but it is already active.");
        }
        String string = "IBM i Job Status Monitor";
        Thread thread = new Thread((Runnable)this.jobStatusMonitor, string);
        thread.setDaemon(true);
        thread.setPriority(5);
        thread.start();
        return thread;
    }

    private Thread startTheJobStateMonitor() {
        if (this.isJobStateMonitorActive()) {
            throw new IllegalStateException("Program error: Attempting to start the Job State Monitor, but it is already active.");
        }
        String string = "IBM i Job State Monitor";
        Thread thread = new Thread((Runnable)this.jobStateMonitor, string);
        thread.setDaemon(true);
        thread.setPriority(5);
        thread.start();
        return thread;
    }

    private String timestampedMessage(String string) {
        return MessageUtil.formatMsg((String)"{0} - {1}", (Object[])new Object[]{DateTranslator.formatDateTimeWithTZ((Date)new Date()), string});
    }

    private void submissionError(LogFile logFile, String string, Exception exception, ExecutableJob executableJob) {
        JobCompletionDM jobCompletionDM;
        String[] stringArray;
        long l = System.currentTimeMillis();
        if (exception instanceof IBMiCallException) {
            logFile.write(string);
            logFile.write(exception.getMessage());
            stringArray = ((IBMiCallException)exception).getAS400Messages();
            logFile.write(stringArray);
        } else {
            logFile.write(string, exception);
        }
        logFile.writeJobEndedAndClose(l);
        stringArray = new JobCompletionInfo(executableJob);
        stringArray.setCompletionCode('F');
        stringArray.setJobEndedReasonCode(JobEndedReasonCode.INITIALIZATION_FAILURE);
        stringArray.setWhenEnded(l);
        stringArray.setPeerID(this.getPeerID());
        stringArray.setJobLogFilename(this.logFileVerifiedName(logFile));
        boolean bl = false;
        if (this.isConnectedToServer() && (jobCompletionDM = this.getJobCompletionDM()) != null) {
            jobCompletionDM.jobCompleted((JobCompletionInfo)stringArray);
            bl = true;
            this.removeCachedEntries(executableJob.getJobHistory().getId());
            this.removeDBEntries(executableJob.getJobHistory().getId());
        }
        if (!bl) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to notify the server of the submission failure of job {0} with run ID {1}.", (Object[])new Object[]{executableJob.getScheduleJob().getName(), executableJob.getJobHistory().getId()}));
        }
    }

    private class MyPeerListener
    extends PeerEventListener {
        private MyPeerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void peerConnected(PeerID peerID, PeerID peerID2) {
            if (peerID.getPeerDescriptor().getType() == 6) {
                if (IBMiJobExecDMImpl.this.isJobStatusMonitorActive()) {
                    Object object = IBMiJobExecDMImpl.this.pauseLock;
                    synchronized (object) {
                        IBMiJobExecDMImpl.this.pauseLock.notify();
                    }
                } else {
                    IBMiJobExecDMImpl.this.jobStatusMonitorThread = IBMiJobExecDMImpl.this.startTheJobStatusMonitor();
                }
                if (!IBMiJobExecDMImpl.this.isJobStateMonitorActive()) {
                    IBMiJobExecDMImpl.this.jobStateMonitorThread = IBMiJobExecDMImpl.this.startTheJobStateMonitor();
                }
            }
        }

        protected void peerDisconnected(PeerID peerID, PeerID peerID2) {
        }
    }

    private class CachedJobInfo {
        private JobHistory jobHistory;
        private ScheduleJob scheduleJob;
        private Agent agent;
        private boolean copyJobLogToServer;
        private long agentStartedTime;

        private CachedJobInfo(ExecutableJob executableJob) {
            this.jobHistory = executableJob.getJobHistory();
            this.scheduleJob = executableJob.getScheduleJob();
            this.agent = executableJob.getAgent();
            this.copyJobLogToServer = executableJob.isCopyJobLogToServer();
            this.agentStartedTime = executableJob.getAgentStartedTime();
        }

        private Agent getAgent() {
            return this.agent;
        }

        private long getAgentStartedTime() {
            return this.agentStartedTime;
        }

        private boolean isCopyJobLogToServer() {
            return this.copyJobLogToServer;
        }

        private JobHistory getJobHistory() {
            return this.jobHistory;
        }

        private ScheduleJob getScheduleJob() {
            return this.scheduleJob;
        }
    }
}

