/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.DaemonThreadFactory;
import com.helpsystems.common.server.file.FileHandle;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.dm.FilePeerControlAM;
import com.helpsystems.enterprise.core.dm.FilePeerGatewayAM;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FilePeerGatewayAMImpl
extends AbstractManager
implements FilePeerGatewayAM {
    private static final Logger logger = Logger.getLogger(FilePeerGatewayAMImpl.class);
    ScheduledExecutorService connectionExecutor = null;
    private AgentPeer myPeer;
    private boolean NAME_SET;
    private FileCleanup fileCleanup;

    public FilePeerGatewayAMImpl(AgentPeer agentPeer) {
        this.myPeer = agentPeer;
        this.setName("ENTERPRISE.FilePeerGatewayAM");
    }

    @Override
    public FileHandle getHandle(PeerID peerID, String string, String string2) throws ActionFailedException {
        if (peerID == null) {
            return this.getLocalHandle(string, string2);
        }
        if (this.myPeer.getPeerFromRoutingTable(peerID) == null) {
            throw new ActionFailedException("Unable to obtain file handle from " + peerID + ", it is not connected to the agent.");
        }
        try {
            RemoteFileAM remoteFileAM = (RemoteFileAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"COMMON.RemoteFileAM");
            FileHandle fileHandle = remoteFileAM.getHandle(UserIdentity.NO_USER_SPECIFIED, string, string2);
            this.setFirstHop(fileHandle);
            return fileHandle;
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to get a remote file from " + peerID), (Throwable)exception);
            throw new ActionFailedException("Unable to obtain file handle from " + peerID, (Throwable)exception);
        }
    }

    @Override
    public void delete(PeerID peerID, String string) throws ActionFailedException {
        RemoteFileAM remoteFileAM = null;
        logger.debug((Object)("About to delete " + string + " on filePeerID:" + peerID));
        if (peerID == null) {
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            System.gc();
            boolean bl = file.delete();
            if (!bl) {
                if (this.connectionExecutor == null) {
                    this.connectionExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory("FileCleanupThread"));
                    this.fileCleanup = new FileCleanup();
                    this.connectionExecutor.scheduleWithFixedDelay(this.fileCleanup, 30L, 60L, TimeUnit.SECONDS);
                }
                this.fileCleanup.addEntry(string);
                throw new ActionFailedException("Unable to delete " + string);
            }
            if (this.fileCleanup != null) {
                this.fileCleanup.removeEntry(string);
            }
        } else {
            remoteFileAM = (RemoteFileAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"COMMON.RemoteFileAM");
            boolean bl = false;
            ActionFailedException actionFailedException = null;
            for (int i = 0; !bl && i < 12; ++i) {
                try {
                    remoteFileAM.delete(UserIdentity.NO_USER_SPECIFIED, string);
                    bl = true;
                    actionFailedException = null;
                    break;
                }
                catch (ActionFailedException actionFailedException2) {
                    actionFailedException = actionFailedException2;
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (actionFailedException != null) {
                throw actionFailedException;
            }
        }
    }

    private FileHandle getLocalHandle(String string, String string2) throws ActionFailedException {
        RemoteFileAM remoteFileAM = (RemoteFileAM)ManagerRegistry.getManager((String)"COMMON.RemoteFileAM");
        File file = new File(string);
        if (string2.indexOf("r") > -1 && !file.canRead()) {
            throw new ActionFailedException("Unable to read " + string);
        }
        if (string2.indexOf("w") > -1 && !file.canWrite()) {
            throw new ActionFailedException("Unable to write " + string);
        }
        return remoteFileAM.getHandle(UserIdentity.NO_USER_SPECIFIED, string, string2);
    }

    private void setFirstHop(FileHandle fileHandle) {
        Class<?> clazz = fileHandle.getClass();
        while (true) {
            try {
                Method method = clazz.getDeclaredMethod("setFirstHop", PeerID.class);
                method.invoke((Object)fileHandle, this.myPeer.getRemotePeerID());
                return;
            }
            catch (Exception exception) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new IllegalArgumentException("Unable to preset  route information on object " + fileHandle.getClass().getName());
            }
            break;
        }
    }

    @Override
    public void finished(PeerID peerID) throws ActionFailedException {
        try {
            FilePeerControlAM filePeerControlAM = (FilePeerControlAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.FilePeerControlAM");
            filePeerControlAM.finished();
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to tell the FilePeer " + peerID + " that this agent is finished with it."), (Throwable)exception);
            this.myPeer.disconnectFromPeer(peerID);
        }
    }

    private class FileCleanup
    implements Runnable {
        private String[] paths;
        private Map<String, String> latentDeleteFiles = Collections.synchronizedMap(new HashMap());

        private FileCleanup() {
        }

        public void addEntry(String string) {
            this.latentDeleteFiles.put(string, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEntry(String string) {
            File file = null;
            try {
                file = new File(string);
                if (!file.exists() && this.latentDeleteFiles.containsKey(string)) {
                    this.latentDeleteFiles.remove(string);
                }
            }
            catch (Exception exception) {
            }
            finally {
                file = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.latentDeleteFiles.isEmpty()) {
                return;
            }
            Map<String, String> map = this.latentDeleteFiles;
            synchronized (map) {
                if (!FilePeerGatewayAMImpl.this.NAME_SET) {
                    FilePeerGatewayAMImpl.this.NAME_SET = true;
                    Thread.currentThread().setName("Joblog Cleanup Thread");
                }
                this.paths = this.latentDeleteFiles.values().toArray(new String[0]);
                if (this.paths == null) {
                    return;
                }
            }
            for (int i = 0; i < this.paths.length; ++i) {
                try {
                    FilePeerGatewayAMImpl.this.delete(null, this.paths[i]);
                    continue;
                }
                catch (ActionFailedException actionFailedException) {
                    // empty catch block
                }
            }
            this.paths = null;
        }
    }
}

