/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.dm.AgentLogAM;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import com.helpsystems.enterprise.module.exec.AgentOutputWorker;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.File;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class AgentLogAMImpl
extends AbstractManager
implements AgentLogAM {
    private static final Logger logger = Logger.getLogger(AgentLogAMImpl.class);
    private StandbyBackupFileQueueAM standbyBackupFileQueueAM = null;

    public AgentLogAMImpl() {
        this.setName("ENTERPRISE.AgentLogAM");
    }

    @Override
    public void purge(long l, String string, String string2) throws ResourceUnavailableException {
        this.purgeAndGetParentDirectory(l, string, string2, 0L);
    }

    @Override
    public String purgeAndGetParentDirectory(long l, String string, String string2, long l2) throws ResourceUnavailableException {
        String string3 = "Purge JobLogs for Run ID: " + l + " failed to start.";
        String string4 = DefaultConfigPath.getServerDirectoryName((long)l2, (boolean)false);
        String string5 = DefaultConfigPath.getLogFile((String)string4, (long)l, (String)string, (String)string2, (long)l2, (boolean)false);
        logger.trace((Object)("Server Directory: " + string4 + " JOBENDED was " + l2));
        try {
            File file;
            if (string5 == null) {
                string3 = "Purge JobLogs for Run ID: " + l + " failed to find the " + string5 + ".";
                String string6 = null;
                return string6;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("About to purge JobLog file: " + string5));
            }
            if ((file = new File(string5)).exists()) {
                if (file.delete()) {
                    if (logger.isTraceEnabled()) {
                        string3 = "Joblog was deleted: " + file.getAbsolutePath();
                    }
                } else {
                    string3 = "Joblog was NOT deleted: " + file.getAbsolutePath();
                    logger.debug((Object)string3);
                }
                this.putStandbyBackupFileForDelete(string5);
                String string7 = string4;
                return string7;
            }
            string3 = string5 + " was not found to remove.";
            logger.debug((Object)("Joblog was NOT found for purge: " + file.getAbsolutePath()));
            String string8 = null;
            return string8;
        }
        catch (Exception exception) {
            String string9;
            string3 = string9 = "Unable to delete the JobLog file " + string5;
            throw new ResourceUnavailableException(string9, (Throwable)exception);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)string3);
            }
        }
    }

    @Override
    public String getTodaysParentDirectory() {
        return AgentOutputWorker.getServerDirectoryName(Calendar.getInstance().getTimeInMillis(), false);
    }

    @Override
    public String getVersionOneDirectory() {
        return DefaultConfigPath.getJobLogDirectory();
    }

    private void putStandbyBackupFileForDelete(String string) {
        StandbyBackupFile standbyBackupFile = new StandbyBackupFile();
        standbyBackupFile.setActionType(1);
        standbyBackupFile.setFileType(0);
        standbyBackupFile.setServerFileName(string);
        try {
            this.getStandbyBackupFileQueueAM().putStandbyBackupFile(standbyBackupFile);
        }
        catch (ActionFailedException actionFailedException) {
            logger.error((Object)"Can't put standby backup file in queue", (Throwable)actionFailedException);
        }
    }

    private StandbyBackupFileQueueAM getStandbyBackupFileQueueAM() {
        if (this.standbyBackupFileQueueAM == null) {
            this.standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.StandbyBackupFileQueueAM");
        }
        return this.standbyBackupFileQueueAM;
    }
}

