/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.license.SequelCommands;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.AgentEnvironmentVariable;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.AgentJobLog;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.busobj.CommandSet;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.OutputDistribution;
import com.helpsystems.enterprise.core.busobj.RunningJobLogException;
import com.helpsystems.enterprise.core.busobj.SkybotVariable;
import com.helpsystems.enterprise.core.busobj.SkybotVariableResolveException;
import com.helpsystems.enterprise.core.busobj.oracle.OracleExecutable;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutable;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEnvironmentDM;
import com.helpsystems.enterprise.core.dm.AgentEventHistoryInfoDM;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.dm.EnterpriseLicenseInfoAM;
import com.helpsystems.enterprise.core.dm.IBMiAgentEnvironmentDM;
import com.helpsystems.enterprise.core.dm.JobCompletionDM;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMarkRunningAM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.OutputDistributionDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.SkybotVariableDM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.core.dm.oracle.OracleServerHelperAM;
import com.helpsystems.enterprise.core.dm.sap.SAPServerHelperAM;
import com.helpsystems.enterprise.core.enums.CommandSetType;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobTimer;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.AgentEnvironmentType;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.util.JobParameterUtil;
import com.helpsystems.enterprise.module.IBMiExecutableJobHelper;
import com.helpsystems.enterprise.module.exec.ProcessUtil;
import com.helpsystems.enterprise.module.exec.RemoteFileCopier;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.File;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

class ExecutableJobHelper {
    private static Logger logger = Logger.getLogger(ExecutableJobHelper.class);
    private AgentPeer agentServer;
    private JobExecDM jobExecDM;
    private JobCompletionDM jobCompletionDM;
    private Agent agent;
    private ScheduleJobDM scheduleJobDM;
    private JobMarkRunningAM jobMarkRunningAM;
    private SAPServerHelperAM sapServerHelperAM;
    private EnterpriseLicenseInfo licenseInfo = null;
    private OracleServerHelperAM oracleServerHelperAM;
    private CalendarObjectDM calendarObjectDM;
    private IBMiExecutableJobHelper ibmiExecutableJobHelper;
    private JobHistoryDM jobHistoryDM;

    ExecutableJobHelper(AgentPeer agentPeer) {
        this.agentServer = agentPeer;
    }

    public ExecutableJobHelper(AgentPeer agentPeer, Agent agent, ScheduleJobDM scheduleJobDM) {
        this(agentPeer);
        this.agent = agent;
        this.scheduleJobDM = scheduleJobDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ExecutableJob loadJob(JobHistory jobHistory) throws ActionFailedException, SubmitFailedException {
        long l = jobHistory.getJobID();
        long l2 = jobHistory.getAgentID();
        long l3 = jobHistory.getId();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Loading job " + l + " for agent " + l2 + " - Event ID: " + l3));
        }
        if (l2 <= 0L) {
            throw new ActionFailedException("Agent ID missing from the request.");
        }
        if (l <= 0L) {
            throw new ActionFailedException("Job Number missing from the request.");
        }
        if (l3 <= 0L) {
            throw new ActionFailedException("Event ID missing from the request.");
        }
        ScheduleJob scheduleJob = null;
        try {
            Class<ExecutableJobHelper> clazz = ExecutableJobHelper.class;
            synchronized (ExecutableJobHelper.class) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                long l4;
                ScheduleJob scheduleJob2 = this.scheduleJobDM.get(l);
                // ** MonitorExit[clazz] (shouldn't be in output)
                if (scheduleJob2 == null) {
                    throw new ActionFailedException("Job " + l + " not found");
                }
                if (this.agent == null) {
                    throw new ActionFailedException("Agent " + l2 + " not found");
                }
                if (this.agentServer.searchForAgent((AgentProxy)this.agent) == null) {
                    throw new SubmitFailedException("Agent " + this.agent.getName() + " is not on-line.", SubmitFailedException.Reason.AGENT_OFFLINE);
                }
                if (!this.agentServer.isLicensedAndOnline((AgentProxy)this.agent)) {
                    throw new SubmitFailedException("Agent " + this.agent.getName() + " is not licensed to run jobs.", SubmitFailedException.Reason.INVALID_LICENSE);
                }
                if (scheduleJob2.getScheduleType().equals(ScheduleJobProxy.ScheduleType.CRON_EXPRESSION)) {
                    scheduleJob2.setScheduleType(ScheduleJobProxy.ScheduleType.UNSCHEDULED);
                }
                long l5 = jobHistory.getScheduledTime();
                if (scheduleJob2.getJobType() == JobType.SUITE_MEMBER && (scheduleJob = this.scheduleJobDM.getSuite(l4 = jobHistory.getJobSuiteID())).getVariableBaseDate() == 1) {
                    long l6 = jobHistory.getJobSuiteHistoryID();
                    object5 = this.getJobHistoryDM().get(l6);
                    l5 = object5.getScheduledTime();
                }
                scheduleJob2.setJobType(null);
                scheduleJob2.setTimezoneType(null);
                ExecutableJob executableJob = new ExecutableJob();
                executableJob.setScheduleJob(scheduleJob2);
                executableJob.setEventID(String.valueOf(l3));
                executableJob.setServerPeerID(this.agentServer.getRemotePeerID());
                executableJob.setAgent(this.agent);
                executableJob.setConditional(scheduleJob2.isConditional());
                executableJob.setCondRetry(scheduleJob2.isCondRetry());
                executableJob.setCondRetryDelay(scheduleJob2.getCondRetryDelay());
                executableJob.setCondRetryCount(scheduleJob2.getCondRetryCount());
                executableJob.setConditionFailStatus(scheduleJob2.getConditionFailStatus());
                if (scheduleJob != null) {
                    jobHistory.setDefaultSuiteParameters(scheduleJob.getJobParameters());
                }
                String string = null;
                try {
                    string = JobParameterUtil.overrideJobParameters(jobHistory.getJobName(), scheduleJob2.getJobParameters(), jobHistory.getDefaultSuiteParameters(), jobHistory.getJobParameters());
                    jobHistory.setJobParameters(string);
                }
                catch (Exception exception) {
                    String string2 = "Error processing job parameters for job: " + jobHistory.getJobName();
                    logger.error((Object)string2, (Throwable)exception);
                    throw new SubmitFailedException(string2, SubmitFailedException.Reason.JOB_PARAMETER_ERROR);
                }
                if (scheduleJob2.getJobType() == JobType.SUITE) {
                    jobHistory.setDefaultSuiteParameters(scheduleJob2.getJobParameters());
                }
                executableJob.setJobHistory(jobHistory);
                JobHistoryDM jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
                jobHistoryDM.updateJobParameters(jobHistory.getId(), string, jobHistory.getDefaultSuiteParameters());
                boolean bl = false;
                object5 = null;
                boolean bl2 = bl = string != null && string.length() > 0;
                if (bl) {
                    object5 = this.getJobParametersAsAEVs(string);
                }
                AgentEnvironmentType agentEnvironmentType = AgentEnvironmentType.persistanceCodeToEnum(scheduleJob2.getAgentEnvironmentType());
                switch (agentEnvironmentType) {
                    case STANDARD: {
                        object4 = (AgentEnvironmentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentEnvironmentDM");
                        AgentEnvironment agentEnvironment = object4.get(scheduleJob2.getAgentEnvironmentID());
                        if (bl) {
                            this.addJobParametersToEnvironment((ArrayList<AgentEnvironmentVariable>)object5, agentEnvironment);
                        }
                        this.resolveEnvironmentVariables(agentEnvironment, jobHistory, l5);
                        if (agentEnvironment.isShared()) {
                            executableJob.setSharedAgentEnvironment(agentEnvironment);
                            break;
                        }
                        if (agentEnvironment.isPrivate()) {
                            executableJob.setPrivateAgentEnvironment(agentEnvironment);
                            if (!agentEnvironment.isSharedWithOverrides()) break;
                            object3 = object4.get(agentEnvironment.getRefSharedOID());
                            this.resolveEnvironmentVariables((AgentEnvironment)((Object)object3), jobHistory, l5);
                            executableJob.setSharedAgentEnvironment((AgentEnvironment)((Object)object3));
                            break;
                        }
                        throw new IllegalStateException("Unsupported agent environment:" + agentEnvironment.getType());
                    }
                    case IBM_I: {
                        Object object6;
                        object3 = (IBMiAgentEnvironmentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.IBMiAgentEnvironmentDM");
                        AgentEnvironment agentEnvironment = object3.get(scheduleJob2.getAgentEnvironmentID());
                        if (bl) {
                            this.addJobParametersToEnvironment((ArrayList<AgentEnvironmentVariable>)object5, agentEnvironment);
                            this.resolveEnvironmentVariables(agentEnvironment, jobHistory, l5);
                        }
                        executableJob.setSharedAgentEnvironment(agentEnvironment);
                        String string3 = scheduleJob2.getIBMiJobName();
                        if (string3 == null || string3.length() == 0) {
                            object6 = executableJob.getScheduleJob().getSkybotJobName();
                            logger.debug((Object)("No IBM i Job Name found.  Attempting to use Automate Schedule Job Name '" + (String)object6 + "'"));
                            try {
                                object6 = this.getIBMiExecutableJobHelper().getValidIBMiJobName((String)object6);
                                logger.debug((Object)("IBM i Job Name set to '" + (String)object6 + "'"));
                            }
                            catch (InvalidStateException invalidStateException) {
                                logger.warn((Object)invalidStateException.getMessage());
                            }
                            scheduleJob2.setIBMiJobName((String)object6);
                        }
                        try {
                            object6 = (OutputDistributionDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)executableJob.getServerPeerID(), (String)"ENTERPRISE.OutputDistributiontDM");
                            object2 = object6.getByJobId(scheduleJob2.getSkybotJobNumber());
                            if (((OutputDistribution[])object2).length <= 0) break;
                            executableJob.setIncludingOutputDistributions(true);
                            break;
                        }
                        catch (Exception exception) {
                            object2 = "Error while retrieving the output distribution for jobId = " + scheduleJob2.getSkybotJobNumber();
                            logger.debug(object2, (Throwable)exception);
                        }
                    }
                }
                object4 = (AgentEventHistoryInfoDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentEventHistoryInfoDM");
                object3 = object4.getRelatedAgentEventHistory(jobHistory);
                executableJob.setEventHistory(object3.toArray(new AgentEventHistoryInfo[object3.size()]));
                logger.trace((Object)("Checking if Agent " + this.agent.getName() + " is available..."));
                long l7 = this.agentServer.getWhenStarted().getTime() + 360000L;
                while (System.currentTimeMillis() < l7) {
                    for (OutputDistribution object7 : this.agentServer.getPeersFromRoutingTable()) {
                        if (!this.agent.getInstanceIdentifier().equals(object7.getInstanceIdentifier()) || !this.agent.getHardwareHash().equals(object7.getHardwareHash())) continue;
                        l7 = 0L;
                        logger.trace((Object)("Agent " + this.agent.getName() + " is available."));
                        break;
                    }
                    if (l7 <= 0L) continue;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.getJobExecDM() == null) {
                    object2 = "Agent " + this.agent.getName() + " is not available.";
                    logger.debug(object2);
                    throw new ActionFailedException((String)object2);
                }
                object2 = scheduleJob2.getCommandSet();
                CommandSet commandSet = new CommandSet();
                commandSet.setName(object2.getName());
                commandSet.setDescription(object2.getDescription());
                commandSet.setOid(((CommandSet)((Object)object2)).getOid());
                commandSet.setType(((CommandSet)((Object)object2)).getType());
                CommandSetCommand[] commandSetCommandArray = ((CommandSet)((Object)object2)).getCommands();
                Object var26_37 = null;
                SkybotVariableDM skybotVariableDM = MRHelper.getSkybotVariableDM();
                for (CommandSetCommand commandSetCommand : commandSetCommandArray) {
                    Object object;
                    Object object6;
                    Object object7;
                    void var26_38;
                    if (commandSetCommand.isSAPCommand()) {
                        Map<String, String> map = this.getEnvironmentVariablesMAP((Map<String, String>)var26_38, executableJob);
                        object7 = this.getSAPServerHelperAM().getSAPExecutableFromCommand(commandSetCommand, map, this.agent.getOperatingSystem().startsWith("Windows"));
                        commandSetCommand.setSAPExecutable((SAPExecutable)((Object)object7));
                        logger.debug((Object)("Loaded SAPExecutable into CommandSetCommand for " + commandSetCommand.getCommandString()));
                        object6 = ((SAPExecutable)((Object)object7)).getSapCommand().getSAPCommandName();
                        object6 = this.agent.getOperatingSystem().startsWith("Windows") ? "REM " + (String)object6 : "# " + (String)object6;
                        commandSetCommand.setCommandString((String)object6);
                        continue;
                    }
                    if (commandSetCommand.isOracleCommand()) {
                        logger.debug((Object)"Found Oracle command...");
                        object7 = this.getOracleServerHelperAM().getOracleExecutableFromCommand(commandSetCommand, this.agent.getOperatingSystem().startsWith("Windows"));
                        commandSetCommand.setOracleExecutable((OracleExecutable)((Object)object7));
                        continue;
                    }
                    if (!agentEnvironmentType.equals(AgentEnvironmentType.IBM_I)) continue;
                    object7 = executableJob.getEventHistory();
                    if (object7 != null && ((AgentEventHistoryInfo[])object7).length > 0) {
                        this.getIBMiExecutableJobHelper().resolveCommandWithEventDataVariables(commandSetCommand, executableJob.getEventHistory());
                    }
                    Map<String, String> map = this.getEnvironmentVariablesMAP((Map<String, String>)var26_38, executableJob);
                    this.getIBMiExecutableJobHelper().resolveCommandWithVariables(commandSetCommand, map);
                    try {
                        object6 = Calendar.getInstance();
                        ((Calendar)object6).setTimeInMillis(jobHistory.getScheduledTime());
                        object = null;
                        if (jobHistory.getTimezoneType().equalsIgnoreCase("A")) {
                            object = jobHistory.getAgentTimezone();
                        } else if (jobHistory.getTimezoneType().equalsIgnoreCase("J")) {
                            object = jobHistory.getJobTimezone();
                        }
                        if (object != null && ((String)object).trim().length() > 0) {
                            try {
                                ((Calendar)object6).setTimeZone(TimeZone.getTimeZone(((String)object).trim()));
                            }
                            catch (Exception exception) {
                                logger.error((Object)("Error loading time zone (" + (String)object + ") for automate schedule variable."), (Throwable)exception);
                            }
                        }
                        this.getIBMiExecutableJobHelper().resolveCommandWithSkybotVariables(commandSetCommand, skybotVariableDM, (Calendar)object6);
                    }
                    catch (SkybotVariableResolveException skybotVariableResolveException) {
                        object = new String[]{skybotVariableResolveException.getSkybotVariableName(), skybotVariableResolveException.getLocalizedMessage()};
                        ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(RosettaMsg.SKYBOT_VARIABLE_UNRESOLVED, (String[])object, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId());
                        ScheduleLogger.write(scheduleLogEntry);
                        logger.info((Object)RosettaMsg.getMsgText(RosettaMsg.SKYBOT_VARIABLE_UNRESOLVED, (Object[])object));
                        throw new SubmitFailedException(skybotVariableResolveException.getLocalizedMessage());
                    }
                }
                if (scheduleJob2.getScheduleType().equals(ScheduleJobProxy.ScheduleType.SAP_RUN_INTERCEPT)) {
                    commandSetCommandArray = this.getSAPServerHelperAM().getExpandedCSCArray(jobHistory, commandSetCommandArray, l, this.agent.getOperatingSystem().startsWith("Windows"));
                }
                for (CommandSetCommand commandSetCommand : commandSetCommandArray) {
                    if (commandSetCommand.getLineNumber() < jobHistory.getStartAtCommandSequence()) continue;
                    commandSet.addCommand(commandSetCommand);
                }
                this.performLicenseChecks(commandSet);
                this.performIBMiLicenseChecks(commandSet);
                scheduleJob2.setCommandSet(commandSet);
                executableJob.setCopyJobLogToServer(scheduleJob2.isCopyJobLogToServer());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Finished loading job " + l + " for agent " + l2 + " - Event ID: " + l3));
                }
                return executableJob;
            }
        }
        catch (DataException dataException) {
            logger.error((Object)dataException);
            throw new ActionFailedException("Unable to restore jobID " + l + " from the database for agent " + l2 + " - Event ID: " + l3, (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException);
            resourceUnavailableException.printStackTrace();
            throw new ActionFailedException("Unable to restore jobID " + l + " from the database for agent " + l2 + " - Event ID: " + l3, (Throwable)resourceUnavailableException);
        }
    }

    private IBMiExecutableJobHelper getIBMiExecutableJobHelper() {
        if (this.ibmiExecutableJobHelper == null) {
            this.ibmiExecutableJobHelper = new IBMiExecutableJobHelper();
        }
        return this.ibmiExecutableJobHelper;
    }

    private void addJobParametersToEnvironment(ArrayList<AgentEnvironmentVariable> arrayList, AgentEnvironment agentEnvironment) {
        AgentEnvironmentVariable[] agentEnvironmentVariableArray = agentEnvironment.getVariables();
        ArrayList<AgentEnvironmentVariable> arrayList2 = new ArrayList<AgentEnvironmentVariable>(Arrays.asList(agentEnvironmentVariableArray));
        HashMap<String, AgentEnvironmentVariable> hashMap = new HashMap<String, AgentEnvironmentVariable>();
        for (AgentEnvironmentVariable agentEnvironmentVariable : arrayList) {
            hashMap.put(agentEnvironmentVariable.getName(), agentEnvironmentVariable);
        }
        for (AgentEnvironmentVariable agentEnvironmentVariable : arrayList2) {
            SkybotVariable skybotVariable = agentEnvironmentVariable.getSkybotVariable();
            if (skybotVariable == null || !hashMap.containsKey(skybotVariable.getName())) continue;
            skybotVariable.setValue(((AgentEnvironmentVariable)((Object)hashMap.get(skybotVariable.getName()))).getVariable());
        }
        arrayList2.addAll(arrayList);
        agentEnvironmentVariableArray = arrayList2.toArray(new AgentEnvironmentVariable[arrayList2.size()]);
        agentEnvironment.setVariableList(agentEnvironmentVariableArray);
    }

    private ArrayList<AgentEnvironmentVariable> getJobParametersAsAEVs(String string) {
        String[] stringArray = string.split("\t");
        ArrayList<AgentEnvironmentVariable> arrayList = new ArrayList<AgentEnvironmentVariable>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) {
                logger.error((Object)("Error interpreting Job Parameter: " + stringArray[i]));
                continue;
            }
            AgentEnvironmentVariable agentEnvironmentVariable = new AgentEnvironmentVariable();
            agentEnvironmentVariable.setName(stringArray2[0]);
            agentEnvironmentVariable.setVariable(stringArray2[1]);
            arrayList.add(agentEnvironmentVariable);
        }
        return arrayList;
    }

    private CalendarObjectDM getCalendarObjectDM() {
        if (this.calendarObjectDM == null) {
            this.calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CalendarObjectDM");
        }
        return this.calendarObjectDM;
    }

    private void performLicenseChecks(CommandSet commandSet) throws SubmitFailedException {
        CommandSetCommand[] commandSetCommandArray;
        EnterpriseLicenseInfo enterpriseLicenseInfo = this.getLicenseInfo();
        if (enterpriseLicenseInfo == null) {
            logger.error((Object)"Error obtaining license information.");
            throw new SubmitFailedException("Agent " + this.agent.getName() + " is not licensed to run commands.", SubmitFailedException.Reason.INVALID_LICENSE);
        }
        if (enterpriseLicenseInfo.isValidTrialLicense()) {
            return;
        }
        EnterpriseProductLicense enterpriseProductLicense = enterpriseLicenseInfo.getPrimaryLicense();
        if (enterpriseProductLicense == null) {
            logger.error((Object)"No primary license found.");
            throw new SubmitFailedException("Agent " + this.agent.getName() + " is not licensed to run commands.", SubmitFailedException.Reason.INVALID_LICENSE);
        }
        for (CommandSetCommand commandSetCommand : commandSetCommandArray = commandSet.getCommands()) {
            if (commandSetCommand.isSAPCommand() && !enterpriseProductLicense.isSAPEnabled()) {
                throw new SubmitFailedException("Agent " + this.agent.getName() + " is not licensed to run SAP commands.", SubmitFailedException.Reason.INVALID_SAP_LICENSE);
            }
            if (commandSetCommand.isInformaticaCommand() && !enterpriseProductLicense.isInformaticaEnabled()) {
                throw new SubmitFailedException("Agent " + this.agent.getName() + " is not licensed to run Informatica commands.", SubmitFailedException.Reason.INVALID_INFORMATICA_LICENSE);
            }
            if (commandSetCommand.isOracleCommand() && !enterpriseProductLicense.isOracleEnabled()) {
                throw new SubmitFailedException("Agent " + this.agent.getName() + " is not licensed to run Oracle commands.", SubmitFailedException.Reason.INVALID_ORACLE_LICENSE);
            }
            if (!commandSetCommand.isUniversalConnectorCommand() || enterpriseProductLicense.isUniversalConnectorEnabled()) continue;
            throw new SubmitFailedException("Agent " + this.agent.getName() + " is not licensed to run Universal Connector commands.", SubmitFailedException.Reason.INVALID_UNIVERSAL_CONNECTOR_LICENSE);
        }
    }

    private void performIBMiLicenseChecks(CommandSet commandSet) throws SubmitFailedException {
        CommandSetCommand[] commandSetCommandArray;
        EnterpriseLicenseInfo enterpriseLicenseInfo;
        if (commandSet.getType() != CommandSetType.PRIVATE_IBMI.persistanceCode().intValue() && commandSet.getType() != CommandSetType.SHARED_IBMI.persistanceCode().intValue()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Performing IBM i License Checks: " + commandSet.getOid()));
        }
        if ((enterpriseLicenseInfo = this.getLicenseInfo()) == null) {
            logger.error((Object)"Error obtaining license information.");
            throw new SubmitFailedException("Agent " + this.agent.getName() + " is not licensed to run commands.", SubmitFailedException.Reason.INVALID_LICENSE);
        }
        boolean bl = false;
        if (enterpriseLicenseInfo.isValidTrialLicense()) {
            logger.trace((Object)"Valid IBM i Trial License...");
            commandSetCommandArray = enterpriseLicenseInfo.getTrialLicense();
            if (commandSetCommandArray.isSequelBundledLicense()) {
                bl = true;
            }
        } else {
            logger.trace((Object)"Valid IBM i Primary License...");
            commandSetCommandArray = enterpriseLicenseInfo.getPrimaryLicense();
            if (commandSetCommandArray != null && commandSetCommandArray.isSequelBundledLicense()) {
                bl = true;
            }
        }
        if (!bl) {
            logger.trace((Object)"Skipping SEQUEL Bundled License Check...");
            return;
        }
        for (CommandSetCommand commandSetCommand : commandSetCommandArray = commandSet.getCommands()) {
            String string = commandSetCommand.getCommandString();
            boolean bl2 = SequelCommands.isCommandAllowed((String)string);
            if (bl2) continue;
            throw new SubmitFailedException("The IBM i Command Set contains a prohibited command for a SEQUEL Bundled license: '" + string, SubmitFailedException.Reason.SEQUEL_PROHIBITED_COMMAND);
        }
    }

    private Map<String, String> getEnvironmentVariablesMAP(Map<String, String> map, ExecutableJob executableJob) {
        AgentEnvironment agentEnvironment;
        if (map != null) {
            return map;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(executableJob.getEventEnvVars());
        ProcessUtil.loadJobConfigInfo(executableJob, hashMap);
        AgentEnvironment agentEnvironment2 = executableJob.getPrivateAgentEnvironment();
        if (agentEnvironment2 != null) {
            hashMap.putAll(agentEnvironment2.getMap());
        }
        if ((agentEnvironment = executableJob.getSharedAgentEnvironment()) != null) {
            hashMap.putAll(agentEnvironment.getMap());
        }
        return hashMap;
    }

    private OracleServerHelperAM getOracleServerHelperAM() {
        if (this.oracleServerHelperAM == null) {
            this.oracleServerHelperAM = (OracleServerHelperAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.OracleServerHelperAM");
        }
        return this.oracleServerHelperAM;
    }

    private EnterpriseLicenseInfo getLicenseInfo() {
        if (this.licenseInfo == null) {
            EnterpriseLicenseInfoAM enterpriseLicenseInfoAM = (EnterpriseLicenseInfoAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseLicenseInfoAM");
            try {
                this.licenseInfo = enterpriseLicenseInfoAM.getLicenseInfo();
                logger.debug((Object)("LicenseInfo acquired for Agent " + this.agent.getName()));
            }
            catch (Exception exception) {
                logger.debug((Object)"Error retrieving license information", (Throwable)exception);
            }
        }
        return this.licenseInfo;
    }

    private void resolveEnvironmentVariables(AgentEnvironment agentEnvironment, JobHistory jobHistory, long l) throws NoDataException, BadDataException, ResourceUnavailableException, SubmitFailedException {
        AgentEnvironmentVariable[] agentEnvironmentVariableArray;
        for (AgentEnvironmentVariable agentEnvironmentVariable : agentEnvironmentVariableArray = agentEnvironment.getVariables()) {
            Object object;
            CalendarObject calendarObject = null;
            SkybotVariable skybotVariable = agentEnvironmentVariable.getSkybotVariable();
            if (skybotVariable != null && (object = skybotVariable.getCalendarObjectID()) != null) {
                calendarObject = this.getCalendarObjectDM().get((Long)object);
            }
            object = null;
            if (jobHistory.getTimezoneType().equalsIgnoreCase("A")) {
                object = jobHistory.getAgentTimezone();
            } else if (jobHistory.getTimezoneType().equalsIgnoreCase("J")) {
                object = jobHistory.getJobTimezone();
            }
            try {
                agentEnvironmentVariable.setResolvedValue(calendarObject, l, (String)object);
            }
            catch (SkybotVariableResolveException skybotVariableResolveException) {
                Object[] objectArray = new String[]{skybotVariableResolveException.getSkybotVariableName(), skybotVariableResolveException.getLocalizedMessage()};
                ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(RosettaMsg.SKYBOT_VARIABLE_UNRESOLVED, (String[])objectArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId());
                ScheduleLogger.write(scheduleLogEntry);
                logger.info((Object)RosettaMsg.getMsgText(RosettaMsg.SKYBOT_VARIABLE_UNRESOLVED, objectArray));
                throw new SubmitFailedException(skybotVariableResolveException.getLocalizedMessage());
            }
        }
    }

    private void checkTimeRange(int n, int n2, TimeZone timeZone) throws SubmitFailedException {
        logger.debug((Object)("Selected time range = " + n + " to " + n2 + " using " + timeZone.getID()));
        if (n == n2) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        logger.debug((Object)("Exception Scheduling is using Time Zone: " + calendar.getTimeZone().getDisplayName()));
        calendar.setTimeInMillis(System.currentTimeMillis());
        int n3 = n / 100;
        int n4 = n - n3 * 100;
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(11, n3);
        calendar2.set(12, n4);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        int n5 = n2 / 100;
        int n6 = n2 - n5 * 100;
        Calendar calendar3 = (Calendar)calendar.clone();
        calendar3.set(11, n5);
        calendar3.set(12, n6);
        calendar3.set(13, 59);
        calendar3.set(14, 999);
        String string = "Exception Schedule: " + ScheduleLogger.formatTimeStampTZ(calendar) + " between " + ScheduleLogger.formatTimeStampTZ(calendar2) + " and " + ScheduleLogger.formatTimeStampTZ(calendar3) + "?";
        logger.debug((Object)string);
        if (!this.isValidTimeRange(n3, n4, n5, n6)) {
            logger.error((Object)("Invalid time range of " + n + " to " + n2 + ".  Time range will be ignored."));
            return;
        }
        if (n2 < n ? calendar.getTimeInMillis() == calendar2.getTimeInMillis() || calendar.after(calendar2) || calendar.before(calendar3) : (calendar.getTimeInMillis() == calendar2.getTimeInMillis() || calendar.after(calendar2)) && calendar.before(calendar3)) {
            return;
        }
        throw new SubmitFailedException("Outside Exception Schedule Time Range: " + string, SubmitFailedException.Reason.OUTSIDE_TIMERANGE);
    }

    private boolean isValidTimeRange(int n, int n2, int n3, int n4) {
        if (n < 0 || n3 < 0 || n2 < 0 || n4 < 0) {
            return false;
        }
        return n <= 23 && n3 <= 23 && n2 <= 59 && n4 <= 59;
    }

    static Agent loadAgentOID(long l) throws DataException, ResourceUnavailableException {
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        return agentDM.get(l);
    }

    public void runJob(JobHistory jobHistory, ExecutableJob executableJob) throws SubmitFailedException, ActionFailedException {
        long l;
        if (executableJob == null) {
            throw new ActionFailedException("Job not specified.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Preparing to run job " + executableJob.getScheduleJob().getName() + " for agent " + executableJob.getAgent().getName() + " - Event ID: " + executableJob.getEventID()));
        }
        RelMod relMod = RelMod.parse((String)this.agent.getVersion());
        int n = ProcessUtil.resolveRunType(executableJob);
        if (relMod.getRelease() < 3 && n != 2) {
            throw new SubmitFailedException("The agent " + this.agent.getName() + " needs to be upgraded to version 3.0 (or later) to run" + " this job. The agent is currently running version " + relMod, SubmitFailedException.Reason.NEED_TO_UPDATE_AGENT);
        }
        if (n == 3 && !this.agent.getAllowAgentUserExec()) {
            throw new SubmitFailedException("Agent " + this.agent.getName() + " does not allow jobs submitted to run with the default" + " agent user and no password.  Edit the agent settings" + " to enable this feature or provide a user and password" + " in the environment defined for this job.", SubmitFailedException.Reason.EXEC_AS_AGENT_USER_DISABLED);
        }
        if (jobHistory.getStatusCode().equals(JobStatusCode.CONDITION_RETRY_WAIT) && !executableJob.isIgnoreConditions()) {
            logger.debug((Object)("Starting retry " + jobHistory.getRetryNumber() + " of " + executableJob.getCondRetryCount() + " for run number " + jobHistory.getId() + " of conditional Job '" + jobHistory.getJobName() + "'."));
        }
        if (this.getJobExecDM() == null) {
            throw new SubmitFailedException("Remote agent not available.", SubmitFailedException.Reason.AGENT_OFFLINE);
        }
        if (!jobHistory.isManuallyStarted()) {
            TimeZone timeZone = this.timezone(jobHistory);
            this.checkTimeRange(executableJob.getScheduleJob().getTimeRangeStart(), executableJob.getScheduleJob().getTimeRangeEnd(), timeZone);
        }
        long l2 = System.currentTimeMillis();
        executableJob.setServerRunningTime(l2);
        if (this.getJobCompletionDM() != null) {
            this.getJobCompletionDM().registerSocket(executableJob.getEventID(), executableJob);
        }
        boolean bl = false;
        try {
            l = this.getJobExecDM().run(executableJob);
            bl = true;
        }
        catch (NullPointerException nullPointerException) {
            throw new SubmitFailedException("Remote agent not available.", SubmitFailedException.Reason.AGENT_OFFLINE);
        }
        finally {
            if (!bl && this.getJobCompletionDM() != null) {
                this.getJobCompletionDM().removeSocket(executableJob.getEventID());
            }
        }
        RelMod relMod2 = new RelMod(2, 3);
        int n2 = relMod2.compareTo((Object)relMod);
        if (n2 < 0) {
            try {
                executableJob.setAgentStartedTime(l);
                this.getJobMarkRunningAM().markJobAsRunning(executableJob);
            }
            catch (Exception exception) {
                logger.error((Object)("Error while marking job history " + jobHistory.getId() + " as Running."), (Throwable)exception);
            }
        }
    }

    public int activeJobCount() {
        JobExecDM jobExecDM = this.getJobExecDM();
        if (jobExecDM == null) {
            return -1;
        }
        return jobExecDM.activeJobCount();
    }

    private JobExecDM getJobExecDM() {
        if (this.agent == null) {
            return null;
        }
        this.jobExecDM = null;
        try {
            this.jobExecDM = (JobExecDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.agent, (String)"ENTERPRISE.JobExecDM");
        }
        catch (Exception exception) {
            logger.error((Object)"*** Caught Exception in ExecutableJobHelper.getJobExecDM.", (Throwable)exception);
        }
        return this.jobExecDM;
    }

    private JobCompletionDM getJobCompletionDM() {
        if (this.jobCompletionDM == null) {
            this.jobCompletionDM = (JobCompletionDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobCompletionDM");
        }
        return this.jobCompletionDM;
    }

    private JobMarkRunningAM getJobMarkRunningAM() {
        if (this.jobMarkRunningAM == null) {
            this.jobMarkRunningAM = (JobMarkRunningAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMarkRunningAM");
        }
        return this.jobMarkRunningAM;
    }

    private String getJobName(long l) {
        return MessageUtil.formatMsg((String)"job with ID {0}", (Object[])new Object[]{l});
    }

    private SAPServerHelperAM getSAPServerHelperAM() {
        if (this.sapServerHelperAM == null) {
            this.sapServerHelperAM = (SAPServerHelperAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPServerHelperAM");
        }
        return this.sapServerHelperAM;
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }

    private TimeZone timezone(JobHistory jobHistory) {
        TimeZone timeZone;
        ScheduleInfo.TimeZoneType timeZoneType = this.timezoneType(jobHistory);
        switch (timeZoneType) {
            case SERVER: {
                timeZone = this.serverTimeZone();
                break;
            }
            case AGENT: {
                String string = jobHistory.getAgentTimezone();
                timeZone = this.timezone(string, jobHistory.getJobID());
                break;
            }
            case JOB: {
                String string = jobHistory.getJobTimezone();
                timeZone = this.timezone(string, jobHistory.getJobID());
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
            }
        }
        return timeZone;
    }

    private TimeZone timezone(String string, long l) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                timeZone = this.serverTimeZone();
                String string2 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, this.getJobName(l), string2}));
            }
        }
        catch (Exception exception) {
            timeZone = this.serverTimeZone();
            String string3 = timeZone.getID();
            String string4 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, this.getJobName(l), string3});
            logger.error((Object)string4, (Throwable)exception);
        }
        return timeZone;
    }

    private ScheduleInfo.TimeZoneType timezoneType(JobHistory jobHistory) {
        String string = jobHistory.getTimezoneType();
        String string2 = "";
        if (string != null && !string.isEmpty()) {
            try {
                return ScheduleInfo.TimeZoneType.persistanceCodeToEnum(string);
            }
            catch (Exception exception) {
                string2 = MessageUtil.formatMsg((String)"The time zone type code {0} for job {1} is unrecognized. Code S (SERVER) will be used instead.", (Object[])new Object[]{string, jobHistory.getJobName()});
            }
        } else {
            string2 = MessageUtil.formatMsg((String)"The time zone type code for job {0} is missing. Code S (SERVER) will be used instead.", (Object[])new Object[]{jobHistory.getJobName()});
        }
        logger.warn((Object)string2);
        return ScheduleInfo.TimeZoneType.SERVER;
    }

    public void sapXMIAuditLevelChange(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        this.jobExecDM = this.getJobExecDM();
        if (this.jobExecDM == null) {
            logger.warn((Object)("Unable to notify Agent of SAP XMI Audit Level change for SAP System Definition ID " + l + " and new Audit level " + sAPXMIAuditLevel));
            return;
        }
        this.jobExecDM.sapXMIAuditLevelChange(l, sAPXMIAuditLevel);
    }

    public String loadJobLog(JobHistory jobHistory, String string) throws RunningJobLogException {
        return this.copyRunningJobLogToServer(jobHistory, string);
    }

    private String copyRunningJobLogToServer(JobHistory jobHistory, String string) throws RunningJobLogException {
        Object object;
        String string2 = "Unable to load running job log.";
        logger.trace((Object)("Start of copyRunningJobLogToServer(JobHistory ID: " + jobHistory.getId() + ", userName " + string + ")"));
        JobExecDM jobExecDM = this.getJobExecDM();
        if (jobExecDM == null) {
            throw new RunningJobLogException("Agent is unavailable.", RunningJobLogException.Reason.AGENT_UNAVAILABLE);
        }
        RemoteFile remoteFile = jobExecDM.getJobLog(String.valueOf(jobHistory.getId()));
        if (remoteFile == null) {
            logger.error((Object)("Unable to copy Agent job log file for Job History ID " + jobHistory.getId() + ".  File not found or does not exist."));
            throw new RunningJobLogException("Agent file not found or does not exist.", RunningJobLogException.Reason.FILE_NOT_FOUND);
        }
        RemoteFileCopier remoteFileCopier = new RemoteFileCopier(jobExecDM.getPeerID(), remoteFile.getAbsolutePath());
        remoteFileCopier.setDeleteWhenFinished(false);
        String string3 = DefaultConfigPath.getTempLogDirectory((boolean)true);
        if (!(string3 == null || string3.length() <= 0 || ((File)(object = new File(string3))).exists() && ((File)object).isDirectory())) {
            logger.error((Object)("Unable to copy Agent job log file for Job History ID " + jobHistory.getId() + ".  The server directory " + string3 + " does not exist or is not a directory."));
            throw new RunningJobLogException("The server directory " + string3 + " does not exist or is not a directory.", RunningJobLogException.Reason.SERVER_DIRECTORY_NOT_AVAILABLE);
        }
        object = DefaultConfigPath.getTempLogFile((String)string3, (long)jobHistory.getId(), (String)jobHistory.getAgentName(), (String)jobHistory.getJobName(), (String)string);
        remoteFileCopier.setServerFilename((String)object);
        remoteFileCopier.run(true);
        string2 = AgentJobLog.getTempJobLogFileName(jobHistory.getId(), jobHistory.getAgentName(), jobHistory.getJobName(), string);
        Throwable throwable = remoteFileCopier.getServerWriteError();
        if (throwable != null) {
            logger.error((Object)("Unable to copy Agent job log file for Job History ID " + jobHistory.getId() + " to the server file " + (String)object + "."), throwable);
            throw new RunningJobLogException("An Error occurred while copying the Agent job log to the Server.", throwable);
        }
        logger.trace((Object)("End of copyRunningJobLogToServer(JobHistory ID: " + jobHistory.getId() + ", userName " + string + ") serverLogFileName: " + (String)object));
        return string2;
    }

    public void clearLicenseInfo() {
        this.licenseInfo = null;
    }

    public ArrayList<JobHistory> getActiveJobsAL() {
        ArrayList<JobHistory> arrayList = new ArrayList<JobHistory>();
        try {
            Map<JobTimer, ExecutableJob> map = this.getJobExecDM().listJobs();
            Collection<ExecutableJob> collection = map.values();
            for (ExecutableJob executableJob : collection) {
                JobHistory jobHistory = executableJob.getJobHistory();
                if (jobHistory == null) {
                    try {
                        jobHistory = this.getJobHistoryDM().get(Integer.valueOf(executableJob.getEventID()).intValue());
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error getting Job History record for ID " + executableJob.getEventID()), (Throwable)exception);
                        continue;
                    }
                }
                arrayList.add(jobHistory);
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof NotSerializableException) {
                logger.warn((Object)("Agent " + this.agent.getName() + " must be updated in order to retrieve the list of active jobs."));
            }
            logger.error((Object)("Error retrieving the list of running jobs from Agent " + this.agent.getName()), (Throwable)runtimeException);
        }
        return arrayList;
    }

    private JobHistoryDM getJobHistoryDM() {
        if (this.jobHistoryDM == null) {
            this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        }
        return this.jobHistoryDM;
    }
}

