/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.event.PeerDisconnectEvent;
import com.helpsystems.common.tl.ex.RemoteManagerNotFoundException;
import com.helpsystems.common.tl.ex.RuntimePeerDisconnectedException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.JobCanceledException;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobConditionR02M03;
import com.helpsystems.enterprise.core.busobj.JobConditionType;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobFailedException;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.NotOnQueueException;
import com.helpsystems.enterprise.core.busobj.RequeueJobException;
import com.helpsystems.enterprise.core.busobj.RunningJobLogException;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.dm.AgentWorkManagerAM;
import com.helpsystems.enterprise.core.dm.JobConditionDM;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.core.enums.CommandSetType;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.AgentEnvironmentType;
import com.helpsystems.enterprise.module.ExecutableJobHelper;
import com.helpsystems.enterprise.module.exec.JobConditionController;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class AgentWorkManager {
    private static Logger logger = Logger.getLogger(AgentWorkManager.class);
    private static final String JOB_RUNNER = "JobRunner";
    private static final String OS400_OS_CHECK_STRING = "OS/400";
    private ExecutableJobHelper jobHelper;
    private ScheduleJobDM jobDM;
    private JobConditionDM jobConditionDM;
    private JobHistoryDM jobHistoryDM;
    JobTrackerAM jobTrackerAM;
    private Agent agent;
    private AgentPeer agentServer;
    private PeerID agentPeerID;
    private boolean onHold;
    private String objectName;
    private Object agentAvailableObject = new Object();
    private boolean agentAvailable = true;
    private Set<Long> terminateJobSet = new HashSet<Long>();
    private Set<Long> startingJobSet = new HashSet<Long>();
    private LinkedBlockingQueue<TerminateJobInfo> terminateJobQueue = new LinkedBlockingQueue();
    private AgentWorkManagerAM agentWorkManagerAM;
    private Thread jobTerminatorThread;
    private JobTerminator jobTerminator;
    private boolean agentShutDownInProgress;

    public AgentWorkManager(Agent agent, AgentPeer agentPeer, AgentWorkManagerAM agentWorkManagerAM) {
        this.agent = agent;
        this.agentServer = agentPeer;
        this.agentWorkManagerAM = agentWorkManagerAM;
        this.init();
    }

    private void init() {
        this.jobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
        this.jobConditionDM = (JobConditionDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobConditionDM");
        this.jobHelper = new ExecutableJobHelper(this.agentServer, this.agent, this.jobDM);
        this.jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setPort(this.agent.getPort());
        peerDescriptor.setType(4);
        peerDescriptor.addAddress(this.agent.getIPAddress());
        this.agentPeerID = PeerID.createPeerID((String)this.agent.getHardwareKey(), (Serializable)((Object)this.agent.getInstanceIdentifier()), (PeerDescriptor)peerDescriptor);
    }

    public void updateAgentInfo(Agent agent) {
        this.agent = agent;
        logger.debug((Object)("Assigning new ExecutableJobHelper using agent " + this.agent.getName()));
        this.jobHelper = new ExecutableJobHelper(this.agentServer, this.agent, this.jobDM);
    }

    public void notifyJobHelperOfLicenseChange() {
        this.jobHelper.clearLicenseInfo();
    }

    public int getAgentActiveJobCount() {
        return this.jobHelper.activeJobCount();
    }

    public PeerID getAgentPeerID() {
        return this.agentPeerID;
    }

    public ArrayList<JobHistory> getActiveJobsFromAgent() {
        return this.jobHelper.getActiveJobsAL();
    }

    protected Exception processJob(JobHistory jobHistory, boolean bl) {
        JobRunner jobRunner = new JobRunner(jobHistory);
        String string = "JobRunner for " + jobHistory.getJobName() + "(" + jobHistory.getId() + ") on " + this.agent.getName() + "(" + this.agent.getOid() + ")";
        long l = SkybotStackSize.getStackSize();
        Thread thread = l != 0L ? new Thread(null, jobRunner, string, l) : new Thread((Runnable)jobRunner, string);
        thread.start();
        if (bl) {
            try {
                thread.join();
                return jobRunner.exception;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    private void processSubmitFailedException(SubmitFailedException submitFailedException, JobHistory jobHistory, ExecutableJob executableJob) throws DataException, ResourceUnavailableException, RequeueJobException, SubmitFailedException, JobFailedException {
        long l = jobHistory.getId();
        JobHistory jobHistory2 = this.getJobHistoryDM().get(l);
        String string = null;
        switch (submitFailedException.getReason()) {
            case CONDITION_NOT_MET: {
                String string2 = "Agent needs to be updated to support Conditional Job Execution. Please update Agent " + jobHistory2.getAgentName();
                logger.warn((Object)string2, (Throwable)submitFailedException);
                if (executableJob != null && executableJob.isCondRetry()) {
                    ScheduleLogEntry scheduleLogEntry = null;
                    String[] stringArray = new String[]{jobHistory2.getAgentName(), jobHistory2.getJobName()};
                    scheduleLogEntry = RosettaMsg.CONDITIONAL_JOB_BACKLEVEL_AGENT_RETRY.newLogEntry(stringArray);
                    scheduleLogEntry.setAgentID(jobHistory2.getAgentID());
                    scheduleLogEntry.setJobID(jobHistory2.getJobID());
                    scheduleLogEntry.setJobHistoryID(jobHistory2.getId());
                    ScheduleLogger.write(scheduleLogEntry);
                    jobHistory2.setStatusCode(JobStatusCode.ERROR);
                    jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.AGENT_UPDATE_REQUIRED);
                    break;
                }
                if (executableJob != null && executableJob.getConditionFailStatus() == JobConditionController.RUN_ANYWAY) {
                    jobHistory2.setBypassConditions(true);
                    throw new RequeueJobException("Requeueing jobHistoryID: " + jobHistory2.getId() + " because job condition not met but run anyway is selected.", submitFailedException.getReason());
                }
                jobHistory2.setStatusCode(JobStatusCode.FAILED);
                jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.CONDITION_NOT_MET);
                break;
            }
            case AGENT_BUSY: {
                throw new RequeueJobException("Waiting on Agent to finish a job.", submitFailedException.getReason());
            }
            case AGENT_OFFLINE: {
                throw new RequeueJobException("Agent Offline", submitFailedException.getReason());
            }
            case INVALID_LICENSE: {
                string = "Failed to run JobHistoryID " + jobHistory2.getId() + " on Agent " + jobHistory2.getAgentName() + ".  Agent is not licensed to run jobs.";
                jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.INVALID_LICENSE);
            }
            case INVALID_SAP_LICENSE: {
                if (string == null) {
                    string = "Failed to run JobHistoryID " + jobHistory2.getId() + " on Agent " + jobHistory2.getAgentName() + ".  Agent is not licensed to run SAP commands.";
                    jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.INVALID_LICENSE);
                }
            }
            case INVALID_INFORMATICA_LICENSE: {
                if (string == null) {
                    string = "Failed to run JobHistoryID " + jobHistory2.getId() + " on Agent " + jobHistory2.getAgentName() + ".  Agent is not licensed to run Informatica commands.";
                    jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.INVALID_LICENSE);
                }
            }
            case INVALID_ORACLE_LICENSE: {
                if (string == null) {
                    string = "Failed to run JobHistoryID " + jobHistory2.getId() + " on Agent " + jobHistory2.getAgentName() + ".  Agent is not licensed to run Oracle commands.";
                    jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.INVALID_LICENSE);
                }
            }
            case INVALID_UNIVERSAL_CONNECTOR_LICENSE: {
                if (string == null) {
                    string = "Failed to run JobHistoryID " + jobHistory2.getId() + " on Agent " + jobHistory2.getAgentName() + ".  Agent is not licensed to run Universal Connector commands.";
                    jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.INVALID_LICENSE);
                }
            }
            case EXEC_AS_AGENT_USER_DISABLED: {
                if (string == null) {
                    string = submitFailedException.getMessage();
                    jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.EXEC_AS_AGENT_USER_DISABLED);
                }
            }
            case NEED_TO_UPDATE_AGENT: {
                if (string == null) {
                    string = submitFailedException.getMessage();
                    jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.AGENT_UPDATE_REQUIRED);
                }
                logger.debug((Object)string);
                jobHistory2.setStatusCode(JobStatusCode.FAILED);
                this.postScheduleLogEntry(jobHistory2, submitFailedException.getReason());
                throw new JobFailedException(string, jobHistory2.getJobEndedReasonCode());
            }
            case OUTSIDE_TIMERANGE: {
                String string3 = "JobHistoryID " + jobHistory2.getId() + " on Agent " + jobHistory2.getAgentName() + " will be canceled." + "  It is outside the allowed time range.";
                logger.debug((Object)string3);
                jobHistory2.setStatusCode(JobStatusCode.CANCELED);
                jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.TIME_RANGE_VIOLATION);
                this.postScheduleLogEntry(jobHistory2, submitFailedException.getReason());
                throw new JobCanceledException(string3, jobHistory2.getJobEndedReasonCode());
            }
            case SHUTDOWN_IN_PROGRESS: {
                if (!this.agentShutDownInProgress) {
                    this.agentServer.addEvent((GenericEvent)new PeerDisconnectEvent(this.agentPeerID, this.agentServer.getRemotePeerID()));
                }
                throw new RequeueJobException("Agent shutdown is in progress.  JobHistoryID: " + l + " will be requeued.", submitFailedException.getReason());
            }
            case CREATE_PROCESS_FAILED: {
                throw new RequeueJobException("Failed to create process on Agent.", submitFailedException.getReason());
            }
            case PLATFORM_COMMAND_INCOMPATIBILITY: {
                string = "Job contains command not compatible with Agent platform.";
                logger.debug((Object)string);
                jobHistory2.setStatusCode(JobStatusCode.ERROR);
                jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.PLATFORM_COMMAND_MISMATCH);
                this.postScheduleLogEntry(jobHistory2, submitFailedException.getReason());
                throw new JobFailedException(string, jobHistory2.getJobEndedReasonCode());
            }
            case UNSUPPORTED_COMMAND_TYPE: {
                String string4 = submitFailedException.getCommand().getCommandTypeString();
                string = "Command type " + string4 + " found in job " + jobHistory2.getJobName() + " which is unsupported on the Agent.";
                logger.error((Object)string);
                jobHistory2.setStatusCode(JobStatusCode.ERROR);
                jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.AGENT_UPDATE_REQUIRED);
                String[] stringArray = new String[]{jobHistory2.getJobName(), jobHistory2.getAgentName(), string4};
                this.postScheduleLogEntry(jobHistory2, submitFailedException.getReason(), stringArray);
                throw new JobFailedException(string, jobHistory2.getJobEndedReasonCode());
            }
            case SEQUEL_PROHIBITED_COMMAND: {
                string = "Job " + jobHistory2.getJobName() + " with run number " + jobHistory2.getId() + " contains a prohibited IBM i Command that is not allowed with a SEQUEL Bundled license.";
                logger.error((Object)string);
                jobHistory2.setStatusCode(JobStatusCode.ERROR);
                jobHistory2.setJobEndedReasonCode(JobEndedReasonCode.SEQUEL_PROHIBITED_COMMAND);
                String[] stringArray = new String[]{jobHistory2.getJobName(), jobHistory2.getAgentName(), String.valueOf(jobHistory2.getId())};
                this.postScheduleLogEntry(jobHistory2, submitFailedException.getReason(), stringArray);
                throw new JobFailedException(string, jobHistory2.getJobEndedReasonCode());
            }
            case JOB_ALREADY_STARTED: {
                logger.warn((Object)MessageUtil.formatMsg((String)"Agent {0} responded to the server request to run job {1} (run ID {2}) that the job run had already started, based on a previous request. The entry will be removed from the agent queue.", (Object[])new Object[]{jobHistory2.getAgentName(), jobHistory2.getJobName(), jobHistory2.getId()}), submitFailedException.getCause());
                break;
            }
            default: {
                throw submitFailedException;
            }
        }
    }

    private void postScheduleLogEntry(JobHistory jobHistory, SubmitFailedException.Reason reason) {
        String string = String.valueOf(jobHistory.getId());
        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getStatusCode_asStr(), string};
        this.postScheduleLogEntry(jobHistory, reason, stringArray);
    }

    private void postScheduleLogEntry(JobHistory jobHistory, SubmitFailedException.Reason reason, String[] stringArray) {
        ScheduleLogEntry scheduleLogEntry = null;
        switch (reason) {
            case EXEC_AS_AGENT_USER_DISABLED: {
                scheduleLogEntry = RosettaMsg.DEFAULT_AGENT_USER_NOT_ALLOWED.newLogEntry(stringArray);
                break;
            }
            case INVALID_LICENSE: {
                scheduleLogEntry = RosettaMsg.JOB_FAILED_DUE_TO_LICENSE.newLogEntry(stringArray);
                break;
            }
            case INVALID_SAP_LICENSE: {
                scheduleLogEntry = RosettaMsg.JOB_FAILED_DUE_TO_SAP_LICENSE.newLogEntry(stringArray);
                break;
            }
            case INVALID_INFORMATICA_LICENSE: {
                scheduleLogEntry = RosettaMsg.JOB_FAILED_DUE_TO_INFORMATICA_LICENSE.newLogEntry(stringArray);
                break;
            }
            case INVALID_ORACLE_LICENSE: {
                scheduleLogEntry = RosettaMsg.JOB_FAILED_DUE_TO_ORACLE_LICENSE.newLogEntry(stringArray);
                break;
            }
            case INVALID_UNIVERSAL_CONNECTOR_LICENSE: {
                scheduleLogEntry = RosettaMsg.JOB_FAILED_DUE_TO_UNIVERSAL_CONNECTOR_LICENSE.newLogEntry(stringArray);
                break;
            }
            case NEED_TO_UPDATE_AGENT: {
                scheduleLogEntry = RosettaMsg.AGENT_UPDATE_REQUIRED.newLogEntry(stringArray);
                break;
            }
            case OUTSIDE_TIMERANGE: {
                scheduleLogEntry = RosettaMsg.JOB_CANCELED_DUE_TO_TIMERANGE.newLogEntry(stringArray);
                break;
            }
            case PLATFORM_COMMAND_INCOMPATIBILITY: {
                scheduleLogEntry = RosettaMsg.JOB_ERRORED_DUE_TO_COMMAND_PLATFORM_MISMATCH.newLogEntry(stringArray);
                break;
            }
            case SEQUEL_PROHIBITED_COMMAND: {
                scheduleLogEntry = RosettaMsg.JOB_ERRORED_DUE_TO_PROHIBITED_SEQUEL_COMMAND.newLogEntry(stringArray);
                break;
            }
            case UNSUPPORTED_COMMAND_TYPE: {
                scheduleLogEntry = RosettaMsg.UNSUPPORTED_COMMAND_TYPE.newLogEntry(stringArray);
                break;
            }
            case JOB_PARAMETER_ERROR: {
                scheduleLogEntry = RosettaMsg.JOB_PARAMETER_ERROR.newLogEntry(stringArray);
                break;
            }
            default: {
                logger.error((Object)("Unhandled SubmitFailedException. Reason " + reason.name()));
                return;
            }
        }
        scheduleLogEntry.setAgentID(jobHistory.getAgentID());
        scheduleLogEntry.setJobID(jobHistory.getJobID());
        scheduleLogEntry.setJobHistoryID(jobHistory.getId());
        ScheduleLogger.write(scheduleLogEntry);
        logger.warn((Object)scheduleLogEntry.getMessageText());
    }

    private JobHistoryDM getJobHistoryDM() {
        if (this.jobHistoryDM == null) {
            this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        }
        return this.jobHistoryDM;
    }

    protected void jobCompleted(long l) {
        this.removeFromTerminateJobSet(l);
        this.notifyOfAgentAvailable("Job with History ID " + l + " completed.");
    }

    private void loadJobConditions(ExecutableJob executableJob, JobHistory jobHistory) throws ResourceUnavailableException, DataException {
        logger.trace((Object)("Retrieving job conditions for job: '" + jobHistory.getJobName() + "' jobHistoryID: " + jobHistory.getId() + " agent: " + jobHistory.getAgentID() + ". "));
        String string = executableJob.getAgent().getVersion();
        int n = RelMod.parse((String)string).toInt();
        int n2 = JobConditionR02M03.MINIMUM_RELMOD.toInt();
        if (n < n2) {
            executableJob.setJobConditions(this.getPreR02M03JobConditions(jobHistory.getJobID()));
        } else {
            executableJob.setJobConditions(this.getR02M03JobConditions(jobHistory.getJobID()));
        }
        executableJob.setIgnoreConditions(jobHistory.isBypassConditions());
    }

    private JobCondition[] getPreR02M03JobConditions(long l) throws ResourceUnavailableException, DataException {
        JobCondition[] jobConditionArray = null;
        jobConditionArray = this.jobConditionDM.getList(l, new JobCondition());
        return jobConditionArray;
    }

    private JobCondition[] getR02M03JobConditions(long l) {
        JobCondition[] jobConditionArray = null;
        try {
            jobConditionArray = (JobConditionR02M03[])this.jobConditionDM.getList(l, new JobConditionR02M03());
        }
        catch (Exception exception) {
            logger.error((Object)("Error loading Job Conditions for jobID " + l), (Throwable)exception);
        }
        for (JobCondition jobCondition : jobConditionArray) {
            if (jobCondition.getConditionType() != JobConditionType.FILE_TRANSFER_SYSTEM) continue;
            try {
                this.jobConditionDM.fillJobConditionFromFTS((JobConditionR02M03)jobCondition);
            }
            catch (Exception exception) {
                logger.error((Object)("Error filling jobCondition from FileTransferSystem object for jobCondition ID = " + jobCondition.getOid()), (Throwable)exception);
            }
        }
        return jobConditionArray;
    }

    private void validateAgentEnvironmentForOS(String string) throws IllegalStateException {
        AgentEnvironmentType agentEnvironmentType = AgentEnvironmentType.persistanceCodeToEnum(string);
        String string2 = this.getAgent().getOperatingSystem();
        switch (agentEnvironmentType) {
            case STANDARD: {
                if (!string2.contains(OS400_OS_CHECK_STRING)) break;
                throw new IllegalStateException("Agent Environment Type " + string + " is incompatible with the OS " + string2);
            }
            case IBM_I: {
                if (string2.contains(OS400_OS_CHECK_STRING)) break;
                throw new IllegalStateException("Agent Environment Type " + string + " is incompatible with the OS " + string2);
            }
        }
    }

    private void validateCommandSetForOS(String string, long l) {
        int n = 0;
        try {
            n = this.jobDM.get(l).getCommandSet().getType();
        }
        catch (Exception exception) {
            logger.error((Object)("Error validating Command Set Type for Job ID " + l + "."), (Throwable)exception);
            return;
        }
        CommandSetType commandSetType = CommandSetType.persistanceCodeToEnum(n);
        switch (commandSetType) {
            case PRIVATE: 
            case SHARED: {
                if (!string.contains(OS400_OS_CHECK_STRING)) break;
                throw new IllegalStateException("Command Set Type '" + commandSetType + "' is incompatible with the OS '" + string + "'.");
            }
            case PRIVATE_IBMI: 
            case SHARED_IBMI: {
                if (string.contains(OS400_OS_CHECK_STRING)) break;
                throw new IllegalStateException("Command Set Type '" + commandSetType + "' is incompatible with the OS '" + string + "'.");
            }
            default: {
                logger.warn((Object)("Unhandled CommandSetType " + commandSetType + " while validating Command Set Type for OS."));
            }
        }
    }

    public void bypassConditionsOnJob(JobHistory jobHistory, String string) throws ResourceUnavailableException, ActionFailedException, DataException {
        long l = jobHistory.getId();
        String string2 = jobHistory.getJobName();
        String string3 = jobHistory.getAgentName();
        if (!jobHistory.isBypassConditions() && (jobHistory.getStatusCode().equals(JobStatusCode.CONDITION_RETRY_WAIT) || jobHistory.getStatusCode().equals(JobStatusCode.CONDITION_CHECK))) {
            logger.debug((Object)("Notifying Agent " + string3 + " to run the conditional job '" + string2 + "' with run number " + l + " without conditions."));
            String[] stringArray = new String[]{string2, Long.toString(l), string3, string};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.CONDITIONAL_JOB_RUN_BY_USER.newLogEntry(stringArray);
            scheduleLogEntry.setAgentID(jobHistory.getAgentID());
            scheduleLogEntry.setJobHistoryID(l);
            scheduleLogEntry.setJobID(jobHistory.getJobID());
            ScheduleLogger.write(scheduleLogEntry);
            JobExecDM jobExecDM = (JobExecDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.agent, (String)"ENTERPRISE.JobExecDM");
            jobExecDM.bypassConditions(Long.toString(l), string);
        }
    }

    public String toString() {
        return this.objectName;
    }

    public void setName(String string) {
        this.objectName = string;
    }

    protected void agentConnected(Agent agent) {
        if (!this.agent.isTheSameAs((Object)agent)) {
            this.updateAgentInfo(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean terminateJobSetContains(long l) {
        Set<Long> set = this.terminateJobSet;
        synchronized (set) {
            return this.terminateJobSet.contains(l);
        }
    }

    private void agentShutdownInProgress() {
        this.agentShutDownInProgress = true;
        this.setAgentUnavailable(SubmitFailedException.Reason.SHUTDOWN_IN_PROGRESS.toString());
    }

    protected void agentDisconnected() {
        this.agentShutDownInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAgentAvailable() {
        Object object = this.agentAvailableObject;
        synchronized (object) {
            return this.agentAvailable;
        }
    }

    private void setAgentUnavailable(String string) {
        if (this.isAgentAvailable()) {
            this.setAgentAvailable(false, string);
        }
    }

    protected void notifyOfAgentAvailable(String string) {
        this.notifyOfAgentAvailable(string, false);
    }

    protected void notifyOfAgentAvailable(String string, boolean bl) {
        if (bl) {
            this.agentShutDownInProgress = false;
            this.setAgentAvailable(true, string);
        } else if (!this.agentShutDownInProgress && !this.isAgentAvailable()) {
            this.setAgentAvailable(true, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAgentAvailable(boolean bl, String string) {
        Object object = this.agentAvailableObject;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                String string2 = "available";
                if (!bl) {
                    string2 = "unavailable";
                }
                String string3 = "Setting Agent " + this.agent.getName() + " " + string2 + " due to " + string;
                logger.debug((Object)string3);
            }
            this.agentAvailable = bl;
        }
    }

    private boolean isAgentUpdateRequired(Exception exception, JobHistory jobHistory) {
        boolean bl = this.isCommandAttempt(exception, CommandType.SAP);
        boolean bl2 = this.isCommandAttempt(exception, CommandType.MS_SQL);
        boolean bl3 = this.isCommandAttempt(exception, CommandType.JOB_CONDITION);
        boolean bl4 = bl || bl2 || bl3;
        Throwable throwable = exception.getCause();
        if (bl4 || throwable instanceof ClassNotFoundException || throwable instanceof InvalidObjectException || throwable instanceof InvalidClassException) {
            String string = "Feature unsupported; Error Running Job " + jobHistory.getJobName() + " with JobHistoryID " + jobHistory.getId() + ".  Please update Agent " + jobHistory.getAgentName();
            logger.warn((Object)string, (Throwable)exception);
            jobHistory.setJobEndedReasonCode(JobEndedReasonCode.AGENT_UPDATE_REQUIRED);
            ScheduleLogEntry scheduleLogEntry = null;
            String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName()};
            scheduleLogEntry = bl ? RosettaMsg.SAP_COMMAND_BACKLEVEL_AGENT.newLogEntry(stringArray) : (bl2 ? RosettaMsg.SQL_SERVER_JOB_BACKLEVEL_AGENT.newLogEntry(stringArray) : (bl3 ? RosettaMsg.CONDITIONAL_JOB_BACKLEVEL_AGENT.newLogEntry(stringArray) : RosettaMsg.AGENT_UPDATE_REQUIRED.newLogEntry(stringArray)));
            logger.warn((Object)scheduleLogEntry.getMessageText());
            scheduleLogEntry.setAgentID(jobHistory.getAgentID());
            scheduleLogEntry.setJobID(jobHistory.getJobID());
            scheduleLogEntry.setJobHistoryID(jobHistory.getId());
            ScheduleLogger.write(scheduleLogEntry);
            return true;
        }
        return false;
    }

    public boolean isCommandAttempt(Exception exception, CommandType commandType) {
        Throwable throwable = exception;
        String string = "";
        switch (commandType) {
            case JOB_CONDITION: {
                string = "busobj.JobCondition";
                break;
            }
            case MS_SQL: {
                string = "busobj.SqlServer";
                break;
            }
            case SAP: {
                string = "busobj.sap.";
                break;
            }
            case INFORMATICA: {
                string = "busobj.informatica.";
            }
        }
        while (throwable != null) {
            if (throwable instanceof ClassNotFoundException && throwable.getMessage().contains(string)) {
                return true;
            }
            if (commandType.equals((Object)CommandType.SAP) && throwable instanceof InvalidObjectException && throwable.getMessage().contains("enum constant SAP_RUN_INTERCEPT does not exist")) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public void notifyOfSAPXMIAuditLevelChange(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        this.jobHelper.sapXMIAuditLevelChange(l, sAPXMIAuditLevel);
    }

    public Agent getAgent() {
        return this.agent;
    }

    public boolean isJobQueueHeld() {
        return this.onHold;
    }

    protected boolean isToBeTerminated(long l) {
        return this.removeFromTerminateJobSet(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateJob(JobHistory jobHistory, String string, boolean bl) {
        String string2 = "is not";
        if (bl) {
            string2 = "is";
        }
        logger.debug((Object)("Received notice from " + string + " to terminate job history " + jobHistory.getId() + " which " + string2 + " running for Agent " + this.agent.getName()));
        this.addToTerminateJobSet(jobHistory.getId());
        Set<Long> set = this.terminateJobSet;
        synchronized (set) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added " + jobHistory.getId() + " to terminateJobSet for Agent " + this.agent.getName() + ".  Size:" + this.terminateJobSet.size()));
            }
            if (logger.isTraceEnabled()) {
                String string3 = "\nAgent " + this.agent.getName() + " - Jobs on terminateJobSet:";
                Iterator<Long> iterator = this.terminateJobSet.iterator();
                while (iterator.hasNext()) {
                    string3 = string3 + "\n" + iterator.next();
                }
                logger.trace((Object)string3);
            }
        }
        try {
            this.terminateJobQueue.put(new TerminateJobInfo(jobHistory, string, bl));
            this.startJobTerminator();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"BlockingQueue.put operation was unexpectedly interrupted.", (Throwable)interruptedException);
        }
    }

    private void startJobTerminator() {
        if (this.jobTerminator == null) {
            this.jobTerminator = new JobTerminator();
        }
        if (this.jobTerminatorThread == null || !this.jobTerminatorThread.isAlive()) {
            this.agentWorkManagerAM.acquireSemaphore();
            this.jobTerminatorThread = new Thread((Runnable)this.jobTerminator, "Job Terminator for " + this.agent.getName());
            this.jobTerminatorThread.start();
        } else {
            this.jobTerminator.notifyJobTerminator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToTerminateJobSet(long l) {
        Set<Long> set = this.terminateJobSet;
        synchronized (set) {
            this.terminateJobSet.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromTerminateJobSet(long l) {
        boolean bl;
        Set<Long> set = this.terminateJobSet;
        synchronized (set) {
            String string;
            bl = this.terminateJobSet.remove(l);
            if (logger.isDebugEnabled()) {
                string = " was removed";
                if (!bl) {
                    string = " was not removed";
                }
                logger.debug((Object)("Agent " + this.agent.getName() + " - Jobs on terminateJobSet(after " + l + string + "):" + this.terminateJobSet.size()));
            }
            if (logger.isTraceEnabled()) {
                string = "\nAgent " + this.agent.getName() + " - Jobs on terminateJobSet:";
                if (this.terminateJobSet.isEmpty()) {
                    string = string + " none.";
                } else {
                    Iterator<Long> iterator = this.terminateJobSet.iterator();
                    while (iterator.hasNext()) {
                        string = string + "\n" + iterator.next();
                    }
                }
                logger.trace((Object)string);
            }
        }
        return bl;
    }

    public void shutdown() {
        this.jobTerminator.shutdown = true;
        if (this.jobTerminatorThread != null && this.jobTerminatorThread.isAlive()) {
            this.jobTerminatorThread.interrupt();
        }
    }

    public String loadRunningJobLog(JobHistory jobHistory, String string) throws RunningJobLogException {
        return this.jobHelper.loadJobLog(jobHistory, string);
    }

    private class TerminateJobInfo {
        private JobHistory jobHistory;
        private String userName;
        private boolean isRunning;

        public TerminateJobInfo(JobHistory jobHistory, String string, boolean bl) {
            this.jobHistory = jobHistory;
            this.userName = string;
            this.isRunning = bl;
        }
    }

    class JobTerminator
    implements Runnable {
        private boolean shutdown = false;
        private TerminateJobInfo terminateJobInfo;
        private long jobHistoryID;
        private String jobName;
        private JobHistory latestJobHistoryRecord;
        private Object interruptableObject = new Object();

        JobTerminator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug((Object)("The Job Terminator for agent " + AgentWorkManager.this.agent.getName() + " has started."));
            while (!this.shutdown) {
                try {
                    block28: {
                        this.terminateJobInfo = (TerminateJobInfo)AgentWorkManager.this.terminateJobQueue.poll();
                        if (this.terminateJobInfo == null) break;
                        this.jobHistoryID = this.terminateJobInfo.jobHistory.getId();
                        this.jobName = this.terminateJobInfo.jobHistory.getJobName();
                        logger.debug((Object)("Next job to terminate: " + this.jobName + "(" + this.jobHistoryID + ").  Remaining = " + AgentWorkManager.this.terminateJobQueue.size()));
                        if (!AgentWorkManager.this.terminateJobSetContains(this.jobHistoryID)) {
                            logger.debug((Object)("Job History ID " + this.jobHistoryID + " no longer needs terminating."));
                            continue;
                        }
                        if (!this.terminateJobInfo.isRunning) {
                            try {
                                AgentWorkManager.this.agentWorkManagerAM.dequeueJob(this.terminateJobInfo.jobHistory);
                                AgentWorkManager.this.removeFromTerminateJobSet(this.jobHistoryID);
                            }
                            catch (NotOnQueueException notOnQueueException) {
                                Object object = AgentWorkManager.this.startingJobSet;
                                synchronized (object) {
                                    if (AgentWorkManager.this.startingJobSet.contains(this.jobHistoryID)) {
                                        logger.debug((Object)("Throwing job " + this.jobName + "(" + this.jobHistoryID + ") back on the terminate queue." + "  Job is in the process of being started."));
                                        AgentWorkManager.this.terminateJobQueue.add(this.terminateJobInfo);
                                        Object object2 = this.interruptableObject;
                                        synchronized (object2) {
                                            try {
                                                this.interruptableObject.wait(1000L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                logger.debug((Object)"*** interruptableObject was interrupted ***");
                                            }
                                        }
                                    }
                                }
                                try {
                                    this.latestJobHistoryRecord = AgentWorkManager.this.getJobHistoryDM().get(this.jobHistoryID);
                                    if (this.latestJobHistoryRecord.isIBMiJobSubmitted() || this.latestJobHistoryRecord.getQueueEndedTime() != 0L) break block28;
                                    logger.debug((Object)("Job " + this.jobName + "(" + this.jobHistoryID + ") not yet started."));
                                    object = this.interruptableObject;
                                    synchronized (object) {
                                        if (AgentWorkManager.this.terminateJobQueue.size() == 0) {
                                            try {
                                                this.interruptableObject.wait(500L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                logger.debug((Object)"*** interruptableObject was interrupted ***");
                                            }
                                        }
                                    }
                                    logger.debug((Object)("Throwing job " + this.jobName + "(" + this.jobHistoryID + ") back on the terminate queue."));
                                    AgentWorkManager.this.terminateJobQueue.add(this.terminateJobInfo);
                                }
                                catch (Exception exception) {
                                    logger.error((Object)("Error obtaining latest Job History record for ID " + this.jobHistoryID), (Throwable)exception);
                                    AgentWorkManager.this.removeFromTerminateJobSet(this.jobHistoryID);
                                }
                            }
                            catch (Exception exception) {
                                logger.error((Object)"Error attempting to remove job from the queue.", (Throwable)exception);
                                AgentWorkManager.this.removeFromTerminateJobSet(this.jobHistoryID);
                            }
                            continue;
                        }
                    }
                    JobExecDM jobExecDM = (JobExecDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)AgentWorkManager.this.agent, (String)"ENTERPRISE.JobExecDM");
                    try {
                        jobExecDM.endJob(String.valueOf(this.jobHistoryID), this.terminateJobInfo.userName);
                    }
                    catch (NullPointerException nullPointerException) {
                        logger.debug((Object)"Ending an older Agent.  Not able to track who ended the job in the joblog.");
                        jobExecDM.endJob(String.valueOf(this.jobHistoryID));
                    }
                    logger.debug((Object)("Remote Agent " + AgentWorkManager.this.agent.getName() + " will end the job " + this.jobName + "(" + this.jobHistoryID + ")"));
                    AgentWorkManager.this.removeFromTerminateJobSet(this.jobHistoryID);
                }
                catch (RemoteManagerNotFoundException remoteManagerNotFoundException) {
                    logger.error((Object)("Error ending job history ID " + this.jobHistoryID + "."), (Throwable)remoteManagerNotFoundException);
                    AgentWorkManager.this.removeFromTerminateJobSet(this.jobHistoryID);
                }
                catch (RuntimeException runtimeException) {
                    logger.error((Object)("Unexpected error attempting to end job history ID " + this.jobHistoryID + "."), (Throwable)runtimeException);
                    AgentWorkManager.this.removeFromTerminateJobSet(this.jobHistoryID);
                }
            }
            logger.debug((Object)("The Job Terminator for agent " + AgentWorkManager.this.agent.getName() + " has ended."));
            AgentWorkManager.this.agentWorkManagerAM.releaseSemaphore();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyJobTerminator() {
            Object object = this.interruptableObject;
            synchronized (object) {
                this.interruptableObject.notify();
            }
        }
    }

    class JobRunner
    implements Runnable {
        public Exception exception;
        private JobHistory jobHistory;

        public JobRunner(JobHistory jobHistory) {
            this.jobHistory = jobHistory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AgentWorkManager.this.startingJobSet;
            synchronized (object) {
                AgentWorkManager.this.startingJobSet.add(this.jobHistory.getId());
            }
            logger.debug((Object)"Start of run()");
            this.jobHistory.setQueueEndedTime(System.currentTimeMillis());
            try {
                AgentWorkManager.this.validateAgentEnvironmentForOS(this.jobHistory.getAgentEnvironmentType());
                AgentWorkManager.this.validateCommandSetForOS(AgentWorkManager.this.agent.getOperatingSystem(), this.jobHistory.getJobID());
                object = null;
                try {
                    object = AgentWorkManager.this.jobHelper.loadJob(this.jobHistory);
                    if (((ExecutableJob)((Object)object)).isConditional()) {
                        AgentWorkManager.this.loadJobConditions((ExecutableJob)((Object)object), this.jobHistory);
                    }
                    AgentWorkManager.this.jobHelper.runJob(this.jobHistory, (ExecutableJob)((Object)object));
                    logger.debug((Object)("Job " + this.jobHistory.getJobName() + "(" + this.jobHistory.getId() + ") was sent to the Agent " + AgentWorkManager.this.agent.getName() + "."));
                    AgentWorkManager.this.agentWorkManagerAM.jobStartedOnAgent(this.jobHistory);
                }
                catch (SubmitFailedException submitFailedException) {
                    AgentWorkManager.this.processSubmitFailedException(submitFailedException, this.jobHistory, (ExecutableJob)((Object)object));
                }
                catch (RuntimePeerDisconnectedException runtimePeerDisconnectedException) {
                    String string = MessageUtil.formatMsg((String)"The agent disconnected while trying to run job {0} run ID {1}. The state of the job run on the agent is unknown.", (Object[])new Object[]{this.jobHistory.getJobName(), this.jobHistory.getId()});
                    logger.warn((Object)string);
                    this.jobHistory.setNeedToCheckIfJobRunHasStarted(true);
                    AgentWorkManager.this.agentWorkManagerAM.requeueJob(this.jobHistory, SubmitFailedException.Reason.AGENT_OFFLINE);
                }
            }
            catch (RequeueJobException requeueJobException) {
                this.exception = requeueJobException;
                switch (requeueJobException.getReason()) {
                    case AGENT_OFFLINE: {
                        AgentWorkManager.this.setAgentUnavailable(requeueJobException.getReason().toString());
                        break;
                    }
                    case CREATE_PROCESS_FAILED: {
                        try {
                            JobHistory jobHistory = AgentWorkManager.this.getJobHistoryDM().get(this.jobHistory.getId());
                            if (jobHistory.getStatusCode().isTerminalState()) {
                                AgentWorkManager.this.addToTerminateJobSet(this.jobHistory.getId());
                                break;
                            }
                            logger.warn((Object)("Run " + jobHistory.getId() + " of Job " + this.jobHistory.getJobName() + " is being requeued due to: " + requeueJobException.getMessage()));
                        }
                        catch (Exception exception) {
                            logger.error((Object)("Error getting latest job history record for ID " + this.jobHistory.getId()), (Throwable)exception);
                            AgentWorkManager.this.addToTerminateJobSet(this.jobHistory.getId());
                        }
                        break;
                    }
                    case SHUTDOWN_IN_PROGRESS: {
                        AgentWorkManager.this.agentShutdownInProgress();
                    }
                }
                if (AgentWorkManager.this.terminateJobSetContains(this.jobHistory.getId())) {
                    AgentWorkManager.this.removeFromTerminateJobSet(this.jobHistory.getId());
                    AgentWorkManager.this.agentWorkManagerAM.removeFromActiveList(this.jobHistory);
                    logger.debug((Object)("JobHistoryID: " + this.jobHistory.getId() + " will not be requeued.  It is flagged to be terminated."));
                } else {
                    try {
                        AgentWorkManager.this.agentWorkManagerAM.requeueJob(this.jobHistory, requeueJobException.getReason());
                        requeueJobException.setJobRequeued(true);
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error placing run number " + this.jobHistory.getId() + " of Job '" + this.jobHistory.getJobName() + "' back on the queue: " + this.jobHistory.getJobQueueName()), (Throwable)exception);
                        AgentWorkManager.this.agentWorkManagerAM.jobFailedToStart(this.jobHistory);
                        this.exception = new EndJobException(exception.getMessage(), exception);
                    }
                }
            }
            catch (JobCanceledException jobCanceledException) {
                this.jobHistory.setStatusCode(JobStatusCode.CANCELED);
                this.jobHistory.setJobEndedReasonCode(jobCanceledException.getReason());
                this.jobHistory.setQueueEndedTime(System.currentTimeMillis());
                AgentWorkManager.this.agentWorkManagerAM.jobFailedToStart(this.jobHistory);
            }
            catch (JobFailedException jobFailedException) {
                this.jobHistory.setStatusCode(JobStatusCode.FAILED);
                this.jobHistory.setJobEndedReasonCode(jobFailedException.getReason());
                this.jobHistory.setQueueEndedTime(System.currentTimeMillis());
                AgentWorkManager.this.agentWorkManagerAM.jobFailedToStart(this.jobHistory);
            }
            catch (Exception exception) {
                if (!AgentWorkManager.this.isAgentUpdateRequired(exception, this.jobHistory)) {
                    String string = "Error Running JobHistoryID " + this.jobHistory.getId() + " on Agent " + this.jobHistory.getAgentName();
                    logger.debug((Object)string, (Throwable)exception);
                }
                logger.error((Object)"Error while starting job.", (Throwable)exception);
                this.jobHistory.setStatusCode(JobStatusCode.ERROR);
                this.jobHistory.setQueueEndedTime(System.currentTimeMillis());
                AgentWorkManager.this.agentWorkManagerAM.jobFailedToStart(this.jobHistory);
            }
            finally {
                AgentWorkManager.this.agentWorkManagerAM.releaseSemaphore();
                Set set = AgentWorkManager.this.startingJobSet;
                synchronized (set) {
                    AgentWorkManager.this.startingJobSet.remove(this.jobHistory.getId());
                }
            }
            logger.debug((Object)"End of run()");
        }
    }

    private static enum CommandType {
        SAP,
        MS_SQL,
        JOB_CONDITION,
        INFORMATICA;

    }
}

