/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.access.dataset.EmptyDataSet;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.AgentLicenseStatus;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentStatusAM;
import com.helpsystems.enterprise.peer.AgentPeer;
import org.apache.log4j.Logger;

public class AgentStatusAMImpl
extends AbstractManager
implements AgentStatusAM {
    private static Logger logger = Logger.getLogger(AgentStatusAMImpl.class);
    private AgentPeer peer;

    public AgentStatusAMImpl(AgentPeer agentPeer) {
        this.setName("ENTERPRISE.AgentStatusAM");
        this.peer = agentPeer;
    }

    @Override
    public AgentProxy[] getStatus(AgentProxy[] agentProxyArray) {
        return this.getStatus(agentProxyArray, false);
    }

    private AgentProxy[] getStatus(AgentProxy[] agentProxyArray, boolean bl) {
        if (agentProxyArray == null) {
            return null;
        }
        int n = this.peer.getDefaultLicenseState(bl);
        for (AgentProxy agentProxy : agentProxyArray) {
            PeerID peerID = this.peer.searchForAgent(agentProxy);
            int n2 = agentProxy.getRuntimeState();
            int n3 = 3;
            if (peerID == null) {
                if (n2 != 1) {
                    n3 = n2;
                } else {
                    logger.debug((Object)("getStatus is Setting previously active agent status to failed for agent " + agentProxy.getName()));
                    n3 = 3;
                }
                AgentLicenseStatus agentLicenseStatus = new AgentLicenseStatus();
                if (agentProxy.isLicensed()) {
                    agentLicenseStatus.setLicenseState(3);
                } else {
                    agentLicenseStatus.setLicenseState(n);
                }
                agentProxy.setLicenseStatus(agentLicenseStatus);
            } else {
                n3 = 1;
                agentProxy.setLicenseStatus(this.peer.getAgentLicenseStatus(peerID));
            }
            agentProxy.setRuntimeState(n3);
        }
        return agentProxyArray;
    }

    @Override
    public DataSet<AgentProxy> getDataSet(boolean bl) throws DataSetException, ResourceUnavailableException {
        ArrayDataSet arrayDataSet;
        DataSet<AgentProxy> dataSet = this.getAgentDM().getDataSet(null, null, null);
        try {
            ArrayDataSet arrayDataSet2;
            if (dataSet.size() == 0) {
                EmptyDataSet emptyDataSet = new EmptyDataSet();
                return emptyDataSet;
            }
            AgentProxy[] agentProxyArray = (AgentProxy[])ArrayDataSet.toArray(dataSet, (boolean)true);
            agentProxyArray = this.getStatus(agentProxyArray, bl);
            arrayDataSet = arrayDataSet2 = new ArrayDataSet((Object[])agentProxyArray);
        }
        catch (BadDataException badDataException) {
            throw new DataSetException("Invalid Data returned from the database.", (Throwable)badDataException);
        }
        finally {
            try {
                dataSet.close();
            }
            catch (Exception exception) {}
        }
        return arrayDataSet;
    }

    @Override
    public DataSet<AgentProxy> getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws DataSetException, ResourceUnavailableException {
        ArrayDataSet arrayDataSet;
        DataSet<AgentProxy> dataSet = this.getAgentDM().getDataSet(userIdentity, dataFilter, sortField);
        try {
            ArrayDataSet arrayDataSet2;
            if (dataSet.size() == 0) {
                EmptyDataSet emptyDataSet = new EmptyDataSet();
                return emptyDataSet;
            }
            AgentProxy[] agentProxyArray = (AgentProxy[])ArrayDataSet.toArray(dataSet, (boolean)true);
            agentProxyArray = this.getStatus(agentProxyArray);
            arrayDataSet = arrayDataSet2 = new ArrayDataSet((Object[])agentProxyArray);
        }
        catch (BadDataException badDataException) {
            throw new DataSetException("Invalid Data returned from the database.", (Throwable)badDataException);
        }
        finally {
            try {
                dataSet.close();
            }
            catch (Exception exception) {}
        }
        return arrayDataSet;
    }

    private AgentDM getAgentDM() {
        return (AgentDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentDM");
    }

    @Override
    public void refresh() throws ResourceUnavailableException, ActionFailedException {
        this.peer.pollAgents(true);
    }
}

