/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorAM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.AgentEventRefreshAM;
import com.helpsystems.enterprise.module.ExecutableJobHelper;
import com.helpsystems.enterprise.peer.AgentPeer;

public class AgentEventRefreshAMImpl
extends AbstractManager
implements AgentEventRefreshAM {
    private AgentPeer agentPeer;

    public AgentEventRefreshAMImpl(AgentPeer agentPeer) {
        this.setName("ENTERPRISE.AgentEventRefreshAM");
        this.agentPeer = agentPeer;
    }

    @Override
    public void refreshEventsForAgent(long l) throws ActionFailedException {
        try {
            Agent agent = ExecutableJobHelper.loadAgentOID(l);
            if (agent == null) {
                throw new ActionFailedException("Agent " + l + " is undefined.");
            }
            if (!this.agentPeer.isLicensedAndOnline((AgentProxy)agent)) {
                return;
            }
            AgentEventMonitorDM agentEventMonitorDM = (AgentEventMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorDM");
            AgentEventMonitor[] agentEventMonitorArray = agentEventMonitorDM.getEventsForAgent(l);
            AgentEventMonitorAM agentEventMonitorAM = (AgentEventMonitorAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"ENTERPRISE.AgentEventMonitorAM");
            RelMod relMod = RelMod.parse((String)agent.getVersion());
            int n = AgentEventMonitorAM.RELMOD0202.compareTo((Object)relMod);
            if (n < 0) {
                for (int i = 0; i < agentEventMonitorArray.length; ++i) {
                    agentEventMonitorArray[i].setAgentOID(agent.getOid());
                }
                agentEventMonitorAM.setMonitors(agentEventMonitorArray);
            } else {
                agentEventMonitorAM.setMonitors(agentEventMonitorArray, agent.getOid());
            }
            return;
        }
        catch (Exception exception) {
            String string = "Unable to notify agent " + l + " about new event monitors.";
            throw new ActionFailedException(string, (Throwable)exception);
        }
    }
}

