/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.webservices.test;

import com.helpsystems.enterprise.core.webservices.WebServiceExecutor_Apache;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestComposite;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestParameter;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestProperty;
import com.helpsystems.enterprise.core.webservices.WebServiceServer;
import com.helpsystems.enterprise.core.webservices.test.WebServiceTestHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.apache.http.client.ClientProtocolException;

public class WebServiceTest_Github
extends WebServiceTestHelper {
    private static final String DELIMITER = "=================================================================";
    private static final String github_user = "KeithKruse";
    private static final String github_pwd = "***********";
    private static final String github_org = "HelpSystems";
    WebServiceServer wss = new WebServiceServer("https://api.github.com");

    public static void main(String[] stringArray) throws UnsupportedEncodingException, ClientProtocolException, IOException, URISyntaxException {
        WebServiceTest_Github webServiceTest_Github = new WebServiceTest_Github();
        webServiceTest_Github.runTests();
    }

    private void runTests() throws UnsupportedEncodingException, ClientProtocolException, IOException, URISyntaxException {
        String string = "get_user_info";
        WebServiceRequestComposite webServiceRequestComposite = this.loadGetUserRequest(this.wss, github_user);
        this.processRequest(webServiceRequestComposite, string);
        super.setBasicAuthority(github_user, "popcorn", github_pwd, this.wss);
        string = "get_user_repo_list_page";
        webServiceRequestComposite = this.loadGetUserRepoListPage(this.wss);
        this.processRequest(webServiceRequestComposite, string);
        string = "get_organization";
        webServiceRequestComposite = this.loadGetOrganization(this.wss, github_org);
        this.processRequest(webServiceRequestComposite, string);
        string = "get_org_members";
        webServiceRequestComposite = this.loadGetOrgMembers(this.wss, github_org);
        this.processRequest(webServiceRequestComposite, string);
        string = "get_org_teams";
        webServiceRequestComposite = this.loadGetOrgTeams(this.wss, github_org);
        this.processRequest(webServiceRequestComposite, string);
        System.out.println(DELIMITER);
        System.out.println("Web Service Tests Finished!");
        System.exit(0);
    }

    private void processRequest(WebServiceRequestComposite webServiceRequestComposite, String string) throws UnsupportedEncodingException, ClientProtocolException, IOException, URISyntaxException {
        System.out.println(DELIMITER);
        System.out.println(" Web Service Request Test Name: " + string);
        System.out.println(DELIMITER);
        WebServiceRequestComposite webServiceRequestComposite2 = WebServiceTest_Github.wsrTestSaveRestore(webServiceRequestComposite, string);
        WebServiceExecutor_Apache webServiceExecutor_Apache = new WebServiceExecutor_Apache();
        int n = webServiceExecutor_Apache.processRequest(webServiceRequestComposite2);
        System.out.println();
        System.out.println("Web Service Request Return Code: " + n);
        System.out.println();
    }

    private static WebServiceRequestComposite wsrTestSaveRestore(WebServiceRequestComposite webServiceRequestComposite, String string) {
        try {
            String string2 = string + ".config.xml";
            WebServiceRequestComposite.saveToDisk(webServiceRequestComposite, string2);
            return WebServiceRequestComposite.restoreFromDisk(string2);
        }
        catch (Exception exception) {
            System.out.println("Error saving/restoring web service request.");
            exception.printStackTrace();
            return null;
        }
    }

    private WebServiceRequestComposite loadGetUserRequest(WebServiceServer webServiceServer, String string) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("/users/" + string);
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.setOutputType(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadGetUserRepoListPage(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("/user/repos");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.setOutputType(1);
        webServiceRequest.addParameter(new WebServiceRequestParameter("page", "1", 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("per_page", "25", 2));
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadGetOrganization(WebServiceServer webServiceServer, String string) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("/orgs/" + string);
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.setOutputType(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadGetOrgMembers(WebServiceServer webServiceServer, String string) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("/orgs/" + string + "/members");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.setOutputType(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadGetOrgTeams(WebServiceServer webServiceServer, String string) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("/orgs/" + string + "/teams");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.setOutputType(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }
}

