/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.webservices.test;

import com.helpsystems.enterprise.core.webservices.WebServiceExecutor_Apache;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestComposite;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestParameter;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestProperty;
import com.helpsystems.enterprise.core.webservices.WebServiceServer;
import com.helpsystems.enterprise.core.webservices.test.WebServiceTestHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.apache.http.client.ClientProtocolException;

public class WebServiceExtendedTest
extends WebServiceTestHelper {
    private static final String DELIMITER = "=================================================================";
    private static final String SKYADMIN = "admin";
    private static final String SKYADMIN_PWD = "Enterprise2";
    WebServiceServer wssHttpWebX = new WebServiceServer("http://www.webservicex.net/");
    WebServiceServer wssHttpTatoosh = new WebServiceServer("http://tatoosh:3333/");
    WebServiceServer wssHttpSkybot = new WebServiceServer("http://skybot-robot:8008/");
    WebServiceServer untrustedSSL = new WebServiceServer("https://www.pcwebshop.co.uk/");

    public static void main(String[] stringArray) {
        try {
            new WebServiceExtendedTest();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (ClientProtocolException clientProtocolException) {
            clientProtocolException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    public WebServiceExtendedTest() throws UnsupportedEncodingException, ClientProtocolException, IOException, URISyntaxException {
        this.wssHttpWebX.resetAuthority();
        this.wssHttpTatoosh.resetAuthority();
        super.setBasicAuthority(SKYADMIN, "popcorn", SKYADMIN_PWD, this.wssHttpSkybot);
        String string = "get_stock_quote";
        WebServiceRequestComposite webServiceRequestComposite = this.getStockQuote(this.wssHttpWebX);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        string = "post_stock_quote";
        webServiceRequestComposite = this.postStockQuote(this.wssHttpWebX);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        string = "get_weather_FAIL";
        webServiceRequestComposite = this.getWeather(this.wssHttpWebX);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        string = "post_weather_FAIL";
        webServiceRequestComposite = this.postWeather(this.wssHttpWebX);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        string = "get_ipaddress_location";
        webServiceRequestComposite = this.getIPAddressLocation(this.wssHttpWebX);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        string = "post_ipaddress_location";
        webServiceRequestComposite = this.postIPAddressLocation(this.wssHttpWebX);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        string = "get_system_settings";
        webServiceRequestComposite = this.getSystemSettings(this.wssHttpTatoosh);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        string = "put_Object_Rule_File_Entity";
        webServiceRequestComposite = this.postObjectRule2(this.wssHttpTatoosh);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        String string2 = "WSR_TESTJOB";
        string = "skybot_delete_job_before_add";
        WebServiceRequestComposite webServiceRequestComposite2 = this.loadDeleteSkybotJobRequest(this.wssHttpSkybot, string2);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite2, string);
        string = "skybot_add_job";
        webServiceRequestComposite = this.loadAddSkybotJobRequestString(this.wssHttpSkybot, string2);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        string = "skybot_delete_job_after_add";
        WebServiceExtendedTest.processRequest(webServiceRequestComposite2, string);
        string = "untrusted_ssl";
        webServiceRequestComposite = this.getUntrustedSSL(this.untrustedSSL);
        WebServiceExtendedTest.processRequest(webServiceRequestComposite, string);
        System.out.println(DELIMITER);
        System.out.println("Web Service Tests Finished!");
        System.exit(0);
    }

    private static void processRequest(WebServiceRequestComposite webServiceRequestComposite, String string) throws UnsupportedEncodingException, ClientProtocolException, IOException, URISyntaxException {
        System.out.println(DELIMITER);
        System.out.println(" Web Service Request Test Name: " + string);
        System.out.println(DELIMITER);
        WebServiceRequestComposite webServiceRequestComposite2 = WebServiceExtendedTest.wsrTestSaveRestore(webServiceRequestComposite, string);
        WebServiceExecutor_Apache webServiceExecutor_Apache = new WebServiceExecutor_Apache();
        int n = webServiceExecutor_Apache.processRequest(webServiceRequestComposite2);
        System.out.println();
        System.out.println("Web Service Request Return Code: " + n);
        System.out.println();
    }

    private static WebServiceRequestComposite wsrTestSaveRestore(WebServiceRequestComposite webServiceRequestComposite, String string) {
        try {
            String string2 = string + ".config.xml";
            WebServiceRequestComposite.saveToDisk(webServiceRequestComposite, string2);
            return WebServiceRequestComposite.restoreFromDisk(string2);
        }
        catch (Exception exception) {
            System.out.println("Error saving/restoring web service request.");
            exception.printStackTrace();
            return null;
        }
    }

    private WebServiceRequestComposite getStockQuote(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("stockquote.asmx/GetQuote?symbol=GOOG");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite postStockQuote(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("stockquote.asmx/GetQuote");
        webServiceRequest.setRequestMethod(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.configRequestParameters(new WebServiceRequestParameter("symbol", "GOOG", 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite getWeather(WebServiceServer webServiceServer) {
        System.out.println("The following 2 weather requests will fail because the server is down. \nThese tests are here to show what a fail looks like");
        WebServiceRequest webServiceRequest = new WebServiceRequest("WeatherForecast.asmx/GetWeatherByZipCode?ZipCode=55372");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite postWeather(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("WeatherForecast.asmx/GetWeatherByZipCode");
        webServiceRequest.setRequestMethod(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.configRequestParameters(new WebServiceRequestParameter("ZipCode", "55372", 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite getIPAddressLocation(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("geoipservice.asmx/GetGeoIP?IPAddress=207.250.247.34");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite postIPAddressLocation(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("geoipservice.asmx/GetGeoIP");
        webServiceRequest.setRequestMethod(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.configRequestParameters(new WebServiceRequestParameter("IPAddress", "207.250.247.34", 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite getSystemSettings(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("ptns/jsx/rest_v1/systemSettings");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite postObjectRule(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("ptns/jsx/rest_v1/objectLists");
        webServiceRequest.setRequestMethod(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addProperty(new WebServiceRequestProperty("Content-Type", "application/json", 2));
        webServiceRequest.configStringBody("{\"OBJECT_LIST_NAME\":\"BENS5" + (int)(Math.random() * 99.0) + "\",\"OBJECT_LIST_TYPE\":\"Q\",\"OBJECT_LIST_TEXT\":\"It's a REST thing.\"}");
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite postObjectRule2(WebServiceServer webServiceServer) {
        System.out.println("The following will return a 500 because Ben Peter hasn't finished implementing the\nserver side stuff, but the fact that its is trying to PUT shows it works.");
        WebServiceRequest webServiceRequest = new WebServiceRequest("ptns/jsx/rest_v1/userRules/*ALL-*ALL-*PUBLIC");
        webServiceRequest.setRequestMethod(2);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addProperty(new WebServiceRequestProperty("Content-Type", "application/json", 2));
        webServiceRequest.configFileBody("TestJSONFile.txt");
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadDeleteSkybotJobRequest(WebServiceServer webServiceServer, String string) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("automate-schedule/ws/jobs/" + string);
        webServiceRequest.setRequestMethod(3);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadAddSkybotJobRequestString(WebServiceServer webServiceServer, String string) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("automate-schedule/ws/jobs");
        webServiceRequest.setRequestMethod(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addProperty(new WebServiceRequestProperty("Content-Type", "application/xml", 2));
        webServiceRequest.configStringBody("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <request><job> <name>" + string + "</name> <description>created by ws client</description> <target-type>Agent</target-type> <target> <name>CLEVELAND_DEFAULT</name> </target> <agent-environment-name>DEMO_ENV</agent-environment-name> <calendar-name>STANDARD</calendar-name> </job> </request>");
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite getUntrustedSSL(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceServer.setTrustAll(true);
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }
}

