/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UnicodeGenerator
extends JFrame {
    private static final int UNIMAX = 65535;
    private static final int UNISHOWN = 100;
    private static final int SLIDER_MAX = 65435;
    private static final int SLIDER_START = 1;
    private final UnicodeRange[] uniRanges = new UnicodeRange[]{new UnicodeRange("All Characters", 1, 65535), new UnicodeRange("Basic Latin", 1, 127), new UnicodeRange("Latin-1 Supplement", 128, 255), new UnicodeRange("Latin Extended-A", 256, 383), new UnicodeRange("Latin Extended-B", 384, 591), new UnicodeRange("IPA Extensions", 592, 687), new UnicodeRange("Spacing Modifier Letters", 688, 767), new UnicodeRange("Combining Diacritical Marks", 768, 879), new UnicodeRange("Greek", 880, 1023), new UnicodeRange("Cyrillic", 1024, 1279), new UnicodeRange("Armenian", 1328, 1423), new UnicodeRange("Hebrew", 1424, 1535), new UnicodeRange("Arabic", 1536, 1791), new UnicodeRange("Syriac", 1792, 1871), new UnicodeRange("Thaana", 1872, 1983), new UnicodeRange("Devanagari", 2304, 2431), new UnicodeRange("Bengali", 2432, 2559), new UnicodeRange("Gurmukhi", 2560, 2687), new UnicodeRange("Gujarati", 2688, 2815), new UnicodeRange("Oriya", 2816, 2943), new UnicodeRange("Tamil", 2944, 3071), new UnicodeRange("Telugu", 3072, 3199), new UnicodeRange("Kannada", 3200, 3327), new UnicodeRange("Malayalam", 3328, 3455), new UnicodeRange("Sinhala", 3456, 3583), new UnicodeRange("Thai", 3584, 3711), new UnicodeRange("Lao", 3712, 3839), new UnicodeRange("Tibetan", 3840, 4095), new UnicodeRange("Myanmar", 4096, 4255), new UnicodeRange("Georgian", 4256, 4351), new UnicodeRange("Hangul Jamo", 4352, 4607), new UnicodeRange("Ethiopic", 4608, 4991), new UnicodeRange("Cherokee", 5024, 5119), new UnicodeRange("Unified Canadian Aboriginal Syllabics", 5120, 5759), new UnicodeRange("Ogham", 5760, 5791), new UnicodeRange("Runic", 5792, 5887), new UnicodeRange("Khmer", 6016, 6143), new UnicodeRange("Mongolian", 6144, 6319), new UnicodeRange("Latin Extended Additional", 7680, 7935), new UnicodeRange("Greek Extended", 7936, 8191), new UnicodeRange("General Puntuation", 8192, 8303), new UnicodeRange("Superscripts and Subscripts", 8304, 8351), new UnicodeRange("Currency Symbols", 8352, 8399), new UnicodeRange("Combining Marks for Symbols", 8400, 8447), new UnicodeRange("Letterlike Symbols", 8448, 8527), new UnicodeRange("Number Forms", 8528, 8591), new UnicodeRange("Arrows", 8592, 8703), new UnicodeRange("Mathematical Operators", 8704, 8959), new UnicodeRange("Miscellaneous Technical", 8960, 9251), new UnicodeRange("Control Pictures", 9216, 9279), new UnicodeRange("Optical Character Recognition", 9280, 9311), new UnicodeRange("Enclosed Alphanumerics", 9312, 9471), new UnicodeRange("Box Drawing", 9472, 9599), new UnicodeRange("Block Elements", 9600, 9631), new UnicodeRange("Geometric Shapes", 9632, 9727), new UnicodeRange("Miscellaneous Symbols", 9728, 9983), new UnicodeRange("Dingbats", 9984, 10175), new UnicodeRange("Braille Patterns", 10240, 10495), new UnicodeRange("CJK Radicals Supplement", 11904, 12031), new UnicodeRange("Kangxi Radicals", 12032, 12255), new UnicodeRange("Ideographic Description Characters", 12272, 12287), new UnicodeRange("CJK Symbols and Punctuation", 12288, 12351), new UnicodeRange("Hiragana", 12352, 12447), new UnicodeRange("Katakana", 12448, 12543), new UnicodeRange("Bopomofo", 12544, 12591), new UnicodeRange("Hangul Compatibility Jamo", 12592, 12687), new UnicodeRange("Kanbun", 12688, 12703), new UnicodeRange("Bopomofo Extended", 12704, 12735), new UnicodeRange("Enclosed CJK Letters and Months", 12800, 13055), new UnicodeRange("CJK Compatibility", 13056, 13311), new UnicodeRange("CJK Unified Ideographs Extension A", 13312, 19893), new UnicodeRange("CJK Unified Ideographs", 19968, 40959), new UnicodeRange("Yi Syllables", 40960, 42127), new UnicodeRange("Yi Radicals ", 42128, 42191), new UnicodeRange("Hangul Syllables", 44032, 55203), new UnicodeRange("High Surrogates", 55296, 56191), new UnicodeRange("High Private Use Surrogates", 56192, 56319), new UnicodeRange("Low Surrogates", 56320, 57343), new UnicodeRange("Private Use", 57344, 63743), new UnicodeRange("CJK Compatibility Ideographs", 63744, 64255), new UnicodeRange("Alphabetic Presentation Forms", 64256, 64335), new UnicodeRange("Arabic Presentation Forms-A", 64336, 65023), new UnicodeRange("Combining Half Marks", 65056, 65071), new UnicodeRange("CJK Compatibility Forms", 65072, 65103), new UnicodeRange("Small Form Variants", 65104, 65135), new UnicodeRange("Arabic Presentation Forms-B", 65136, 65287), new UnicodeRange("Specials-1", 65279, 65279), new UnicodeRange("Halfwidth and Fullwidth Forms", 65280, 65519), new UnicodeRange("Specials-2", 65520, 65533)};
    private int uniRangeMin;
    private int uniSliderMax;
    private int uniRangeMax;
    private JLabel lblUniValue = new JLabel("Unicode Value:");
    private JTextField txtUniValue = new JTextField("");
    private JPanel pnlUniButtons = null;
    private JScrollPane scrollButtons = null;
    private JButton[] uniButtons = new JButton[100];
    private JComboBox comboRanges = new JComboBox<UnicodeRange>(this.uniRanges);
    private JButton btnIndexJumpUp = new JButton("Index >>100");
    private JButton btnIndexJumpDown = new JButton("Index <<100");
    private JButton btnIndexJump = new JButton("Index Position:");
    private JTextField txtIndexValue = new JTextField(String.valueOf(1), 5);
    private JCheckBox chkShowGrouping = new JCheckBox("Show Grouping", true);
    private JSlider sliderBar = new JSlider(1, 65435, 1);
    private JButton btnClear = new JButton("Clear Unicode Value");
    private JButton btnDetails = new JButton("Unicode Value Details...");
    private JButton btnCancel = new JButton("Close");
    private Dimension uniButtonSize = new Dimension(300, 42);

    public UnicodeGenerator() {
        this.setTitle("Unicode String Generator");
        this.setDefaultCloseOperation(3);
        this.setUniRange(0);
        this.pnlUniButtons = this.getUniButtonsPanel();
        this.scrollButtons = new JScrollPane(this.pnlUniButtons);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    if (UnicodeGenerator.this.chkShowGrouping.isSelected()) {
                        UnicodeGenerator.this.uniButtonSize = new Dimension(300, 40);
                    } else {
                        UnicodeGenerator.this.uniButtonSize = new Dimension(300, 20);
                    }
                    int n = jSlider.getValue();
                    for (int i = 0; i < UnicodeGenerator.this.uniButtons.length; ++i) {
                        UnicodeGenerator.this.updateButton(UnicodeGenerator.this.uniButtons[i], i + n);
                    }
                    UnicodeGenerator.this.txtIndexValue.setText(String.valueOf(n));
                }
            }
        };
        this.sliderBar.addChangeListener(changeListener);
        this.sliderBar.setPaintLabels(true);
        this.sliderBar.setPaintTicks(true);
        this.sliderBar.setBorder(BorderFactory.createTitledBorder("Unicode Index Position"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.getTextPanel(), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this.getIndexPanel(), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this.scrollButtons, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this.getCommandsPanel(), gridBagConstraints);
        this.pack();
        this.btnIndexJumpDown.setName("btnIndexJumpDown");
        this.btnIndexJumpUp.setName("btnIndexJumpUp");
        this.btnIndexJump.setName("btnIndexJump");
        this.txtIndexValue.setName("txtIndexValue");
        this.sliderBar.setName("sliderBar");
        this.btnIndexJumpDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = UnicodeGenerator.this.sliderBar.getValue();
                if (n > UnicodeGenerator.this.uniRangeMin) {
                    if ((n -= 100) < UnicodeGenerator.this.uniRangeMin) {
                        n = UnicodeGenerator.this.uniRangeMin;
                    }
                    UnicodeGenerator.this.sliderBar.setValue(n);
                }
            }
        });
        this.btnIndexJumpUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = UnicodeGenerator.this.sliderBar.getValue();
                if (n < UnicodeGenerator.this.uniSliderMax) {
                    if ((n += 100) > UnicodeGenerator.this.uniSliderMax) {
                        n = UnicodeGenerator.this.uniSliderMax;
                    }
                    UnicodeGenerator.this.sliderBar.setValue(n);
                }
            }
        });
        this.btnIndexJump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                block4: {
                    n = UnicodeGenerator.this.sliderBar.getValue();
                    try {
                        n = Integer.parseInt(UnicodeGenerator.this.txtIndexValue.getText());
                        if (n < UnicodeGenerator.this.uniRangeMin) {
                            String string = "Jump to index is invalid: " + n;
                            n = UnicodeGenerator.this.uniRangeMin;
                            throw new RuntimeException(string);
                        }
                        if (n > UnicodeGenerator.this.uniSliderMax) {
                            String string = "Jump to index is invalid: " + n;
                            n = UnicodeGenerator.this.uniSliderMax;
                            throw new RuntimeException(string);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(UnicodeGenerator.this, "'Jump To' index must be a number between " + UnicodeGenerator.this.uniRangeMin + " and " + UnicodeGenerator.this.uniSliderMax + ".", "Error", 0);
                        if (!(exception instanceof NumberFormatException)) break block4;
                        return;
                    }
                }
                UnicodeGenerator.this.sliderBar.setValue(n);
            }
        });
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnicodeGenerator.this.txtUniValue.setText("");
            }
        });
        this.btnDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UnicodeGenerator.this.txtUniValue.getText();
                String string2 = "Hex(" + UnicodeGenerator.byteArrayToHexString(string) + ")";
                String string3 = "Decimal(" + UnicodeGenerator.stringToDecimalString(string) + ")";
                String string4 = "CodePoint(" + UnicodeGenerator.stringToCodePointString(string) + ")";
                JOptionPane.showMessageDialog(UnicodeGenerator.this, "\"" + string + "\"\n\n" + string2 + "\n\n" + string3 + "\n\n" + string4);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.comboRanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnicodeGenerator.this.setUniRange(UnicodeGenerator.this.comboRanges.getSelectedIndex());
            }
        });
    }

    public static void main(String[] stringArray) {
        UnicodeGenerator unicodeGenerator = new UnicodeGenerator();
        unicodeGenerator.setVisible(true);
    }

    private void setUniRange(int n) {
        if (this.comboRanges.getSelectedIndex() != n) {
            this.comboRanges.setSelectedIndex(n);
        }
        UnicodeRange unicodeRange = (UnicodeRange)this.comboRanges.getSelectedItem();
        this.uniRangeMin = unicodeRange.start;
        this.uniRangeMax = unicodeRange.end + 1;
        this.uniSliderMax = this.uniRangeMax - 100;
        if (this.uniSliderMax < this.uniRangeMin) {
            this.uniSliderMax = this.uniRangeMin;
        }
        this.sliderBar.setValueIsAdjusting(true);
        this.sliderBar.setMinimum(this.uniRangeMin);
        this.sliderBar.setMaximum(this.uniSliderMax);
        int n2 = this.uniSliderMax - this.uniRangeMin;
        if (n2 > 5000) {
            this.sliderBar.setMajorTickSpacing(2500);
        } else if (n2 > 500) {
            this.sliderBar.setMajorTickSpacing(250);
        } else {
            this.sliderBar.setMajorTickSpacing(10);
        }
        Dictionary dictionary = this.sliderBar.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                this.sliderBar.getLabelTable().remove(enumeration.nextElement());
            }
            this.sliderBar.setLabelTable(this.sliderBar.createStandardLabels(this.sliderBar.getMajorTickSpacing()));
        }
        this.sliderBar.setValueIsAdjusting(false);
        this.sliderBar.setValue(this.uniRangeMin);
        this.sliderBar.invalidate();
        this.sliderBar.repaint();
    }

    private JPanel getTextPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.add((Component)this.lblUniValue, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.txtUniValue, gridBagConstraints);
        return jPanel;
    }

    private JPanel getIndexPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.sliderBar, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.comboRanges, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.btnIndexJumpDown, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.btnIndexJumpUp, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.btnIndexJump, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel.add((Component)this.txtIndexValue, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.chkShowGrouping, gridBagConstraints);
        return jPanel;
    }

    private JPanel getUniButtonsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JButton) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    int n = Integer.parseInt(jButton.getActionCommand());
                    int n2 = UnicodeGenerator.this.txtUniValue.getCaretPosition();
                    String string = UnicodeGenerator.this.txtUniValue.getText();
                    String string2 = string.substring(0, n2) + UnicodeGenerator.this.getUniString(n) + string.substring(n2);
                    UnicodeGenerator.this.txtUniValue.setText(string2);
                    UnicodeGenerator.this.txtUniValue.setCaretPosition(n2 + 1);
                } else {
                    System.out.println("Unknown source: " + actionEvent.getSource());
                }
            }
        };
        int n = this.sliderBar.getValue();
        int n2 = 4;
        for (int i = 0; i < this.uniButtons.length; ++i) {
            gridBagConstraints.gridy = i / n2;
            gridBagConstraints.gridx = i % n2;
            JButton jButton = new JButton();
            this.updateButton(jButton, i + n);
            jButton.addActionListener(actionListener);
            jPanel.add((Component)jButton, gridBagConstraints);
            this.uniButtons[i] = jButton;
        }
        gridBagConstraints.gridwidth = n2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    private void updateButton(JButton jButton, int n) {
        String string = this.getUniString(n);
        String string2 = "";
        char c = this.getUniChar(n);
        if (Character.isSpaceChar(c)) {
            jButton.setBackground(Color.YELLOW);
            string2 = " - Space-Char";
        } else if (Character.isWhitespace(c)) {
            jButton.setBackground(Color.GREEN);
            string2 = " - White-Spc";
        } else if (Character.isISOControl(c)) {
            jButton.setBackground(Color.CYAN);
            string2 = " - ISO-Ctrl";
        } else if (Character.isDigit(c)) {
            jButton.setBackground(Color.MAGENTA);
            string2 = " - Digit";
        } else if (Character.isLetter(c)) {
            jButton.setBackground(Color.ORANGE);
            string2 = " - Letter";
        } else if (Character.isLowSurrogate(c)) {
            jButton.setBackground(Color.PINK);
            string2 = " - Low Surrogate";
        } else if (Character.isHighSurrogate(c)) {
            jButton.setBackground(Color.PINK);
            string2 = " - High Surrogate";
        } else if (!Character.isDefined(c)) {
            jButton.setBackground(Color.RED);
            string2 = " - Undefined";
        } else {
            jButton.setBackground(this.btnCancel.getBackground());
        }
        String string3 = "";
        if (this.chkShowGrouping.isSelected()) {
            string3 = "<br>" + this.getGroupName(n);
        }
        jButton.setText("<html>'" + string + "'     (#" + n + " - hex'" + UnicodeGenerator.byteArrayToHexString(string) + "' " + string2 + ")" + string3 + "</html>");
        jButton.setActionCommand(String.valueOf(n));
        jButton.setPreferredSize(this.uniButtonSize);
        if (n > this.uniRangeMax) {
            jButton.setVisible(false);
        } else {
            jButton.setVisible(true);
        }
    }

    private String getGroupName(int n) {
        String string = "N/A";
        for (int i = 1; i < this.uniRanges.length; ++i) {
            if (this.uniRanges[i].start > n || this.uniRanges[i].end < n) continue;
            string = this.uniRanges[i].name;
            break;
        }
        return "Group: " + string;
    }

    private String getUniString(int n) {
        return "" + this.getUniChar(n);
    }

    private char getUniChar(int n) {
        return (char)n;
    }

    private JPanel getCommandsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.btnClear, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.btnDetails, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.btnCancel, gridBagConstraints);
        return jPanel;
    }

    private static String byteArrayToHexString(String string) {
        String string2 = "";
        String string3 = "";
        try {
            for (int i = 0; i < string.length(); ++i) {
                string2 = string2 + string3 + UnicodeGenerator.byteArrayToHexString(string.substring(i, i + 1).getBytes("utf8"));
                string3 = "-";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private static String byteArrayToHexString(byte[] byArray) {
        byte by = 0;
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(byArray[i] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(stringArray[by]);
            by = (byte)(byArray[i] & 0xF);
            stringBuffer.append(stringArray[by]);
        }
        String string = new String(stringBuffer);
        return string;
    }

    private static String stringToDecimalString(String string) {
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = c = string.charAt(i);
            string2 = string2 + string3 + String.valueOf((int)c2);
            string3 = "-";
        }
        return string2;
    }

    private static String stringToCodePointString(String string) {
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            string2 = string2 + string3 + String.valueOf(n);
            string3 = "-";
        }
        return string2;
    }

    public class UnicodeRange {
        protected String name;
        protected int start;
        protected int end;

        public UnicodeRange(String string, int n, int n2) {
            this.name = string;
            this.start = n;
            this.end = n2;
        }

        public String toString() {
            if (this.name != null) {
                return this.name + " (" + this.start + " - " + this.end + ")";
            }
            return "Undefined name";
        }
    }
}

