/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.util.HSSnmpPduTrap;
import java.net.InetAddress;
import junit.framework.TestCase;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpVarBind;

public class HSSnmpPduTrapTest
extends TestCase {
    private String hostname;
    private SnmpVarBind var0;
    private SnmpVarBind var1;
    private SnmpPduTrap pduTrap;
    private HSSnmpPduTrap trap;

    protected void setUp() throws Exception {
        super.setUp();
        this.var0 = new SnmpVarBind("zero");
        this.var1 = new SnmpVarBind("one");
        this.hostname = InetAddress.getLocalHost().toString();
        this.pduTrap = new SnmpPduTrap();
        this.pduTrap.addVarBind(this.var0);
        this.pduTrap.addVarBind(this.var1);
        this.trap = new HSSnmpPduTrap(this.pduTrap, InetAddress.getLocalHost(), new SnmpOctetString(), 1234);
    }

    protected void tearDown() throws Exception {
        this.trap = null;
        this.pduTrap = null;
        this.var0 = null;
        this.var1 = null;
        this.hostname = null;
        super.tearDown();
    }

    public void testGetHostName() {
        String string = this.hostname;
        String string2 = this.trap.getHostName();
        HSSnmpPduTrapTest.assertEquals((String)string, (String)string2);
    }

    public void testSetCommunity() {
        SnmpOctetString snmpOctetString = new SnmpOctetString("community".getBytes());
        this.trap.setCommunity(snmpOctetString);
        HSSnmpPduTrapTest.assertEquals((String)snmpOctetString.toString(), (String)this.trap.getCommunity().toString());
    }

    public void testSetPort() {
        this.trap.setPort(4321);
        HSSnmpPduTrapTest.assertEquals((int)4321, (int)this.trap.getPort());
    }

    public void testSetSendingAddress() throws Exception {
        InetAddress inetAddress = InetAddress.getByAddress(new byte[]{10, 20, 30, 40});
        this.trap.setSendingAddress(inetAddress);
        HSSnmpPduTrapTest.assertEquals((Object)inetAddress, (Object)this.trap.getSendingAddress());
    }
}

