/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;

public class TimeRange
implements Comparable {
    private LocalHHMM begin;
    private LocalHHMM end;

    public TimeRange(LocalHHMM localHHMM, LocalHHMM localHHMM2) {
        ValidationHelper.checkForNull((String)"Begin", (Object)((Object)localHHMM));
        ValidationHelper.checkForNull((String)"End", (Object)((Object)localHHMM2));
        if (localHHMM.toInt() > localHHMM2.toInt()) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Trying to create a TimeRange where the begin time {0} is greater than the end time {1}.", (Object[])new Object[]{localHHMM, localHHMM2}));
        }
        this.begin = localHHMM;
        this.end = localHHMM2;
    }

    public LocalHHMM getBegin() {
        return this.begin;
    }

    public LocalHHMM getEnd() {
        return this.end;
    }

    public boolean contains(int n) {
        return n >= this.begin.toInt() && n <= this.end.toInt();
    }

    public boolean contains(LocalHHMM localHHMM) {
        ValidationHelper.checkForNull((String)"HHMM", (Object)((Object)localHHMM));
        return localHHMM.toInt() >= this.begin.toInt() && localHHMM.toInt() <= this.end.toInt();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        TimeRange timeRange = (TimeRange)object;
        return timeRange.begin.equals((Object)this.begin) && timeRange.end.equals((Object)this.end);
    }

    public int hashCode() {
        return this.begin.toInt() + this.end.toInt();
    }

    public int compareTo(Object object) {
        TimeRange timeRange = (TimeRange)object;
        if (this.begin.compareTo((Object)timeRange.begin) < 0) {
            return -1;
        }
        if (this.begin.equals((Object)timeRange.begin) && this.end.compareTo((Object)timeRange.end) < 0) {
            return -1;
        }
        if (this.begin.equals((Object)timeRange.begin) && this.end.equals((Object)timeRange.end)) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return MessageUtil.formatMsg((String)"{0} - {1}", (Object[])new Object[]{this.begin, this.end});
    }
}

