/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.core.scheduler.CronExpression;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_CronExpression;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class SkybotCronExpression {
    private static final Logger logger = Logger.getLogger(SkybotCronExpression.class);
    public static final List<String> ALL_WEEKDAY_STRINGS = Arrays.asList(Weekday.access$000(Weekday.SUNDAY), Weekday.access$000(Weekday.MONDAY), Weekday.access$000(Weekday.TUESDAY), Weekday.access$000(Weekday.WEDNESDAY), Weekday.access$000(Weekday.THURSDAY), Weekday.access$000(Weekday.FRIDAY), Weekday.access$000(Weekday.SATURDAY));
    private static final String ASTERISK = "*";
    private static final String QUESTION_MARK = "?";
    private CronExpression usableCronExpression;
    private String minute;
    private String hour;
    private String day;
    private String month;
    private String weekday;
    private String year;

    public SkybotCronExpression(String string) {
        try {
            this.usableCronExpression = new CronExpression(this.getUsableCronExpressionString(string));
            this.usableCronExpression.setTimeZone(TimeZone.getDefault());
        }
        catch (ParseException parseException) {
            if (parseException.getMessage().equals("Day-of-Week values must be between 1 and 7")) {
                throw new IllegalStateException("Day-of-Week values must be between 0 and 7");
            }
            throw new IllegalStateException(parseException.getMessage());
        }
        catch (InvalidStateException invalidStateException) {
            logger.trace((Object)"Unable to determine NST for job.  ", (Throwable)invalidStateException);
            throw new IllegalStateException(invalidStateException.getMessage());
        }
    }

    public SkybotCronExpression(String string, TimeZone timeZone) {
        try {
            this.usableCronExpression = new CronExpression(this.getUsableCronExpressionString(string));
            this.usableCronExpression.setTimeZone(timeZone);
        }
        catch (ParseException parseException) {
            if (parseException.getMessage().equals("Day-of-Week values must be between 1 and 7")) {
                throw new IllegalStateException("Day-of-Week values must be between 0 and 7");
            }
            throw new IllegalStateException(parseException.getMessage());
        }
        catch (InvalidStateException invalidStateException) {
            logger.trace((Object)"Unable to determine NST for job.  ", (Throwable)invalidStateException);
            throw new IllegalStateException(invalidStateException.getMessage());
        }
    }

    private String getUsableCronExpressionString(String string) throws ParseException, InvalidStateException {
        String string2;
        String string3 = "0 " + string;
        try {
            string2 = this.getConvertedCronExpression(string3);
        }
        catch (Exception exception) {
            throw new InvalidStateException(exception.getMessage() + " '" + string + "'");
        }
        CronExpression cronExpression = null;
        Calendar calendar = Calendar.getInstance();
        try {
            cronExpression = new CronExpression(string2);
            cronExpression.getNextValidTimeAfter(calendar.getTime());
        }
        catch (ParseException parseException) {
            if (parseException.getMessage().equals("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.")) {
                logger.debug((Object)(parseException.getMessage() + "  About to determine a usable CronExpression."));
                logger.trace((Object)parseException);
                string2 = this.getSoonestNSTCronExpressionString(calendar, string2);
            }
            throw parseException;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            logger.debug((Object)(unsupportedOperationException.getMessage() + "  About to determine a usable CronExpression."));
            logger.trace((Object)unsupportedOperationException);
            string2 = this.getSoonestNSTCronExpressionString(calendar, string2);
        }
        logger.trace((Object)("Usable CronExpression = " + string2));
        return string2;
    }

    private String getSoonestNSTCronExpressionString(Calendar calendar, String string) throws ParseException {
        String string2 = "";
        String string3 = this.getModifiedCronExpression(string, true);
        logger.trace((Object)("About to test using " + string3));
        CronExpression cronExpression = new CronExpression(string3);
        Date date = cronExpression.getNextValidTimeAfter(calendar.getTime());
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        String string4 = this.getModifiedCronExpression(string, false);
        logger.trace((Object)("About to test using " + string4));
        cronExpression = new CronExpression(string4);
        Date date2 = cronExpression.getNextValidTimeAfter(calendar.getTime());
        Calendar calendar3 = Calendar.getInstance();
        calendar3.setTime(date2);
        string2 = calendar2.before(calendar3) ? string3 : string4;
        return string2;
    }

    private String getConvertedCronExpression(String string) throws Exception {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        boolean bl = false;
        String[] stringArray = string.split(" ");
        block9: for (int i = 0; i < stringArray.length; ++i) {
            switch (i) {
                case 0: {
                    string3 = stringArray[i];
                    continue block9;
                }
                case 1: {
                    string4 = stringArray[i];
                    continue block9;
                }
                case 2: {
                    string5 = stringArray[i];
                    continue block9;
                }
                case 3: {
                    string6 = stringArray[i];
                    bl = string6.equals(ASTERISK) || string6.equals(QUESTION_MARK);
                    continue block9;
                }
                case 4: {
                    string7 = stringArray[i];
                    continue block9;
                }
                case 5: {
                    string8 = this.getConvertedDayOfWeekString(stringArray[i]);
                    if (string8.equals(ASTERISK)) {
                        if (!string6.equals(ASTERISK) && bl) continue block9;
                        string8 = QUESTION_MARK;
                        continue block9;
                    }
                    if (string8.equals(QUESTION_MARK) || !string6.equals(ASTERISK)) continue block9;
                    string6 = QUESTION_MARK;
                    continue block9;
                }
                case 6: {
                    string9 = stringArray[i];
                    continue block9;
                }
                default: {
                    throw new Exception("Invalid number of fields in the Cron Expression");
                }
            }
        }
        string2 = string3;
        string2 = string2 + " " + string4;
        string2 = string2 + " " + string5;
        string2 = string2 + " " + string6;
        string2 = string2 + " " + string7;
        string2 = string2 + " " + string8;
        string2 = string2 + " " + string9;
        logger.trace((Object)("Converted Cron Expression = " + string2));
        return string2;
    }

    private String getConvertedDayOfWeekString(String string) {
        String string2 = "";
        logger.trace((Object)("dayOfWeekString = " + string));
        if (string.equals(ASTERISK) || string.equals(QUESTION_MARK)) {
            return string;
        }
        if (!(string.contains(",") || string.contains("-") || string.contains(ASTERISK) || string.contains(QUESTION_MARK) || string.contains("/") || string.contains("L") || string.contains("#"))) {
            return String.valueOf(this.getIntegerValueOfWeekday(string) + 1);
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string3;
            Object object2;
            if (string2 != "") {
                string2 = string2 + ",";
            }
            String string4 = stringArray[i];
            logger.trace((Object)("dayOfWeekString[" + i + "] = " + string4));
            if (string4.contains("-") && !string4.contains("/")) {
                string2 = string2 + this.getConvertedRange(string4);
                continue;
            }
            if (string4.contains("/")) {
                object2 = string4.split("/");
                string3 = object2[0];
                object = object2[1];
                String string5 = "";
                string5 = string3.contains("-") ? this.getConvertedRange(string3) : (string3.equals(ASTERISK) ? string3 : String.valueOf(Integer.valueOf(string3) + 1));
                string2 = string2 + string5 + "/" + (String)object;
                continue;
            }
            if (string4.contains("L")) {
                if (string4.equals("L")) {
                    string2 = string2 + string4;
                    continue;
                }
                object2 = String.valueOf(string4.charAt(0));
                int n = Integer.valueOf((String)object2);
                string2 = string2 + (n + 1) + "L";
                continue;
            }
            if (string4.contains("#")) {
                object2 = string4.split("#");
                string3 = object2[0];
                object = Integer.valueOf(string3);
                string2 = string2 + ((Integer)object + 1) + "#" + object2[1];
                continue;
            }
            string2 = string2 + (this.getIntegerValueOfWeekday(string4) + 1);
        }
        logger.trace((Object)("new Day Of Week expression = " + string2));
        return string2;
    }

    private String getConvertedRange(String string) {
        String[] stringArray = string.split("-");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = this.getIntegerValueOfWeekday(string2) + 1;
        int n2 = this.getIntegerValueOfWeekday(string3) + 1;
        return n + "-" + n2;
    }

    private int getIntegerValueOfWeekday(String string) {
        int n;
        if (ALL_WEEKDAY_STRINGS.contains(string.toUpperCase())) {
            Weekday weekday = Weekday.persistanceCodeToEnum(string.toUpperCase());
            logger.trace((Object)("Found Weekday = " + weekday.name()));
            n = weekday.weekdayNumber;
        } else {
            n = Integer.valueOf(string);
        }
        if (n == 7) {
            n = 0;
        }
        return n;
    }

    private void validateFutureDates(CronExpression cronExpression, Calendar calendar) {
        TreeSet<Integer> treeSet = cronExpression.getSet(6);
        int n = treeSet.last();
        logger.debug((Object)("last Year = " + n));
        if (n < calendar.get(1)) {
            throw new IllegalStateException("There are no future run dates defined in the Cron Expression associated with this job.");
        }
        if (n > calendar.get(1)) {
            return;
        }
        TreeSet<Integer> treeSet2 = cronExpression.getSet(4);
        int n2 = treeSet2.last();
        logger.debug((Object)("last Month = " + n2));
        if (n2 < calendar.get(3)) {
            throw new IllegalStateException("There are no future run dates defined in the Cron Expression associated with this job.");
        }
        if (n2 > calendar.get(3)) {
            return;
        }
        TreeSet<Integer> treeSet3 = cronExpression.getSet(3);
        int n3 = treeSet3.last();
        logger.debug((Object)("last Day = " + n3));
        if (n3 < calendar.get(5)) {
            throw new IllegalStateException("There are no future run dates defined in the Cron Expression associated with this job.");
        }
    }

    private String getModifiedCronExpression(String string, boolean bl) {
        String string2 = "";
        String[] stringArray = string.split(" ");
        block9: for (int i = 0; i < stringArray.length; ++i) {
            switch (i) {
                case 0: {
                    logger.trace((Object)("second = " + stringArray[i]));
                    string2 = string2 + stringArray[i];
                    continue block9;
                }
                case 1: {
                    logger.trace((Object)("minute = " + stringArray[i]));
                    string2 = string2 + " " + stringArray[i];
                    continue block9;
                }
                case 2: {
                    logger.trace((Object)("hour = " + stringArray[i]));
                    string2 = string2 + " " + stringArray[i];
                    continue block9;
                }
                case 3: {
                    logger.trace((Object)("day of month = " + stringArray[i]));
                    if (!bl) {
                        string2 = string2 + " ?";
                        continue block9;
                    }
                    string2 = string2 + " " + stringArray[i];
                    continue block9;
                }
                case 4: {
                    logger.trace((Object)("month = " + stringArray[i]));
                    string2 = string2 + " " + stringArray[i];
                    continue block9;
                }
                case 5: {
                    logger.trace((Object)("day of week = " + stringArray[i]));
                    if (bl) {
                        string2 = string2 + " ?";
                        continue block9;
                    }
                    string2 = string2 + " " + stringArray[i];
                    continue block9;
                }
                case 6: {
                    logger.trace((Object)("year = " + stringArray[i]));
                    string2 = string2 + " " + stringArray[i];
                    continue block9;
                }
            }
        }
        return string2;
    }

    public Calendar getNextScheduledTime(Calendar calendar) {
        Calendar calendar2 = null;
        Date date = calendar.getTime();
        Date date2 = this.usableCronExpression.getNextValidTimeAfter(date);
        calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2.getTime());
        return calendar2;
    }

    public boolean isScheduledToday(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(14, 0);
        calendar2.set(13, 0);
        calendar2.set(12, 59);
        calendar2.set(11, 23);
        calendar2.add(5, -1);
        Calendar calendar3 = this.getNextScheduledTime(calendar2);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar3.set(14, 0);
        calendar3.set(13, 0);
        calendar3.set(12, 0);
        calendar3.set(11, 0);
        String string = ScheduleInfo_CronExpression.getDateTimeString(calendar.getTimeInMillis());
        String string2 = ScheduleInfo_CronExpression.getDateTimeString(calendar3.getTimeInMillis());
        return string.equals(string2);
    }

    public String getMinute() {
        return this.minute;
    }

    public void setMinute(String string) {
        this.minute = string;
    }

    public String getHour() {
        return this.hour;
    }

    public void setHour(String string) {
        this.hour = string;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String string) {
        this.day = string;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String string) {
        this.month = string;
    }

    public String getWeekday() {
        return this.weekday;
    }

    public void setWeekday(String string) {
        this.weekday = string;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String string) {
        this.year = string;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.usableCronExpression.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.usableCronExpression.getTimeZone();
    }

    private static enum Weekday implements PersistableEnum<String>
    {
        SUNDAY("SUN", 0),
        MONDAY("MON", 1),
        TUESDAY("TUE", 2),
        WEDNESDAY("WED", 3),
        THURSDAY("THU", 4),
        FRIDAY("FRI", 5),
        SATURDAY("SAT", 6),
        SUNDAY7("SUN", 7);

        private String weekdayString;
        private int weekdayNumber;
        private static PersistanceCodeToEnumMap<String, Weekday> map;

        private Weekday(String string2, int n2) {
            this.weekdayString = string2;
            this.weekdayNumber = n2;
        }

        @Override
        public String persistanceCode() {
            return this.weekdayString;
        }

        public static Weekday persistanceCodeToEnum(String string) {
            Weekday weekday = map.get(string);
            if (weekday == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return weekday;
        }

        static /* synthetic */ String access$000(Weekday weekday) {
            return weekday.weekdayString;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])Weekday.values());
        }
    }
}

