/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.busobj.CommandSet;
import com.helpsystems.enterprise.core.busobj.JobMonitor;
import com.helpsystems.enterprise.core.scheduler.MissedJobAction;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import junit.framework.TestCase;

public class ScheduleJobTest
extends TestCase {
    private ScheduleJob job;

    public ScheduleJobTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.job = new ScheduleJob();
    }

    protected void tearDown() throws Exception {
        this.job = null;
        super.tearDown();
    }

    public void testSetName() {
        this.job.setName("jobName");
        ScheduleJobTest.assertEquals((String)"jobName", (String)this.job.getName());
    }

    public void testSetKey() {
        Object object = new Object();
        this.job.setKey(object);
        ScheduleJobTest.assertEquals((Object)object, (Object)this.job.getKey());
    }

    public void testSetSkybotJobName() {
        this.job.setSkybotJobName("skybotJobName");
        ScheduleJobTest.assertEquals((String)"skybotJobName", (String)this.job.getSkybotJobName());
    }

    public void testSetSkybotJobNumber() {
        this.job.setSkybotJobNumber(12345678L);
        ScheduleJobTest.assertEquals((long)12345678L, (long)this.job.getSkybotJobNumber());
    }

    public void testSetScheduleInfo() {
        this.job.setScheduleType(ScheduleJobProxy.ScheduleType.DATE_LIST);
        ScheduleJobTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DATE_LIST, (Object)this.job.getScheduleType());
        this.job.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_COUNT);
        ScheduleJobTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_COUNT, (Object)this.job.getScheduleType());
        this.job.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD);
        ScheduleJobTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD, (Object)this.job.getScheduleType());
        this.job.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_OF_WEEK);
        ScheduleJobTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_OF_WEEK, (Object)this.job.getScheduleType());
    }

    public void testValidateRequiresJobNumber() {
        try {
            this.job.validate();
            ScheduleJobTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.job.setSkybotJobNumber(1234L);
        this.job.validate();
    }

    public void testIsScheduleTypeJob() {
        ScheduleJobTest.assertFalse((boolean)this.job.isScheduleTypeJob());
        this.job.setScheduleType(ScheduleJobProxy.ScheduleType.DATE_LIST);
        ScheduleJobTest.assertTrue((boolean)this.job.isScheduleTypeJob());
    }

    public void testIsUseDefaultsForJobHistoryPurge() {
        ScheduleJobTest.assertFalse((boolean)this.job.isUseDefaultsForJobHistoryPurge());
        this.job.setUseDefaultsForJobHistoryPurge(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isUseDefaultsForJobHistoryPurge());
        this.job.setUseDefaultsForJobHistoryPurge(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isUseDefaultsForJobHistoryPurge());
    }

    public void testIsPurgeJobHistory() {
        ScheduleJobTest.assertFalse((boolean)this.job.isPurgeJobHistory());
        this.job.setPurgeJobHistory(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isPurgeJobHistory());
        this.job.setPurgeJobHistory(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isPurgeJobHistory());
    }

    public void testIsOverrunMonitorSelected() {
        ScheduleJobTest.assertFalse((boolean)this.job.isOverrunMonitorSelected());
        this.job.setOverrunMonitorSelected(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isOverrunMonitorSelected());
        this.job.setOverrunMonitorSelected(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isOverrunMonitorSelected());
    }

    public void testIsOverrunSendSNMPTrap() {
        ScheduleJobTest.assertFalse((boolean)this.job.isOverrunSendSNMPTrap());
        this.job.setOverrunSendSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isOverrunSendSNMPTrap());
        this.job.setOverrunSendSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isOverrunSendSNMPTrap());
    }

    public void testIsOverrunSendEmail() {
        ScheduleJobTest.assertFalse((boolean)this.job.isOverrunSendEmail());
        this.job.setOverrunSendEmail(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isOverrunSendEmail());
        this.job.setOverrunSendEmail(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isOverrunSendEmail());
    }

    public void testIsOverrunEndJob() {
        ScheduleJobTest.assertFalse((boolean)this.job.isOverrunEndJob());
        this.job.setOverrunEndJob(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isOverrunEndJob());
        this.job.setOverrunEndJob(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isOverrunEndJob());
    }

    public void testIsUnderrunMonitorSelected() {
        ScheduleJobTest.assertFalse((boolean)this.job.isUnderrunSendSNMPTrap());
        this.job.setUnderrunSendSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isUnderrunSendSNMPTrap());
        this.job.setUnderrunSendSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isUnderrunSendSNMPTrap());
    }

    public void testIsUnderrunSendSNMPTrap() {
        ScheduleJobTest.assertFalse((boolean)this.job.isUnderrunSendSNMPTrap());
        this.job.setUnderrunSendSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isUnderrunSendSNMPTrap());
        this.job.setUnderrunSendSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isUnderrunSendSNMPTrap());
    }

    public void testIsUnderrunSendEmail() {
        ScheduleJobTest.assertFalse((boolean)this.job.isUnderrunSendEmail());
        this.job.setUnderrunSendEmail(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isUnderrunSendEmail());
        this.job.setUnderrunSendEmail(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isUnderrunSendEmail());
    }

    public void testIsLateStartMonitorSelected() {
        ScheduleJobTest.assertFalse((boolean)this.job.isLateStartMonitorSelected());
        this.job.setLateStartMonitorSelected(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isLateStartMonitorSelected());
        this.job.setLateStartMonitorSelected(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isLateStartMonitorSelected());
    }

    public void testIsLateStartSendSNMPTrap() {
        ScheduleJobTest.assertFalse((boolean)this.job.isLateStartSendSNMPTrap());
        this.job.setLateStartSendSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isLateStartSendSNMPTrap());
        this.job.setLateStartSendSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isLateStartSendSNMPTrap());
    }

    public void testIsLateStartSendEmail() {
        ScheduleJobTest.assertFalse((boolean)this.job.isLateStartSendEmail());
        this.job.setLateStartSendEmail(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isLateStartSendEmail());
        this.job.setLateStartSendEmail(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isLateStartSendEmail());
    }

    public void testIsLateStartEndJob() {
        ScheduleJobTest.assertFalse((boolean)this.job.isLateStartEndJob());
        this.job.setLateStartEndJob(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isLateStartEndJob());
        this.job.setLateStartEndJob(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isLateStartEndJob());
    }

    public void testIsSendSubmitSNMPTrap() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendSubmitSNMPTrap());
        this.job.setSendSubmitSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendSubmitSNMPTrap());
        this.job.setSendSubmitSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendSubmitSNMPTrap());
    }

    public void testIsSendSubmitEmail() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendSubmitEmail());
        this.job.setSendSubmitEmail(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendSubmitEmail());
        this.job.setSendSubmitEmail(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendSubmitEmail());
    }

    public void testIsSendRunSNMPTrap() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendRunSNMPTrap());
        this.job.setSendRunSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendRunSNMPTrap());
        this.job.setSendRunSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendRunSNMPTrap());
    }

    public void testIsSendRunEmail() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendRunEmail());
        this.job.setSendRunEmail(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendRunEmail());
        this.job.setSendRunEmail(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendRunEmail());
    }

    public void testIsSendCompleteSNMPTrap() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendCompleteSNMPTrap());
        this.job.setSendCompleteSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendCompleteSNMPTrap());
        this.job.setSendCompleteSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendCompleteSNMPTrap());
    }

    public void testIsSendCompleteEmail() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendCompleteEmail());
        this.job.setSendCompleteEmail(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendCompleteEmail());
        this.job.setSendCompleteEmail(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendCompleteEmail());
    }

    public void testIsSendFailSNMPTrap() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendFailSNMPTrap());
        this.job.setSendFailSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendFailSNMPTrap());
        this.job.setSendFailSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendFailSNMPTrap());
    }

    public void testIsSendFailEmail() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendFailEmail());
        this.job.setSendFailEmail(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendFailEmail());
        this.job.setSendFailEmail(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendFailEmail());
    }

    public void testIsSendCancelSNMPTrap() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendCancelSNMPTrap());
        this.job.setSendCancelSNMPTrap(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendCancelSNMPTrap());
        this.job.setSendCancelSNMPTrap(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendCancelSNMPTrap());
    }

    public void testIsSendCancelEmail() {
        ScheduleJobTest.assertFalse((boolean)this.job.isSendCancelEmail());
        this.job.setSendCancelEmail(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isSendCancelEmail());
        this.job.setSendCancelEmail(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isSendCancelEmail());
    }

    public void testSetAgentEnvironmentID() {
        this.job.setAgentEnvironmentID(12345L);
        ScheduleJobTest.assertEquals((long)12345L, (long)this.job.getAgentEnvironmentID());
    }

    public void testSetCommandSet() {
        CommandSet commandSet = new CommandSet();
        this.job.setCommandSet(commandSet);
        ScheduleJobTest.assertEquals((Object)((Object)commandSet), (Object)((Object)this.job.getCommandSet()));
    }

    public void testSetJobHistoriesToKeep() {
        this.job.setJobHistoriesToKeep(34);
        ScheduleJobTest.assertEquals((int)34, (int)this.job.getJobHistoriesToKeep());
    }

    public void testSetMissedJobAction() {
        this.job.setMissedJobAction(MissedJobAction.COMPLETE);
        ScheduleJobTest.assertEquals((Object)MissedJobAction.COMPLETE, (Object)this.job.getMissedJobAction());
    }

    public void testIsCopyJobLogToServer() {
        ScheduleJobTest.assertFalse((boolean)this.job.isCopyJobLogToServer());
        this.job.setCopyJobLogToServer(true);
        ScheduleJobTest.assertTrue((boolean)this.job.isCopyJobLogToServer());
        this.job.setCopyJobLogToServer(false);
        ScheduleJobTest.assertFalse((boolean)this.job.isCopyJobLogToServer());
    }

    public void testSetOverrunMonitorOption() {
        this.job.setOverrunMonitorOption(JobMonitor.MonitorOption.TARGET_TIME);
        ScheduleJobTest.assertEquals((Object)JobMonitor.MonitorOption.TARGET_TIME, (Object)this.job.getOverrunMonitorOption());
    }

    public void testSetOverrunMaximumMinutes() {
        this.job.setOverrunMaximumMinutes(123);
        ScheduleJobTest.assertEquals((int)123, (int)this.job.getOverrunMaximumMinutes());
    }

    public void testSetOverrunTargetCompletionTime() {
        this.job.setOverrunTargetCompletionTime(1058);
        ScheduleJobTest.assertEquals((int)1058, (int)this.job.getOverrunTargetCompletionTime());
    }

    public void testSetOverrunNotificationListID() {
        this.job.setOverrunNotificationListID(345678L);
        ScheduleJobTest.assertEquals((long)345678L, (long)this.job.getOverrunNotificationListID());
    }

    public void testSetUnderrunMinimumMinutes() {
        this.job.setUnderrunMinimumMinutes(234);
        ScheduleJobTest.assertEquals((int)234, (int)this.job.getUnderrunMinimumMinutes());
    }

    public void testSetUnderrunNotificationListID() {
        this.job.setUnderrunNotificationListID(48484848L);
        ScheduleJobTest.assertEquals((long)48484848L, (long)this.job.getUnderrunNotificationListID());
    }

    public void testSetLateStartMonitorOption() {
        this.job.setLateStartMonitorOption(JobMonitor.MonitorOption.TARGET_TIME);
        ScheduleJobTest.assertEquals((Object)JobMonitor.MonitorOption.TARGET_TIME, (Object)this.job.getLateStartMonitorOption());
    }

    public void testSetLateStartMaximumMinutes() {
        this.job.setLateStartMaximumMinutes(6543);
        ScheduleJobTest.assertEquals((int)6543, (int)this.job.getLateStartMaximumMinutes());
    }

    public void testSetLateStartTargetStartTime() {
        this.job.setLateStartTargetStartTime(945);
        ScheduleJobTest.assertEquals((int)945, (int)this.job.getLateStartTargetStartTime());
    }

    public void testSetLateStartNotificationListID() {
        this.job.setLateStartNotificationListID(37373737L);
        ScheduleJobTest.assertEquals((long)37373737L, (long)this.job.getLateStartNotificationListID());
    }

    public void testSetSubmitNotificationListID() {
        this.job.setSubmitNotificationListID(26262626L);
        ScheduleJobTest.assertEquals((long)26262626L, (long)this.job.getSubmitNotificationListID());
    }

    public void testSetRunNotificationListID() {
        this.job.setRunNotificationListID(15151515L);
        ScheduleJobTest.assertEquals((long)15151515L, (long)this.job.getRunNotificationListID());
    }

    public void testSetCompleteNotificationListID() {
        this.job.setCompleteNotificationListID(678678L);
        ScheduleJobTest.assertEquals((long)678678L, (long)this.job.getCompleteNotificationListID());
    }

    public void testSetFailNotificationListID() {
        this.job.setFailNotificationListID(246246L);
        ScheduleJobTest.assertEquals((long)246246L, (long)this.job.getFailNotificationListID());
    }

    public void testSetCancelNotificationListID() {
        this.job.setCancelNotificationListID(135135L);
        ScheduleJobTest.assertEquals((long)135135L, (long)this.job.getCancelNotificationListID());
    }

    public void testSetTimeRangeStart() {
        this.job.setTimeRangeStart(945);
        ScheduleJobTest.assertEquals((int)945, (int)this.job.getTimeRangeStart());
    }

    public void testSetTimeRangeEnd() {
        this.job.setTimeRangeEnd(1145);
        ScheduleJobTest.assertEquals((int)1145, (int)this.job.getTimeRangeEnd());
    }

    public void testHasMonitorsSelected() {
        ScheduleJobTest.assertFalse((boolean)this.job.hasMonitorsSelected());
        this.job.setOverrunMonitorSelected(true);
        ScheduleJobTest.assertTrue((boolean)this.job.hasMonitorsSelected());
        this.job.setOverrunMonitorSelected(false);
        this.job.setUnderrunMonitorSelected(true);
        ScheduleJobTest.assertTrue((boolean)this.job.hasMonitorsSelected());
        this.job.setUnderrunMonitorSelected(false);
        this.job.setLateStartMonitorSelected(true);
        ScheduleJobTest.assertTrue((boolean)this.job.hasMonitorsSelected());
        this.job.setLateStartMonitorSelected(false);
    }

    public void testSetCopyJobLogToServer() {
        ScheduleJobTest.assertFalse((boolean)this.job.getCopyJobLogToServer());
        this.job.setCopyJobLogToServer(true);
        ScheduleJobTest.assertTrue((boolean)this.job.getCopyJobLogToServer());
        this.job.setCopyJobLogToServer(false);
        ScheduleJobTest.assertFalse((boolean)this.job.getCopyJobLogToServer());
    }
}

