/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.JobHoldFlag;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import junit.framework.TestCase;

public class ScheduleJobProxyTest
extends TestCase {
    private ScheduleJobProxy prox;

    public ScheduleJobProxyTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.prox = new ScheduleJobProxy();
    }

    protected void tearDown() throws Exception {
        this.prox = null;
        super.tearDown();
    }

    public void testSetSkybotJobNumber() {
        this.prox.setSkybotJobNumber(1827364L);
        ScheduleJobProxyTest.assertEquals((long)1827364L, (long)this.prox.getSkybotJobNumber());
    }

    public void testCanSetSkybotJobNumberToSameValueAgain() {
        this.prox.setSkybotJobNumber(12345678L);
        this.prox.setSkybotJobNumber(12345678L);
        ScheduleJobProxyTest.assertEquals((long)12345678L, (long)this.prox.getSkybotJobNumber());
    }

    public void testCannotChangeSkybotJobNumberOnceSet() {
        this.prox.setSkybotJobNumber(12345678L);
        try {
            this.prox.setSkybotJobNumber(55555555L);
            ScheduleJobProxyTest.fail((String)"Allowed change to SkybotJobNumber");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetScheduleType() {
        this.prox.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_COUNT);
        ScheduleJobProxyTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_COUNT, (Object)this.prox.getScheduleType());
        this.prox.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD);
        ScheduleJobProxyTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD, (Object)this.prox.getScheduleType());
        this.prox.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_OF_WEEK);
        ScheduleJobProxyTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_OF_WEEK, (Object)this.prox.getScheduleType());
        this.prox.setScheduleType(ScheduleJobProxy.ScheduleType.DATE_LIST);
        ScheduleJobProxyTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DATE_LIST, (Object)this.prox.getScheduleType());
        this.prox.setScheduleType(ScheduleJobProxy.ScheduleType.TIMED_INTERVAL);
        ScheduleJobProxyTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.TIMED_INTERVAL, (Object)this.prox.getScheduleType());
    }

    public void testSetSystem() {
        this.prox.setSystem(246246);
        ScheduleJobProxyTest.assertEquals((int)246246, (int)this.prox.getSystem());
    }

    public void testSetModel() {
        this.prox.setModel(252525);
        ScheduleJobProxyTest.assertEquals((int)252525, (int)this.prox.getModel());
    }

    public void testSetJobHoldFlag() {
        this.prox.setJobHoldFlag(JobHoldFlag.NOT_HELD);
        ScheduleJobProxyTest.assertEquals((Object)JobHoldFlag.NOT_HELD, (Object)this.prox.getJobHoldFlag());
        this.prox.setJobHoldFlag(JobHoldFlag.HELD_FOR_X_TIMES);
        ScheduleJobProxyTest.assertEquals((Object)JobHoldFlag.HELD_FOR_X_TIMES, (Object)this.prox.getJobHoldFlag());
        this.prox.setJobHoldFlag(JobHoldFlag.HELD);
        ScheduleJobProxyTest.assertEquals((Object)JobHoldFlag.HELD, (Object)this.prox.getJobHoldFlag());
    }

    public void testIsJobHeld() {
        this.prox.setJobHoldFlag(JobHoldFlag.NOT_HELD);
        ScheduleJobProxyTest.assertFalse((boolean)this.prox.isJobHeld());
        this.prox.setJobHoldFlag(JobHoldFlag.HELD);
        ScheduleJobProxyTest.assertTrue((boolean)this.prox.isJobHeld());
        this.prox.setJobHoldFlag(JobHoldFlag.HELD_FOR_X_TIMES);
        this.prox.setHoldTimes(4);
        this.prox.setHeldCount(3);
        ScheduleJobProxyTest.assertTrue((boolean)this.prox.isJobHeld());
        this.prox.setHeldCount(4);
        ScheduleJobProxyTest.assertFalse((boolean)this.prox.isJobHeld());
        this.prox.setHeldCount(5);
        ScheduleJobProxyTest.assertFalse((boolean)this.prox.isJobHeld());
    }

    public void testIsScheduleTypeJob() {
        ScheduleJobProxyTest.assertFalse((boolean)this.prox.isScheduleTypeJob());
        this.prox.setScheduleType(ScheduleJobProxy.ScheduleType.DATE_LIST);
        ScheduleJobProxyTest.assertTrue((boolean)this.prox.isScheduleTypeJob());
    }

    public void testSetHoldTimes() {
        this.prox.setHoldTimes(2345);
        ScheduleJobProxyTest.assertEquals((int)2345, (int)this.prox.getHoldTimes());
    }

    public void testSetHeldCount() {
        this.prox.setHeldCount(1234);
        ScheduleJobProxyTest.assertEquals((int)1234, (int)this.prox.getHeldCount());
    }

    public void testSetHoldOnFailure() {
        this.prox.setHoldOnFailure(true);
        ScheduleJobProxyTest.assertTrue((boolean)this.prox.isHoldOnFailure());
        this.prox.setHoldOnFailure(false);
        ScheduleJobProxyTest.assertFalse((boolean)this.prox.isHoldOnFailure());
    }
}

