/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class ScheduleInfo_TimedInterval
extends ScheduleInfo {
    private int minutes;
    private DisplayPref displayPref;
    private Calendar baseDateTime;
    private CalendarObject.DayType dayType;
    private RuntimeRanges runtimeRanges;
    private int lastOmitDateLogged;

    public ScheduleInfo_TimedInterval() {
        super(ScheduleJobProxy.ScheduleType.TIMED_INTERVAL);
    }

    public Calendar getBaseDateTime() {
        return this.baseDateTime;
    }

    public CalendarObject.DayType getDayType() {
        return this.dayType;
    }

    public DisplayPref getDisplayPref() {
        return this.displayPref;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public RuntimeRanges getRuntimeRanges() {
        return this.runtimeRanges;
    }

    public void setBaseDateTime(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Base Date/Time", (Object)calendar);
        this.baseDateTime = calendar;
    }

    public void setDayType(CalendarObject.DayType dayType) {
        ValidationHelper.checkForNull((String)"Day Type", (Object)dayType);
        this.dayType = dayType;
    }

    public void setDisplayPref(DisplayPref displayPref) {
        this.displayPref = displayPref;
    }

    public void setMinutes(int n) {
        this.minutes = n;
    }

    public void setRuntimeRanges(RuntimeRanges runtimeRanges) {
        ValidationHelper.checkForNull((String)"Runtime Ranges", (Object)runtimeRanges);
        this.runtimeRanges = runtimeRanges;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationHelper.validateReqFieldNotNull((String)"Base Date/Time", (Object)this.baseDateTime);
        ValidationHelper.validateReqFieldNotNull((String)"Day Type", (Object)this.dayType);
        ValidationHelper.validateReqFieldNotNull((String)"Runtime Ranges", (Object)this.runtimeRanges);
    }

    @Override
    public Calendar calcNST(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        Calendar calendar2 = this.constructBaseDateTime(timeZone);
        if (calendar == null || calendar2.after(calendar)) {
            Calendar calendar3 = (Calendar)calendar2.clone();
            long l = System.currentTimeMillis();
            calendar3 = this.getTimeZoneAdjustedRuntime(calendar3, l);
            calendar3 = this.findFirstValidRuntime(calendar3, jobInfo);
            return calendar3;
        }
        if (this.minutes <= 0) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Invalid interval value: {0}.", (Object[])new Object[]{this.minutes}));
        }
        Calendar calendar4 = (Calendar)calendar.clone();
        Calendar calendar5 = this.calculateMaximumTimeHorizon(calendar);
        do {
            calendar4.add(12, this.minutes);
        } while ((!this.isRunDay(calendar4, jobInfo) || !this.isDayTypeMatch(calendar4) || !this.isInTimeRange(calendar4) || this.isOmitDate(calendar4, jobInfo)) && !this.maxTimeHorizonExceeded(calendar4, calendar5));
        if (this.maxTimeHorizonExceeded(calendar4, calendar5)) {
            String string = this.maximumTimeHorizonExceededErrorText(calendar5);
            throw new IllegalStateException(string);
        }
        return calendar4;
    }

    private Calendar getTimeZoneAdjustedRuntime(Calendar calendar, long l) {
        if (calendar.getTimeInMillis() > l) {
            return calendar;
        }
        long l2 = this.minutes * 60000;
        long l3 = l - calendar.getTimeInMillis();
        long l4 = l3 / l2 + 1L;
        Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
        calendar2.setTimeInMillis(calendar.getTimeInMillis() + l4 * l2);
        return calendar2;
    }

    private Calendar findFirstValidRuntime(Calendar calendar, JobInfo jobInfo) {
        Calendar calendar2 = (Calendar)calendar.clone();
        Calendar calendar3 = this.calculateMaximumTimeHorizon(calendar);
        while (!this.isRunDay(calendar2, jobInfo) || !this.isDayTypeMatch(calendar2) || !this.isInTimeRange(calendar2) || this.isOmitDate(calendar2, jobInfo)) {
            calendar2.add(12, this.minutes);
            if (!calendar2.after(calendar3)) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar2.getTimeZone());
            String string = simpleDateFormat.format(calendar2.getTime());
            simpleDateFormat.setTimeZone(calendar3.getTimeZone());
            String string2 = simpleDateFormat.format(calendar3.getTime());
            String string3 = MessageUtil.formatMsg((String)"A valid run date/time could not be calculated before {1} from the base date/time {0} for job {3} on agent {2}.", (Object[])new Object[]{string, string2, jobInfo.getAgentNameOrID(), jobInfo.getJobNameOrID()});
            throw new IllegalStateException(string3);
        }
        return calendar2;
    }

    @Override
    public String toString() {
        String string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        if (this.displayPref == DisplayPref.HOURS && this.minutes % 60 != 0) {
            this.displayPref = DisplayPref.MINUTES;
        }
        switch (this.displayPref) {
            case MINUTES: {
                string = Integer.toString(this.minutes) + " min";
                break;
            }
            case HOURS: {
                string = Integer.toString(this.minutes / 60) + " hr";
                break;
            }
            default: {
                string = Integer.toString(this.minutes) + " ?";
            }
        }
        if (!string.startsWith("1 ")) {
            string = string + "s";
        }
        simpleDateFormat.setTimeZone(this.baseDateTime.getTimeZone());
        String string2 = simpleDateFormat.format(this.baseDateTime.getTime());
        return super.toString() + "|Interval: " + string + "|Base:" + string2 + "|Day type: " + this.dayType + "|Runtime ranges: " + this.runtimeRanges;
    }

    private Calendar constructBaseDateTime(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)this.baseDateTime.clone();
        calendar2.setTimeZone(calendar.getTimeZone());
        Calendar calendar3 = Calendar.getInstance(timeZone);
        calendar3.setTimeInMillis(0L);
        calendar3.set(1, calendar2.get(1));
        calendar3.set(2, calendar2.get(2));
        calendar3.set(5, calendar2.get(5));
        calendar3.set(11, calendar2.get(11));
        calendar3.set(12, calendar2.get(12));
        return calendar3;
    }

    private boolean isDayTypeMatch(Calendar calendar) {
        switch (this.dayType) {
            case ALL_DAYS: {
                return true;
            }
            case WORKDAYS: {
                return this.getCalendarObject().isWorkday(calendar);
            }
            case NON_WORKDAYS: {
                return this.getCalendarObject().isNonWorkday(calendar);
            }
        }
        throw new IllegalArgumentException("Unrecognized day type: " + this.dayType);
    }

    private boolean isInTimeRange(Calendar calendar) {
        return this.runtimeRanges.contains(calendar);
    }

    private boolean isOmitDate(Calendar calendar, JobInfo jobInfo) {
        if (this.isOmitDate(calendar)) {
            int n = this.getCalendarObject().yyyymmdd_AdjustedForVirtualDay(calendar);
            if (n != this.lastOmitDateLogged) {
                this.logThatIntervalJobWasOmitted(n, jobInfo);
                this.lastOmitDateLogged = n;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isRunDay(Calendar calendar, JobInfo jobInfo) {
        return !this.runtimeRanges.hasNoRuntimeRangesDefinedForDate(calendar);
    }

    private void logThatIntervalJobWasOmitted(int n, JobInfo jobInfo) {
        int n2 = n / 10000;
        int n3 = n / 100 % 100;
        int n4 = n % 100;
        String string = n2 + "-" + n3 + "-" + n4;
        String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string, this.getOmitDates().getName()};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.SCHEDULED_INTERVAL_JOB_RUN_OMITTED_FOR_DAY.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
        this.writeScheduleLogEntry(scheduleLogEntry);
    }

    private boolean maxTimeHorizonExceeded(Calendar calendar, Calendar calendar2) {
        return calendar.after(calendar2);
    }

    public static enum DisplayPref implements PersistableEnum<String>
    {
        MINUTES("M"),
        HOURS("H");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, DisplayPref> map;

        private DisplayPref(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static DisplayPref persistanceCodeToEnum(String string) {
            DisplayPref displayPref = map.get(string);
            if (displayPref == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return displayPref;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])DisplayPref.values());
        }
    }
}

