/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoTest;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ScheduleInfo_DayOfWeekTest
extends ScheduleInfoTest {
    private ScheduleInfo_DayOfWeek info;
    private Runtimes_DayOfWeek runtimes;

    public ScheduleInfo_DayOfWeekTest(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.info = new ScheduleInfo_DayOfWeek();
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        this.info.setCalendarObject(this.calendar);
        this.info.setOmitDates(this.omitDates);
        this.runtimes = new Runtimes_DayOfWeek(this.calendar);
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.WEEK1, new LocalHHMM(9, 0));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(16, 35));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.WEEK2, new LocalHHMM(11, 15));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.WED, Runtimes_DayOfWeek.RunCode.WEEK3, new LocalHHMM(13, 30));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.THU, Runtimes_DayOfWeek.RunCode.WEEK4, new LocalHHMM(15, 45));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.FRI, Runtimes_DayOfWeek.RunCode.LAST_WEEK, new LocalHHMM(16, 25));
        this.info.setRuntimes(this.runtimes);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public void testCreateScheduleInfoOfType() {
        super.testCreateScheduleInfoOfType();
        ScheduleInfo scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.DAY_OF_WEEK);
        ScheduleInfo_DayOfWeekTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_OF_WEEK, (Object)scheduleInfo.getScheduleType());
    }

    public void testValidate() {
        this.info.validate();
    }

    public void testValidateRequiresRuntimes() {
        this.info = new ScheduleInfo_DayOfWeek();
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        this.info.setCalendarObject(this.calendar);
        this.info.setOmitDates(this.omitDates);
        try {
            this.info.validate();
            ScheduleInfo_DayOfWeekTest.fail((String)"validate() should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testToString() {
        String string = "Schedule type: DAY_OF_WEEK|Timezone type: AGENT|Calendar: MyCalendar|Omit Date List: OmitDates|Runtimes: {MON={1=[09:00, 16:35], 2=[16:35], 3=[16:35], 4=[16:35], 5=[16:35]}, TUE={2=[11:15]}, WED={3=[13:30]}, THU={4=[15:45]}, FRI={}, L=[16:25]}";
        String string2 = this.info.toString();
        ScheduleInfo_DayOfWeekTest.assertEquals((String)string, (String)string2);
    }

    public void testGetRuntimes() {
        ScheduleInfo_DayOfWeekTest.assertEquals((Object)this.runtimes, (Object)this.info.getRuntimes());
    }

    @Override
    public void testCalcNST() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 5);
        gregorianCalendar.set(11, 7);
        gregorianCalendar.set(12, 15);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        Calendar calendar = this.info.calcNST(gregorianCalendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)9, (int)calendar.get(11));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)0, (int)calendar.get(12));
        gregorianCalendar.set(11, 12);
        calendar = this.info.calcNST(gregorianCalendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)16, (int)calendar.get(11));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)35, (int)calendar.get(12));
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 18);
        calendar = this.info.calcNST(gregorianCalendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)13, (int)calendar.get(5));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)11, (int)calendar.get(11));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)15, (int)calendar.get(12));
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 5);
        gregorianCalendar.set(11, 7);
        gregorianCalendar.set(12, 15);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        ((Calendar)gregorianCalendar).setTimeZone(AGENT_TIME_ZONE);
        calendar = this.info.calcNST(gregorianCalendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)9, (int)calendar.get(11));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)0, (int)calendar.get(12));
        gregorianCalendar.set(11, 12);
        calendar = this.info.calcNST(gregorianCalendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)16, (int)calendar.get(11));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)35, (int)calendar.get(12));
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 18);
        calendar = this.info.calcNST(gregorianCalendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)13, (int)calendar.get(5));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)11, (int)calendar.get(11));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)15, (int)calendar.get(12));
    }

    public void testIsRunDay() {
        ScheduleInfo_DayOfWeekTest.assertEquals((int)2, (int)MAR15_SERVER_TIME_ZONE.get(7));
        System.out.println();
        ScheduleInfo_DayOfWeekTest.assertTrue((boolean)this.info.isRunDay(MAR15_SERVER_TIME_ZONE, this.jobInfo));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)3, (int)MAR16_SERVER_TIME_ZONE.get(7));
        ScheduleInfo_DayOfWeekTest.assertFalse((boolean)this.info.isRunDay(MAR16_SERVER_TIME_ZONE, this.jobInfo));
        ScheduleInfo_DayOfWeekTest.assertEquals((int)7, (int)MAR20_SERVER_TIME_ZONE.get(7));
        ScheduleInfo_DayOfWeekTest.assertFalse((boolean)this.info.isRunDay(MAR20_SERVER_TIME_ZONE, this.jobInfo));
    }

    @Override
    public void testGetOmitDates() {
        ScheduleInfo_DayOfWeekTest.assertEquals((Object)this.omitDates, (Object)this.info.getOmitDates());
    }

    @Override
    public void testSetLateStartJob() {
        this.info.setLateStartJob(false);
        ScheduleInfo_DayOfWeekTest.assertFalse((boolean)this.info.isLateStartJob());
        this.info.setLateStartJob(true);
        ScheduleInfo_DayOfWeekTest.assertTrue((boolean)this.info.isLateStartJob());
    }

    @Override
    public void testSetNonWorkdayOption() {
        this.info.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.RUN_ON_NEAREST_PRIOR_WORKDAY);
        ScheduleInfo_DayOfWeekTest.assertEquals((Object)ScheduleInfo.NonWorkdayOption.RUN_ON_NEAREST_PRIOR_WORKDAY, (Object)this.info.getNonWorkdayOption());
    }

    @Override
    public void testSetTargetID() {
        this.info.setTargetID(12345);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)12345, (int)this.info.getTargetID());
    }

    @Override
    public void testSetTargetType() {
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        ScheduleInfo_DayOfWeekTest.assertEquals((Object)ScheduleInfo.TargetType.AGENT, (Object)this.info.getTargetType());
    }

    @Override
    public void testSetTimeZoneToUse() {
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        ScheduleInfo_DayOfWeekTest.assertEquals((Object)ScheduleInfo.TimeZoneType.SERVER, (Object)this.info.getTimeZoneType());
    }

    @Override
    public void testSetUpdateCounter() {
        this.info.setUpdateCounter(34567);
        ScheduleInfo_DayOfWeekTest.assertEquals((int)34567, (int)this.info.getUpdateCounter());
    }
}

