/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import java.util.TimeZone;

public class ScheduleInfo_DayOfPeriod
extends ScheduleInfo {
    private CalendarObject.DayType dayType;
    private Runtimes runtimes;

    public ScheduleInfo_DayOfPeriod() {
        super(ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD);
    }

    public CalendarObject.DayType getDayType() {
        return this.dayType;
    }

    public Runtimes getRuntimes() {
        return this.runtimes;
    }

    public void setDayType(CalendarObject.DayType dayType) {
        ValidationHelper.checkForNull((String)"Day type", (Object)dayType);
        this.dayType = dayType;
    }

    public void setRuntimes(Runtimes runtimes) {
        ValidationHelper.checkForNull((String)"Run Times", (Object)runtimes);
        this.runtimes = runtimes;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationHelper.validateReqFieldNotNull((String)"Day Type", (Object)this.dayType);
        ValidationHelper.validateReqFieldNotNull((String)"Runtimes", (Object)this.runtimes);
    }

    @Override
    public Calendar calcNST(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        ValidationHelper.checkForNull((String)"CST", (Object)calendar);
        if (this.runtimes.isEmpty()) {
            throw new IllegalStateException("There are no runtimes defined.");
        }
        Calendar calendar2 = null;
        if (this.isRunDay(calendar, jobInfo)) {
            calendar2 = this.nextRuntimeSameDay(calendar, jobInfo, timeZone);
        }
        if (calendar2 == null) {
            Calendar calendar3 = (Calendar)calendar.clone();
            Calendar calendar4 = this.calculateMaximumTimeHorizon(calendar);
            do {
                this.advanceOneDay(calendar3);
                if (this.isRunDay(calendar3, jobInfo)) {
                    try {
                        calendar2 = this.firstRuntimeOfDay(calendar3, jobInfo, timeZone);
                    }
                    catch (CalendarObjectRangeException calendarObjectRangeException) {
                        String string = MessageUtil.formatMsg((String)"There are no more rundays that occur before the maximum date defined by calendar {0}, which is {1}.", (Object[])new Object[]{this.getCalendarObject().getName(), calendarObjectRangeException.getMaximumDateInRange()});
                        throw new IllegalStateException(string, calendarObjectRangeException);
                    }
                } else {
                    calendar2 = null;
                }
            } while (calendar2 == null && !this.maxTimeHorizonExceeded(calendar3, calendar4));
            if (this.maxTimeHorizonExceeded(calendar3, calendar4)) {
                String string = this.maximumTimeHorizonExceededErrorText(calendar4);
                throw new IllegalStateException(string);
            }
        }
        return calendar2;
    }

    @Override
    public String toString() {
        return super.toString() + "|Day type: " + this.dayType + "|Runtimes: " + this.runtimes;
    }

    @Override
    protected boolean isRunDay(Calendar calendar, JobInfo jobInfo) {
        return this.runtimes.firstRuntimeOfDay(calendar, jobInfo) != null;
    }

    private Calendar firstRuntimeOfDay(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        Calendar calendar2 = this.runtimes.firstRuntimeOfDay(calendar, jobInfo);
        if (this.isOmitDate(calendar2)) {
            this.logThatJobWasOmitted(calendar2, jobInfo);
        } else {
            Calendar calendar3 = this.adjustForNonWorkdayIfNecessary(calendar2, jobInfo, timeZone);
            if (calendar3 != null) {
                return calendar3;
            }
        }
        return this.nextRuntimeSameDay(calendar2, jobInfo, timeZone);
    }

    private Calendar nextRuntimeSameDay(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        Calendar calendar2;
        while ((calendar2 = this.runtimes.nextRuntimeSameDay(calendar, jobInfo)) != null) {
            if (this.isOmitDate(calendar2)) {
                this.logThatJobWasOmitted(calendar2, jobInfo);
            } else {
                Calendar calendar3 = this.adjustForNonWorkdayIfNecessary(calendar2, jobInfo, timeZone);
                if (calendar3 != null) {
                    return calendar3;
                }
            }
            calendar = calendar2;
        }
        return null;
    }

    private boolean maxTimeHorizonExceeded(Calendar calendar, Calendar calendar2) {
        return calendar.after(calendar2);
    }
}

