/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ScheduleInfo_DayCount
extends ScheduleInfo {
    private int dayCountInterval;
    private int baseDate;
    private CalendarObject.DayType dayType;
    private Runtimes runtimes;

    public ScheduleInfo_DayCount() {
        super(ScheduleJobProxy.ScheduleType.DAY_COUNT);
    }

    public int getBaseDate() {
        return this.baseDate;
    }

    public int getDayCountInterval() {
        return this.dayCountInterval;
    }

    public CalendarObject.DayType getDayType() {
        return this.dayType;
    }

    public Runtimes getRuntimes() {
        return this.runtimes;
    }

    public void setBaseDate(int n) {
        this.baseDate = n;
    }

    public void setDayCountInterval(int n) {
        this.dayCountInterval = n;
    }

    public void setDayType(CalendarObject.DayType dayType) {
        ValidationHelper.checkForNull((String)"Day type", (Object)dayType);
        this.dayType = dayType;
    }

    public void setRuntimes(Runtimes runtimes) {
        ValidationHelper.checkForNull((String)"Run Times", (Object)runtimes);
        this.runtimes = runtimes;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationHelper.validateReqFieldNotZero((String)"Base Date", (int)this.baseDate);
        ValidationHelper.validateReqFieldNotNull((String)"Day Type", (Object)this.dayType);
        ValidationHelper.validateReqFieldNotNull((String)"Run Times", (Object)this.runtimes);
    }

    @Override
    public Calendar calcNST(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        if (this.runtimes.isEmpty()) {
            throw new IllegalStateException("There are no runtimes defined.");
        }
        Calendar calendar2 = this.constructBaseDateTime(jobInfo, timeZone);
        if (calendar == null || calendar2.after(calendar)) {
            if (this.isDayTypeMatch(calendar2) && !this.isOmitDate(calendar2)) {
                return calendar2;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setTimeZone(calendar2.getTimeZone());
            String string = MessageUtil.formatMsg((String)"The start date has been specified as {0}, but that date is not a valid run day.", (Object[])new Object[]{simpleDateFormat.format(calendar2.getTime())});
            throw new IllegalStateException(string);
        }
        if (this.dayCountInterval <= 0) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Invalid interval value: {0}.", (Object[])new Object[]{this.dayCountInterval}));
        }
        Calendar calendar3 = null;
        if (this.isDayTypeMatch(calendar)) {
            calendar3 = this.nextRuntimeSameDay(calendar, jobInfo);
        }
        if (calendar3 == null) {
            calendar3 = this.nextRunDay(calendar);
            calendar3 = this.firstRuntimeOfDay(calendar3, jobInfo, timeZone);
        }
        return calendar3;
    }

    @Override
    public String toString() {
        return super.toString() + "|Interval: " + this.dayCountInterval + "|Day type: " + this.dayType + "|Runtimes: " + this.runtimes.toString().replace("null", "none");
    }

    private Calendar constructBaseDateTime(JobInfo jobInfo, TimeZone timeZone) {
        int n = this.baseDate;
        int n2 = n / 10000;
        int n3 = n / 100 % 100;
        int n4 = n % 100;
        Calendar calendar = new GregorianCalendar(n2, n3 - 1, n4);
        ((Calendar)calendar).setTimeZone(timeZone);
        calendar = this.runtimes.firstRuntimeOfDay(calendar, jobInfo);
        return calendar;
    }

    private Calendar firstRuntimeOfDay(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        Calendar calendar2 = this.runtimes.firstRuntimeOfDay(calendar, jobInfo);
        if (!this.isOmitDate(calendar2)) {
            return calendar2;
        }
        this.logThatJobWasOmitted(calendar2, jobInfo);
        return this.calcNST(calendar2, jobInfo, timeZone);
    }

    private boolean isDayTypeMatch(Calendar calendar) {
        switch (this.dayType) {
            case ALL_DAYS: {
                return true;
            }
            case WORKDAYS: {
                return this.getCalendarObject().isWorkday(calendar);
            }
            case NON_WORKDAYS: {
                return this.getCalendarObject().isNonWorkday(calendar);
            }
        }
        throw new IllegalArgumentException("Unrecognized day type: " + this.dayType);
    }

    @Override
    protected boolean isRunDay(Calendar calendar, JobInfo jobInfo) {
        throw new IllegalStateException("It is invalid to call the isRunDay method for an Interval-Day type job.");
    }

    private Calendar nextRunDay(Calendar calendar) {
        try {
            return this.getCalendarObject().addDays(this.dayCountInterval, this.dayType, calendar);
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            String string = MessageUtil.formatMsg((String)"There are no more rundays that occur before the maximum date defined by calendar {0}, which is {1}.", (Object[])new Object[]{this.getCalendarObject().getName(), calendarObjectRangeException.getMaximumDateInRange()});
            throw new IllegalStateException(string, calendarObjectRangeException);
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            return invalidDateTimeException.getMovedInvalidDateTime();
        }
    }

    private Calendar nextRuntimeSameDay(Calendar calendar, JobInfo jobInfo) {
        Calendar calendar2;
        while ((calendar2 = this.runtimes.nextRuntimeSameDay(calendar, jobInfo)) != null) {
            if (!this.isOmitDate(calendar2)) {
                return calendar2;
            }
            this.logThatJobWasOmitted(calendar2, jobInfo);
            calendar = calendar2;
        }
        return null;
    }
}

