/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_Basic;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_WeekOfPeriod;
import com.helpsystems.enterprise.core.scheduler.Runtimes_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.TimeRange;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Map;

public class RuntimeRanges_DayOfWeek
implements RuntimeRanges {
    private CalendarObject calendarObject;
    private Map<CalendarObject.DayOfWeek, RuntimeRanges> map = new EnumMap<CalendarObject.DayOfWeek, RuntimeRanges>(CalendarObject.DayOfWeek.class);

    public RuntimeRanges_DayOfWeek(CalendarObject calendarObject) {
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        this.calendarObject = calendarObject;
    }

    public void addRuntimeRange(CalendarObject.DayOfWeek dayOfWeek, Runtimes_DayOfWeek.RunCode runCode, TimeRange timeRange) {
        ValidationHelper.checkForNull((String)"Day of week", (Object)((Object)dayOfWeek));
        ValidationHelper.checkForNull((String)"Run code", (Object)runCode);
        ValidationHelper.checkForNull((String)"Runtime Range", (Object)timeRange);
        RuntimeRanges runtimeRanges = this.map.get((Object)dayOfWeek);
        switch (runCode) {
            case NEVER: {
                break;
            }
            case EVERY_WEEK: {
                if (runtimeRanges == null) {
                    runtimeRanges = new RuntimeRanges_Basic();
                    this.map.put(dayOfWeek, runtimeRanges);
                }
                if (runtimeRanges instanceof RuntimeRanges_Basic) {
                    ((RuntimeRanges_Basic)runtimeRanges).addRuntimeRange(timeRange);
                    break;
                }
                ((RuntimeRanges_WeekOfPeriod)runtimeRanges).addRuntimeRangeToEachWeek(timeRange);
                break;
            }
            case LAST_WEEK: {
                if (runtimeRanges == null) {
                    runtimeRanges = new RuntimeRanges_WeekOfPeriod(this.calendarObject);
                    this.map.put(dayOfWeek, runtimeRanges);
                }
                if (runtimeRanges instanceof RuntimeRanges_WeekOfPeriod) {
                    ((RuntimeRanges_WeekOfPeriod)runtimeRanges).addLastWeekOfPeriodRuntimeRange(timeRange);
                    break;
                }
                RuntimeRanges_Basic runtimeRanges_Basic = (RuntimeRanges_Basic)runtimeRanges;
                RuntimeRanges_WeekOfPeriod runtimeRanges_WeekOfPeriod = new RuntimeRanges_WeekOfPeriod(this.calendarObject);
                runtimeRanges_WeekOfPeriod.addRuntimeRangesToEachWeek(runtimeRanges_Basic);
                runtimeRanges_WeekOfPeriod.addLastWeekOfPeriodRuntimeRange(timeRange);
                this.map.put(dayOfWeek, runtimeRanges_WeekOfPeriod);
                break;
            }
            default: {
                if (runtimeRanges == null) {
                    runtimeRanges = new RuntimeRanges_WeekOfPeriod(this.calendarObject);
                    this.map.put(dayOfWeek, runtimeRanges);
                }
                int n = this.extractWeekFromRunCode(runCode);
                if (runtimeRanges instanceof RuntimeRanges_WeekOfPeriod) {
                    ((RuntimeRanges_WeekOfPeriod)runtimeRanges).addRuntimeRange(n, timeRange);
                    break;
                }
                RuntimeRanges_Basic runtimeRanges_Basic = (RuntimeRanges_Basic)runtimeRanges;
                RuntimeRanges_WeekOfPeriod runtimeRanges_WeekOfPeriod = new RuntimeRanges_WeekOfPeriod(this.calendarObject);
                runtimeRanges_WeekOfPeriod.addRuntimeRangesToEachWeek(runtimeRanges_Basic);
                runtimeRanges_WeekOfPeriod.addRuntimeRange(n, timeRange);
                this.map.put(dayOfWeek, runtimeRanges_WeekOfPeriod);
            }
        }
    }

    @Override
    public boolean contains(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Date/Time", (Object)calendar);
        CalendarObject.DayOfWeek dayOfWeek = this.calendarObject.dayOfWeek(calendar);
        RuntimeRanges runtimeRanges = this.map.get((Object)dayOfWeek);
        return runtimeRanges != null && runtimeRanges.contains(calendar);
    }

    @Override
    public boolean hasNoRuntimeRangesDefinedForDate(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Date/Time", (Object)calendar);
        CalendarObject.DayOfWeek dayOfWeek = this.calendarObject.dayOfWeek(calendar);
        return this.map.get((Object)dayOfWeek) == null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.toString();
    }

    private int extractWeekFromRunCode(Runtimes_DayOfWeek.RunCode runCode) {
        switch (runCode) {
            case WEEK1: {
                return 1;
            }
            case WEEK2: {
                return 2;
            }
            case WEEK3: {
                return 3;
            }
            case WEEK4: {
                return 4;
            }
            case WEEK5: {
                return 5;
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Unable to extract a week number from RunCode {0}.", (Object[])new Object[]{runCode}));
    }
}

