/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public class MovedInvalidDateTimeTest
extends TestCase {
    private MovedInvalidDateTime movedInvalidDateTime;
    private Calendar adjDateTime;

    public MovedInvalidDateTimeTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.adjDateTime = new GregorianCalendar(TimeZone.getTimeZone("America/Chicago"));
        this.adjDateTime.clear();
    }

    protected void tearDown() throws Exception {
        this.movedInvalidDateTime = null;
        this.adjDateTime = null;
        super.tearDown();
    }

    public void test_calc_of_minutes_moved() {
        this.adjDateTime.set(2010, 2, 14, 3, 0);
        this.movedInvalidDateTime = new MovedInvalidDateTime(this.adjDateTime, new LocalHHMM(2, 10));
        MovedInvalidDateTimeTest.assertEquals((int)50, (int)this.movedInvalidDateTime.getMinutesMoved());
    }

    public void test_calc_of_original_HHMM() {
        this.adjDateTime.set(2010, 2, 14, 3, 0);
        this.movedInvalidDateTime = new MovedInvalidDateTime(this.adjDateTime, 50);
        MovedInvalidDateTimeTest.assertEquals((String)"02:10", (String)this.movedInvalidDateTime.getOriginalTimeHHMM().toString());
    }

    public void test_getOriginalDateTimeYYYYMMDDHHMM() {
        this.adjDateTime.set(2010, 2, 14, 3, 0);
        this.movedInvalidDateTime = new MovedInvalidDateTime(this.adjDateTime, new LocalHHMM(2, 10));
        MovedInvalidDateTimeTest.assertEquals((long)201003140210L, (long)this.movedInvalidDateTime.getOriginalDateTimeYYYYMMDDHHMM());
    }

    public void test_toCalendar() {
        this.adjDateTime.set(2010, 2, 14, 3, 0);
        this.movedInvalidDateTime = new MovedInvalidDateTime(this.adjDateTime, 50);
        MovedInvalidDateTimeTest.assertEquals((Object)this.adjDateTime, (Object)this.movedInvalidDateTime.toCalendar());
    }
}

