/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import junit.framework.TestCase;

public class LocalHHMMTest
extends TestCase {
    private LocalHHMM obj;

    public LocalHHMMTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.obj = new LocalHHMM();
    }

    protected void tearDown() throws Exception {
        this.obj = null;
        super.tearDown();
    }

    public void testHashCode() {
        this.obj = new LocalHHMM(12, 34);
        int n = this.obj.hashCode();
        for (int i = 0; i < 100; ++i) {
            LocalHHMMTest.assertEquals((int)n, (int)this.obj.hashCode());
        }
        LocalHHMM localHHMM = new LocalHHMM(12, 34);
        LocalHHMMTest.assertEquals((Object)((Object)this.obj), (Object)((Object)localHHMM));
        LocalHHMMTest.assertEquals((int)n, (int)localHHMM.hashCode());
    }

    public void testEqualsObject() {
        this.obj = new LocalHHMM(12, 34);
        LocalHHMM localHHMM = new LocalHHMM(12, 34);
        LocalHHMM localHHMM2 = new LocalHHMM(12, 0);
        LocalHHMM localHHMM3 = new LocalHHMM(11, 34);
        LocalHHMMTest.assertFalse((boolean)this.obj.equals(null));
        LocalHHMMTest.assertFalse((boolean)this.obj.equals(new Object()));
        LocalHHMMTest.assertTrue((boolean)this.obj.equals((Object)this.obj));
        LocalHHMMTest.assertTrue((boolean)this.obj.equals((Object)localHHMM));
        LocalHHMMTest.assertTrue((boolean)localHHMM.equals((Object)this.obj));
        LocalHHMMTest.assertFalse((boolean)this.obj.equals((Object)localHHMM2));
        LocalHHMMTest.assertFalse((boolean)this.obj.equals((Object)localHHMM3));
    }

    public void testLocalHHMMIntInt() {
        this.obj = new LocalHHMM(12, 34);
        LocalHHMMTest.assertEquals((int)12, (int)this.obj.getHourOfDay());
        LocalHHMMTest.assertEquals((int)34, (int)this.obj.getMinuteOfHour());
    }

    public void testSetHourOfDayWorksWithinLimits() {
        try {
            this.obj.setHourOfDay(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (int i = 0; i <= 23; ++i) {
            this.obj.setHourOfDay(i);
            LocalHHMMTest.assertEquals((int)i, (int)this.obj.getHourOfDay());
        }
        try {
            this.obj.setHourOfDay(24);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetMinuteOfHourWorksWithinLimits() {
        try {
            this.obj.setMinuteOfHour(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (int i = 0; i <= 59; ++i) {
            this.obj.setMinuteOfHour(i);
            LocalHHMMTest.assertEquals((int)i, (int)this.obj.getMinuteOfHour());
        }
        try {
            this.obj.setMinuteOfHour(60);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToString() {
        this.obj.setHourOfDay(12);
        this.obj.setMinuteOfHour(34);
        String string = "12:34";
        String string2 = this.obj.toString();
        LocalHHMMTest.assertEquals((String)string, (String)string2);
        this.obj.setHourOfDay(9);
        this.obj.setMinuteOfHour(56);
        string = "09:56";
        string2 = this.obj.toString();
        LocalHHMMTest.assertEquals((String)string, (String)string2);
        this.obj.setHourOfDay(10);
        this.obj.setMinuteOfHour(5);
        string = "10:05";
        string2 = this.obj.toString();
        LocalHHMMTest.assertEquals((String)string, (String)string2);
    }

    public void testCompareTo() {
        this.obj.setHourOfDay(12);
        this.obj.setMinuteOfHour(15);
        LocalHHMM localHHMM = new LocalHHMM(7, 35);
        LocalHHMM localHHMM2 = new LocalHHMM(11, 58);
        LocalHHMM localHHMM3 = new LocalHHMM(12, 17);
        LocalHHMM localHHMM4 = new LocalHHMM(19, 0);
        LocalHHMMTest.assertTrue((this.obj.compareTo((Object)localHHMM) > 0 ? 1 : 0) != 0);
        LocalHHMMTest.assertTrue((this.obj.compareTo((Object)localHHMM2) > 0 ? 1 : 0) != 0);
        LocalHHMMTest.assertTrue((this.obj.compareTo((Object)this.obj) == 0 ? 1 : 0) != 0);
        LocalHHMMTest.assertTrue((this.obj.compareTo((Object)localHHMM3) < 0 ? 1 : 0) != 0);
        LocalHHMMTest.assertTrue((this.obj.compareTo((Object)localHHMM4) < 0 ? 1 : 0) != 0);
    }
}

