/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMemberSkipFlag;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;

public class JobSuiteMember {
    private long memberID;
    private long jobID;
    private String name;
    private MemberType memberType;
    private long targetID;
    private ScheduleInfo.TargetType targetType;
    private int priority;
    private JobSuiteMemberSkipFlag skipFlag;
    private int skipTimes;
    private int skipCount;
    private long skipUntil;
    private boolean skipMatched;
    private int requiredPrereqs;
    private int failedMemberAction;
    private long jobQueueID;
    private String jobQueueName;

    public long getJobID() {
        return this.jobID;
    }

    public long getMemberID() {
        return this.memberID;
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public JobSuiteMemberSkipFlag getSkipFlag() {
        return this.skipFlag;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public int getSkipTimes() {
        return this.skipTimes;
    }

    public long getSkipUntil() {
        return this.skipUntil;
    }

    public long getTargetID() {
        return this.targetID;
    }

    public ScheduleInfo.TargetType getTargetType() {
        return this.targetType;
    }

    public void setJobID(long l) {
        this.jobID = l;
    }

    public void setMemberID(long l) {
        this.memberID = l;
    }

    public void setMemberType(MemberType memberType) {
        this.memberType = memberType;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public void setSkipFlag(JobSuiteMemberSkipFlag jobSuiteMemberSkipFlag) {
        this.skipFlag = jobSuiteMemberSkipFlag;
    }

    public void setSkipCount(int n) {
        this.skipCount = n;
    }

    public void setSkipTimes(int n) {
        this.skipTimes = n;
    }

    public void setSkipUntil(long l) {
        this.skipUntil = l;
    }

    public void setTargetID(long l) {
        this.targetID = l;
    }

    public void setTargetType(ScheduleInfo.TargetType targetType) {
        this.targetType = targetType;
    }

    public boolean isSkipMatched() {
        return this.skipMatched;
    }

    public void setSkipMatched(boolean bl) {
        this.skipMatched = bl;
    }

    public int getRequiredPrereqs() {
        return this.requiredPrereqs;
    }

    public void setRequiredPrereqs(int n) {
        this.requiredPrereqs = n;
    }

    public int getFailedMemberAction() {
        return this.failedMemberAction;
    }

    public void setFailedMemberAction(int n) {
        this.failedMemberAction = n;
    }

    public long getJobQueueID() {
        return this.jobQueueID;
    }

    public void setJobQueueID(long l) {
        this.jobQueueID = l;
    }

    public String getJobQueueName() {
        return this.jobQueueName;
    }

    public void setJobQueueName(String string) {
        this.jobQueueName = string;
    }

    public String getFailedMemberActionStr() {
        switch (this.failedMemberAction) {
            case 0: {
                return "Fail the suite";
            }
            case 1: {
                return "Do not fail the suite";
            }
        }
        return "Unknown";
    }

    public String getRequiredPrereqsStr() {
        switch (this.requiredPrereqs) {
            case 0: {
                return "All (Member can only run once)";
            }
            case 1: {
                return "Any (Member may run multiple times)";
            }
            case 2: {
                return "First (Member can only run once)";
            }
        }
        return "Unknown";
    }

    public static enum MemberType implements PersistableEnum<Integer>
    {
        JOB(0),
        SUITE(1);

        private int persistanceCode;
        private static PersistanceCodeToEnumMap<Integer, MemberType> map;

        private MemberType(int n2) {
            this.persistanceCode = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.persistanceCode;
        }

        public static MemberType persistanceCodeToEnum(Integer n) {
            MemberType memberType = map.get(n);
            if (memberType == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return memberType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])MemberType.values());
        }
    }
}

