/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.forecast.ForecastStatus;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.DSTHelper;
import com.helpsystems.enterprise.core.scheduler.ForecastDefinition;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ForecastRun {
    private long id;
    private ForecastStatus forecastStatus = ForecastStatus.RUNNING;
    private ForecastDefinition forecastDefinition;
    private Calendar forecastWindowBegin;
    private Calendar forecastWindowEnd;
    private Calendar generationBegin;
    private Calendar generationEnd;

    public ForecastRun(ForecastDefinition forecastDefinition) {
        ValidationHelper.checkForNull((String)"Forecast Definition", (Object)forecastDefinition);
        this.forecastDefinition = forecastDefinition;
        this.constructForecastWindow(forecastDefinition);
    }

    public long getForecastRunID() {
        return this.id;
    }

    public long getForecastDefinitionID() {
        return this.forecastDefinition.getID();
    }

    public Calendar getForecastWindowBegin() {
        return this.forecastWindowBegin;
    }

    public Calendar getForecastWindowEnd() {
        return this.forecastWindowEnd;
    }

    public Calendar getGenerationBegin() {
        return this.generationBegin;
    }

    public Calendar getGenerationEnd() {
        return this.generationEnd;
    }

    public boolean isExcludeTimedIntervalJobs() {
        return this.forecastDefinition.isExcludeTimedIntervalJobs();
    }

    public boolean isExcludeDailyIntervalJobs() {
        return this.forecastDefinition.isExcludeDailyIntervalJobs();
    }

    public ForecastStatus getForecastStatus() {
        return this.forecastStatus;
    }

    public void setForecastRunID(long l) {
        this.id = l;
    }

    public void setGenerationBegin(Calendar calendar) {
        this.generationBegin = calendar;
    }

    public void setGenerationEnd(Calendar calendar) {
        this.generationEnd = calendar;
    }

    public void setForecastStatus(ForecastStatus forecastStatus) {
        this.forecastStatus = forecastStatus;
    }

    public String getForecastName() {
        return this.forecastDefinition.getName();
    }

    private void constructForecastWindow(ForecastDefinition forecastDefinition) {
        this.forecastWindowBegin = this.constructForecastWindowBegin(forecastDefinition);
        this.forecastWindowEnd = (Calendar)this.forecastWindowBegin.clone();
        int n = forecastDefinition.getDuration();
        switch (forecastDefinition.getDurationOption()) {
            case HOURS: {
                this.forecastWindowEnd.add(11, n);
                break;
            }
            case DAYS: {
                try {
                    DSTHelper.addDays(this.forecastWindowEnd, n);
                }
                catch (InvalidDateTimeException invalidDateTimeException) {
                    MovedInvalidDateTime movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
                    String string = movedInvalidDateTime.getOriginalTimeHHMM().toString();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
                    simpleDateFormat.setTimeZone(movedInvalidDateTime.getTimeZone());
                    String[] stringArray = new String[]{forecastDefinition.getName(), simpleDateFormat.format(movedInvalidDateTime.getTime()), string};
                    ScheduleLogEntry scheduleLogEntry = RosettaMsg.FORECAST_WINDOW_END_TIME_WAS_MOVED.newLogEntry(stringArray);
                    ScheduleLogger.write(scheduleLogEntry);
                    this.forecastWindowEnd = movedInvalidDateTime;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized forecast definition duration option: " + forecastDefinition.getDurationOption());
            }
        }
    }

    private Calendar constructForecastWindowBegin(ForecastDefinition forecastDefinition) {
        Calendar calendar;
        block5 : switch (forecastDefinition.getStartDateOption()) {
            case SPECIFIC: {
                Calendar calendar2 = forecastDefinition.getStartDate();
                calendar = this.createCalendarFromYMD(calendar2);
                switch (forecastDefinition.getStartTimeOption()) {
                    case SPECIFIC: {
                        LocalHHMM localHHMM = forecastDefinition.getStartTime();
                        try {
                            calendar = DSTHelper.replaceTime(calendar, localHHMM);
                        }
                        catch (InvalidDateTimeException invalidDateTimeException) {
                            MovedInvalidDateTime movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
                            this.issueWindowStartTimeMovedMsg(movedInvalidDateTime);
                            calendar = movedInvalidDateTime;
                        }
                        break block5;
                    }
                    case NOW: {
                        Calendar calendar3 = this.getNow();
                        calendar.set(11, calendar3.get(11));
                        calendar.set(12, calendar3.get(12));
                        break block5;
                    }
                }
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Definition Start Time Option {0} is not supported by this method.", (Object[])new Object[]{forecastDefinition.getStartTimeOption()}));
            }
            case TODAY: {
                switch (forecastDefinition.getStartTimeOption()) {
                    case SPECIFIC: {
                        LocalHHMM localHHMM = forecastDefinition.getStartTime();
                        Calendar calendar4 = Calendar.getInstance();
                        calendar = this.createCalendarFromYMD(calendar4);
                        try {
                            calendar = DSTHelper.replaceTime(calendar, localHHMM);
                        }
                        catch (InvalidDateTimeException invalidDateTimeException) {
                            MovedInvalidDateTime movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
                            this.issueWindowStartTimeMovedMsg(movedInvalidDateTime);
                            calendar = movedInvalidDateTime;
                        }
                        break block5;
                    }
                    case NOW: {
                        Calendar calendar5 = this.getNow();
                        calendar = this.createCalendarFromYMD(calendar5);
                        calendar.set(11, calendar5.get(11));
                        calendar.set(12, calendar5.get(12));
                        break block5;
                    }
                }
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Definition Start Time Option {0} is not supported by this method.", (Object[])new Object[]{forecastDefinition.getStartTimeOption()}));
            }
            case TOMORROW: {
                switch (forecastDefinition.getStartTimeOption()) {
                    case SPECIFIC: {
                        boolean bl;
                        LocalHHMM localHHMM = forecastDefinition.getStartTime();
                        Calendar calendar6 = Calendar.getInstance();
                        calendar = this.createCalendarFromYMD(calendar6);
                        try {
                            calendar = DSTHelper.replaceTime(calendar, localHHMM);
                            bl = false;
                        }
                        catch (InvalidDateTimeException invalidDateTimeException) {
                            bl = true;
                        }
                        if (bl) {
                            calendar = this.createCalendarFromYMD(calendar6);
                            calendar.add(5, 1);
                            calendar.set(11, calendar6.get(11));
                            calendar.set(12, calendar6.get(12));
                            break block5;
                        }
                        try {
                            DSTHelper.addDays(calendar, 1);
                        }
                        catch (InvalidDateTimeException invalidDateTimeException) {
                            MovedInvalidDateTime movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
                            this.issueWindowStartTimeMovedMsg(movedInvalidDateTime);
                            calendar = movedInvalidDateTime;
                        }
                        break block5;
                    }
                    case NOW: {
                        Calendar calendar7 = this.getNow();
                        calendar = this.createCalendarFromYMD(calendar7);
                        calendar.set(11, calendar7.get(11));
                        calendar.set(12, calendar7.get(12));
                        try {
                            DSTHelper.addDays(calendar, 1);
                        }
                        catch (InvalidDateTimeException invalidDateTimeException) {
                            MovedInvalidDateTime movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
                            this.issueWindowStartTimeMovedMsg(movedInvalidDateTime);
                            calendar = movedInvalidDateTime;
                        }
                        break block5;
                    }
                }
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Definition Start Time Option {0} is not supported by this method.", (Object[])new Object[]{forecastDefinition.getStartTimeOption()}));
            }
            default: {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Definition Start Date Option {0} is not supported by this method.", (Object[])new Object[]{forecastDefinition.getStartDateOption()}));
            }
        }
        return calendar;
    }

    private Calendar createCalendarFromYMD(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        return new GregorianCalendar(n, n2, n3);
    }

    private Calendar getNow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, 60 - calendar.get(13));
        return calendar;
    }

    private void issueWindowStartTimeMovedMsg(MovedInvalidDateTime movedInvalidDateTime) {
        String string = movedInvalidDateTime.getOriginalTimeHHMM().toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        simpleDateFormat.setTimeZone(movedInvalidDateTime.getTimeZone());
        String[] stringArray = new String[]{this.forecastDefinition.getName(), simpleDateFormat.format(movedInvalidDateTime.getTime()), string};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.FORECAST_WINDOW_START_TIME_WAS_MOVED.newLogEntry(stringArray);
        ScheduleLogger.write(scheduleLogEntry);
    }
}

