/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public class DependentObject
implements Cloneable {
    private long id;
    private DependentObjectType type;

    public DependentObject() {
    }

    public DependentObject(long l, DependentObjectType dependentObjectType) {
        this.id = l;
        this.type = dependentObjectType;
    }

    public long getID() {
        return this.id;
    }

    public DependentObjectType getType() {
        return this.type;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setType(DependentObjectType dependentObjectType) {
        this.type = dependentObjectType;
    }

    public Object clone() {
        return new DependentObject(this.id, this.type);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        DependentObject dependentObject = (DependentObject)object;
        return dependentObject.id == this.id && dependentObject.type == this.type;
    }

    public int hashCode() {
        return (int)this.id + this.type.hashCode();
    }

    public String toString() {
        return this.type + " " + Long.toString(this.id);
    }

    public static enum DependentObjectType implements PersistableEnum<String>
    {
        JOB("J"),
        JOB_SUITE("S"),
        MEMBER_JOB("M"),
        REACTIVE_EVENT("E");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, DependentObjectType> map;

        private DependentObjectType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static DependentObjectType persistanceCodeToEnum(String string) {
            DependentObjectType dependentObjectType = map.get(string);
            if (dependentObjectType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return dependentObjectType;
        }

        public static DependentObjectType forecastableEventTypeToEnum(ForecastableEvent.ForecastableEventType forecastableEventType) {
            switch (forecastableEventType) {
                case JOB_SUBMISSION: {
                    return JOB;
                }
                case JOB_SUITE: {
                    return JOB_SUITE;
                }
                case MEMBER_JOB: {
                    return MEMBER_JOB;
                }
                case REACTIVE_EVENT_OCCURS: {
                    return REACTIVE_EVENT;
                }
            }
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"There is no DependentObjectType associated with ForecastableEvent type: {0}.", (Object[])new Object[]{forecastableEventType}));
        }

        public static DependentObjectType jobTypeToEnum(JobType jobType) {
            switch (jobType) {
                case JOB: {
                    return JOB;
                }
                case SUITE: {
                    return JOB_SUITE;
                }
                case SUITE_MEMBER: {
                    return MEMBER_JOB;
                }
            }
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"There is no DependentObjectType associated with job type: {0}.", (Object[])new Object[]{jobType}));
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])DependentObjectType.values());
        }
    }
}

