/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.DSTHelper;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public class DSTHelperTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test_addDays_Normal() {
        GregorianCalendar gregorianCalendar;
        GregorianCalendar gregorianCalendar2;
        try {
            gregorianCalendar2 = new GregorianCalendar(2012, 0, 4, 11, 23, 0);
            DSTHelper.addDays(gregorianCalendar2, 11);
            gregorianCalendar = new GregorianCalendar(2012, 0, 15, 11, 23, 0);
            DSTHelperTest.assertEquals((Object)gregorianCalendar, (Object)gregorianCalendar2);
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.fail((String)"");
        }
        try {
            gregorianCalendar2 = new GregorianCalendar(2012, 2, 5, 14, 53, 0);
            DSTHelper.addDays(gregorianCalendar2, 10);
            gregorianCalendar = new GregorianCalendar(2012, 2, 15, 14, 53, 0);
            DSTHelperTest.assertEquals((Object)gregorianCalendar, (Object)gregorianCalendar2);
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.fail((String)"");
        }
        try {
            gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("Asia/Shanghai"));
            gregorianCalendar2.clear();
            gregorianCalendar2.set(2010, 2, 1, 1, 30, 0);
            DSTHelper.addDays(gregorianCalendar2, 30);
            gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Asia/Shanghai"));
            gregorianCalendar.clear();
            gregorianCalendar.set(2010, 2, 31, 1, 30, 0);
            DSTHelperTest.assertEquals((Object)gregorianCalendar, (Object)gregorianCalendar2);
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.fail((String)"");
        }
    }

    public void test_addDays_InvalidDateTime() {
        GregorianCalendar gregorianCalendar;
        try {
            gregorianCalendar = new GregorianCalendar(2019, 2, 9, 2, 41, 0);
            DSTHelper.addDays(gregorianCalendar, 1);
            DSTHelperTest.fail((String)"Expected an InvalidDateTimeException to be thrown.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.assertTrue((boolean)invalidDateTimeException.isCausedByTheSwitchToDaylightSavingTime());
            DSTHelperTest.assertEquals((int)19, (int)invalidDateTimeException.getMovedInvalidDateTime().getMinutesMoved());
        }
        try {
            gregorianCalendar = new GregorianCalendar(2019, 2, 9, 2, 0, 0);
            DSTHelper.addDays(gregorianCalendar, 1);
            DSTHelperTest.fail((String)"Expected an InvalidDateTimeException to be thrown.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.assertTrue((boolean)invalidDateTimeException.isCausedByTheSwitchToDaylightSavingTime());
            DSTHelperTest.assertEquals((int)60, (int)invalidDateTimeException.getMovedInvalidDateTime().getMinutesMoved());
        }
    }

    public void test_replaceTime_Normal() {
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(2012, 6, 4, 9, 45, 0);
            Calendar calendar = DSTHelper.replaceTime(gregorianCalendar, new LocalHHMM(16, 30));
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2012, 6, 4, 16, 30, 0);
            DSTHelperTest.assertEquals((Object)gregorianCalendar2, (Object)calendar);
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.fail((String)"");
        }
    }

    public void test_replaceTime_InvalidDateTime() {
        Calendar calendar;
        GregorianCalendar gregorianCalendar;
        try {
            gregorianCalendar = new GregorianCalendar(2010, 2, 14, 4, 36, 0);
            calendar = DSTHelper.replaceTime(gregorianCalendar, new LocalHHMM(2, 36));
            DSTHelperTest.fail((String)"Expected an InvalidDateTimeException to be thrown.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.assertTrue((boolean)invalidDateTimeException.isCausedByTheSwitchToDaylightSavingTime());
            DSTHelperTest.assertEquals((int)24, (int)invalidDateTimeException.getMovedInvalidDateTime().getMinutesMoved());
            calendar = new GregorianCalendar(2010, 2, 14, 3, 0, 0);
            DSTHelperTest.assertEquals((Object)calendar, (Object)invalidDateTimeException.getMovedInvalidDateTime());
        }
        try {
            gregorianCalendar = new GregorianCalendar(2010, 2, 14, 0, 30, 0);
            calendar = DSTHelper.replaceTime(gregorianCalendar, new LocalHHMM(2, 0));
            DSTHelperTest.fail((String)"Expected an InvalidDateTimeException to be thrown.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.assertTrue((boolean)invalidDateTimeException.isCausedByTheSwitchToDaylightSavingTime());
            DSTHelperTest.assertEquals((int)60, (int)invalidDateTimeException.getMovedInvalidDateTime().getMinutesMoved());
        }
    }

    public void test_replaceTime_AmbiguousDateTime() {
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(2010, 10, 7, 6, 0, 0);
            Calendar calendar = DSTHelper.replaceTime(gregorianCalendar, new LocalHHMM(1, 50));
            DSTHelperTest.assertTrue((boolean)calendar.getTimeZone().inDaylightTime(calendar.getTime()));
            DSTHelperTest.assertTrue((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(calendar));
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            DSTHelperTest.fail((String)"");
        }
    }

    public void test_dstBegins_Chicago() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2010, 4, 12, 15, 0, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2010, 2, 14, 3, 30, 0);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar(2010, 2, 14, 1, 30, 0);
        Calendar calendar = DSTHelper.dstBegins(gregorianCalendar);
        Calendar calendar2 = DSTHelper.dstBegins(gregorianCalendar2);
        Calendar calendar3 = DSTHelper.dstBegins(gregorianCalendar3);
        GregorianCalendar gregorianCalendar4 = new GregorianCalendar(2010, 2, 14, 3, 0, 0);
        DSTHelperTest.assertEquals((Object)gregorianCalendar4, (Object)calendar);
        DSTHelperTest.assertEquals((Object)gregorianCalendar4, (Object)calendar2);
        DSTHelperTest.assertEquals((Object)gregorianCalendar4, (Object)calendar3);
    }

    public void test_dstBegins_London() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"));
        gregorianCalendar.clear();
        gregorianCalendar.set(2010, 2, 28, 1, 30, 0);
        Calendar calendar = DSTHelper.dstBegins(gregorianCalendar);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"));
        gregorianCalendar2.clear();
        gregorianCalendar2.set(2010, 2, 28, 2, 0, 0);
        DSTHelperTest.assertEquals((Object)gregorianCalendar2, (Object)calendar);
    }

    public void test_dstBegins_Egypt_first_transition() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Africa/Cairo"));
        gregorianCalendar.clear();
        gregorianCalendar.set(2010, 3, 30, 0, 30, 0);
        gregorianCalendar.getTimeInMillis();
        Calendar calendar = DSTHelper.dstBegins(gregorianCalendar);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("Africa/Cairo"));
        gregorianCalendar2.clear();
        gregorianCalendar2.set(2010, 3, 30, 1, 0, 0);
        DSTHelperTest.assertEquals((Object)gregorianCalendar2, (Object)calendar);
    }

    public void test_dstBegins_Egypt_second_transition() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Africa/Cairo"));
        gregorianCalendar.clear();
        gregorianCalendar.set(2010, 8, 10, 0, 30, 0);
        gregorianCalendar.getTimeInMillis();
        Calendar calendar = DSTHelper.dstBegins(gregorianCalendar);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("Africa/Cairo"));
        gregorianCalendar2.clear();
        gregorianCalendar2.set(2010, 8, 10, 1, 0, 0);
        DSTHelperTest.assertEquals((Object)gregorianCalendar2, (Object)calendar);
    }

    public void test_isInDSTtoStdTimeTransitionPeriod_Egypt_first_transition() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Africa/Cairo"));
        gregorianCalendar.clear();
        gregorianCalendar.set(2010, 7, 10, 22, 59, 59);
        ((Calendar)gregorianCalendar).add(13, 1);
        gregorianCalendar.get(1);
        DSTHelperTest.assertTrue((boolean)((Calendar)gregorianCalendar).getTimeZone().inDaylightTime(gregorianCalendar.getTime()));
        DSTHelperTest.assertTrue((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(gregorianCalendar));
        ((Calendar)gregorianCalendar).add(14, -1);
        DSTHelperTest.assertFalse((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(gregorianCalendar));
        gregorianCalendar.clear();
        gregorianCalendar.set(2010, 7, 11, 0, 0, 0);
        DSTHelperTest.assertFalse((boolean)((Calendar)gregorianCalendar).getTimeZone().inDaylightTime(gregorianCalendar.getTime()));
        DSTHelperTest.assertFalse((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(gregorianCalendar));
        ((Calendar)gregorianCalendar).add(14, -1);
        DSTHelperTest.assertTrue((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(gregorianCalendar));
    }

    public void test_isInDSTtoStdTimeTransitionPeriod_Egypt_second_transition() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("Africa/Cairo"));
        gregorianCalendar.clear();
        gregorianCalendar.set(2010, 8, 30, 22, 59, 59);
        ((Calendar)gregorianCalendar).add(13, 1);
        DSTHelperTest.assertTrue((boolean)((Calendar)gregorianCalendar).getTimeZone().inDaylightTime(gregorianCalendar.getTime()));
        DSTHelperTest.assertTrue((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(gregorianCalendar));
        ((Calendar)gregorianCalendar).add(14, -1);
        DSTHelperTest.assertFalse((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(gregorianCalendar));
        gregorianCalendar.clear();
        gregorianCalendar.set(2010, 9, 1, 0, 0, 0);
        DSTHelperTest.assertFalse((boolean)((Calendar)gregorianCalendar).getTimeZone().inDaylightTime(gregorianCalendar.getTime()));
        DSTHelperTest.assertFalse((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(gregorianCalendar));
        ((Calendar)gregorianCalendar).add(14, -1);
        DSTHelperTest.assertTrue((boolean)DSTHelper.isInDSTtoStdTimeTransitionPeriod(gregorianCalendar));
    }

    public void test_Prove_Calendar_CDT_problem() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2010, 2, 13, 2, 30);
        calendar.add(5, 1);
        DSTHelperTest.assertEquals((int)1, (int)calendar.get(11));
        DSTHelperTest.assertEquals((int)30, (int)calendar.get(12));
        calendar = new GregorianCalendar(TimeZone.getTimeZone("America/Sao_Paulo"));
        calendar.clear();
        calendar.set(2010, 9, 16, 0, 30);
        calendar.add(5, 1);
        DSTHelperTest.assertEquals((int)1, (int)calendar.get(11));
        DSTHelperTest.assertEquals((int)30, (int)calendar.get(12));
        DSTHelperTest.assertEquals((int)17, (int)calendar.get(5));
    }
}

