/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.SimpleProxy;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.DSTHelper;
import com.helpsystems.enterprise.core.scheduler.DateRange;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class CalendarObject
extends SimpleProxy {
    private static final long serialVersionUID = -8681953473217642387L;
    private int[] holidays = new int[0];
    private int[] otherNonWorkdates = new int[0];
    private LocalHHMM dayStart = new LocalHHMM();
    private EnumSet<DayOfWeek> nonWorkdayByDOW = EnumSet.noneOf(DayOfWeek.class);
    private boolean isAssignDayStartToNextDay;
    private boolean notifyBeforeExpiration;

    public boolean isAssignDayStartToNextDay() {
        return this.isAssignDayStartToNextDay;
    }

    public boolean isNotifyBeforeExpiration() {
        return this.notifyBeforeExpiration;
    }

    public LocalHHMM getDayStart() {
        return this.dayStart;
    }

    public int[] getHolidays() {
        return this.holidays;
    }

    public EnumSet<DayOfWeek> getNonWorkdayByDOW() {
        return this.nonWorkdayByDOW;
    }

    public int[] getOtherNonWorkdates() {
        return this.otherNonWorkdates;
    }

    public void setAssignDayStartToNextDay(boolean bl) {
        this.isAssignDayStartToNextDay = bl;
    }

    public void setDayStart(LocalHHMM localHHMM) {
        ValidationHelper.checkForNull((String)"Day Start", (Object)((Object)localHHMM));
        this.dayStart = localHHMM;
    }

    public void setHolidays(int[] nArray) {
        ValidationHelper.checkForNull((String)"Holidays", (Object)nArray);
        Arrays.sort(nArray);
        this.holidays = nArray;
    }

    public void setNonWorkdayByDOW(EnumSet<DayOfWeek> enumSet) {
        ValidationHelper.checkForNull((String)"Non-Workdays By Day Of Week", enumSet);
        this.nonWorkdayByDOW = enumSet;
    }

    public void setNotifyBeforeExpiration(boolean bl) {
        this.notifyBeforeExpiration = bl;
    }

    public void setOtherNonWorkdates(int[] nArray) {
        ValidationHelper.checkForNull((String)"Other Non-work Dates", (Object)nArray);
        Arrays.sort(nArray);
        this.otherNonWorkdates = nArray;
    }

    public void validate() {
    }

    public Calendar addDays(int n, DayType dayType, Calendar calendar) throws CalendarObjectRangeException, InvalidDateTimeException {
        ValidationHelper.checkForNull((String)"Day type", (Object)dayType);
        ValidationHelper.checkForNull((String)"Start date", (Object)calendar);
        int n2 = n < 0 ? -1 : 1;
        int n3 = Math.abs(n);
        Calendar calendar2 = (Calendar)calendar.clone();
        InvalidDateTimeException invalidDateTimeException = null;
        switch (dayType) {
            case ALL_DAYS: {
                DSTHelper.addDays(calendar2, n);
                break;
            }
            case WORKDAYS: {
                if (this.daysToAddExceedDefinedWorkdays()) {
                    throw new CalendarObjectRangeException(MessageUtil.formatMsg((String)"There are not enough work days defined in calendar {0} to support the request to determine what date is {1} work days from {2}.", (Object[])new Object[]{this.getName(), n, this.formatAsYyyymmdd(calendar)}));
                }
                for (int i = 0; i < n3; ++i) {
                    do {
                        try {
                            DSTHelper.addDays(calendar2, n2);
                        }
                        catch (InvalidDateTimeException invalidDateTimeException2) {
                            invalidDateTimeException = invalidDateTimeException2;
                            calendar2 = (Calendar)invalidDateTimeException2.getMovedInvalidDateTime().clone();
                        }
                    } while (!this.isWorkday(calendar2));
                }
                break;
            }
            case NON_WORKDAYS: {
                if (this.daysToAddExceedDefinedNonWorkdays(n, calendar)) {
                    throw new CalendarObjectRangeException(MessageUtil.formatMsg((String)"There are not enough non-work days defined in calendar {0} to support the request to determine what date is {1} non-work days from {2}.", (Object[])new Object[]{this.getName(), n, this.formatAsYyyymmdd(this.adjustForVirtualDay(calendar))}));
                }
                for (int i = 0; i < n3; ++i) {
                    do {
                        try {
                            DSTHelper.addDays(calendar2, n2);
                        }
                        catch (InvalidDateTimeException invalidDateTimeException3) {
                            invalidDateTimeException = invalidDateTimeException3;
                            calendar2 = (Calendar)invalidDateTimeException3.getMovedInvalidDateTime().clone();
                        }
                    } while (!this.isNonWorkday(calendar2));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized day type: " + dayType);
            }
        }
        if (invalidDateTimeException != null) {
            this.handleInvalidDateTime(invalidDateTimeException, calendar2, n, calendar);
        }
        return calendar2;
    }

    public DayOfWeek dayOfWeek(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        Calendar calendar2 = this.adjustForVirtualDay(calendar);
        return DayOfWeek.fromCalendar(calendar2);
    }

    public boolean isNonWorkday(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Date field", (Object)calendar);
        return this.isNonWorkday(this.yyyymmdd_AdjustedForVirtualDay(calendar));
    }

    public boolean isWorkday(Calendar calendar) {
        return !this.isNonWorkday(calendar);
    }

    public boolean isVirtualDay() {
        return !this.dayStart.isZero();
    }

    public boolean isLastWeekOfMonth(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        Calendar calendar2 = this.adjustForVirtualDay(calendar);
        int n = calendar2.get(5);
        int n2 = calendar2.getActualMaximum(5);
        return n > n2 - 7;
    }

    public int relativeDayFromBeginOfPeriod(Calendar calendar, PeriodType periodType, DayType dayType) {
        ValidationHelper.checkForNull((String)"Date", (Object)calendar);
        ValidationHelper.checkForNull((String)"Period type", (Object)periodType);
        ValidationHelper.checkForNull((String)"Day type", (Object)dayType);
        int n = this.yyyymmdd_AdjustedForVirtualDay(calendar);
        DateRange dateRange = this.periodContaining(n, periodType);
        Integer n2 = this.nthDayOfTypeFromBegin(dateRange.getBegin(), calendar, dayType);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public int relativeDayFromEndOfPeriod(Calendar calendar, PeriodType periodType, DayType dayType) {
        ValidationHelper.checkForNull((String)"Date", (Object)calendar);
        ValidationHelper.checkForNull((String)"Period type", (Object)periodType);
        ValidationHelper.checkForNull((String)"Day type", (Object)dayType);
        int n = this.yyyymmdd_AdjustedForVirtualDay(calendar);
        DateRange dateRange = this.periodContaining(n, periodType);
        Integer n2 = this.nthDayOfTypeFromEnd(dateRange.getEnd(), calendar, dayType);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public int weekOfMonth(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        Calendar calendar2 = this.adjustForVirtualDay(calendar);
        return calendar2.get(8);
    }

    public int yyyymmdd_AdjustedForVirtualDay(Calendar calendar) {
        return CalendarObject.yyyymmdd(this.adjustForVirtualDay(calendar));
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SimpleProxy simpleProxy = (SimpleProxy)object;
        return simpleProxy.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private boolean isDayOfWeekNonWorkday(DayOfWeek dayOfWeek) {
        return this.nonWorkdayByDOW.contains((Object)dayOfWeek);
    }

    private boolean isDayTypeMismatch(Calendar calendar, DayType dayType) {
        switch (dayType) {
            case ALL_DAYS: {
                return false;
            }
            case WORKDAYS: {
                return this.isNonWorkday(calendar);
            }
            case NON_WORKDAYS: {
                return this.isWorkday(calendar);
            }
        }
        throw new IllegalArgumentException("Unrecognized day type: " + dayType);
    }

    private boolean isHoliday(int n) {
        return this.isInArray(this.holidays, n);
    }

    protected boolean isNonWorkday(int n) {
        DayOfWeek dayOfWeek = DayOfWeek.fromYyyymmdd(n);
        return this.isDayOfWeekNonWorkday(dayOfWeek) || this.isHoliday(n) || this.isOtherNonWorkdate(n);
    }

    private boolean isOtherNonWorkdate(int n) {
        return this.isInArray(this.otherNonWorkdates, n);
    }

    private boolean isWorkday(int n) {
        return !this.isNonWorkday(n);
    }

    private Calendar adjustForVirtualDay(Calendar calendar) {
        if (this.isVirtualDay()) {
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTimeInMillis(calendar2.getTimeInMillis() + this.virtualDayOffsetInMillis());
            return calendar2;
        }
        return calendar;
    }

    private boolean isInArray(int[] nArray, int n) {
        return Arrays.binarySearch(nArray, n) > -1;
    }

    private boolean daysToAddExceedDefinedWorkdays() {
        return this.nonWorkdayByDOW.size() == 7;
    }

    private boolean daysToAddExceedDefinedNonWorkdays(int n, Calendar calendar) {
        int n2;
        int n3;
        if (this.nonWorkdayRuleIsDefined()) {
            return false;
        }
        int[] nArray = new int[this.holidays.length + this.otherNonWorkdates.length];
        System.arraycopy(this.holidays, 0, nArray, 0, this.holidays.length);
        int n4 = this.holidays.length;
        System.arraycopy(this.otherNonWorkdates, 0, nArray, n4, this.otherNonWorkdates.length);
        if (this.duplicateDates(nArray)) {
            nArray = this.removeDuplicates(nArray);
        }
        int n5 = this.yyyymmdd_AdjustedForVirtualDay(calendar);
        int n6 = nArray.length;
        int n7 = Arrays.binarySearch(nArray, n5);
        if (n7 >= 0) {
            n3 = n6 - (n7 + 1);
            n2 = n6 - (n3 + 1);
        } else {
            int n8 = -(n7 + 1);
            n3 = n6 - n8;
            n2 = n6 - n3;
        }
        if (n >= 0) {
            return n > n3;
        }
        return -n > n2;
    }

    private boolean duplicateDates(int[] nArray) {
        Arrays.sort(nArray);
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] != nArray[i - 1]) continue;
            return true;
        }
        return false;
    }

    private String formatAsYyyymmdd(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        return simpleDateFormat.format(calendar.getTime());
    }

    private void handleInvalidDateTime(InvalidDateTimeException invalidDateTimeException, Calendar calendar, int n, Calendar calendar2) throws InvalidDateTimeException {
        int n2;
        MovedInvalidDateTime movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
        int n3 = CalendarObject.yyyymmdd(movedInvalidDateTime);
        if (n3 == (n2 = CalendarObject.yyyymmdd(calendar))) {
            throw invalidDateTimeException;
        }
        try {
            calendar = DSTHelper.replaceTime(calendar, movedInvalidDateTime.getOriginalTimeHHMM());
        }
        catch (InvalidDateTimeException invalidDateTimeException2) {
            MovedInvalidDateTime movedInvalidDateTime2 = invalidDateTimeException2.getMovedInvalidDateTime();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar2.getTimeZone());
            String string = MessageUtil.formatMsg((String)"An invalid date/time has been detected. Adding {0} day(s) to {1} results in an invalid date/time.", (Object[])new Object[]{n, simpleDateFormat.format(calendar2.getTime())});
            throw new InvalidDateTimeException(string, movedInvalidDateTime2, invalidDateTimeException2.isCausedByTheSwitchToDaylightSavingTime());
        }
    }

    private boolean nonWorkdayRuleIsDefined() {
        return !this.nonWorkdayByDOW.isEmpty();
    }

    private Integer nthDayOfTypeFromBegin(int n, Calendar calendar, DayType dayType) {
        if (this.isDayTypeMismatch(calendar, dayType)) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        CalendarObject.setCalendarToYyyymmdd(gregorianCalendar, n);
        int n2 = this.yyyymmdd_AdjustedForVirtualDay(calendar);
        int n3 = 0;
        while (CalendarObject.yyyymmdd(gregorianCalendar) <= n2) {
            switch (dayType) {
                case ALL_DAYS: {
                    ++n3;
                    break;
                }
                case WORKDAYS: {
                    if (!this.isWorkday(CalendarObject.yyyymmdd(gregorianCalendar))) break;
                    ++n3;
                    break;
                }
                case NON_WORKDAYS: {
                    if (!this.isNonWorkday(CalendarObject.yyyymmdd(gregorianCalendar))) break;
                    ++n3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized day type: " + dayType);
                }
            }
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        return n3;
    }

    private Integer nthDayOfTypeFromEnd(int n, Calendar calendar, DayType dayType) {
        if (this.isDayTypeMismatch(calendar, dayType)) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        CalendarObject.setCalendarToYyyymmdd(gregorianCalendar, n);
        int n2 = this.yyyymmdd_AdjustedForVirtualDay(calendar);
        int n3 = 0;
        while (CalendarObject.yyyymmdd(gregorianCalendar) >= n2) {
            switch (dayType) {
                case ALL_DAYS: {
                    ++n3;
                    break;
                }
                case WORKDAYS: {
                    if (!this.isWorkday(CalendarObject.yyyymmdd(gregorianCalendar))) break;
                    ++n3;
                    break;
                }
                case NON_WORKDAYS: {
                    if (!this.isNonWorkday(CalendarObject.yyyymmdd(gregorianCalendar))) break;
                    ++n3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized day type: " + dayType);
                }
            }
            ((Calendar)gregorianCalendar).add(5, -1);
        }
        return n3;
    }

    protected DateRange periodContaining(int n, PeriodType periodType) {
        ValidationHelper.checkForNull((String)"Period type", (Object)periodType);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        CalendarObject.setCalendarToYyyymmdd(gregorianCalendar, n);
        int n2 = n % 10000;
        int n3 = n / 100 % 100;
        switch (periodType) {
            case YEAR: {
                return new DateRange(n - n2 + 101, n - n2 + 1231);
            }
            case MONTH: {
                int n4 = n % 100;
                return new DateRange(n - n4 + 1, n - n4 + ((Calendar)gregorianCalendar).getActualMaximum(5));
            }
            case QUARTER: {
                int[] nArray = new int[]{101, 401, 701, 1001};
                int[] nArray2 = new int[]{331, 630, 930, 1231};
                int n5 = (n3 - 1) / 3;
                return new DateRange(n - n2 + nArray[n5], n - n2 + nArray2[n5]);
            }
            case HALF_YEAR: {
                int[] nArray = new int[]{101, 701};
                int[] nArray3 = new int[]{630, 1231};
                int n6 = (n3 - 1) / 6;
                return new DateRange(n - n2 + nArray[n6], n - n2 + nArray3[n6]);
            }
        }
        throw new IllegalArgumentException("Unrecognized period type: " + periodType);
    }

    private int[] removeDuplicates(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = 0;
        for (int n3 : nArray) {
            if (n3 == n2) continue;
            nArray2[n++] = n3;
            n2 = n3;
        }
        return Arrays.copyOf(nArray2, n);
    }

    private static void setCalendarToYyyymmdd(Calendar calendar, int n) {
        int n2 = n / 10000;
        int n3 = n / 100 % 100;
        int n4 = n % 100;
        calendar.clear();
        boolean bl = calendar.isLenient();
        calendar.setLenient(false);
        try {
            calendar.set(n2, n3 - 1, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = MessageUtil.formatMsg((String)"Invalid date: {0}-{1}-{2}.", (Object[])new Object[]{n2, n3, n4});
            throw new IllegalArgumentException(string);
        }
        calendar.setLenient(bl);
    }

    private static int yyyymmdd(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        return n * 10000 + n2 * 100 + n3;
    }

    private long virtualDayOffsetInMillis() {
        if (this.isVirtualDay()) {
            long l = 60000L;
            long l2 = l * 60L;
            long l3 = (long)this.dayStart.getHourOfDay() * l2 + (long)this.dayStart.getMinuteOfHour() * l;
            if (this.isAssignDayStartToNextDay) {
                return l2 * 24L - l3;
            }
            return -l3;
        }
        return 0L;
    }

    public static enum PeriodType implements PersistableEnum<String>
    {
        MONTH("M"),
        QUARTER("Q"),
        HALF_YEAR("S"),
        YEAR("Y");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, PeriodType> map;

        private PeriodType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static PeriodType persistanceCodeToEnum(String string) {
            PeriodType periodType = map.get(string);
            if (periodType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return periodType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])PeriodType.values());
        }
    }

    public static enum DayOfWeek {
        SUN,
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT;


        public static DayOfWeek fromCalendar(Calendar calendar) {
            ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
            switch (calendar.get(7)) {
                case 1: {
                    return SUN;
                }
                case 2: {
                    return MON;
                }
                case 3: {
                    return TUE;
                }
                case 4: {
                    return WED;
                }
                case 5: {
                    return THU;
                }
                case 6: {
                    return FRI;
                }
                case 7: {
                    return SAT;
                }
            }
            String string = MessageUtil.formatMsg((String)"Unrecognized Calendar.DAY_OF_WEEK code {0}.", (Object[])new Object[]{calendar.get(7)});
            throw new IllegalStateException(string);
        }

        public static DayOfWeek fromYyyymmdd(int n) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            CalendarObject.setCalendarToYyyymmdd(gregorianCalendar, n);
            return DayOfWeek.fromCalendar(gregorianCalendar);
        }
    }

    public static enum DayType implements PersistableEnum<String>
    {
        WORKDAYS("W"),
        NON_WORKDAYS("N"),
        ALL_DAYS("A");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, DayType> map;

        private DayType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static DayType persistanceCodeToEnum(String string) {
            DayType dayType = map.get(string);
            if (dayType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return dayType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])DayType.values());
        }
    }
}

