/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.reports.filter.declarationparser;

import com.helpsystems.enterprise.core.reports.filter.BaseDateFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.DateFilter;
import com.helpsystems.enterprise.core.reports.filter.declarationparser.FilterDeclarationParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DateFilterParser
implements FilterDeclarationParser<DateFilter> {
    private static final Logger logger = Logger.getLogger(DateFilterParser.class);
    private String RANGE_DATE_PARAM = null;
    private String END_DATE_DURATION_PARAM = null;
    private String START_DATE_DURATION_PARAM = null;
    public static final String DEFAULT_RANGE_DATE_PARAM = "-dateRange";
    public static final String DEFAULT_END_DATE_DURATION_PARAM = "-endDateDuration";
    public static final String DEFAULT_START_DATE_DURATION_PARAM = "-startDateDuration";
    public static final String SCHEDULED_RELEASE_RANGE_DATE_PARAM = "-scheduledReleaseStartDateRange";
    public static final String SCHEDULED_RELEASE_END_DATE_DURATION_PARAM = "-scheduledReleaseEndDateDuration";
    public static final String SCHEDULED_RELEASE_START_DATE_DURATION_PARAM = "-scheduledReleaseStartDateDuration";
    public static final String SAP_PLANNED_RANGE_DATE_PARAM = "-sapPlannedStartDateRange";
    public static final String SAP_PLANNED_END_DATE_DURATION_PARAM = "-sapPlannedEndDateDuration";
    public static final String SAP_PLANNED_START_DATE_DURATION_PARAM = "-sapPlannedStartDateDuration";
    public static final int DEFAULT_TYPE = 0;
    public static final int SCHEDULED_RELEASE_TYPE = 1;
    public static final int SAP_PLANNED_TYPE = 2;
    private static final int RANGE_DATE_PARAM_ID = 1;
    private static final int END_DATE_DURATION_PARAM_ID = 2;
    private static final int START_DATE_DURATION_PARAM_ID = 3;
    public final DateFormat dateformatter = new SimpleDateFormat("yyyyMMdd");
    public final DateFormat dateTimeformatter = new SimpleDateFormat("yyyyMMddHHmm");

    public DateFilterParser() {
        this.RANGE_DATE_PARAM = DEFAULT_RANGE_DATE_PARAM;
        this.END_DATE_DURATION_PARAM = DEFAULT_END_DATE_DURATION_PARAM;
        this.START_DATE_DURATION_PARAM = DEFAULT_START_DATE_DURATION_PARAM;
    }

    public DateFilterParser(int n) {
        switch (n) {
            case 1: {
                this.RANGE_DATE_PARAM = SCHEDULED_RELEASE_RANGE_DATE_PARAM;
                this.END_DATE_DURATION_PARAM = SCHEDULED_RELEASE_END_DATE_DURATION_PARAM;
                this.START_DATE_DURATION_PARAM = SCHEDULED_RELEASE_START_DATE_DURATION_PARAM;
                break;
            }
            case 2: {
                this.RANGE_DATE_PARAM = SAP_PLANNED_RANGE_DATE_PARAM;
                this.END_DATE_DURATION_PARAM = SAP_PLANNED_END_DATE_DURATION_PARAM;
                this.START_DATE_DURATION_PARAM = SAP_PLANNED_START_DATE_DURATION_PARAM;
            }
        }
    }

    @Override
    public void parseParameters(DateFilter dateFilter, Object ... objectArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n2 = -1;
        block5: for (n = 0; n < objectArray.length; ++n) {
            Object object = objectArray[n];
            String string = (String)object;
            if (this.RANGE_DATE_PARAM.equalsIgnoreCase(string)) {
                n2 = 1;
                continue;
            }
            if (this.END_DATE_DURATION_PARAM.equalsIgnoreCase(string)) {
                n2 = 2;
                continue;
            }
            if (this.START_DATE_DURATION_PARAM.equalsIgnoreCase(string)) {
                n2 = 3;
                continue;
            }
            if (string.startsWith("-")) {
                n2 = -1;
                continue;
            }
            switch (n2) {
                case 1: {
                    arrayList.add(string);
                    continue block5;
                }
                case 2: {
                    arrayList2.add(string);
                    continue block5;
                }
                case 3: {
                    arrayList3.add(string);
                }
            }
        }
        this.setBackValuesIfExist(arrayList);
        this.setBackValuesIfExist(arrayList2);
        this.setBackValuesIfExist(arrayList3);
        n = arrayList.size();
        int n3 = arrayList2.size();
        int n4 = arrayList3.size();
        if (dateFilter instanceof BaseDateFilter) {
            logger.debug((Object)"This report requires a time range.");
            if (n == 0 && n3 == 0 && n4 == 0) {
                logger.error((Object)"No time range found for this report.");
                throw new IllegalStateException("No time range parameter was passed.");
            }
        }
        if (n > 0 && n3 > 0 || n3 > 0 && n4 > 0 || n4 > 0 && n > 0 || n == 0 && n3 == 0 && n4 == 0) {
            throw new IllegalStateException("Wrong parameter order/definition.");
        }
        if (n > 0) {
            if (n != 2 && n != 4) {
                logger.error((Object)("Wrong parameter order/definition for  " + this.RANGE_DATE_PARAM));
                throw new IllegalStateException("Wrong parameter order/definition for  " + this.RANGE_DATE_PARAM);
            }
            this.parseRangeDates(arrayList, dateFilter);
        }
        if (n3 > 0) {
            if (n3 > 4 || n3 == 3) {
                logger.error((Object)("Wrong parameter order/definition for  " + this.END_DATE_DURATION_PARAM));
                throw new IllegalStateException("Wrong parameter order/definition for  " + this.END_DATE_DURATION_PARAM);
            }
            this.parseEndDateDuration(arrayList2, dateFilter);
        }
        if (n4 > 0) {
            if (n4 != 4) {
                logger.error((Object)("Wrong parameter order/definition for  " + this.START_DATE_DURATION_PARAM));
                throw new IllegalStateException("Wrong parameter order/definition for  " + this.START_DATE_DURATION_PARAM);
            }
            this.parseStartDateDuration(arrayList3, dateFilter);
        }
    }

    private void setBackValuesIfExist(List<String> list) {
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if (string.indexOf("val_") == -1) continue;
                string = string.replaceAll("val_", "-");
                list.remove(i);
                list.add(i, string);
            }
        }
    }

    private void parseRangeDates(ArrayList<String> arrayList, DateFilter dateFilter) {
        Date date;
        Long l = null;
        Long l2 = null;
        try {
            date = this.dateTimeformatter.parse(arrayList.get(0) + arrayList.get(1));
            l = date.getTime();
        }
        catch (ParseException parseException) {
            logger.error((Object)"Wrong format of start date/time");
            throw new IllegalStateException("Wrong format of start date/time");
        }
        if (arrayList.size() == 4) {
            try {
                date = this.dateTimeformatter.parse(arrayList.get(2) + arrayList.get(3));
                l2 = date.getTime();
            }
            catch (ParseException parseException) {
                logger.error((Object)"Wrong format of end date/time");
                throw new IllegalStateException("Wrong format of end date/time");
            }
            if (l > l2) {
                logger.error((Object)"Start date is greater than to date.");
                throw new IllegalStateException("Start date is greater than to date.");
            }
        } else {
            l2 = new Date().getTime();
            dateFilter.setToCurrentDate(true);
        }
        dateFilter.setFromDate(l);
        dateFilter.setToDate(l2);
    }

    private void parseEndDateDuration(ArrayList<String> arrayList, DateFilter dateFilter) {
        long l;
        Comparable<Calendar> comparable;
        int n = arrayList.size();
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = Integer.parseInt(arrayList.get(0));
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)"Wrong parameter format: The parameter number of days should be a number.");
            throw new IllegalStateException("Wrong parameter format: The parameter number of days should be a number.");
        }
        dateFilter.setDateDayFromRelative(n2);
        if (n > 2) {
            try {
                comparable = this.dateTimeformatter.parse(arrayList.get(2) + arrayList.get(3));
                l = ((Date)comparable).getTime();
            }
            catch (ParseException parseException) {
                logger.error((Object)"Wrong format of start date/time");
                throw new IllegalStateException("Wrong format of start date/time");
            }
        } else {
            l = new Date().getTime();
        }
        dateFilter.setToDate(l);
        comparable = Calendar.getInstance();
        ((Calendar)comparable).setTimeInMillis(l);
        ((Calendar)comparable).add(5, -1 * n2);
        if (n > 1) {
            try {
                n3 = Integer.parseInt(arrayList.get(1));
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)"Wrong parameter format: The parameter number of hours should be a number.");
                throw new IllegalStateException("Wrong parameter format: The parameter number of hours should be a number.");
            }
            dateFilter.setDateHourFromRelative(n3);
            ((Calendar)comparable).add(10, -1 * n3);
        }
        dateFilter.setFromDate(((Calendar)comparable).getTime().getTime());
    }

    private void parseStartDateDuration(ArrayList<String> arrayList, DateFilter dateFilter) {
        long l;
        Comparable<Date> comparable;
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(arrayList.get(0));
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)"Wrong parameter format: The parameter number of days should be a number.");
            throw new IllegalStateException("Wrong parameter format: The parameter number of days should be a number.");
        }
        try {
            n2 = Integer.parseInt(arrayList.get(1));
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)"Wrong parameter format: The parameter number of hours should be a number.");
            throw new IllegalStateException("Wrong parameter format: The parameter number of hours should be a number.");
        }
        dateFilter.setDateDayToRelative(n);
        dateFilter.setDateHourToRelative(n2);
        try {
            comparable = this.dateTimeformatter.parse(arrayList.get(2) + arrayList.get(3));
            l = ((Date)comparable).getTime();
            dateFilter.setFromDate(((Date)comparable).getTime());
        }
        catch (ParseException parseException) {
            logger.error((Object)"Wrong format of start date/time");
            throw new IllegalStateException("Wrong format of start date/time");
        }
        comparable = Calendar.getInstance();
        ((Calendar)comparable).setTimeInMillis(l);
        ((Calendar)comparable).add(5, n);
        n2 = Integer.parseInt(arrayList.get(1));
        dateFilter.setDateHourToRelative(n2);
        ((Calendar)comparable).add(10, n2);
        dateFilter.setToDate(((Calendar)comparable).getTime().getTime());
    }
}

